/*
 * Decompiled with CFR 0.152.
 */
package tyrex.tm.impl;

import javax.naming.Context;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import tyrex.naming.MemoryBinding;
import tyrex.naming.MemoryContext;
import tyrex.tm.RuntimeContext;
import tyrex.tm.impl.TransactionImpl;

public class ThreadContext
extends RuntimeContext {
    protected TransactionImpl _tx;
    protected XAResource[] _resources;
    private final Subject _subject;
    private final MemoryBinding _bindings;
    private static ThreadEntry[] _table = new ThreadEntry[1103];
    private static final int TABLE_SIZE = 1103;
    static /* synthetic */ Class class$tyrex$naming$MemoryContextFactory;

    public ThreadContext(Subject subject) {
        this._bindings = new MemoryBinding();
        this._subject = subject;
    }

    public ThreadContext(Context context, Subject subject) throws NamingException {
        if (context == null) {
            this._bindings = new MemoryBinding();
        } else {
            if (!(context instanceof MemoryContext)) {
                throw new NamingException("The context was not created from " + (class$tyrex$naming$MemoryContextFactory == null ? (class$tyrex$naming$MemoryContextFactory = ThreadContext.class$("tyrex.naming.MemoryContextFactory")) : class$tyrex$naming$MemoryContextFactory).getName());
            }
            this._bindings = ((MemoryContext)context).getBindings();
            if (!this._bindings.isRoot()) {
                throw new NamingException("The context is not a root context");
            }
        }
        this._subject = subject;
    }

    public static ThreadContext getThreadContext() {
        ThreadContext threadContext;
        Thread thread = Thread.currentThread();
        int n = (thread.hashCode() & Integer.MAX_VALUE) % _table.length;
        ThreadEntry threadEntry = _table[n];
        while (threadEntry != null) {
            if (threadEntry._thread == thread) {
                return threadEntry._context;
            }
            threadEntry = threadEntry._nextEntry;
        }
        ThreadEntry[] threadEntryArray = _table;
        synchronized (threadEntryArray) {
            threadContext = new ThreadContext(null);
            threadEntry = new ThreadEntry(threadContext, thread, null);
            threadEntry._nextEntry = _table[n];
            ThreadContext._table[n] = threadEntry;
        }
        return threadContext;
    }

    public static ThreadContext getThreadContext(Thread thread) {
        ThreadContext threadContext;
        int n = (thread.hashCode() & Integer.MAX_VALUE) % _table.length;
        ThreadEntry threadEntry = _table[n];
        while (threadEntry != null) {
            if (threadEntry._thread == thread) {
                return threadEntry._context;
            }
            threadEntry = threadEntry._nextEntry;
        }
        ThreadEntry[] threadEntryArray = _table;
        synchronized (threadEntryArray) {
            threadContext = new ThreadContext(null);
            threadEntry = new ThreadEntry(threadContext, thread, null);
            threadEntry._nextEntry = _table[n];
            ThreadContext._table[n] = threadEntry;
        }
        return threadContext;
    }

    public static void setThreadContext(ThreadContext threadContext) {
        if (threadContext == null) {
            throw new IllegalArgumentException("Argument context is null");
        }
        ThreadEntry[] threadEntryArray = _table;
        synchronized (threadEntryArray) {
            Thread thread = Thread.currentThread();
            int n = (thread.hashCode() & Integer.MAX_VALUE) % _table.length;
            ThreadEntry threadEntry = _table[n];
            if (threadEntry != null && threadEntry._thread == thread) {
                ThreadContext._table[n] = threadEntry = new ThreadEntry(threadContext, thread, threadEntry);
                return;
            }
            ThreadEntry threadEntry2 = threadEntry != null ? threadEntry._nextEntry : null;
            while (threadEntry2 != null) {
                if (threadEntry2._thread == thread) {
                    threadEntry._nextEntry = threadEntry2 = new ThreadEntry(threadContext, thread, threadEntry2);
                    return;
                }
                threadEntry = threadEntry2;
                threadEntry2 = threadEntry2._nextEntry;
            }
            threadEntry = new ThreadEntry(threadContext, thread, null);
            threadEntry._nextEntry = _table[n];
            ThreadContext._table[n] = threadEntry;
        }
    }

    public static ThreadContext unsetThreadContext() {
        ThreadEntry[] threadEntryArray = _table;
        synchronized (threadEntryArray) {
            Thread thread = Thread.currentThread();
            int n = (thread.hashCode() & Integer.MAX_VALUE) % _table.length;
            ThreadEntry threadEntry = _table[n];
            if (threadEntry == null) {
                ThreadContext threadContext = null;
                return threadContext;
            }
            if (threadEntry._thread == thread) {
                ThreadEntry threadEntry2 = threadEntry._previous;
                if (threadEntry2 == null) {
                    ThreadContext._table[n] = threadEntry._nextEntry;
                } else {
                    threadEntry2._nextEntry = threadEntry._nextEntry;
                    ThreadContext._table[n] = threadEntry2;
                }
                ThreadContext threadContext = threadEntry._context;
                return threadContext;
            }
            ThreadEntry threadEntry3 = threadEntry._nextEntry;
            while (threadEntry3 != null) {
                if (threadEntry3._thread == thread) {
                    ThreadEntry threadEntry4 = threadEntry3._previous;
                    if (threadEntry4 == null) {
                        threadEntry._nextEntry = threadEntry3._nextEntry;
                    } else {
                        threadEntry4._nextEntry = threadEntry3._nextEntry;
                        threadEntry._nextEntry = threadEntry4;
                    }
                    ThreadContext threadContext = threadEntry3._context;
                    return threadContext;
                }
                threadEntry = threadEntry3;
                threadEntry3 = threadEntry3._nextEntry;
            }
        }
        return null;
    }

    public static void cleanup(Thread thread) {
        if (thread == null) {
            throw new IllegalArgumentException("Argument thread is null");
        }
        ThreadEntry[] threadEntryArray = _table;
        synchronized (threadEntryArray) {
            int n = (thread.hashCode() & Integer.MAX_VALUE) % _table.length;
            ThreadEntry threadEntry = _table[n];
            if (threadEntry == null) {
                return;
            }
            if (threadEntry._thread == thread) {
                ThreadContext._table[n] = threadEntry._nextEntry;
                return;
            }
            ThreadEntry threadEntry2 = threadEntry._nextEntry;
            while (threadEntry2 != null) {
                if (threadEntry2._thread == thread) {
                    threadEntry._nextEntry = threadEntry2._nextEntry;
                    return;
                }
                threadEntry = threadEntry2;
                threadEntry2 = threadEntry2._nextEntry;
            }
        }
    }

    public Context getEnvContext() {
        return this._bindings.getContext();
    }

    public Transaction getTransaction() {
        return this._tx;
    }

    public Subject getSubject() {
        return this._subject;
    }

    public void cleanup() {
        this._tx = null;
        this._resources = null;
    }

    public MemoryBinding getMemoryBinding() {
        return this._bindings;
    }

    protected void add(XAResource xAResource) {
        int n = -1;
        if (xAResource == null) {
            throw new IllegalArgumentException("Argument xaResource is null");
        }
        if (this._resources == null) {
            this._resources = new XAResource[]{xAResource};
        } else {
            int n2 = this._resources.length;
            while (n2-- > 0) {
                if (this._resources[n2] == xAResource) {
                    return;
                }
                if (this._resources[n2] != null) continue;
                n = n2;
            }
            if (n >= 0) {
                this._resources[n] = xAResource;
            } else {
                XAResource[] xAResourceArray = new XAResource[this._resources.length * 2];
                int n3 = this._resources.length;
                while (n3-- > 0) {
                    xAResourceArray[n3] = this._resources[n3];
                }
                xAResourceArray[this._resources.length] = xAResource;
                this._resources = xAResourceArray;
            }
        }
    }

    protected boolean remove(XAResource xAResource) {
        if (this._resources != null) {
            int n = this._resources.length;
            while (n-- > 0) {
                if (this._resources[n] != xAResource) continue;
                this._resources[n] = null;
                return true;
            }
        }
        return false;
    }

    protected XAResource[] getResources() {
        int n;
        int n2 = 0;
        if (this._resources == null) {
            return null;
        }
        if (this._resources != null) {
            n = this._resources.length;
            while (n-- > 0) {
                if (this._resources[n] == null) continue;
                ++n2;
            }
        }
        if (n2 == 0) {
            return null;
        }
        XAResource[] xAResourceArray = new XAResource[n2];
        n2 = 0;
        n = this._resources.length;
        while (n-- > 0) {
            if (this._resources[n] == null) continue;
            xAResourceArray[n2++] = this._resources[n];
        }
        return xAResourceArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class ThreadEntry {
        final Thread _thread;
        ThreadContext _context;
        ThreadEntry _previous;
        ThreadEntry _nextEntry;

        ThreadEntry(ThreadContext threadContext, Thread thread, ThreadEntry threadEntry) {
            this._context = threadContext;
            this._thread = thread;
            if (threadEntry != null) {
                this._previous = threadEntry;
                this._nextEntry = threadEntry._nextEntry;
            }
        }
    }
}

