/*
 * Decompiled with CFR 0.152.
 */
package tyrex.tm.impl;

import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.log4j.Category;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TSIdentification;
import org.omg.CORBA.TSIdentificationPackage.AlreadyIdentified;
import org.omg.CosTSPortability.Receiver;
import org.omg.CosTSPortability.Sender;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.TransactionFactory;
import org.omg.CosTransactions.otid_t;
import tyrex.resource.Resource;
import tyrex.resource.ResourceException;
import tyrex.resource.Resources;
import tyrex.services.Clock;
import tyrex.services.DaemonMaster;
import tyrex.tm.DomainConfigurationException;
import tyrex.tm.DomainMetrics;
import tyrex.tm.Journal;
import tyrex.tm.JournalFactory;
import tyrex.tm.RecoveryException;
import tyrex.tm.TransactionDomain;
import tyrex.tm.TransactionInterceptor;
import tyrex.tm.impl.DomainConfig;
import tyrex.tm.impl.NestedSystemException;
import tyrex.tm.impl.ThreadContext;
import tyrex.tm.impl.TransactionFactoryImpl;
import tyrex.tm.impl.TransactionImpl;
import tyrex.tm.impl.TransactionManagerImpl;
import tyrex.tm.impl.UserTransactionImpl;
import tyrex.tm.impl.Util;
import tyrex.tm.xid.BaseXid;
import tyrex.tm.xid.XidUtils;
import tyrex.util.Configuration;
import tyrex.util.Logger;
import tyrex.util.LoggerPrintWriter;
import tyrex.util.Messages;

public class TransactionDomainImpl
extends TransactionDomain
implements Runnable,
DomainMetrics {
    public static final int TABLE_SIZE = 1103;
    private final TransactionImpl[] _hashTable;
    private int _txCount;
    private final String _domainName;
    protected final TransactionManagerImpl _txManager;
    private final UserTransaction _userTx;
    private final TransactionFactoryImpl _txFactory;
    protected ORB _orb;
    private Field _bqualField;
    private int _txTimeout;
    private int _waitNew;
    protected final Category _category;
    private boolean _nestedTx = false;
    private TransactionInterceptor[] _interceptors;
    private long _nextTimeout = 0L;
    protected final Journal _journal;
    private final int _maximum;
    private final Resources _resources;
    private int _state;
    private RecoveryException _recoveryErrors;
    private TransactionDomainImpl _nextDomain;
    private int _accumTime;
    private int _accumCommitted;
    private int _accumRolledback;
    private int _active;

    public TransactionDomainImpl(DomainConfig domainConfig) throws DomainConfigurationException {
        if (domainConfig == null) {
            throw new IllegalArgumentException("Argument config is null");
        }
        String string = domainConfig.getName();
        if (string == null || string.trim().length() == 0) {
            throw new DomainConfigurationException("The domain name is missing");
        }
        this._domainName = string.trim();
        this._maximum = domainConfig.getMaximum();
        this.setTransactionTimeout(domainConfig.getTimeout());
        this._waitNew = domainConfig.getWaitNew() * 1000;
        String string2 = domainConfig.getJournalFactory();
        if (string2 != null && string2.trim().length() != 0) {
            JournalFactory journalFactory;
            string2 = string2.trim();
            try {
                journalFactory = (JournalFactory)this.getClass().getClassLoader().loadClass(string2).newInstance();
            }
            catch (Exception exception) {
                throw new DomainConfigurationException("Error obtaining transaction journal factory " + string2, exception);
            }
            try {
                this._journal = journalFactory.openJournal(this._domainName);
            }
            catch (SystemException systemException) {
                throw new DomainConfigurationException((Exception)((Object)systemException));
            }
        }
        this._journal = null;
        this._interceptors = new TransactionInterceptor[0];
        this._txManager = new TransactionManagerImpl(this);
        this._userTx = new UserTransactionImpl(this._txManager);
        this._txFactory = new TransactionFactoryImpl(this);
        this._category = Category.getInstance((String)("tyrex." + this._domainName));
        this._category.addAppender(Logger.appender);
        this._hashTable = new TransactionImpl[1103];
        if (domainConfig.getResources() != null) {
            try {
                this._resources = domainConfig.getResources();
                this._resources.setTransactionDomain(this);
            }
            catch (Exception exception) {
                throw new DomainConfigurationException(exception);
            }
        } else {
            this._resources = new Resources();
        }
        DaemonMaster.addDaemon(this, "Transaction Domain " + this._domainName);
        this._state = 0;
        if (Configuration.verbose) {
            this._category.info((Object)("Created transaction domain " + this._domainName));
        }
    }

    public String toString() {
        return this._domainName;
    }

    public TransactionManager getTransactionManager() {
        return this._txManager;
    }

    public UserTransaction getUserTransaction() {
        return this._userTx;
    }

    public TransactionFactory getTransactionFactory() {
        return this._txFactory;
    }

    public int getTransactionTimeout() {
        return this._txTimeout;
    }

    public boolean getNestedTransactions() {
        return this._nestedTx;
    }

    public synchronized void addInterceptor(TransactionInterceptor transactionInterceptor) {
        int n = 0;
        while (n < this._interceptors.length) {
            if (this._interceptors[n] == transactionInterceptor) {
                return;
            }
            ++n;
        }
        TransactionInterceptor[] transactionInterceptorArray = new TransactionInterceptor[this._interceptors.length + 1];
        System.arraycopy(this._interceptors, 0, transactionInterceptorArray, 0, this._interceptors.length);
        transactionInterceptorArray[this._interceptors.length] = transactionInterceptor;
        this._interceptors = transactionInterceptorArray;
    }

    public synchronized void removeInterceptor(TransactionInterceptor transactionInterceptor) {
        int n = 0;
        while (n < this._interceptors.length) {
            if (this._interceptors[n] == transactionInterceptor) {
                this._interceptors[n] = this._interceptors[this._interceptors.length - 1];
                TransactionInterceptor[] transactionInterceptorArray = new TransactionInterceptor[this._interceptors.length - 1];
                System.arraycopy(this._interceptors, 0, transactionInterceptorArray, 0, this._interceptors.length - 1);
                this._interceptors = transactionInterceptorArray;
                break;
            }
            ++n;
        }
    }

    public synchronized void terminate() {
        if (this._state != 3) {
            this._state = 3;
            this.notifyAll();
        }
    }

    public DomainMetrics getDomainMetrics() {
        return this;
    }

    public String getDomainName() {
        return this._domainName;
    }

    public Resources getResources() {
        return this._resources;
    }

    public int getState() {
        return this._state;
    }

    public synchronized void recover() throws RecoveryException {
        if (this._state == 0) {
            this._state = 1;
            ArrayList<XAResource> arrayList = new ArrayList<XAResource>();
            Iterator iterator = this._resources.listResources();
            while (iterator.hasNext()) {
                try {
                    XAResource xAResource;
                    Resource resource = this._resources.getResource((String)iterator.next());
                    if (resource == null || (xAResource = resource.getXAResource()) == null) continue;
                    arrayList.add(xAResource);
                }
                catch (ResourceException resourceException) {
                    this.recoveryError(new RecoveryException(resourceException));
                }
            }
            XAResource[] xAResourceArray = arrayList.toArray(new XAResource[arrayList.size()]);
            this.recover(this._journal, xAResourceArray);
            this._state = 2;
            RecoveryException recoveryException = this._recoveryErrors;
            this._recoveryErrors = null;
            if (recoveryException != null) {
                this._category.info((Object)("Transaction recovery for domain " + this._domainName + " reported errors:"));
                LoggerPrintWriter loggerPrintWriter = new LoggerPrintWriter(this._category, null, true);
                RecoveryException recoveryException2 = recoveryException;
                while (recoveryException2 != null) {
                    ((PrintWriter)loggerPrintWriter).println(recoveryException2.toString());
                    recoveryException2 = recoveryException2.getNextException();
                }
                throw recoveryException;
            }
        }
    }

    public int getTotalCommitted() {
        return this._accumCommitted;
    }

    public int getTotalRolledback() {
        return this._accumRolledback;
    }

    public synchronized float getAvgDuration() {
        return ((float)this._accumTime / (float)this._accumCommitted + (float)this._accumRolledback) / 10000.0f;
    }

    public int getActive() {
        return this._active;
    }

    public synchronized void reset() {
        this._accumTime = 0;
        this._accumCommitted = 0;
        this._accumRolledback = 0;
    }

    public TransactionImpl findTransaction(Xid xid) {
        if (xid == null) {
            throw new IllegalArgumentException("Argument xid is null");
        }
        int n = xid.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this._hashTable.length;
        TransactionImpl transactionImpl = this._hashTable[n2];
        if (transactionImpl != null) {
            if (transactionImpl._hashCode == n && transactionImpl._xid.equals(xid)) {
                return transactionImpl;
            }
            transactionImpl = transactionImpl._nextEntry;
            while (transactionImpl != null) {
                if (transactionImpl._hashCode == n && transactionImpl._xid.equals(xid)) {
                    return transactionImpl;
                }
                transactionImpl = transactionImpl._nextEntry;
            }
        }
        return null;
    }

    public TransactionImpl findTransaction(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Argument xid is null");
        }
        int n = string.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this._hashTable.length;
        TransactionImpl transactionImpl = this._hashTable[n2];
        if (transactionImpl != null) {
            if (transactionImpl._hashCode == n && transactionImpl._xid.toString().equals(string)) {
                return transactionImpl;
            }
            transactionImpl = transactionImpl._nextEntry;
            while (transactionImpl != null) {
                if (transactionImpl._hashCode == n && transactionImpl._xid.toString().equals(string)) {
                    return transactionImpl;
                }
                transactionImpl = transactionImpl._nextEntry;
            }
        }
        return null;
    }

    public TransactionDomainImpl getNextDomain() {
        return this._nextDomain;
    }

    public void setNextDomain(TransactionDomainImpl transactionDomainImpl) {
        this._nextDomain = transactionDomainImpl;
    }

    protected TransactionImpl createTransaction(TransactionImpl transactionImpl, long l) throws SystemException {
        if (this._state != 2) {
            throw new SystemException("Transaction domain not active");
        }
        BaseXid baseXid = (BaseXid)XidUtils.newGlobal();
        if (l <= 0L) {
            l = this._txTimeout;
        } else if (l > 600L) {
            l = 600L;
        }
        int n = baseXid.hashCode();
        TransactionImpl transactionImpl2 = new TransactionImpl(baseXid, transactionImpl, this, l * 1000L);
        l = transactionImpl2._timeout;
        TransactionDomainImpl transactionDomainImpl = this;
        synchronized (transactionDomainImpl) {
            if (transactionImpl == null) {
                this.canCreateNew();
            }
            int n2 = 0;
            while (n2 < this._interceptors.length) {
                try {
                    this._interceptors[n2].begin(baseXid);
                }
                catch (Throwable throwable) {
                    this._category.error((Object)("Interceptor " + this._interceptors[n2] + " reported error"), throwable);
                }
                ++n2;
            }
            if (transactionImpl != null) {
                TransactionImpl transactionImpl3 = transactionImpl2;
                return transactionImpl3;
            }
            int n3 = (n & Integer.MAX_VALUE) % this._hashTable.length;
            TransactionImpl transactionImpl4 = this._hashTable[n3];
            if (transactionImpl4 == null) {
                this._hashTable[n3] = transactionImpl2;
            } else {
                TransactionImpl transactionImpl5 = transactionImpl4._nextEntry;
                while (transactionImpl5 != null) {
                    if (transactionImpl5._hashCode == n && transactionImpl5._xid.equals(baseXid)) {
                        throw new SystemException("A transaction with the identifier " + baseXid.toString() + " already exists");
                    }
                    transactionImpl4 = transactionImpl5;
                    transactionImpl5 = transactionImpl5._nextEntry;
                }
                transactionImpl4._nextEntry = transactionImpl2;
            }
            ++this._txCount;
            ++this._active;
            if (this._nextTimeout == 0L || this._nextTimeout > l) {
                this._nextTimeout = l;
                this.notifyAll();
            }
        }
        return transactionImpl2;
    }

    protected TransactionImpl recreateTransaction(PropagationContext propagationContext) throws SystemException {
        TransactionImpl transactionImpl;
        int n;
        if (propagationContext == null) {
            throw new IllegalArgumentException("Argument pgContext is null");
        }
        if (propagationContext.current == null || propagationContext.current.otid == null) {
            throw new SystemException("Propagation context missing otid in current transaction identifier");
        }
        if (this._state != 2) {
            throw new SystemException("Transaction domain not active");
        }
        otid_t otid_t2 = propagationContext.current.otid;
        Class<?> clazz = otid_t2.getClass();
        if (this._bqualField == null) {
            try {
                this._bqualField = clazz.getField("bqual_length");
            }
            catch (NoSuchFieldException noSuchFieldException) {
                try {
                    this._bqualField = clazz.getField("bequal_length");
                }
                catch (NoSuchFieldException noSuchFieldException2) {
                    throw new NestedSystemException(noSuchFieldException2);
                }
                catch (SecurityException securityException) {
                    throw new NestedSystemException(securityException);
                }
            }
            catch (SecurityException securityException) {
                throw new NestedSystemException(securityException);
            }
        }
        try {
            n = this._bqualField.getInt(otid_t2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NestedSystemException(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new NestedSystemException(illegalArgumentException);
        }
        byte[] byArray = new byte[n];
        int n2 = n;
        while (n2-- > 0) {
            byArray[n2] = otid_t2.tid[n2];
        }
        BaseXid baseXid = (BaseXid)XidUtils.importXid(otid_t2.formatID, byArray, null);
        TransactionDomainImpl transactionDomainImpl = this;
        synchronized (transactionDomainImpl) {
            transactionImpl = this.findTransaction(baseXid);
            if (transactionImpl != null) {
                TransactionImpl transactionImpl2 = transactionImpl;
                return transactionImpl2;
            }
            long l = propagationContext.timeout;
            if (l <= 0L) {
                l = this._txTimeout;
            } else if (l > 600L) {
                l = 600L;
            }
            try {
                transactionImpl = new TransactionImpl(baseXid, propagationContext, this, l * 1000L);
            }
            catch (Inactive inactive) {
                throw new SystemException(Messages.message("tyrex.tx.inactive"));
            }
            int n3 = baseXid.hashCode();
            l = transactionImpl._timeout;
            this.canCreateNew();
            int n4 = 0;
            while (n4 < this._interceptors.length) {
                try {
                    this._interceptors[n4].begin(baseXid);
                }
                catch (Throwable throwable) {
                    this._category.error((Object)("Interceptor " + this._interceptors[n4] + " reported error"), throwable);
                }
                ++n4;
            }
            int n5 = (n3 & Integer.MAX_VALUE) % this._hashTable.length;
            TransactionImpl transactionImpl3 = this._hashTable[n5];
            if (transactionImpl3 == null) {
                this._hashTable[n5] = transactionImpl;
            } else {
                TransactionImpl transactionImpl4 = transactionImpl3._nextEntry;
                while (transactionImpl4 != null) {
                    if (transactionImpl4._hashCode == n3 && transactionImpl4._xid.equals(baseXid)) {
                        throw new SystemException("A transaction with the identifier " + baseXid.toString() + " already exists");
                    }
                    transactionImpl3 = transactionImpl4;
                    transactionImpl4 = transactionImpl4._nextEntry;
                }
                transactionImpl3._nextEntry = transactionImpl;
            }
            ++this._txCount;
            ++this._active;
            if (this._nextTimeout == 0L || this._nextTimeout > l) {
                this._nextTimeout = l;
                this.notifyAll();
            }
        }
        return transactionImpl;
    }

    protected synchronized void forgetTransaction(TransactionImpl transactionImpl) {
        if (transactionImpl == null) {
            throw new IllegalArgumentException("Argument tx is null");
        }
        BaseXid baseXid = transactionImpl._xid;
        int n = transactionImpl._hashCode;
        int n2 = (n & Integer.MAX_VALUE) % this._hashTable.length;
        TransactionImpl transactionImpl2 = this._hashTable[n2];
        if (transactionImpl2 == null) {
            return;
        }
        if (transactionImpl2._hashCode == n && transactionImpl2._xid.equals(baseXid)) {
            this._hashTable[n2] = transactionImpl2._nextEntry;
        } else {
            TransactionImpl transactionImpl3 = transactionImpl2._nextEntry;
            while (transactionImpl3 != null) {
                if (transactionImpl3._hashCode == n && transactionImpl3._xid.equals(baseXid)) {
                    transactionImpl2._nextEntry = transactionImpl3._nextEntry;
                    transactionImpl2 = transactionImpl3;
                    break;
                }
                transactionImpl2 = transactionImpl3;
                transactionImpl3 = transactionImpl3._nextEntry;
            }
            if (transactionImpl3 == null) {
                return;
            }
        }
        --this._txCount;
        --this._active;
        if (this._state == 3) {
            if (this._journal != null) {
                try {
                    this._journal.close();
                }
                catch (SystemException systemException) {
                    this._category.error((Object)("Error closing journal for transaction domain " + this._domainName), (Throwable)systemException);
                }
            }
        } else {
            this.notifyAll();
        }
    }

    protected void setTransactionTimeout(int n) {
        if (n <= 0) {
            n = 120;
        } else if (n > 600) {
            n = 600;
        }
        this._txTimeout = n;
    }

    protected synchronized void setTransactionTimeout(TransactionImpl transactionImpl, int n) {
        if (transactionImpl == null) {
            throw new IllegalArgumentException("Argument tx is null");
        }
        if (n <= 0) {
            n = this._txTimeout;
        } else if (n > 600) {
            n = 600;
        }
        long l = transactionImpl._started + (long)(n * 1000);
        if (l > transactionImpl._timeout) {
            transactionImpl._timeout = l;
            transactionImpl.internalSetTransactionTimeout(n);
            if (this._nextTimeout == 0L || this._nextTimeout > l) {
                this._nextTimeout = l;
                this.notifyAll();
            }
        }
    }

    protected int getTransactionTimeout(TransactionImpl transactionImpl) {
        return (int)(transactionImpl._timeout - transactionImpl._started) / 1000;
    }

    protected void notifyCompletion(TransactionImpl transactionImpl, int n) {
        if (transactionImpl == null) {
            throw new IllegalArgumentException("Argument tx is null");
        }
        int n2 = this._interceptors.length;
        while (n2-- > 0) {
            try {
                this._interceptors[n2].completed(transactionImpl._xid, n);
            }
            catch (Throwable throwable) {
                this._category.error((Object)("Interceptor " + this._interceptors[n2] + " reported error"), throwable);
            }
        }
    }

    protected void notifyCommit(TransactionImpl transactionImpl) throws RollbackException {
        if (transactionImpl == null) {
            throw new IllegalArgumentException("Argument tx is null");
        }
        int n = this._interceptors.length;
        while (n-- > 0) {
            try {
                this._interceptors[n].commit(transactionImpl._xid);
            }
            catch (RollbackException rollbackException) {
                throw rollbackException;
            }
            catch (Throwable throwable) {
                this._category.error((Object)("Interceptor " + this._interceptors[n] + " reported error"), throwable);
            }
        }
        ++this._accumCommitted;
        this._accumTime += (int)(Clock.clock() - transactionImpl._started);
    }

    protected void notifyRollback(TransactionImpl transactionImpl) {
        if (transactionImpl == null) {
            throw new IllegalArgumentException("Argument tx is null");
        }
        int n = this._interceptors.length;
        while (n-- > 0) {
            try {
                this._interceptors[n].rollback(transactionImpl._xid);
            }
            catch (Throwable throwable) {
                this._category.error((Object)("Interceptor " + this._interceptors[n] + " reported error"), throwable);
            }
        }
        ++this._accumRolledback;
        this._accumTime = (int)((long)this._accumTime + (Clock.clock() - transactionImpl._started));
    }

    protected synchronized Transaction[] listTransactions() {
        int n = 0;
        Transaction[] transactionArray = new Transaction[this._txCount];
        int n2 = this._hashTable.length;
        while (n2-- > 0) {
            TransactionImpl transactionImpl = this._hashTable[n2];
            while (transactionImpl != null) {
                transactionArray[n++] = transactionImpl;
                transactionImpl = transactionImpl._nextEntry;
            }
        }
        return transactionArray;
    }

    protected synchronized void dumpTransactionList(PrintWriter printWriter) {
        if (printWriter == null) {
            throw new IllegalArgumentException("Argument writer is null");
        }
        printWriter.println("Transaction domain " + this._domainName + " has " + this._txCount + " transactions");
        int n = this._hashTable.length;
        while (n-- > 0) {
            TransactionImpl transactionImpl = this._hashTable[n];
            while (transactionImpl != null) {
                printWriter.println("  Transaction " + transactionImpl._xid + " " + Util.getStatus(transactionImpl._status));
                printWriter.println("  Started " + Util.fromClock(transactionImpl._started) + " time-out " + Util.fromClock(transactionImpl._timeout));
                transactionImpl = transactionImpl._nextEntry;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected boolean enlistThread(TransactionImpl var1_1, ThreadContext var2_2, Thread var3_3) {
        if (var1_1 == null) {
            throw new IllegalArgumentException("Argument tx is null");
        }
        if (var2_2 == null) {
            throw new IllegalArgumentException("Argument context is null");
        }
        if (var2_2._tx != null) {
            this.delistThread(var2_2, var3_3);
        }
        var4_4 = var1_1._xid;
        var5_5 = this._interceptors.length;
        while (var5_5-- > 0) {
            try {
                this._interceptors[var5_5].resume(var4_4, var3_3);
                continue;
            }
            catch (InvalidTransactionException var6_9) {
                ++var5_5;
                ** while (var5_5 < this._interceptors.length)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    this._interceptors[var5_5].suspend(var4_4, var3_3);
                }
                catch (Throwable var7_8) {
                    this._category.error((Object)("Interceptor " + this._interceptors[var5_5] + " reported error"), var7_8);
                }
                ++var5_5;
                continue;
            }
lbl23:
            // 1 sources

            return false;
            catch (Throwable var7_6) {
                this._category.error((Object)("Interceptor " + this._interceptors[var5_5] + " reported error"), var7_6);
            }
        }
        var2_2._tx = var1_1;
        return true;
    }

    protected void delistThread(ThreadContext threadContext, Thread thread) {
        if (threadContext == null) {
            throw new IllegalArgumentException("Argument context is null");
        }
        TransactionImpl transactionImpl = threadContext._tx;
        if (transactionImpl == null) {
            return;
        }
        BaseXid baseXid = transactionImpl._xid;
        int n = this._interceptors.length;
        while (n-- > 0) {
            try {
                this._interceptors[n].suspend(baseXid, thread);
            }
            catch (Throwable throwable) {
                this._category.error((Object)("Interceptor " + this._interceptors[n] + " reported error"), throwable);
            }
        }
        threadContext._tx = null;
    }

    private void canCreateNew() throws SystemException {
        if (this._maximum == 0 || this._txCount < this._maximum) {
            return;
        }
        long l = Clock.clock();
        long l2 = l + (long)this._waitNew;
        try {
            while (l < l2) {
                this.wait(l2 - l);
                if (this._maximum == 0 || this._txCount < this._maximum) {
                    return;
                }
                l = Clock.clock();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        throw new SystemException(Messages.message("tyrex.server.txCreateExceedsQuota"));
    }

    public synchronized void run() {
        try {
            while (true) {
                TransactionImpl transactionImpl;
                int n;
                long l = Clock.clock();
                while (this._nextTimeout == 0L || this._nextTimeout > l) {
                    if (this._nextTimeout > l) {
                        this.wait(this._nextTimeout - l);
                    } else {
                        this.wait();
                    }
                    l = Clock.clock();
                }
                if (this._state == 3) {
                    n = this._hashTable.length;
                    while (n-- > 0) {
                        transactionImpl = this._hashTable[n];
                        while (transactionImpl != null) {
                            TransactionImpl transactionImpl2 = transactionImpl._nextEntry;
                            transactionImpl.timedOut();
                            transactionImpl = transactionImpl2;
                        }
                    }
                    DaemonMaster.removeDaemon(this);
                    return;
                }
                if (this._nextTimeout == 0L || this._nextTimeout > l) continue;
                long l2 = 0L;
                n = this._hashTable.length;
                while (n-- > 0) {
                    transactionImpl = this._hashTable[n];
                    while (transactionImpl != null) {
                        if (transactionImpl._timeout <= l) {
                            transactionImpl.timedOut();
                        } else if (l2 == 0L || l2 > transactionImpl._timeout) {
                            l2 = transactionImpl._timeout;
                        }
                        transactionImpl = transactionImpl._nextEntry;
                    }
                }
                this._nextTimeout = l2;
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private void recover(Journal journal, XAResource[] xAResourceArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        if (Configuration.verbose) {
            this._category.info((Object)("Initiating transaction recovery for domain " + this._domainName));
        }
        long l = Clock.clock();
        if (journal != null && (n = this.recoverJournal(journal)) > 0 && Configuration.verbose) {
            this._category.info((Object)("Loaded " + n + " records from transaction journal."));
        }
        if (xAResourceArray != null) {
            this.recoverResources(xAResourceArray);
        }
        int n4 = this._hashTable.length;
        while (n4-- > 0) {
            TransactionImpl transactionImpl = this._hashTable[n4];
            while (transactionImpl != null) {
                TransactionImpl transactionImpl2 = transactionImpl._nextEntry;
                if (transactionImpl._status == 2) {
                    transactionImpl._status = 0;
                    try {
                        transactionImpl.commit();
                        ++n2;
                    }
                    catch (Exception exception) {
                        this.recoveryError(new RecoveryException(exception));
                        ++n3;
                    }
                } else if (transactionImpl._status == 3) {
                    transactionImpl._status = 2;
                    transactionImpl.internalCommit(transactionImpl.canUseOnePhaseCommit());
                    try {
                        transactionImpl.forget(1);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                    ++n2;
                } else if (transactionImpl._status == 4) {
                    transactionImpl._status = 1;
                    transactionImpl.internalRollback();
                    try {
                        transactionImpl.forget(2);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                    ++n3;
                }
                transactionImpl = transactionImpl2;
            }
        }
        l = Clock.clock() - l;
        if (Configuration.verbose) {
            this._category.info((Object)("Transaction recovery for domain " + this._domainName + " completed in " + l + " ms"));
            this._category.info((Object)("Transaction recovery for domain " + this._domainName + ": " + n2 + " committed, " + n3 + " rolled back"));
        }
        this.reset();
        this._active = this._txCount;
    }

    private int recoverJournal(Journal journal) {
        Journal.RecoveredTransaction[] recoveredTransactionArray;
        try {
            recoveredTransactionArray = journal.recover();
        }
        catch (SystemException systemException) {
            this.recoveryError(new RecoveryException((Exception)((Object)systemException)));
            return 0;
        }
        if (recoveredTransactionArray != null && recoveredTransactionArray.length > 0) {
            int n = recoveredTransactionArray.length;
            while (n-- > 0) {
                if (recoveredTransactionArray[n] == null) continue;
                try {
                    this.recoverRecord(recoveredTransactionArray[n]);
                }
                catch (RecoveryException recoveryException) {
                    this.recoveryError(recoveryException);
                }
            }
        }
        return recoveredTransactionArray.length;
    }

    private void recoverRecord(Journal.RecoveredTransaction recoveredTransaction) throws RecoveryException {
        Xid xid = recoveredTransaction.getXid();
        if (xid == null) {
            throw new RecoveryException("Transaction recovery record missing Xid");
        }
        TransactionImpl transactionImpl = new TransactionImpl((BaseXid)XidUtils.importXid(xid), recoveredTransaction.getHeuristic(), this);
        int n = transactionImpl._hashCode;
        int n2 = (n & Integer.MAX_VALUE) % this._hashTable.length;
        TransactionImpl transactionImpl2 = this._hashTable[n2];
        if (transactionImpl2 == null) {
            this._hashTable[n2] = transactionImpl;
        } else {
            TransactionImpl transactionImpl3 = transactionImpl2._nextEntry;
            while (transactionImpl3 != null) {
                if (transactionImpl3._hashCode == n && transactionImpl3._xid.equals(xid)) {
                    throw new RecoveryException("A transaction with the identifier " + xid.toString() + " already exists");
                }
                transactionImpl2 = transactionImpl3;
                transactionImpl3 = transactionImpl3._nextEntry;
            }
            transactionImpl2._nextEntry = transactionImpl;
        }
        ++this._txCount;
        ++this._active;
    }

    private void recoverResources(XAResource[] xAResourceArray) {
        Xid[] xidArray = null;
        int n = xAResourceArray.length;
        while (n-- > 0) {
            try {
                xidArray = xAResourceArray[n].recover(0);
            }
            catch (XAException xAException) {
                this.recoveryError(new RecoveryException("Resource manager " + xAResourceArray[n] + " failed to recover: " + Util.getXAException(xAException)));
            }
            if (xidArray == null) continue;
            int n2 = xidArray.length;
            while (n2-- > 0) {
                Xid xid = xidArray[n2];
                if (xid == null) continue;
                TransactionImpl transactionImpl = this.findTransaction(xid = XidUtils.importXid(xid.getFormatId(), xid.getGlobalTransactionId(), null));
                if (transactionImpl == null) {
                    try {
                        xAResourceArray[n].commit(xid, true);
                    }
                    catch (XAException xAException) {
                        this.recoveryError(new RecoveryException(Util.getXAException(xAException)));
                    }
                    continue;
                }
                transactionImpl.addRecovery(xAResourceArray[n], xid);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void recoveryError(RecoveryException var1_1) {
        block1: {
            if (var1_1 == null) break block1;
            var2_2 = this._recoveryErrors;
            if (var2_2 != null) ** GOTO lbl7
            this._recoveryErrors = var1_1;
            break block1;
lbl-1000:
            // 1 sources

            {
                var2_2 = var2_2.getNextException();
lbl7:
                // 2 sources

                ** while (var2_2.getNextException() != null)
            }
lbl8:
            // 1 sources

            var2_2.setNextException(var1_1);
        }
    }

    public synchronized void identifyORB(ORB oRB, TSIdentification tSIdentification, Properties properties) {
        try {
            if (this._orb != null) {
                throw new AlreadyIdentified();
            }
            this._orb = oRB;
            if (tSIdentification != null) {
                tSIdentification.identify_sender((Sender)this._txFactory);
                tSIdentification.identify_receiver((Receiver)this._txFactory);
            }
        }
        catch (Exception exception) {
            this._category.error((Object)"Error occured while identifying ORB", (Throwable)exception);
            this._orb = null;
        }
    }
}

