/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.unittest;

import com.borland.jbuilder.unittest.Res;
import com.borland.jbuilder.unittest.TestCreateException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Socket;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;

public class JBTestRunner
implements TestListener {
    public static final String SUITE_METHOD_NAME = "suite";
    private static final String ERROR_MESSAGE_CANNOT_LOAD_CLASS;
    private PrintStream writer;
    private boolean failed = false;
    private Test test;
    private JUnitTestReporter reporter;
    private HashSet set = new HashSet();
    static /* synthetic */ Class class$com$borland$jbuilder$unittest$JBTestRunner;
    static /* synthetic */ Class class$junit$framework$Test;

    public JBTestRunner() {
        this(System.out);
    }

    public JBTestRunner(PrintStream writer) {
        if (writer == null) {
            throw new NullPointerException();
        }
        this.writer = writer;
        this.reporter = new JUnitTestReporter(this, writer);
    }

    public void addError(Test test, Throwable throwable) {
        this.failed = true;
        this.reporter.reportTestError(test, throwable);
    }

    public void addFailure(Test test, AssertionFailedError error) {
        this.failed = true;
        this.reporter.reportTestFailure(test, error);
    }

    public void startTest(Test test) {
        this.reporter.reportTestStart(test);
    }

    public void endTest(Test test) {
        this.reporter.reportTestEnd(test);
    }

    public void reportTestCreateException(TestCreateException e2) {
        this.reporter.reportTestCreateException(e2);
    }

    public static Test constructTest(String fullClassName) throws TestCreateException {
        TestSuite test = null;
        Class<?> testClass = null;
        try {
            testClass = Class.forName(fullClassName);
        }
        catch (ExceptionInInitializerError e2) {
            throw new TestCreateException(ERROR_MESSAGE_CANNOT_LOAD_CLASS, e2.getException());
        }
        catch (Throwable throwable) {
            throw new TestCreateException(ERROR_MESSAGE_CANNOT_LOAD_CLASS, throwable);
        }
        Method suiteMethod = JBTestRunner.assertSuiteMethod(testClass);
        if (suiteMethod != null) {
            try {
                test = (Test)suiteMethod.invoke(null, new Object[0]);
                if (test == null) {
                    throw new NullPointerException(Res._SuiteReturnNullError);
                }
            }
            catch (IllegalAccessException iae) {
                throw new TestCreateException(Res._InvokingSuiteError, iae);
            }
            catch (InvocationTargetException ite) {
                throw new TestCreateException(Res._InvokingSuiteError, ite.getTargetException());
            }
        }
        if (test == null) {
            test = new TestSuite(testClass);
        }
        return test;
    }

    private static Method assertSuiteMethod(Class testClass) throws TestCreateException {
        Method method = null;
        try {
            Class<?> returnType;
            method = testClass.getMethod(SUITE_METHOD_NAME, new Class[0]);
            int modifiers = method.getModifiers();
            if (!Modifier.isStatic(modifiers)) {
                throw new TestCreateException(String.valueOf(String.valueOf(Res._SuiteNoneStaticError)).concat(String.valueOf(String.valueOf(testClass.getName()))));
            }
            if (!(class$junit$framework$Test == null ? (class$junit$framework$Test = JBTestRunner.class$("junit.framework.Test")) : class$junit$framework$Test).isAssignableFrom(returnType = method.getReturnType())) {
                throw new TestCreateException(Res._SuiteShouldReturnAnTestObject);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return method;
    }

    public void setTest(String testClassName) throws TestCreateException {
        this.setTest(JBTestRunner.constructTest(testClassName));
    }

    public void setTest(Test test) {
        this.test = test;
        this.reporter.setTest(test);
    }

    public void writeTestHierarchy() {
        this.reporter.writeTestHierarchy();
    }

    public void addSelectedTest(String testCaseString) {
        int index = testCaseString.indexOf(58);
        if (index == -1) {
            throw new IllegalArgumentException(Res._WrongFormat);
        }
        this.set.add(testCaseString);
    }

    void run() {
        TestResult result = new TestResult();
        result.addListener((TestListener)this);
        if (this.set.size() > 0 && this.test instanceof TestSuite) {
            this.checkAndRunTestSuite(this.test, result);
        } else {
            this.test.run(result);
        }
    }

    private void checkAndRunTestSuite(Test test, TestResult result) {
        if (test instanceof TestSuite) {
            Enumeration enumeration = ((TestSuite)test).tests();
            while (enumeration.hasMoreElements()) {
                this.checkAndRunTestSuite((Test)enumeration.nextElement(), result);
            }
        } else if (test instanceof TestCase) {
            String testCaseString = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(test.getClass().getName()))).append(":").append(((TestCase)test).getName())));
            if (this.set.contains(testCaseString)) {
                test.run(result);
            } else {
                this.reporter.reportTestSkip(test);
            }
        } else {
            this.reporter.reportTestSkip(test);
        }
    }

    public void initiateTest(String fullClassName, String testCaseSet) {
        this.reporter.writeXmlHeader();
        try {
            this.setTest(fullClassName);
            StringTokenizer tokenizer = new StringTokenizer(testCaseSet, ";");
            while (tokenizer.hasMoreTokens()) {
                this.addSelectedTest(tokenizer.nextToken());
            }
            this.writeTestHierarchy();
            this.run();
        }
        catch (TestCreateException e2) {
            this.reportTestCreateException(e2);
        }
        catch (Throwable t) {
            System.out.println("Error Erorr!!!");
            t.printStackTrace();
        }
        this.reporter.close();
    }

    public void importFile(String fileName) throws IOException {
        FileInputStream fis = new FileInputStream(fileName);
        this.reporter.importXmlStream(fis);
        fis.close();
    }

    public static void printHelp() {
        String[] helpMessage = new String[]{Res._Usage, "java [-Djunit.import=importFile]".concat(String.valueOf(String.valueOf((class$com$borland$jbuilder$unittest$JBTestRunner == null ? (class$com$borland$jbuilder$unittest$JBTestRunner = JBTestRunner.class$("com.borland.jbuilder.unittest.JBTestRunner")) : class$com$borland$jbuilder$unittest$JBTestRunner).getName()))), Res._SocketOption, Res._SelectedOption, Res._SuiteClassName};
        for (int i = 0; i < helpMessage.length; ++i) {
            System.out.println(helpMessage[i]);
        }
    }

    public static void main(String[] arguments) throws IOException {
        Socket socket = null;
        String testCaseSet = "";
        String testSuiteName = null;
        String importFileName = null;
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i].equalsIgnoreCase("-socket")) {
                if (++i >= arguments.length) {
                    JBTestRunner.printHelp();
                    System.exit(1);
                }
                socket = JBTestRunner.loadSocket(arguments[i]);
                continue;
            }
            if (arguments[i].equalsIgnoreCase("-selected")) {
                if (++i >= arguments.length) {
                    JBTestRunner.printHelp();
                    System.exit(1);
                }
                testCaseSet = arguments[i];
                continue;
            }
            testSuiteName = arguments[i];
            break;
        }
        importFileName = System.getProperty("junit.import");
        if (testSuiteName == null && importFileName == null) {
            JBTestRunner.printHelp();
            System.exit(1);
        }
        PrintStream printer = null;
        printer = socket != null ? new PrintStream(socket.getOutputStream()) : System.out;
        JBTestRunner runner = new JBTestRunner(printer);
        if (importFileName == null) {
            runner.initiateTest(testSuiteName, testCaseSet);
        } else {
            runner.importFile(importFileName);
        }
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException ie) {
                ie.printStackTrace();
            }
        }
        System.exit(runner.failed ? 1 : 0);
    }

    private static Socket loadSocket(String socketInfomation) throws IOException {
        int index = socketInfomation.indexOf(":");
        String host = socketInfomation.substring(0, index);
        int port = Integer.parseInt(socketInfomation.substring(index + 1));
        return new Socket(host, port);
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    static {
        SUITE_METHOD_NAME = SUITE_METHOD_NAME;
        ERROR_MESSAGE_CANNOT_LOAD_CLASS = Res._CouldNotLoadTestSuiteClassError;
    }

    private class JUnitTestReporter {
        private static final String TAG_TEST_RUN = "testrun";
        private static final String TAG_TEST_HIERARCHY = "testhierarchy";
        private static final String TAG_TEST_SUITE = "testsuite";
        private static final String TAG_TEST_CASE = "testcase";
        private static final String TAG_TEST = "test";
        private static final String TAG_TEST_START = "teststart";
        private static final String TAG_TEST_END = "testend";
        private static final String TAG_TEST_FAILURE = "testfailure";
        private static final String TAG_STACK_TRACE = "stacktrace";
        private static final String TAG_TEST_ERROR = "testerror";
        private static final String TAG_TEST_SKIP = "testskip";
        private static final String TAG_PROBLEM = "problem";
        private Hashtable hashTable;
        private PrintStream printer;
        private Test test;
        private int id = 0;
        private StringBuffer tempBufferForPrinting;

        public JUnitTestReporter(JBTestRunner this$0, OutputStream outputStream) {
            this(this$0, new PrintStream(outputStream));
        }

        public JUnitTestReporter(JBTestRunner this$0, PrintStream printer) {
            if (printer == null) {
                throw new NullPointerException();
            }
            this.printer = printer;
            this.hashTable = new Hashtable();
            this.tempBufferForPrinting = new StringBuffer(64);
        }

        public void importXmlStream(InputStream is) throws IOException {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = reader.readLine()) != null) {
                this.printer.println(line);
            }
            reader.close();
        }

        public void setTest(Test test) {
            this.test = test;
        }

        public void writeTestHierarchy() {
            this.printStartTagBegin(TAG_TEST_HIERARCHY);
            this.printer.println(">");
            this.writeTestInformation(1, this.test);
            this.printCloseTag(TAG_TEST_HIERARCHY);
            this.printer.flush();
        }

        public void writeXmlHeader() {
            this.printer.println("<?xml version=\"1.0\"?>");
            this.printer.println("<testrun>");
        }

        public void close() {
            this.printer.print("</testrun>");
            if (this.printer != System.out) {
                this.printer.close();
            }
            this.printer = null;
        }

        private void writeTestInformation(int indentation, Test test) {
            if (test instanceof TestSuite) {
                this.writeTestSuiteInformation(indentation, (TestSuite)test);
            } else if (test instanceof TestCase) {
                this.writeTestCaseInformation(indentation, (TestCase)test);
            } else {
                this.writeTestObjectInformation(indentation, test);
            }
            this.printer.flush();
        }

        private void writeTestSuiteInformation(int indentation, TestSuite suite) {
            this.printIndentation(indentation);
            this.printStartTagBegin(TAG_TEST_SUITE);
            this.printAttribute("name", suite.toString());
            this.printAttribute("id", this.generateId((Test)suite));
            if (suite.testCount() == 0) {
                this.printer.println("/>");
            } else {
                this.printer.println(">");
                Enumeration enumeration = suite.tests();
                while (enumeration.hasMoreElements()) {
                    Test test = (Test)enumeration.nextElement();
                    this.writeTestInformation(indentation + 1, test);
                }
                this.printIndentation(indentation);
                this.printer.print("</");
                this.printer.print(TAG_TEST_SUITE);
                this.printer.println(">");
            }
        }

        private void writeTestCaseInformation(int indentation, TestCase testCase) {
            this.printIndentation(indentation);
            this.printStartTagBegin(TAG_TEST_CASE);
            this.printAttribute("class", testCase.getClass().getName());
            this.printAttribute("method", testCase.getName());
            this.printAttribute("id", this.generateId((Test)testCase));
            this.printer.println("/>");
        }

        private void writeTestObjectInformation(int indentation, Test test) {
            this.printIndentation(indentation);
            this.printStartTagBegin(TAG_TEST);
            this.printAttribute("name", test.toString());
            this.printAttribute("id", this.generateId(test));
            this.printAttribute("count", String.valueOf(test.countTestCases()));
            this.printer.println("/>");
        }

        private String generateId(Test test) {
            int current = this.id++;
            String integer = String.valueOf(current);
            this.hashTable.put(test, integer);
            return integer;
        }

        private String getId(Test test) {
            return (String)this.hashTable.get(test);
        }

        public void reportTestStart(Test test) {
            this.printStartTagBegin(TAG_TEST_START);
            this.printAttribute("id", this.getId(test));
            this.printer.println("/>");
            this.printer.flush();
        }

        public void reportTestEnd(Test test) {
            this.printStartTagBegin(TAG_TEST_END);
            this.printAttribute("id", this.getId(test));
            this.printer.println("/>");
            this.printer.flush();
        }

        public void reportTestFailure(Test test, AssertionFailedError error) {
            this.printStartTagBegin(TAG_TEST_FAILURE);
            this.printAttribute("id", this.getId(test));
            this.printer.println(">");
            this.printStackTrace(1, (Throwable)error);
            this.printCloseTag(TAG_TEST_FAILURE);
            this.printer.flush();
        }

        public void reportTestError(Test test, Throwable throwable) {
            this.printStartTagBegin(TAG_TEST_ERROR);
            this.printAttribute("id", this.getId(test));
            this.printer.println(">");
            this.printStackTrace(1, throwable);
            this.printCloseTag(TAG_TEST_ERROR);
            this.printer.flush();
        }

        public void reportTestSkip(Test test) {
            this.printStartTagBegin(TAG_TEST_SKIP);
            this.printAttribute("id", this.getId(test));
            this.printer.println("/>");
            this.printer.flush();
        }

        public void reportTestCreateException(TestCreateException e2) {
            this.printIndentation(1);
            this.printStartTagBegin(TAG_PROBLEM);
            this.printer.println(">");
            this.printStackTrace(2, e2);
            this.printIndentation(1);
            this.printCloseTag(TAG_PROBLEM);
            this.printer.flush();
        }

        private void printStackTrace(int indent, Throwable throwable) {
            this.printIndentation(indent);
            this.printStartTagBegin(TAG_STACK_TRACE);
            this.printer.print("><![CDATA[");
            throwable.printStackTrace(this.printer);
            this.printer.print("]]>");
            this.printCloseTag(TAG_STACK_TRACE);
        }

        private void printStartTagBegin(String tag) {
            this.tempBufferForPrinting.append("<");
            this.tempBufferForPrinting.append(tag);
            this.printer.print(this.tempBufferForPrinting.toString());
            this.tempBufferForPrinting.delete(0, this.tempBufferForPrinting.length());
        }

        private void printAttribute(String name, String value) {
            this.tempBufferForPrinting.append(" ");
            this.tempBufferForPrinting.append(name);
            this.tempBufferForPrinting.append("=\"");
            this.tempBufferForPrinting.append(value);
            this.tempBufferForPrinting.append("\"");
            this.printer.print(this.tempBufferForPrinting.toString());
            this.tempBufferForPrinting.delete(0, this.tempBufferForPrinting.length());
        }

        private void printCloseTag(String tag) {
            this.tempBufferForPrinting.append("</");
            this.tempBufferForPrinting.append(tag);
            this.tempBufferForPrinting.append(">");
            this.printer.println(this.tempBufferForPrinting.toString());
            this.tempBufferForPrinting.delete(0, this.tempBufferForPrinting.length());
        }

        private void printIndentation(int indentation) {
            for (int i = 0; i < indentation; ++i) {
                this.printer.print("  ");
            }
        }

        static {
            TAG_TEST_RUN = TAG_TEST_RUN;
            TAG_TEST_HIERARCHY = TAG_TEST_HIERARCHY;
            TAG_TEST_SUITE = TAG_TEST_SUITE;
            TAG_TEST_CASE = TAG_TEST_CASE;
            TAG_TEST = TAG_TEST;
            TAG_TEST_START = TAG_TEST_START;
            TAG_TEST_END = TAG_TEST_END;
            TAG_TEST_FAILURE = TAG_TEST_FAILURE;
            TAG_STACK_TRACE = TAG_STACK_TRACE;
            TAG_TEST_ERROR = TAG_TEST_ERROR;
            TAG_TEST_SKIP = TAG_TEST_SKIP;
            TAG_PROBLEM = TAG_PROBLEM;
        }
    }
}

