/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.unittest;

import com.borland.jbuilder.unittest.Res;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;

public class PackageTestSuite {
    public static final String JAVA_EXTENSION = ".java";
    private static boolean isPackageTestsuite;
    public static final String PROPERTY_PACKAGE = "junit.package";
    public static final String PROPERTY_FILE_PREFIX = "junit.prefix";
    public static final String PROPERTY_FILE_POSTFIX = "junit.postfix";
    public static final String PROPERTY_SOURCE_ROOT = "junit.sourceroot";
    public static final String PROPERTY_RECURSIVE = "junit.recursive";
    public static final String DEFAULT_VALUE_PACKAGE = "";
    public static final String DEFAULT_VALUE_FILE_PREFIX = "Test";
    public static final String DEFAULT_VALUE_FILE_POSTFIX = "";
    public static final String DEFAULT_VALUE_SOURCE_ROOT = "test";
    public static final String DEFAULT_VALUE_RECURSIVE = "true";
    static /* synthetic */ Class class$com$borland$jbuilder$unittest$PackageTestSuite;

    public static boolean isPackageTestSuite() {
        return isPackageTestsuite;
    }

    public static FileFilter getDefaultFileFilter(final String preFix, String postFix) {
        final String fileEndWith = String.valueOf(String.valueOf(postFix)).concat(JAVA_EXTENSION);
        return new FileFilter(){

            public boolean accept(File pathName) {
                String name = pathName.getName();
                return pathName.isFile() && name.endsWith(fileEndWith) && name.startsWith(preFix);
            }
        };
    }

    public static TestSuite loadTestSuite(String sourcePath, String packageName, FileFilter fileFilter, boolean recursive, boolean compress) {
        File file = new File(sourcePath);
        if (file.exists() && file.isDirectory()) {
            return PackageTestSuite.loadTestSuite(file, packageName, fileFilter, recursive, compress);
        }
        TestSuite suite = new TestSuite(Res._Error);
        suite.addTest(PackageTestSuite.createTestWithError(Res._DirectoryNotFound, new FileNotFoundException(sourcePath)));
        return suite;
    }

    public static TestSuite loadTestSuite(File directory, String packageName, FileFilter fileFilter, boolean recursive, boolean compress) {
        isPackageTestsuite = true;
        if (packageName == null) {
            packageName = "";
        }
        String name = null;
        String packageNamePrefix = null;
        if (packageName.length() == 0) {
            name = recursive ? Res._AllTests : Res._DefaultPackage;
            packageNamePrefix = "";
        } else {
            name = packageName;
            packageNamePrefix = String.valueOf(String.valueOf(packageName)).concat(".");
        }
        TestSuite suite = PackageTestSuite.scanTestSuite(directory, packageNamePrefix, fileFilter, recursive);
        if (suite.testCount() != 0 && suite.testCount() == 1 && compress) {
            suite = PackageTestSuite.compressTestTree(suite, packageNamePrefix);
        }
        suite.setName(name);
        return suite;
    }

    private static TestSuite compressTestTree(TestSuite suite, String packageNamePrefix) {
        TestSuite subSuite = suite;
        Test test = suite.testAt(0);
        StringBuffer buffer = new StringBuffer(packageNamePrefix);
        while (test instanceof TestSuite) {
            subSuite = (TestSuite)test;
            buffer.append(subSuite.getName()).append(".");
            if (subSuite.testCount() != 1) break;
            test = subSuite.testAt(0);
        }
        suite = new TestSuite();
        Enumeration enumeration = subSuite.tests();
        while (enumeration.hasMoreElements()) {
            Test oneTest = (Test)enumeration.nextElement();
            if (oneTest instanceof TestSuite) {
                TestSuite suiteToRename = (TestSuite)oneTest;
                suiteToRename.setName(String.valueOf(String.valueOf(buffer.toString())).concat(String.valueOf(String.valueOf(suiteToRename.getName()))));
                suite.addTest((Test)suiteToRename);
                continue;
            }
            int len = buffer.length();
            buffer.delete(len - 1, len);
            subSuite.setName(buffer.toString());
            suite.addTest((Test)subSuite);
            break;
        }
        return suite;
    }

    private static TestSuite scanTestSuite(File directory, String packageNamePrefix, FileFilter fileFilter, boolean recursive) {
        TestSuite suite = new TestSuite();
        if (recursive) {
            PackageTestSuite.scanSubDirectories(suite, directory, packageNamePrefix, fileFilter, recursive);
        }
        PackageTestSuite.scanCurrentDirectory(suite, directory, packageNamePrefix, fileFilter);
        return suite;
    }

    private static void scanSubDirectories(TestSuite suite, File directory, String packagePrefix, FileFilter fileFilter, boolean compress) {
        File[] subDirectories = directory.listFiles(new FileFilter(){

            public boolean accept(File pathName) {
                return pathName.isDirectory();
            }
        });
        for (int i = 0; i < subDirectories.length; ++i) {
            String subPackagePrefix = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(packagePrefix))).append(subDirectories[i].getName()).append(".")));
            TestSuite subSuite = PackageTestSuite.scanTestSuite(subDirectories[i], subPackagePrefix, fileFilter, true);
            if (subSuite.testCount() > 0) {
                suite.addTest((Test)subSuite);
            }
            subSuite.setName(subDirectories[i].getName());
        }
    }

    private static void scanCurrentDirectory(TestSuite suite, File directory, String packagePrefix, FileFilter fileFilter) {
        File[] files = directory.listFiles(fileFilter);
        for (int i = 0; i < files.length; ++i) {
            String name = files[i].getName();
            Test test = null;
            String shortName = name.substring(0, name.length() - JAVA_EXTENSION.length());
            try {
                Class<?> testClass = Class.forName(String.valueOf(String.valueOf(packagePrefix)).concat(String.valueOf(String.valueOf(shortName))));
                TestSuite classSuite = new TestSuite(testClass);
                classSuite.setName(shortName);
                test = classSuite;
            }
            catch (ClassNotFoundException cnfe) {
                test = PackageTestSuite.createTestWithError(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Res._CouldnotLoadClass))).append(shortName).append(">"))), cnfe);
            }
            catch (Throwable throwable) {
                test = PackageTestSuite.createTestWithError(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Res._ErrorLoadingClass))).append(shortName).append(">"))), throwable);
            }
            suite.addTest(test);
        }
    }

    private static Test createTestWithWarning(String name, final String message) {
        return new TestCase(name){

            protected void runTest() {
                Assert.fail((String)message);
            }
        };
    }

    private static Test createTestWithError(String name, final Throwable throwable) {
        return new TestCase(name){

            protected void runTest() throws Throwable {
                throw throwable;
            }
        };
    }

    public static Test suite() {
        try {
            String packageName = System.getProperty(PROPERTY_PACKAGE, "");
            String preFix = System.getProperty(PROPERTY_FILE_PREFIX, DEFAULT_VALUE_FILE_PREFIX);
            String postFix = System.getProperty(PROPERTY_FILE_POSTFIX, "");
            String fileEndWith = String.valueOf(String.valueOf(postFix)).concat(JAVA_EXTENSION);
            String sourceRoot = System.getProperty(PROPERTY_SOURCE_ROOT, DEFAULT_VALUE_SOURCE_ROOT);
            String path = packageName.replace('.', File.separatorChar);
            String recursiveValue = System.getProperty(PROPERTY_RECURSIVE, DEFAULT_VALUE_RECURSIVE);
            boolean recursive = !"false".equals(recursiveValue);
            TestSuite testSuite = PackageTestSuite.loadTestSuite(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(sourceRoot))).append(File.separator).append(path))), packageName, PackageTestSuite.getDefaultFileFilter(preFix, postFix), recursive, true);
            return testSuite;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return new TestSuite("Error");
        }
    }

    public static void main(String[] arguments) {
        TestRunner.run((Class)(class$com$borland$jbuilder$unittest$PackageTestSuite == null ? (class$com$borland$jbuilder$unittest$PackageTestSuite = PackageTestSuite.class$("com.borland.jbuilder.unittest.PackageTestSuite")) : class$com$borland$jbuilder$unittest$PackageTestSuite));
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    static {
        JAVA_EXTENSION = JAVA_EXTENSION;
        isPackageTestsuite = false;
        PROPERTY_PACKAGE = PROPERTY_PACKAGE;
        PROPERTY_FILE_PREFIX = PROPERTY_FILE_PREFIX;
        PROPERTY_FILE_POSTFIX = PROPERTY_FILE_POSTFIX;
        PROPERTY_SOURCE_ROOT = PROPERTY_SOURCE_ROOT;
        PROPERTY_RECURSIVE = PROPERTY_RECURSIVE;
        DEFAULT_VALUE_PACKAGE = "";
        DEFAULT_VALUE_FILE_PREFIX = DEFAULT_VALUE_FILE_PREFIX;
        DEFAULT_VALUE_FILE_POSTFIX = "";
        DEFAULT_VALUE_SOURCE_ROOT = DEFAULT_VALUE_SOURCE_ROOT;
        DEFAULT_VALUE_RECURSIVE = DEFAULT_VALUE_RECURSIVE;
    }
}

