/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.xalan.lib.sql.ConnectionPool;
import org.apache.xalan.lib.sql.DTMDocument;
import org.apache.xml.dtm.DTMManager;

public class SQLDocument
extends DTMDocument {
    private boolean DEBUG = false;
    private static final String S_NAMESPACE = "http://xml.apache.org/xalan/SQLExtension";
    private static final String S_SQL = "sql";
    private static final String S_ROW_SET = "row-set";
    private static final String S_METADATA = "metadata";
    private static final String S_COLUMN_HEADER = "column-header";
    private static final String S_ROW = "row";
    private static final String S_COL = "col";
    private static final String S_CATALOGUE_NAME = "catalogue-name";
    private static final String S_DISPLAY_SIZE = "column-display-size";
    private static final String S_COLUMN_LABEL = "column-label";
    private static final String S_COLUMN_NAME = "column-name";
    private static final String S_COLUMN_TYPE = "column-type";
    private static final String S_COLUMN_TYPENAME = "column-typename";
    private static final String S_PRECISION = "precision";
    private static final String S_SCALE = "scale";
    private static final String S_SCHEMA_NAME = "schema-name";
    private static final String S_TABLE_NAME = "table-name";
    private static final String S_CASESENSITIVE = "case-sensitive";
    private static final String S_DEFINITLEYWRITABLE = "definitley-writable";
    private static final String S_ISNULLABLE = "nullable";
    private static final String S_ISSIGNED = "signed";
    private static final String S_ISWRITEABLE = "writable";
    private static final String S_ISSEARCHABLE = "searchable";
    private int m_SQL_TypeID = 0;
    private int m_MetaData_TypeID = 0;
    private int m_ColumnHeader_TypeID = 0;
    private int m_RowSet_TypeID = 0;
    private int m_Row_TypeID = 0;
    private int m_Col_TypeID = 0;
    private int m_ColAttrib_CATALOGUE_NAME_TypeID = 0;
    private int m_ColAttrib_DISPLAY_SIZE_TypeID = 0;
    private int m_ColAttrib_COLUMN_LABEL_TypeID = 0;
    private int m_ColAttrib_COLUMN_NAME_TypeID = 0;
    private int m_ColAttrib_COLUMN_TYPE_TypeID = 0;
    private int m_ColAttrib_COLUMN_TYPENAME_TypeID = 0;
    private int m_ColAttrib_PRECISION_TypeID = 0;
    private int m_ColAttrib_SCALE_TypeID = 0;
    private int m_ColAttrib_SCHEMA_NAME_TypeID = 0;
    private int m_ColAttrib_TABLE_NAME_TypeID = 0;
    private int m_ColAttrib_CASESENSITIVE_TypeID = 0;
    private int m_ColAttrib_DEFINITLEYWRITEABLE_TypeID = 0;
    private int m_ColAttrib_ISNULLABLE_TypeID = 0;
    private int m_ColAttrib_ISSIGNED_TypeID = 0;
    private int m_ColAttrib_ISWRITEABLE_TypeID = 0;
    private int m_ColAttrib_ISSEARCHABLE_TypeID = 0;
    private Connection m_Connection = null;
    private Statement m_Statement = null;
    private ResultSet m_ResultSet = null;
    private ConnectionPool m_ConnectionPool = null;
    private int[] m_ColHeadersIdx;
    private int m_ColCount;
    private int m_MetaDataIdx = -1;
    private int m_RowSetIdx = -1;
    private int m_SQLIdx = -1;
    private int m_FirstRowIdx = -1;
    private int m_LastRowIdx = -1;
    private boolean m_StreamingMode = true;

    public SQLDocument(DTMManager dTMManager, int n, ConnectionPool connectionPool, Connection connection, Statement statement, ResultSet resultSet, boolean bl) throws SQLException {
        super(dTMManager, n);
        this.m_Connection = connection;
        this.m_Statement = statement;
        this.m_ResultSet = resultSet;
        this.m_ConnectionPool = connectionPool;
        this.m_StreamingMode = bl;
        this.createExpandedNameTable();
        this.extractSQLMetaData(this.m_ResultSet.getMetaData());
        this.addRowToDTMFromResultSet();
    }

    protected int _nextsib(int n) {
        int n2 = this._exptype(n);
        if (n2 == this.m_Row_TypeID && n >= this.m_LastRowIdx) {
            if (this.DEBUG) {
                System.out.println("reading from the ResultSet");
            }
            this.addRowToDTMFromResultSet();
        }
        return super._nextsib(n);
    }

    private boolean addRowToDTMFromResultSet() {
        try {
            if (this.m_RowSetIdx == -1) {
                this.m_RowSetIdx = this.addElement(1, this.m_RowSet_TypeID, this.m_SQLIdx, this.m_MetaDataIdx);
            }
            if (!this.m_ResultSet.next()) {
                if (this.m_StreamingMode) {
                    this.m_nextsib.setElementAt(-1, this.m_LastRowIdx);
                }
                return false;
            }
            if (this.m_FirstRowIdx == -1) {
                this.m_LastRowIdx = this.m_FirstRowIdx = this.addElement(2, this.m_Row_TypeID, this.m_RowSetIdx, -1);
                if (this.m_StreamingMode) {
                    this.m_nextsib.setElementAt(this.m_LastRowIdx, this.m_LastRowIdx);
                }
            } else if (!this.m_StreamingMode) {
                this.m_LastRowIdx = this.addElement(3, this.m_Row_TypeID, this.m_RowSetIdx, this.m_LastRowIdx);
            }
            int n = this._firstch(this.m_LastRowIdx);
            int n2 = -1;
            int n3 = 1;
            while (n3 <= this.m_ColCount) {
                Object object = this.m_ResultSet.getObject(n3);
                if (n == -1) {
                    n2 = this.addElementWithData(object, 3, this.m_Col_TypeID, this.m_LastRowIdx, n2);
                    this.cloneAttributeFromNode(n2, this.m_ColHeadersIdx[n3 - 1]);
                } else {
                    int n4 = this._firstch(n);
                    if (n4 == -1) {
                        this.error("Streaming Mode, Data Error");
                    } else {
                        this.m_ObjectArray.setAt(n4, object);
                    }
                }
                if (n != -1) {
                    n = this._nextsib(n);
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            if (this.DEBUG) {
                System.out.println("SQL Error Fetching next row [" + exception.getLocalizedMessage() + "]");
            }
            this.error("SQL Error Fetching next row [" + exception.getLocalizedMessage() + "]");
        }
        return true;
    }

    public void close() {
        if (this.DEBUG) {
            System.out.println("close()");
        }
        try {
            if (this.m_ResultSet != null) {
                this.m_ResultSet.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (this.m_Statement != null) {
                this.m_Statement.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (this.m_Connection != null) {
                this.m_ConnectionPool.releaseConnection(this.m_Connection);
            }
        }
        catch (Exception exception) {}
    }

    public void closeOnError() {
        if (this.DEBUG) {
            System.out.println("close()");
        }
        try {
            if (this.m_ResultSet != null) {
                this.m_ResultSet.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (this.m_Statement != null) {
                this.m_Statement.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (this.m_Connection != null) {
                this.m_ConnectionPool.releaseConnectionOnError(this.m_Connection);
            }
        }
        catch (Exception exception) {}
    }

    protected void createExpandedNameTable() {
        super.createExpandedNameTable();
        this.m_SQL_TypeID = this.m_expandedNameTable.getExpandedTypeID(S_NAMESPACE, S_SQL, 1);
        this.m_MetaData_TypeID = this.m_expandedNameTable.getExpandedTypeID(S_NAMESPACE, S_METADATA, 1);
        this.m_ColumnHeader_TypeID = this.m_expandedNameTable.getExpandedTypeID(S_NAMESPACE, S_COLUMN_HEADER, 1);
        this.m_RowSet_TypeID = this.m_expandedNameTable.getExpandedTypeID(S_NAMESPACE, S_ROW_SET, 1);
        this.m_Row_TypeID = this.m_expandedNameTable.getExpandedTypeID(S_NAMESPACE, S_ROW, 1);
        this.m_Col_TypeID = this.m_expandedNameTable.getExpandedTypeID(S_NAMESPACE, S_COL, 1);
        this.m_ColAttrib_CATALOGUE_NAME_TypeID = this.m_expandedNameTable.getExpandedTypeID(S_NAMESPACE, S_CATALOGUE_NAME, 2);
        this.m_ColAttrib_DISPLAY_SIZE_TypeID = this.m_expandedNameTable.getExpandedTypeID(S_NAMESPACE, S_DISPLAY_SIZE, 2);
        this.m_ColAttrib_COLUMN_LABEL_TypeID = this.m_expandedNameTable.getExpandedTypeID(S_NAMESPACE, S_COLUMN_LABEL, 2);
        this.m_ColAttrib_COLUMN_NAME_TypeID = this.m_expandedNameTable.getExpandedTypeID(S_NAMESPACE, S_COLUMN_NAME, 2);
        this.m_ColAttrib_COLUMN_TYPE_TypeID = this.m_expandedNameTable.getExpandedTypeID(S_NAMESPACE, S_COLUMN_TYPE, 2);
        this.m_ColAttrib_COLUMN_TYPENAME_TypeID = this.m_expandedNameTable.getExpandedTypeID(S_NAMESPACE, S_COLUMN_TYPENAME, 2);
        this.m_ColAttrib_PRECISION_TypeID = this.m_expandedNameTable.getExpandedTypeID(S_NAMESPACE, S_PRECISION, 2);
        this.m_ColAttrib_SCALE_TypeID = this.m_expandedNameTable.getExpandedTypeID(S_NAMESPACE, S_SCALE, 2);
        this.m_ColAttrib_SCHEMA_NAME_TypeID = this.m_expandedNameTable.getExpandedTypeID(S_NAMESPACE, S_SCHEMA_NAME, 2);
        this.m_ColAttrib_TABLE_NAME_TypeID = this.m_expandedNameTable.getExpandedTypeID(S_NAMESPACE, S_TABLE_NAME, 2);
        this.m_ColAttrib_CASESENSITIVE_TypeID = this.m_expandedNameTable.getExpandedTypeID(S_NAMESPACE, S_CASESENSITIVE, 2);
        this.m_ColAttrib_DEFINITLEYWRITEABLE_TypeID = this.m_expandedNameTable.getExpandedTypeID(S_NAMESPACE, S_DEFINITLEYWRITABLE, 2);
        this.m_ColAttrib_ISNULLABLE_TypeID = this.m_expandedNameTable.getExpandedTypeID(S_NAMESPACE, S_ISNULLABLE, 2);
        this.m_ColAttrib_ISSIGNED_TypeID = this.m_expandedNameTable.getExpandedTypeID(S_NAMESPACE, S_ISSIGNED, 2);
        this.m_ColAttrib_ISWRITEABLE_TypeID = this.m_expandedNameTable.getExpandedTypeID(S_NAMESPACE, S_ISWRITEABLE, 2);
        this.m_ColAttrib_ISSEARCHABLE_TypeID = this.m_expandedNameTable.getExpandedTypeID(S_NAMESPACE, S_ISSEARCHABLE, 2);
    }

    public void documentRegistration() {
        if (this.DEBUG) {
            System.out.println("Document Registration");
        }
    }

    public void documentRelease() {
        if (this.DEBUG) {
            System.out.println("Document Release");
        }
    }

    private void extractSQLMetaData(ResultSetMetaData resultSetMetaData) {
        this.m_DocumentIdx = this.addElement(0, this.m_Document_TypeID, -1, -1);
        this.m_SQLIdx = this.addElement(1, this.m_SQL_TypeID, this.m_DocumentIdx, -1);
        this.m_MetaDataIdx = this.addElement(1, this.m_MetaData_TypeID, this.m_SQLIdx, -1);
        try {
            this.m_ColCount = resultSetMetaData.getColumnCount();
            this.m_ColHeadersIdx = new int[this.m_ColCount];
        }
        catch (Exception exception) {
            this.error("ERROR Extracting Metadata");
        }
        int n = -1;
        int n2 = 1;
        n2 = 1;
        while (n2 <= this.m_ColCount) {
            this.m_ColHeadersIdx[n2 - 1] = this.addElement(2, this.m_ColumnHeader_TypeID, this.m_MetaDataIdx, n);
            n = this.m_ColHeadersIdx[n2 - 1];
            try {
                this.addAttributeToNode(resultSetMetaData.getColumnName(n2), this.m_ColAttrib_COLUMN_NAME_TypeID, n);
            }
            catch (Exception exception) {
                this.addAttributeToNode("Not Supported", this.m_ColAttrib_COLUMN_NAME_TypeID, n);
            }
            try {
                this.addAttributeToNode(resultSetMetaData.getColumnLabel(n2), this.m_ColAttrib_COLUMN_LABEL_TypeID, n);
            }
            catch (Exception exception) {
                this.addAttributeToNode("Not Supported", this.m_ColAttrib_COLUMN_LABEL_TypeID, n);
            }
            try {
                this.addAttributeToNode(resultSetMetaData.getCatalogName(n2), this.m_ColAttrib_CATALOGUE_NAME_TypeID, n);
            }
            catch (Exception exception) {
                this.addAttributeToNode("Not Supported", this.m_ColAttrib_CATALOGUE_NAME_TypeID, n);
            }
            try {
                this.addAttributeToNode(new Integer(resultSetMetaData.getColumnDisplaySize(n2)), this.m_ColAttrib_DISPLAY_SIZE_TypeID, n);
            }
            catch (Exception exception) {
                this.addAttributeToNode("Not Supported", this.m_ColAttrib_DISPLAY_SIZE_TypeID, n);
            }
            try {
                this.addAttributeToNode(new Integer(resultSetMetaData.getColumnType(n2)), this.m_ColAttrib_COLUMN_TYPE_TypeID, n);
            }
            catch (Exception exception) {
                this.addAttributeToNode("Not Supported", this.m_ColAttrib_COLUMN_TYPE_TypeID, n);
            }
            try {
                this.addAttributeToNode(resultSetMetaData.getColumnTypeName(n2), this.m_ColAttrib_COLUMN_TYPENAME_TypeID, n);
            }
            catch (Exception exception) {
                this.addAttributeToNode("Not Supported", this.m_ColAttrib_COLUMN_TYPENAME_TypeID, n);
            }
            try {
                this.addAttributeToNode(new Integer(resultSetMetaData.getPrecision(n2)), this.m_ColAttrib_PRECISION_TypeID, n);
            }
            catch (Exception exception) {
                this.addAttributeToNode("Not Supported", this.m_ColAttrib_PRECISION_TypeID, n);
            }
            try {
                this.addAttributeToNode(new Integer(resultSetMetaData.getScale(n2)), this.m_ColAttrib_SCALE_TypeID, n);
            }
            catch (Exception exception) {
                this.addAttributeToNode("Not Supported", this.m_ColAttrib_SCALE_TypeID, n);
            }
            try {
                this.addAttributeToNode(resultSetMetaData.getSchemaName(n2), this.m_ColAttrib_SCHEMA_NAME_TypeID, n);
            }
            catch (Exception exception) {
                this.addAttributeToNode("Not Supported", this.m_ColAttrib_SCHEMA_NAME_TypeID, n);
            }
            try {
                this.addAttributeToNode(resultSetMetaData.getTableName(n2), this.m_ColAttrib_TABLE_NAME_TypeID, n);
            }
            catch (Exception exception) {
                this.addAttributeToNode("Not Supported", this.m_ColAttrib_TABLE_NAME_TypeID, n);
            }
            try {
                this.addAttributeToNode(resultSetMetaData.isCaseSensitive(n2) ? "true" : "false", this.m_ColAttrib_CASESENSITIVE_TypeID, n);
            }
            catch (Exception exception) {
                this.addAttributeToNode("Not Supported", this.m_ColAttrib_CASESENSITIVE_TypeID, n);
            }
            try {
                this.addAttributeToNode(resultSetMetaData.isDefinitelyWritable(n2) ? "true" : "false", this.m_ColAttrib_DEFINITLEYWRITEABLE_TypeID, n);
            }
            catch (Exception exception) {
                this.addAttributeToNode("Not Supported", this.m_ColAttrib_DEFINITLEYWRITEABLE_TypeID, n);
            }
            try {
                this.addAttributeToNode(resultSetMetaData.isNullable(n2) != 0 ? "true" : "false", this.m_ColAttrib_ISNULLABLE_TypeID, n);
            }
            catch (Exception exception) {
                this.addAttributeToNode("Not Supported", this.m_ColAttrib_ISNULLABLE_TypeID, n);
            }
            try {
                this.addAttributeToNode(resultSetMetaData.isSigned(n2) ? "true" : "false", this.m_ColAttrib_ISSIGNED_TypeID, n);
            }
            catch (Exception exception) {
                this.addAttributeToNode("Not Supported", this.m_ColAttrib_ISSIGNED_TypeID, n);
            }
            try {
                this.addAttributeToNode(resultSetMetaData.isWritable(n2) ? "true" : "false", this.m_ColAttrib_ISWRITEABLE_TypeID, n);
            }
            catch (Exception exception) {
                this.addAttributeToNode("Not Supported", this.m_ColAttrib_ISWRITEABLE_TypeID, n);
            }
            try {
                this.addAttributeToNode(resultSetMetaData.isSearchable(n2) ? "true" : "false", this.m_ColAttrib_ISSEARCHABLE_TypeID, n);
            }
            catch (Exception exception) {
                this.addAttributeToNode("Not Supported", this.m_ColAttrib_ISSEARCHABLE_TypeID, n);
            }
            ++n2;
        }
    }

    protected boolean nextNode() {
        if (this.DEBUG) {
            System.out.println("nextNode()");
        }
        try {
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

