/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.util.Enumeration;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.trace.GenerateEvent;
import org.apache.xalan.trace.TraceManager;
import org.apache.xalan.transformer.ClonerToResultTree;
import org.apache.xalan.transformer.QueuedEvents;
import org.apache.xalan.transformer.SerializerSwitcher;
import org.apache.xalan.transformer.TransformState;
import org.apache.xalan.transformer.TransformerClient;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.ref.DTMNodeIterator;
import org.apache.xml.dtm.ref.dom2dtm.DOM2DTM;
import org.apache.xml.utils.MutableAttrListImpl;
import org.apache.xml.utils.NamespaceSupport2;
import org.apache.xml.utils.XMLCharacterRecognizer;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class ResultTreeHandler
extends QueuedEvents
implements ContentHandler,
LexicalHandler,
TransformState,
DOM2DTM.CharacterNodeHandler,
ErrorHandler {
    private static final boolean DEBUG = false;
    boolean m_nsContextPushed = false;
    boolean m_isTransformClient = false;
    NamespaceSupport m_nsSupport = new NamespaceSupport2();
    private TransformerImpl m_transformer;
    private ContentHandler m_contentHandler;
    private LexicalHandler m_lexicalHandler;
    private StylesheetRoot m_stylesheetRoot = null;
    private int m_uniqueNSValue = 0;
    private static final String S_NAMESPACEPREFIX = "ns";
    public ClonerToResultTree m_cloner;
    private TraceManager m_tracer;
    private QueuedStateSnapshot m_snapshot = new QueuedStateSnapshot();

    public ResultTreeHandler() {
    }

    public ResultTreeHandler(TransformerImpl transformerImpl, ContentHandler contentHandler) {
        this.init(transformerImpl, contentHandler);
    }

    public void addAttribute(int n) throws TransformerException {
        DTM dTM = this.m_transformer.getXPathContext().getDTM(n);
        if (this.isDefinedNSDecl(n, dTM)) {
            return;
        }
        String string = dTM.getNamespaceURI(n);
        if (string == null) {
            string = "";
        }
        this.addAttribute(string, dTM.getLocalName(n), dTM.getNodeName(n), "CDATA", dTM.getNodeValue(n));
    }

    public void addAttribute(String string, String string2, String string3, String string4, String string5) throws TransformerException {
        if (!this.m_nsDeclsHaveBeenAdded) {
            this.addNSDeclsToAttrs();
        }
        if (string == null) {
            string = "";
        }
        try {
            if (!string3.equals("xmlns")) {
                this.ensurePrefixIsDeclared(string, string3);
            }
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
        if (!this.isDefinedNSDecl(string3, string5)) {
            this.m_attributes.addAttribute(string, string2, string3, string4, string5);
        }
    }

    public void addAttributes(int n) throws TransformerException {
        DTM dTM = this.m_transformer.getXPathContext().getDTM(n);
        int n2 = dTM.getFirstAttribute(n);
        while (n2 != -1) {
            this.addAttribute(n2);
            n2 = dTM.getNextAttribute(n2);
        }
    }

    public void addNSDeclsToAttrs() {
        Enumeration enumeration = this.m_nsSupport.getDeclaredPrefixes();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            boolean bl = string.length() == 0;
            String string2 = bl ? "xmlns" : "xmlns:" + string;
            String string3 = this.m_nsSupport.getURI(string);
            if (string3 == null) {
                string3 = "";
            }
            this.m_attributes.addAttribute("http://www.w3.org/2000/xmlns/", string, string2, "CDATA", string3);
        }
        this.m_nsDeclsHaveBeenAdded = true;
    }

    public void characters(Node node) throws SAXException {
        this.flushPending(true);
        if (this.m_isTransformClient) {
            this.m_snapshot.m_currentNode = node;
        }
        String string = node.getNodeValue();
        char[] cArray = null;
        int n = 0;
        if (string != null) {
            cArray = string.toCharArray();
            n = string.length();
            this.m_contentHandler.characters(cArray, 0, n);
        }
        if (this.m_tracer != null) {
            GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 5, cArray, 0, n);
            this.m_tracer.fireGenerateEvent(generateEvent);
        }
        if (this.m_isTransformClient) {
            this.m_snapshot.m_currentNode = null;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.flushPending(true);
        this.m_contentHandler.characters(cArray, n, n2);
        if (this.m_tracer != null) {
            GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 5, cArray, n, n2);
            this.m_tracer.fireGenerateEvent(generateEvent);
        }
    }

    private void checkForSerializerSwitch(String string, String string2) throws SAXException {
        try {
            if (this.m_docPending) {
                SerializerSwitcher.switchSerializerIfHTML(this.m_transformer, string, string2);
            }
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }

    public void comment(String string) throws SAXException {
        this.flushPending(true);
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.comment(string.toCharArray(), 0, string.length());
        }
        if (this.m_tracer != null) {
            GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 8, string);
            this.m_tracer.fireGenerateEvent(generateEvent);
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.flushPending(true);
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.comment(cArray, n, n2);
        }
        if (this.m_tracer != null) {
            GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 8, new String(cArray, n, n2));
            this.m_tracer.fireGenerateEvent(generateEvent);
        }
    }

    public void endCDATA() throws SAXException {
        this.flushPending(true);
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.endCDATA();
        }
    }

    public void endDTD() throws SAXException {
        this.flushPending(true);
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.endDTD();
        }
    }

    public void endDocument() throws SAXException {
        this.flushPending(true);
        if (!this.m_docEnded) {
            this.m_contentHandler.endDocument();
            if (this.m_tracer != null) {
                GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 2, null);
                this.m_tracer.fireGenerateEvent(generateEvent);
            }
            this.m_docEnded = true;
            this.m_docPending = false;
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.flushPending(true);
        this.m_contentHandler.endElement(string, string2, string3);
        if (this.m_tracer != null) {
            GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 4, string3, null);
            this.m_tracer.fireGenerateEvent(generateEvent);
        }
        this.sendEndPrefixMappings();
        this.popEvent();
        this.m_nsSupport.popContext();
    }

    public void endEntity(String string) throws SAXException {
        this.flushPending(true);
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.endEntity(string);
        }
        if (this.m_tracer != null) {
            GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 9, string);
            this.m_tracer.fireGenerateEvent(generateEvent);
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void ensureNamespaceDeclDeclared(DTM dTM, int n) throws SAXException {
        String string;
        String string2 = dTM.getNodeValue(n);
        String string3 = dTM.getNodeNameX(n);
        if (!(string2 == null || string2.length() <= 0 || string3 == null || (string = this.m_nsSupport.getURI(string3)) != null && string.equals(string2))) {
            this.startPrefixMapping(string3, string2, false);
        }
    }

    public void ensurePrefixIsDeclared(String string, String string2) throws SAXException {
        if (string != null && string.length() > 0) {
            String string3;
            String string4;
            int n = string2.indexOf(":");
            String string5 = string4 = n < 0 ? "" : string2.substring(0, n);
            if (!(string4 == null || (string3 = this.m_nsSupport.getURI(string4)) != null && string3.equals(string))) {
                this.startPrefixMapping(string4, string, false);
            }
        }
    }

    public void entityReference(String string) throws SAXException {
        this.flushPending(true);
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.startEntity(string);
            this.m_lexicalHandler.endEntity(string);
        }
        if (this.m_tracer != null) {
            GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 9, string);
            this.m_tracer.fireGenerateEvent(generateEvent);
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (this.m_contentHandler instanceof ErrorHandler) {
            ((ErrorHandler)((Object)this.m_contentHandler)).error(sAXParseException);
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.m_elemIsPending = false;
        this.m_docEnded = true;
        this.m_docPending = false;
        if (this.m_contentHandler instanceof ErrorHandler) {
            ((ErrorHandler)((Object)this.m_contentHandler)).fatalError(sAXParseException);
        }
    }

    void flushDocEvent() throws SAXException {
        if (this.m_docPending) {
            this.m_contentHandler.startDocument();
            if (this.m_tracer != null) {
                GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 1);
                this.m_tracer.fireGenerateEvent(generateEvent);
            }
            if (this.m_contentHandler instanceof TransformerClient) {
                ((TransformerClient)((Object)this.m_contentHandler)).setTransformState(this);
            }
            this.m_docPending = false;
        }
    }

    void flushElem() throws SAXException {
        if (this.m_elemIsPending) {
            if (this.m_name != null) {
                this.m_contentHandler.startElement(this.m_url, this.m_localName, this.m_name, this.m_attributes);
                if (this.m_tracer != null) {
                    GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 3, this.m_name, this.m_attributes);
                    this.m_tracer.fireGenerateEvent(generateEvent);
                }
                if (this.m_isTransformClient) {
                    this.m_snapshot.m_currentNode = null;
                }
            }
            this.m_elemIsPending = false;
            this.m_attributes.clear();
            this.m_nsDeclsHaveBeenAdded = false;
            this.m_name = null;
            this.m_url = null;
            this.m_localName = null;
            this.m_namespaces = null;
        }
    }

    public final void flushPending() throws SAXException {
        this.flushPending(true);
    }

    public final void flushPending(boolean bl) throws SAXException {
        if (bl && this.m_docPending) {
            this.flushDocEvent();
        }
        if (this.m_elemIsPending) {
            if (!this.m_nsDeclsHaveBeenAdded) {
                this.startAndAddPrefixMappings();
            } else {
                this.sendStartPrefixMappings();
            }
            this.flushElem();
            this.m_nsContextPushed = false;
        }
    }

    public final ContentHandler getContentHandler() {
        return this.m_contentHandler;
    }

    public NodeIterator getContextNodeList() {
        if (this.m_elemIsPending) {
            return new DTMNodeIterator(this.m_snapshot.m_contextNodeList);
        }
        return new DTMNodeIterator(this.m_transformer.getContextNodeList());
    }

    public ElemTemplateElement getCurrentElement() {
        if (this.m_elemIsPending) {
            return this.m_snapshot.m_currentElement;
        }
        return this.m_transformer.getCurrentElement();
    }

    public Node getCurrentNode() {
        if (this.m_snapshot.m_currentNode != null) {
            return this.m_snapshot.m_currentNode;
        }
        DTM dTM = this.m_transformer.getXPathContext().getDTM(this.m_transformer.getCurrentNode());
        return dTM.getNode(this.m_transformer.getCurrentNode());
    }

    public ElemTemplate getCurrentTemplate() {
        if (this.m_elemIsPending) {
            return this.m_snapshot.m_currentTemplate;
        }
        return this.m_transformer.getCurrentTemplate();
    }

    public Node getMatchedNode() {
        if (this.m_elemIsPending) {
            DTM dTM = this.m_transformer.getXPathContext().getDTM(this.m_snapshot.m_matchedNode);
            return dTM.getNode(this.m_snapshot.m_matchedNode);
        }
        DTM dTM = this.m_transformer.getXPathContext().getDTM(this.m_transformer.getMatchedNode());
        return dTM.getNode(this.m_transformer.getMatchedNode());
    }

    public ElemTemplate getMatchedTemplate() {
        if (this.m_elemIsPending) {
            return this.m_snapshot.m_matchedTemplate;
        }
        return this.m_transformer.getMatchedTemplate();
    }

    public NamespaceSupport getNamespaceSupport() {
        return this.m_nsSupport;
    }

    public String getNewUniqueNSPrefix() {
        return S_NAMESPACEPREFIX + String.valueOf(this.getUniqueNSValue());
    }

    public MutableAttrListImpl getPendingAttributes() {
        return this.m_attributes;
    }

    public String getPrefix(String string) {
        Enumeration enumeration = this.m_nsSupport.getPrefixes();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!this.m_nsSupport.getURI(string2).equals(string)) continue;
            return string2;
        }
        return null;
    }

    public Transformer getTransformer() {
        return this.m_transformer;
    }

    public String getURI(String string) {
        return this.m_nsSupport.getURI(string);
    }

    public int getUniqueNSValue() {
        return this.m_uniqueNSValue++;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_docPending && XMLCharacterRecognizer.isWhiteSpace(cArray, n, n2)) {
            return;
        }
        this.flushPending(true);
        this.m_contentHandler.ignorableWhitespace(cArray, n, n2);
        if (this.m_tracer != null) {
            GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 6, cArray, n, n2);
            this.m_tracer.fireGenerateEvent(generateEvent);
        }
    }

    public void init(TransformerImpl transformerImpl, ContentHandler contentHandler) {
        this.m_transformer = transformerImpl;
        TraceManager traceManager = transformerImpl.getTraceManager();
        this.m_tracer = traceManager != null && traceManager.hasTraceListeners() ? traceManager : null;
        this.m_contentHandler = contentHandler;
        this.m_lexicalHandler = this.m_contentHandler instanceof LexicalHandler ? (LexicalHandler)((Object)this.m_contentHandler) : null;
        this.m_isTransformClient = this.m_contentHandler instanceof TransformerClient;
        this.m_cloner = new ClonerToResultTree(transformerImpl, this);
        if (this.m_transformer != null) {
            this.m_stylesheetRoot = this.m_transformer.getStylesheet();
        }
        this.pushDocumentEvent();
    }

    public boolean isDefinedNSDecl(int n) {
        String string;
        String string2;
        DTM dTM = this.m_transformer.getXPathContext().getDTM(n);
        return dTM.getNodeType(n) == 13 && (string2 = this.getURI(string = dTM.getNodeNameX(n))) != null && string2.equals(dTM.getStringValue(n));
    }

    public boolean isDefinedNSDecl(int n, DTM dTM) {
        String string;
        String string2;
        return dTM.getNodeType(n) == 13 && (string2 = this.getURI(string = dTM.getNodeNameX(n))) != null && string2.equals(dTM.getStringValue(n));
    }

    public boolean isDefinedNSDecl(String string, String string2) {
        if (string.equals("xmlns") || string.startsWith("xmlns:")) {
            int n = string.indexOf(":");
            String string3 = n < 0 ? "" : string.substring(0, n);
            String string4 = this.m_nsSupport.getURI(string3);
            if (string4 != null) {
                return string4.equals(string2);
            }
            return false;
        }
        return false;
    }

    public final boolean isElementPending() {
        return this.m_elemIsPending;
    }

    public void outputResultTreeFragment(XObject xObject, XPathContext xPathContext) throws SAXException {
        int n = xObject.rtf();
        DTM dTM = xPathContext.getDTM(n);
        int n2 = dTM.getFirstChild(n);
        while (n2 != -1) {
            this.flushPending(true);
            dTM.dispatchToEvents(n2, this);
            n2 = dTM.getNextSibling(n2);
        }
    }

    public void processNSDecls(int n, int n2, DTM dTM) throws TransformerException {
        try {
            if (n2 == 1) {
                int n3 = dTM.getFirstNamespaceNode(n, true);
                while (n3 != -1) {
                    String string = dTM.getNodeNameX(n3);
                    String string2 = this.getURI(string);
                    String string3 = dTM.getNodeValue(n3);
                    if (!string3.equalsIgnoreCase(string2)) {
                        this.startPrefixMapping(string, string3, false);
                    }
                    n3 = dTM.getNextNamespaceNode(n, n3, true);
                }
            }
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.flushPending(true);
        this.m_contentHandler.processingInstruction(string, string2);
        if (this.m_tracer != null) {
            GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 7, string, string2);
            this.m_tracer.fireGenerateEvent(generateEvent);
        }
    }

    protected void sendEndPrefixMappings() throws SAXException {
        Enumeration enumeration = this.m_nsSupport.getDeclaredPrefixes();
        ContentHandler contentHandler = this.m_contentHandler;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            contentHandler.endPrefixMapping(string);
        }
    }

    protected void sendStartPrefixMappings() throws SAXException {
        Enumeration enumeration = this.m_nsSupport.getDeclaredPrefixes();
        ContentHandler contentHandler = this.m_contentHandler;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            contentHandler.startPrefixMapping(string, this.m_nsSupport.getURI(string));
        }
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.m_contentHandler = contentHandler;
        this.m_isTransformClient = this.m_contentHandler instanceof TransformerClient;
        this.m_lexicalHandler = this.m_contentHandler instanceof LexicalHandler ? (LexicalHandler)((Object)this.m_contentHandler) : null;
        this.reInitEvents();
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void setNSDeclsHaveBeenAdded(boolean bl) {
        this.m_nsDeclsHaveBeenAdded = bl;
    }

    public void skippedEntity(String string) throws SAXException {
    }

    protected void startAndAddPrefixMappings() throws SAXException {
        Enumeration enumeration = this.m_nsSupport.getDeclaredPrefixes();
        ContentHandler contentHandler = this.m_contentHandler;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.m_nsSupport.getURI(string);
            contentHandler.startPrefixMapping(string, string2);
            boolean bl = string.length() == 0;
            String string3 = bl ? "xmlns" : "xmlns:" + string;
            if (string2 == null) {
                string2 = "";
            }
            this.m_attributes.addAttribute("http://www.w3.org/2000/xmlns/", string, string3, "CDATA", string2);
        }
        this.m_nsDeclsHaveBeenAdded = true;
    }

    public void startCDATA() throws SAXException {
        this.flushPending(true);
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.startCDATA();
        }
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.flushPending(true);
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.startDTD(string, string2, string3);
        }
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.m_docPending) {
            this.checkForSerializerSwitch(string, string2);
        }
        this.flushPending(true);
        if (!this.m_nsContextPushed) {
            this.m_nsSupport.pushContext();
            this.m_nsContextPushed = true;
        }
        if (string != null) {
            this.ensurePrefixIsDeclared(string, string3);
        }
        this.m_name = string3;
        this.m_url = string;
        this.m_localName = string2;
        if (attributes != null) {
            this.m_attributes.addAttributes(attributes);
        }
        this.m_elemIsPending = true;
        this.m_elemIsEnded = false;
        if (this.m_isTransformClient && this.m_transformer != null) {
            this.m_snapshot.m_currentElement = this.m_transformer.getCurrentElement();
            this.m_snapshot.m_currentTemplate = this.m_transformer.getCurrentTemplate();
            this.m_snapshot.m_matchedTemplate = this.m_transformer.getMatchedTemplate();
            int n = this.m_transformer.getCurrentNode();
            DTM dTM = this.m_transformer.getXPathContext().getDTM(n);
            this.m_snapshot.m_currentNode = dTM.getNode(n);
            this.m_snapshot.m_matchedNode = this.m_transformer.getMatchedNode();
            this.m_snapshot.m_contextNodeList = this.m_transformer.getContextNodeList();
        }
        ++this.m_eventCount;
    }

    public void startEntity(String string) throws SAXException {
        this.flushPending(true);
        if (this.m_lexicalHandler != null) {
            this.m_lexicalHandler.startEntity(string);
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.startPrefixMapping(string, string2, true);
    }

    public void startPrefixMapping(String string, String string2, boolean bl) throws SAXException {
        String string3;
        if (bl) {
            this.flushPending(false);
        }
        if (!this.m_nsContextPushed) {
            this.m_nsSupport.pushContext();
            this.m_nsContextPushed = true;
        }
        if (string == null) {
            string = "";
        }
        if ((string3 = this.m_nsSupport.getURI(string)) == null) {
            string3 = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (!string3.equals(string2)) {
            this.m_nsSupport.declarePrefix(string, string2);
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (this.m_contentHandler instanceof ErrorHandler) {
            ((ErrorHandler)((Object)this.m_contentHandler)).warning(sAXParseException);
        }
    }

    class QueuedStateSnapshot {
        ElemTemplateElement m_currentElement;
        Node m_currentNode;
        ElemTemplate m_currentTemplate;
        ElemTemplate m_matchedTemplate;
        int m_matchedNode;
        DTMIterator m_contextNodeList;

        QueuedStateSnapshot() {
        }
    }
}

