/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xml.dtm.ref.CoroutineManager;
import org.apache.xml.dtm.ref.CoroutineSAXParser;
import org.apache.xml.serialize.XMLSerializer;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

class CoroutineSAXFilterTest
implements Runnable {
    static boolean TEST_EARLY_STOP = false;
    static int appCoroutineID = -1;
    static CoroutineSAXParser filter;

    CoroutineSAXFilterTest() {
    }

    public static void main(String[] stringArray) {
        block7: {
            SAXParser sAXParser;
            Object object;
            System.out.println("Starting in Filtering mode...");
            XMLReader xMLReader = null;
            try {
                object = SAXParserFactory.newInstance();
                sAXParser = ((SAXParserFactory)object).newSAXParser();
                xMLReader = sAXParser.getXMLReader();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            object = new CoroutineManager();
            appCoroutineID = ((CoroutineManager)object).co_joinCoroutineSet(appCoroutineID);
            if (appCoroutineID == -1) {
                System.out.println("ERROR: Couldn't allocate coroutine number.\n");
                return;
            }
            filter = new CoroutineSAXParser((CoroutineManager)object, appCoroutineID);
            filter.setXMLReader(xMLReader);
            sAXParser = new XMLSerializer((OutputStream)System.out, null);
            filter.setContentHandler((ContentHandler)((Object)sAXParser));
            filter.setLexHandler((LexicalHandler)((Object)sAXParser));
            Thread thread = new Thread(new CoroutineSAXFilterTest());
            thread.setDaemon(false);
            thread.start();
            if (stringArray.length > 1 && "!".equals(stringArray[1])) {
                TEST_EARLY_STOP = true;
            }
            System.out.println("*** Parser start ***");
            try {
                xMLReader.parse(new InputSource(stringArray[0]));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
                Exception exception = sAXException.getException();
                if (exception == null || !exception.getClass().getName().equals("org.apache.xml.dtm.CoroutineSAXParser$UserRequestedStopException")) break block7;
                System.out.println("... NORMAL response to doTerminate().");
            }
        }
        System.out.println("*** Parser end ***");
        filter.doTerminate(appCoroutineID);
    }

    public void run() {
        boolean bl = true;
        Object object = filter.doParse(null, appCoroutineID);
        while (object instanceof Boolean && (Boolean)object == Boolean.TRUE) {
            if (TEST_EARLY_STOP) {
                System.out.println("\nSome parsing successful, trying to stop.\n");
                bl = false;
            } else {
                System.out.println("\nSome parsing successful, trying more.\n");
            }
            object = filter.doMore(bl, appCoroutineID);
        }
        if (object instanceof Boolean && (Boolean)object == Boolean.FALSE) {
            System.out.println("\nfilter ended (EOF or on request).\n");
        } else if (object == null) {
            System.out.println("\nUNEXPECTED: filter says shut down prematurely.\n");
        } else if (object instanceof Exception) {
            System.out.println("\nfilter threw exception:");
            ((Exception)object).printStackTrace();
        }
        filter.doTerminate(appCoroutineID);
    }
}

