/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMAxisIterator;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xml.dtm.DTMException;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMManagerDefault;
import org.apache.xml.dtm.ref.DTMNodeProxy;
import org.apache.xml.dtm.ref.ExpandedNameTable;
import org.apache.xml.utils.BoolStack;
import org.apache.xml.utils.SuballocatedIntVector;
import org.apache.xml.utils.XMLString;
import org.apache.xml.utils.XMLStringFactory;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public abstract class DTMDefaultBase
implements DTM {
    protected int m_size = 0;
    protected SuballocatedIntVector m_exptype;
    protected SuballocatedIntVector m_firstch;
    protected SuballocatedIntVector m_nextsib;
    protected SuballocatedIntVector m_prevsib;
    protected SuballocatedIntVector m_parent;
    protected Vector m_namespaceDeclSets = null;
    protected SuballocatedIntVector m_namespaceDeclSetElements = null;
    protected int[][][] m_elemIndexes;
    protected int m_initialblocksize = 512;
    protected int m_blocksize = 2048;
    protected static final int NOTPROCESSED = -2;
    protected DTMManager m_mgr;
    protected int m_dtmIdent;
    protected static final int m_mask = 0x3FFFFF;
    protected String m_documentBaseURI;
    protected DTMWSFilter m_wsfilter;
    protected boolean m_shouldStripWS = false;
    protected BoolStack m_shouldStripWhitespaceStack;
    protected XMLStringFactory m_xstrf;
    public static final int ROOTNODE = 0;
    protected ExpandedNameTable m_expandedNameTable;
    protected boolean m_indexing;
    protected DTMAxisTraverser[] m_traversers;
    private Vector m_namespaceLists = null;

    public DTMDefaultBase(DTMManager dTMManager, Source source, int n, DTMWSFilter dTMWSFilter, XMLStringFactory xMLStringFactory, boolean bl) {
        if (!bl) {
            this.m_initialblocksize = 8;
            this.m_blocksize = 16;
        }
        this.m_exptype = new SuballocatedIntVector(this.m_initialblocksize);
        this.m_firstch = new SuballocatedIntVector(this.m_initialblocksize);
        this.m_nextsib = new SuballocatedIntVector(this.m_initialblocksize);
        this.m_prevsib = new SuballocatedIntVector(this.m_initialblocksize);
        this.m_parent = new SuballocatedIntVector(this.m_initialblocksize);
        this.m_mgr = dTMManager;
        this.m_documentBaseURI = source != null ? source.getSystemId() : null;
        this.m_dtmIdent = n;
        this.m_wsfilter = dTMWSFilter;
        this.m_xstrf = xMLStringFactory;
        this.m_indexing = bl;
        if (bl) {
            this.m_expandedNameTable = new ExpandedNameTable();
        } else {
            DTMManagerDefault dTMManagerDefault = (DTMManagerDefault)this.m_mgr;
            this.m_expandedNameTable = dTMManagerDefault.getExpandedNameTable(this);
        }
        if (dTMWSFilter != null) {
            this.m_shouldStripWhitespaceStack = new BoolStack();
            this.pushShouldStripWhitespace(false);
        }
    }

    protected int _exptype(int n) {
        while (n >= this.m_size) {
            if (this.nextNode() || n < this.m_size) continue;
            return -1;
        }
        return this.m_exptype.elementAt(n);
    }

    protected int _firstch(int n) {
        int n2 = n >= this.m_size ? -2 : this.m_firstch.elementAt(n);
        while (n2 == -2) {
            boolean bl = this.nextNode();
            if (n >= this.m_size && !bl) {
                return -1;
            }
            n2 = this.m_firstch.elementAt(n);
            if (n2 != -2 || bl) continue;
            return -1;
        }
        return n2;
    }

    protected int _level(int n) {
        int n2;
        while (n >= this.m_size) {
            n2 = this.nextNode();
            if (n2 != 0 || n < this.m_size) continue;
            return -1;
        }
        n2 = 0;
        while ((n = this._parent(n)) != -1) {
            ++n2;
        }
        return n2;
    }

    protected int _nextsib(int n) {
        int n2 = n >= this.m_size ? -2 : this.m_nextsib.elementAt(n);
        while (n2 == -2) {
            boolean bl = this.nextNode();
            if (n >= this.m_size && !bl) {
                return -1;
            }
            n2 = this.m_nextsib.elementAt(n);
            if (n2 != -2 || bl) continue;
            return -1;
        }
        return n2;
    }

    protected int _parent(int n) {
        if (n < this.m_size) {
            return this.m_parent.elementAt(n);
        }
        do {
            boolean bl = this.nextNode();
            if (n < this.m_size || bl) continue;
            return -1;
        } while (n >= this.m_size);
        return this.m_parent.elementAt(n);
    }

    protected int _prevsib(int n) {
        if (n < this.m_size) {
            return this.m_prevsib.elementAt(n);
        }
        do {
            boolean bl = this.nextNode();
            if (n < this.m_size || bl) continue;
            return -1;
        } while (n >= this.m_size);
        return this.m_prevsib.elementAt(n);
    }

    protected short _type(int n) {
        int n2 = this.getExpandedTypeID(n);
        if (n2 != -1) {
            return ExpandedNameTable.getType(n2);
        }
        return -1;
    }

    public void appendChild(int n, boolean bl, boolean bl2) {
        this.error(XSLMessages.createMessage(210, null));
    }

    public void appendTextChild(String string) {
        this.error(XSLMessages.createMessage(210, null));
    }

    protected void declareNamespaceInContext(int n, int n2) {
        int n3;
        int n4;
        SuballocatedIntVector suballocatedIntVector = null;
        if (this.m_namespaceDeclSets == null) {
            this.m_namespaceDeclSetElements = new SuballocatedIntVector();
            this.m_namespaceDeclSetElements.addElement(n);
            this.m_namespaceDeclSets = new Vector();
            suballocatedIntVector = new SuballocatedIntVector();
            this.m_namespaceDeclSets.addElement(suballocatedIntVector);
        } else {
            n4 = this.m_namespaceDeclSetElements.size() - 1;
            if (n == this.m_namespaceDeclSetElements.elementAt(n4)) {
                suballocatedIntVector = (SuballocatedIntVector)this.m_namespaceDeclSets.elementAt(n4);
            }
        }
        if (suballocatedIntVector == null) {
            this.m_namespaceDeclSetElements.addElement(n);
            suballocatedIntVector = new SuballocatedIntVector();
            this.m_namespaceDeclSets.addElement(suballocatedIntVector);
            SuballocatedIntVector suballocatedIntVector2 = this.findNamespaceContext(this._parent(n));
            if (suballocatedIntVector2 != null) {
                n3 = suballocatedIntVector2.size();
                int n5 = 0;
                while (n5 < n3) {
                    suballocatedIntVector.addElement(suballocatedIntVector2.elementAt(n5));
                    ++n5;
                }
            }
        }
        n4 = this.getExpandedTypeID(n2);
        n3 = suballocatedIntVector.size() - 1;
        while (n3 >= 0) {
            if (n4 == this.getExpandedTypeID(suballocatedIntVector.elementAt(n3))) {
                suballocatedIntVector.setElementAt(n2 | this.m_dtmIdent, n3);
                return;
            }
            --n3;
        }
        suballocatedIntVector.addElement(n2 | this.m_dtmIdent);
    }

    public abstract void dispatchCharactersEvents(int var1, ContentHandler var2, boolean var3) throws SAXException;

    public abstract void dispatchToEvents(int var1, ContentHandler var2) throws SAXException;

    public void documentRegistration() {
    }

    public void documentRelease() {
    }

    public void dumpDTM() {
        try {
            File file = new File("DTMDump" + this.hashCode() + ".txt");
            System.err.println("Dumping... " + file.getAbsolutePath());
            PrintStream printStream = new PrintStream(new FileOutputStream(file));
            while (this.nextNode()) {
            }
            int n = this.m_size;
            printStream.println("Total nodes: " + n);
            int n2 = 0;
            while (n2 < n) {
                String string;
                printStream.println("=========== " + n2 + " ===========");
                printStream.println("NodeName: " + this.getNodeName(n2));
                printStream.println("NodeNameX: " + this.getNodeNameX(n2));
                printStream.println("LocalName: " + this.getLocalName(n2));
                printStream.println("NamespaceURI: " + this.getNamespaceURI(n2));
                printStream.println("Prefix: " + this.getPrefix(n2));
                int n3 = this.getExpandedTypeID(n2);
                printStream.println("Expanded Type ID: " + Integer.toHexString(n3));
                short s = this.getNodeType(n2);
                switch (s) {
                    case 2: {
                        string = "ATTRIBUTE_NODE";
                        break;
                    }
                    case 4: {
                        string = "CDATA_SECTION_NODE";
                        break;
                    }
                    case 8: {
                        string = "COMMENT_NODE";
                        break;
                    }
                    case 11: {
                        string = "DOCUMENT_FRAGMENT_NODE";
                        break;
                    }
                    case 9: {
                        string = "DOCUMENT_NODE";
                        break;
                    }
                    case 10: {
                        string = "DOCUMENT_NODE";
                        break;
                    }
                    case 1: {
                        string = "ELEMENT_NODE";
                        break;
                    }
                    case 6: {
                        string = "ENTITY_NODE";
                        break;
                    }
                    case 5: {
                        string = "ENTITY_REFERENCE_NODE";
                        break;
                    }
                    case 13: {
                        string = "NAMESPACE_NODE";
                        break;
                    }
                    case 12: {
                        string = "NOTATION_NODE";
                        break;
                    }
                    case -1: {
                        string = "NULL";
                        break;
                    }
                    case 7: {
                        string = "PROCESSING_INSTRUCTION_NODE";
                        break;
                    }
                    case 3: {
                        string = "TEXT_NODE";
                        break;
                    }
                    default: {
                        string = "Unknown!";
                    }
                }
                printStream.println("Type: " + string);
                int n4 = this._firstch(n2);
                if (n4 == -1) {
                    printStream.println("First child: DTM.NULL");
                } else if (n4 == -2) {
                    printStream.println("First child: NOTPROCESSED");
                } else {
                    printStream.println("First child: " + n4);
                }
                int n5 = this._prevsib(n2);
                if (n5 == -1) {
                    printStream.println("Prev sibling: DTM.NULL");
                } else if (n5 == -2) {
                    printStream.println("Prev sibling: NOTPROCESSED");
                } else {
                    printStream.println("Prev sibling: " + n5);
                }
                int n6 = this._nextsib(n2);
                if (n6 == -1) {
                    printStream.println("Next sibling: DTM.NULL");
                } else if (n6 == -2) {
                    printStream.println("Next sibling: NOTPROCESSED");
                } else {
                    printStream.println("Next sibling: " + n6);
                }
                int n7 = this._parent(n2);
                if (n7 == -1) {
                    printStream.println("Parent: DTM.NULL");
                } else if (n7 == -2) {
                    printStream.println("Parent: NOTPROCESSED");
                } else {
                    printStream.println("Parent: " + n7);
                }
                int n8 = this._level(n2);
                printStream.println("Level: " + n8);
                printStream.println("Node Value: " + this.getNodeValue(n2));
                printStream.println("String Value: " + this.getStringValue(n2));
                ++n2;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    public String dumpNode(int n) {
        String string;
        if (n == -1) {
            return "[null]";
        }
        switch (this.getNodeType(n)) {
            case 2: {
                string = "ATTR";
                break;
            }
            case 4: {
                string = "CDATA";
                break;
            }
            case 8: {
                string = "COMMENT";
                break;
            }
            case 11: {
                string = "DOC_FRAG";
                break;
            }
            case 9: {
                string = "DOC";
                break;
            }
            case 10: {
                string = "DOC_TYPE";
                break;
            }
            case 1: {
                string = "ELEMENT";
                break;
            }
            case 6: {
                string = "ENTITY";
                break;
            }
            case 5: {
                string = "ENT_REF";
                break;
            }
            case 13: {
                string = "NAMESPACE";
                break;
            }
            case 12: {
                string = "NOTATION";
                break;
            }
            case -1: {
                string = "null";
                break;
            }
            case 7: {
                string = "PI";
                break;
            }
            case 3: {
                string = "TEXT";
                break;
            }
            default: {
                string = "Unknown!";
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[" + n + ": " + string + "(0x" + Integer.toHexString(this.getExpandedTypeID(n)) + ") " + this.getNodeNameX(n) + " {" + this.getNamespaceURI(n) + "}" + "=\"" + this.getNodeValue(n) + "\"]");
        return stringBuffer.toString();
    }

    protected void ensureSizeOfIndex(int n, int n2) {
        Object object;
        Object object2;
        if (this.m_elemIndexes == null) {
            this.m_elemIndexes = new int[n + 20][][];
        } else if (this.m_elemIndexes.length <= n) {
            object2 = this.m_elemIndexes;
            this.m_elemIndexes = new int[n + 20][][];
            System.arraycopy(object2, 0, this.m_elemIndexes, 0, ((int[][][])object2).length);
        }
        object2 = this.m_elemIndexes[n];
        if (object2 == null) {
            object2 = new int[n2 + 100][];
            this.m_elemIndexes[n] = (int[][])object2;
        } else if (((int[][][])object2).length <= n2) {
            object = object2;
            object2 = new int[n2 + 100][];
            System.arraycopy(object, 0, object2, 0, ((int[][][])object).length);
            this.m_elemIndexes[n] = (int[][])object2;
        }
        object = object2[n2];
        if (object == null) {
            object = new int[128];
            object2[n2] = (int[][])object;
            object[0] = (int[][])true;
        } else if (((int[][][])object).length <= object[0] + true) {
            Object object3 = object;
            object = new int[object[0] + 1024];
            System.arraycopy(object3, 0, object, 0, ((int[][][])object3).length);
            object2[n2] = (int[][])object;
        }
    }

    protected void error(String string) {
        throw new DTMException(string);
    }

    int findElementFromIndex(int n, int n2, int n3) {
        int n4;
        int[] nArray;
        int[][] nArray2;
        int[][][] nArray3 = this.m_elemIndexes;
        if (nArray3 != null && n < nArray3.length && (nArray2 = nArray3[n]) != null && n2 < nArray2.length && (nArray = nArray2[n2]) != null && (n4 = this.findGTE(nArray, 1, nArray[0], n3)) > -1) {
            return nArray[n4];
        }
        return -2;
    }

    protected int findGTE(int[] nArray, int n, int n2, int n3) {
        int n4;
        int n5 = n;
        int n6 = n4 = n + (n2 - 1);
        while (n5 <= n4) {
            int n7 = (n5 + n4) / 2;
            int n8 = nArray[n7];
            if (n8 > n3) {
                n4 = n7 - 1;
                continue;
            }
            if (n8 < n3) {
                n5 = n7 + 1;
                continue;
            }
            return n7;
        }
        return n5 <= n6 && nArray[n5] > n3 ? n5 : -1;
    }

    protected int findInSortedSuballocatedIntVector(SuballocatedIntVector suballocatedIntVector, int n) {
        int n2 = 0;
        if (suballocatedIntVector != null) {
            int n3 = 0;
            int n4 = suballocatedIntVector.size() - 1;
            while (n3 <= n4) {
                n2 = (n3 + n4) / 2;
                int n5 = n - suballocatedIntVector.elementAt(n2);
                if (n5 == 0) {
                    return n2;
                }
                if (n5 < 0) {
                    n4 = n2 - 1;
                    continue;
                }
                n3 = n2 + 1;
            }
            if (n3 > n2) {
                n2 = n3;
            }
        }
        return -1 - n2;
    }

    protected SuballocatedIntVector findNamespaceContext(int n) {
        if (this.m_namespaceDeclSetElements != null) {
            int n2 = this.findInSortedSuballocatedIntVector(this.m_namespaceDeclSetElements, n);
            if (n2 >= 0) {
                return (SuballocatedIntVector)this.m_namespaceDeclSets.elementAt(n2);
            }
            if (n2 == -1) {
                return null;
            }
            n2 = -1 - n2;
            int n3 = this.m_namespaceDeclSetElements.elementAt(--n2);
            int n4 = this._parent(n);
            while (n2 >= 0 && n4 > 0) {
                n3 = this.m_namespaceDeclSetElements.elementAt(n2);
                if (n3 == n4) {
                    return (SuballocatedIntVector)this.m_namespaceDeclSets.elementAt(n2);
                }
                if (n3 < n4) {
                    n4 = this._parent(n4);
                    continue;
                }
                --n2;
            }
        }
        return null;
    }

    public abstract int getAttributeNode(int var1, String var2, String var3);

    public abstract DTMAxisIterator getAxisIterator(int var1);

    public abstract DTMAxisTraverser getAxisTraverser(int var1);

    public abstract ContentHandler getContentHandler();

    public abstract DTDHandler getDTDHandler();

    public abstract DeclHandler getDeclHandler();

    public int getDocument() {
        return this.m_dtmIdent;
    }

    public boolean getDocumentAllDeclarationsProcessed() {
        return true;
    }

    public String getDocumentBaseURI() {
        return this.m_documentBaseURI;
    }

    public String getDocumentEncoding(int n) {
        return "UTF-8";
    }

    public String getDocumentStandalone(int n) {
        return null;
    }

    public String getDocumentSystemIdentifier(int n) {
        return this.m_documentBaseURI;
    }

    public abstract String getDocumentTypeDeclarationPublicIdentifier();

    public abstract String getDocumentTypeDeclarationSystemIdentifier();

    public String getDocumentVersion(int n) {
        return null;
    }

    public abstract int getElementById(String var1);

    public abstract EntityResolver getEntityResolver();

    public abstract ErrorHandler getErrorHandler();

    public int getExpandedTypeID(int n) {
        return this._exptype(n & 0x3FFFFF);
    }

    public int getExpandedTypeID(String string, String string2, int n) {
        ExpandedNameTable expandedNameTable = this.m_expandedNameTable;
        return expandedNameTable.getExpandedTypeID(string, string2, n);
    }

    public int getFirstAttribute(int n) {
        short s = this.getNodeType(n);
        if (s == 1) {
            int n2 = n & 0x3FFFFF;
            while ((n2 = this.getNextNodeIdentity(n2)) != -1) {
                s = this.getNodeType(n2);
                if (s == 2) {
                    return n2 | this.m_dtmIdent;
                }
                if (s != 13) break;
            }
        }
        return -1;
    }

    public int getFirstChild(int n) {
        int n2 = n & 0x3FFFFF;
        int n3 = this._firstch(n2);
        return n3 | this.m_dtmIdent;
    }

    public int getFirstNamespaceNode(int n, boolean bl) {
        if (bl) {
            SuballocatedIntVector suballocatedIntVector = this.findNamespaceContext(n & 0x3FFFFF);
            if (suballocatedIntVector == null || suballocatedIntVector.size() < 1) {
                return -1;
            }
            return suballocatedIntVector.elementAt(0) | this.m_dtmIdent;
        }
        int n2 = n & 0x3FFFFF;
        while ((n2 = this.getNextNodeIdentity(n2)) != -1) {
            short s = this.getNodeType(n2);
            if (s == 13) {
                return n2 | this.m_dtmIdent;
            }
            if (s != 2) break;
        }
        return -1;
    }

    public int getLastChild(int n) {
        int n2 = n & 0x3FFFFF;
        int n3 = this._firstch(n2);
        int n4 = -1;
        while (n3 != -1) {
            n4 = n3;
            n3 = this._nextsib(n3);
        }
        return n4 | this.m_dtmIdent;
    }

    public short getLevel(int n) {
        int n2 = n & 0x3FFFFF;
        return (short)(this._level(n2) + 1);
    }

    public abstract LexicalHandler getLexicalHandler();

    public abstract String getLocalName(int var1);

    public String getLocalNameFromExpandedNameID(int n) {
        return this.m_expandedNameTable.getLocalName(n);
    }

    public String getNamespaceFromExpandedNameID(int n) {
        return this.m_expandedNameTable.getNamespace(n);
    }

    public int getNamespaceType(int n) {
        int n2 = n & 0x3FFFFF;
        int n3 = this._exptype(n2);
        return ExpandedNameTable.getNamespaceID(n3);
    }

    public abstract String getNamespaceURI(int var1);

    public int getNextAttribute(int n) {
        short s = this.getNodeType(n);
        if (s == 2) {
            int n2 = n & 0x3FFFFF;
            while ((n2 = this.getNextNodeIdentity(n2)) != -1) {
                s = this.getNodeType(n2);
                if (s == 2) {
                    return n2 | this.m_dtmIdent;
                }
                if (s != 13) break;
            }
        }
        return -1;
    }

    public int getNextNamespaceNode(int n, int n2, boolean bl) {
        if (bl) {
            SuballocatedIntVector suballocatedIntVector = this.findNamespaceContext(n & 0x3FFFFF);
            if (suballocatedIntVector == null) {
                return -1;
            }
            int n3 = 1 + suballocatedIntVector.indexOf(n2);
            if (n3 <= 0 || n3 == suballocatedIntVector.size()) {
                return -1;
            }
            return suballocatedIntVector.elementAt(n3) | this.m_dtmIdent;
        }
        int n4 = n2 & 0x3FFFFF;
        while ((n4 = this.getNextNodeIdentity(n4)) != -1) {
            short s = this.getNodeType(n4);
            if (s == 13) {
                return n4 | this.m_dtmIdent;
            }
            if (s != 2) break;
        }
        return -1;
    }

    protected abstract int getNextNodeIdentity(int var1);

    public int getNextSibling(int n) {
        return this._nextsib(n & 0x3FFFFF) | this.m_dtmIdent;
    }

    public Node getNode(int n) {
        return new DTMNodeProxy(this, n);
    }

    public abstract String getNodeName(int var1);

    public String getNodeNameX(int n) {
        this.error(XSLMessages.createMessage(210, null));
        return null;
    }

    public short getNodeType(int n) {
        return (short)(this._exptype(n & 0x3FFFFF) >> ExpandedNameTable.ROTAMOUNT_TYPE);
    }

    public abstract String getNodeValue(int var1);

    protected abstract int getNumberOfNodes();

    public int getOwnerDocument(int n) {
        short s = this.getNodeType(n);
        if (s == 9) {
            return -1;
        }
        return this.getDocument();
    }

    public int getParent(int n) {
        int n2 = n & 0x3FFFFF;
        if (n2 > 0) {
            return this._parent(n2) | this.m_dtmIdent;
        }
        return -1;
    }

    public abstract String getPrefix(int var1);

    public int getPreviousSibling(int n) {
        return this._prevsib(n & 0x3FFFFF) | this.m_dtmIdent;
    }

    protected boolean getShouldStripWhitespace() {
        return this.m_shouldStripWS;
    }

    public abstract SourceLocator getSourceLocatorFor(int var1);

    public abstract XMLString getStringValue(int var1);

    public char[] getStringValueChunk(int n, int n2, int[] nArray) {
        this.error(XSLMessages.createMessage(210, null));
        return null;
    }

    public int getStringValueChunkCount(int n) {
        this.error(XSLMessages.createMessage(210, null));
        return 0;
    }

    public abstract DTMAxisIterator getTypedAxisIterator(int var1, int var2);

    public abstract String getUnparsedEntityURI(String var1);

    public boolean hasChildNodes(int n) {
        int n2 = n & 0x3FFFFF;
        int n3 = this._firstch(n2);
        return n3 != -1;
    }

    protected void indexNode(int n, int n2) {
        ExpandedNameTable expandedNameTable = this.m_expandedNameTable;
        short s = ExpandedNameTable.getType(n);
        if (s == 1) {
            int n3 = ExpandedNameTable.getNamespaceID(n);
            int n4 = ExpandedNameTable.getLocalNameID(n);
            this.ensureSizeOfIndex(n3, n4);
            int[] nArray = this.m_elemIndexes[n3][n4];
            nArray[nArray[0]] = n2;
            nArray[0] = nArray[0] + 1;
        }
    }

    public abstract boolean isAttributeSpecified(int var1);

    public boolean isCharacterElementContentWhitespace(int n) {
        return false;
    }

    public boolean isDocumentAllDeclarationsProcessed(int n) {
        return true;
    }

    public boolean isNodeAfter(int n, int n2) {
        if ((n & 0xFFC00000) != (n2 & 0xFFC00000)) {
            return false;
        }
        int n3 = n & 0x3FFFFF;
        int n4 = n2 & 0x3FFFFF;
        return n3 <= n4;
    }

    public boolean isSupported(String string, String string2) {
        return false;
    }

    public abstract boolean needsTwoThreads();

    protected abstract boolean nextNode();

    protected void popShouldStripWhitespace() {
        if (this.m_shouldStripWhitespaceStack != null) {
            this.m_shouldStripWS = this.m_shouldStripWhitespaceStack.popAndTop();
        }
    }

    protected void pushShouldStripWhitespace(boolean bl) {
        this.m_shouldStripWS = bl;
        if (this.m_shouldStripWhitespaceStack != null) {
            this.m_shouldStripWhitespaceStack.push(bl);
        }
    }

    public void setDocumentBaseURI(String string) {
        this.m_documentBaseURI = string;
    }

    public void setFeature(String string, boolean bl) {
    }

    public abstract void setProperty(String var1, Object var2);

    protected void setShouldStripWhitespace(boolean bl) {
        this.m_shouldStripWS = bl;
        if (this.m_shouldStripWhitespaceStack != null) {
            this.m_shouldStripWhitespaceStack.setTop(bl);
        }
    }

    public boolean supportsPreStripping() {
        return true;
    }
}

