/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import org.apache.xml.dtm.ref.DTMSafeStringPool;
import org.apache.xml.dtm.ref.DTMStringPool;

public class ExpandedNameTable {
    private DTMStringPool m_locNamesPool;
    private DTMStringPool m_namespaceNames;
    public static int BITS_PER_LOCALNAME = 16;
    public static int BITS_PER_NAMESPACE = 10;
    public static int MASK_LOCALNAME = 65535;
    public static int MASK_NAMESPACE = 0x3FF0000;
    public static int MASK_NODETYPE = -67108864;
    public static int MASK_NODEHANDLE = 1048575;
    public static final int ROTAMOUNT_TYPE = BITS_PER_NAMESPACE + BITS_PER_LOCALNAME;
    public static final int ELEMENT = 1 << ROTAMOUNT_TYPE;
    public static final int ATTRIBUTE = 2 << ROTAMOUNT_TYPE;
    public static final int TEXT = 3 << ROTAMOUNT_TYPE;
    public static final int CDATA_SECTION = 4 << ROTAMOUNT_TYPE;
    public static final int ENTITY_REFERENCE = 5 << ROTAMOUNT_TYPE;
    public static final int ENTITY = 6 << ROTAMOUNT_TYPE;
    public static final int PROCESSING_INSTRUCTION = 7 << ROTAMOUNT_TYPE;
    public static final int COMMENT = 8 << ROTAMOUNT_TYPE;
    public static final int DOCUMENT = 9 << ROTAMOUNT_TYPE;
    public static final int DOCUMENT_TYPE = 10 << ROTAMOUNT_TYPE;
    public static final int DOCUMENT_FRAGMENT = 11 << ROTAMOUNT_TYPE;
    public static final int NOTATION = 12 << ROTAMOUNT_TYPE;
    public static final int NAMESPACE = 13 << ROTAMOUNT_TYPE;

    public ExpandedNameTable() {
        this.m_locNamesPool = new DTMSafeStringPool();
        this.m_namespaceNames = new DTMSafeStringPool();
    }

    public ExpandedNameTable(DTMStringPool dTMStringPool, DTMStringPool dTMStringPool2) {
        this.m_locNamesPool = dTMStringPool;
        this.m_namespaceNames = dTMStringPool2;
    }

    public int getExpandedTypeID(int n) {
        int n2 = n << BITS_PER_NAMESPACE + BITS_PER_LOCALNAME;
        return n2;
    }

    public int getExpandedTypeID(String string, String string2, int n) {
        int n2 = string != null ? this.m_namespaceNames.stringToIndex(string) : 0;
        int n3 = this.m_locNamesPool.stringToIndex(string2);
        int n4 = n << BITS_PER_NAMESPACE + BITS_PER_LOCALNAME | n2 << BITS_PER_LOCALNAME | n3;
        return n4;
    }

    public String getLocalName(int n) {
        return this.m_locNamesPool.indexToString(n & MASK_LOCALNAME);
    }

    public static final int getLocalNameID(int n) {
        return n & MASK_LOCALNAME;
    }

    public String getNamespace(int n) {
        int n2 = (n & MASK_NAMESPACE) >> BITS_PER_LOCALNAME;
        return n2 == 0 ? null : this.m_namespaceNames.indexToString(n2);
    }

    public static final int getNamespaceID(int n) {
        return (n & MASK_NAMESPACE) >> BITS_PER_LOCALNAME;
    }

    public static final short getType(int n) {
        return (short)(n >> ROTAMOUNT_TYPE);
    }
}

