/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.xalan.res.XSLMessages;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xml.dtm.ref.CoroutineManager;
import org.apache.xml.dtm.ref.IncrementalSAXSource;
import org.apache.xml.serialize.XMLSerializer;
import org.apache.xml.utils.WrappedRuntimeException;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.LexicalHandler;

public class IncrementalSAXSource_Xerces
implements IncrementalSAXSource {
    SAXParser fIncrementalParser;
    private boolean fParseInProgress = false;

    public IncrementalSAXSource_Xerces() {
        this.fIncrementalParser = new SAXParser();
    }

    public IncrementalSAXSource_Xerces(SAXParser sAXParser) {
        this.fIncrementalParser = sAXParser;
    }

    public static IncrementalSAXSource createIncrementalSAXSource() {
        return new IncrementalSAXSource_Xerces();
    }

    public static IncrementalSAXSource createIncrementalSAXSource(SAXParser sAXParser) {
        return new IncrementalSAXSource_Xerces(sAXParser);
    }

    public Object deliverMoreNodes(boolean bl) {
        Serializable serializable;
        if (!bl) {
            this.fParseInProgress = false;
            return Boolean.FALSE;
        }
        try {
            boolean bl2 = this.fIncrementalParser.parseSome();
            serializable = bl2 ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (SAXException sAXException) {
            serializable = sAXException;
        }
        catch (IOException iOException) {
            serializable = iOException;
        }
        catch (Exception exception) {
            serializable = new SAXException(exception);
        }
        return serializable;
    }

    public static void main(String[] stringArray) {
        System.out.println("Starting...");
        CoroutineManager coroutineManager = new CoroutineManager();
        int n = coroutineManager.co_joinCoroutineSet(-1);
        if (n == -1) {
            System.out.println("ERROR: Couldn't allocate coroutine number.\n");
            return;
        }
        IncrementalSAXSource_Xerces incrementalSAXSource_Xerces = new IncrementalSAXSource_Xerces();
        XMLSerializer xMLSerializer = new XMLSerializer((OutputStream)System.out, null);
        incrementalSAXSource_Xerces.setContentHandler((ContentHandler)xMLSerializer);
        incrementalSAXSource_Xerces.setLexicalHandler((LexicalHandler)xMLSerializer);
        int n2 = 0;
        while (n2 < stringArray.length) {
            try {
                InputSource inputSource = new InputSource(stringArray[n2]);
                Object object = null;
                boolean bl = true;
                incrementalSAXSource_Xerces.startParse(inputSource);
                object = incrementalSAXSource_Xerces.deliverMoreNodes(bl);
                while (object == Boolean.TRUE) {
                    System.out.println("\nSome parsing successful, trying more.\n");
                    if (n2 + 1 < stringArray.length && "!".equals(stringArray[n2 + 1])) {
                        ++n2;
                        bl = false;
                    }
                    object = incrementalSAXSource_Xerces.deliverMoreNodes(bl);
                }
                if (object instanceof Boolean && (Boolean)object == Boolean.FALSE) {
                    System.out.println("\nParser ended (EOF or on request).\n");
                } else if (object == null) {
                    System.out.println("\nUNEXPECTED: Parser says shut down prematurely.\n");
                } else if (object instanceof Exception) {
                    throw new WrappedRuntimeException((Exception)object);
                }
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
            ++n2;
        }
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.fIncrementalParser.setContentHandler(contentHandler);
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        try {
            this.fIncrementalParser.setProperty("http://xml.org/sax/properties/lexical-handler", (Object)lexicalHandler);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {}
    }

    public void startParse(InputSource inputSource) throws SAXException {
        if (this.fIncrementalParser == null) {
            throw new SAXException(XSLMessages.createMessage(175, null));
        }
        if (this.fParseInProgress) {
            throw new SAXException(XSLMessages.createMessage(174, null));
        }
        boolean bl = false;
        try {
            bl = this.fIncrementalParser.parseSomeSetup(inputSource);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
        if (!bl) {
            throw new SAXException(XSLMessages.createMessage(176, null));
        }
    }
}

