/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.QName;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;

public final class VariableStack
implements Cloneable {
    XObject[] _sf = new XObject[8192];
    int _top;
    private int _cfb;
    int[] _links = new int[4096];
    int _linksTop;
    private static XObject[] m_nulls = new XObject[1024];

    public VariableStack() {
        this.reset();
    }

    public final void clearLocalSlots(int n, int n2) {
        System.arraycopy(m_nulls, 0, this._sf, n += this._cfb, n2);
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        VariableStack variableStack = (VariableStack)super.clone();
        variableStack._sf = (XObject[])this._sf.clone();
        variableStack._links = (int[])this._links.clone();
        return variableStack;
    }

    public final XObject elementAt(int n) {
        return this._sf[n];
    }

    public final XObject getGlobalVariable(XPathContext xPathContext, int n) throws TransformerException {
        XObject xObject = this._sf[n];
        if (xObject.getType() == 600) {
            this._sf[n] = xObject.execute(xPathContext);
            return this._sf[n];
        }
        return xObject;
    }

    public final XObject getLocalVariable(int n, int n2) throws TransformerException {
        XObject xObject = this._sf[n += n2];
        return xObject;
    }

    public final XObject getLocalVariable(XPathContext xPathContext, int n) throws TransformerException {
        XObject xObject = this._sf[n += this._cfb];
        if (xObject == null) {
            throw new TransformerException("Variable accessed before it is bound!", xPathContext.getSAXLocator());
        }
        if (xObject.getType() == 600) {
            this._sf[n] = xObject.execute(xPathContext);
            return this._sf[n];
        }
        return xObject;
    }

    public final int getStackFrame() {
        return this._cfb;
    }

    public final XObject getVariableOrParam(XPathContext xPathContext, QName qName) throws TransformerException {
        PrefixResolver prefixResolver = xPathContext.getNamespaceContext();
        if (prefixResolver instanceof ElemTemplateElement) {
            ElemVariable elemVariable;
            ElemTemplateElement elemTemplateElement = (ElemTemplateElement)prefixResolver;
            if (!(elemTemplateElement instanceof Stylesheet)) {
                while (!(elemTemplateElement.getParentNode() instanceof Stylesheet)) {
                    ElemTemplateElement elemTemplateElement2 = elemTemplateElement;
                    while ((elemTemplateElement = elemTemplateElement.getPreviousSiblingElem()) != null) {
                        if (!(elemTemplateElement instanceof ElemVariable) || !(elemVariable = (ElemVariable)elemTemplateElement).getName().equals(qName)) continue;
                        return this.getLocalVariable(xPathContext, elemVariable.getIndex());
                    }
                    elemTemplateElement = elemTemplateElement2.getParentElem();
                }
            }
            if ((elemVariable = elemTemplateElement.getStylesheetRoot().getVariableOrParamComposed(qName)) != null) {
                return this.getGlobalVariable(xPathContext, elemVariable.getIndex());
            }
        }
        throw new TransformerException(XSLMessages.createXPATHMessage(74, new Object[]{qName.toString()}));
    }

    public final boolean isLocalSet(int n) throws TransformerException {
        return this._sf[n + this._cfb] != null;
    }

    public final int link(int n) {
        Object[] objectArray;
        this._cfb = this._top;
        this._top += n;
        if (this._top >= this._sf.length) {
            objectArray = new XObject[this._sf.length + 4096 + n];
            System.arraycopy(this._sf, 0, objectArray, 0, this._sf.length);
            this._sf = objectArray;
        }
        if (this._linksTop + 1 >= this._links.length) {
            objectArray = new int[this._links.length + 2048];
            System.arraycopy(this._links, 0, objectArray, 0, this._links.length);
            this._links = (int[])objectArray;
        }
        this._links[this._linksTop++] = this._cfb;
        return this._cfb;
    }

    public final void reset() {
        this._top = 0;
        this._linksTop = 0;
        this._links[this._linksTop++] = 0;
    }

    public final void setGlobalVariable(int n, XObject xObject) {
        this._sf[n] = xObject;
    }

    public final void setLocalVariable(int n, XObject xObject) {
        this._sf[n + this._cfb] = xObject;
    }

    public final void setLocalVariable(int n, XObject xObject, int n2) {
        this._sf[n + n2] = xObject;
    }

    public final void setStackFrame(int n) {
        this._cfb = n;
    }

    public final int size() {
        return this._top;
    }

    public final void unlink() {
        this._top = this._links[--this._linksTop];
        this._cfb = this._links[this._linksTop - 1];
    }
}

