/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import com.google.common.base.Strings;
import com.google.common.net.MediaType;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Supplier;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.ResponseCodec;
import org.openqa.selenium.remote.http.HttpResponse;

public abstract class AbstractHttpResponseCodec
implements ResponseCodec<HttpResponse> {
    private final ErrorCodes errorCodes = new ErrorCodes();
    private final Json json = new Json();

    @Override
    public HttpResponse encode(Supplier<HttpResponse> factory, Response response) {
        int status = response.getStatus() == 0 ? 200 : 500;
        byte[] data = this.json.toJson(this.getValueToEncode(response)).getBytes(StandardCharsets.UTF_8);
        HttpResponse httpResponse = factory.get();
        httpResponse.setStatus(status);
        httpResponse.setHeader("Cache-Control", "no-cache");
        httpResponse.setHeader("Expires", "Thu, 01 Jan 1970 00:00:00 GMT");
        httpResponse.setHeader("Content-Length", String.valueOf(data.length));
        httpResponse.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
        httpResponse.setContent(data);
        return httpResponse;
    }

    protected abstract Object getValueToEncode(Response var1);

    @Override
    public Response decode(HttpResponse encodedResponse) {
        String content;
        block18: {
            String contentType = Strings.nullToEmpty((String)encodedResponse.getHeader("Content-Type"));
            content = encodedResponse.getContentString().trim();
            try {
                return this.reconstructValue(this.json.toType((Object)content, Response.class));
            }
            catch (JsonException e) {
                if (contentType.startsWith("application/json")) {
                    throw new IllegalArgumentException("Cannot decode response content: " + content, e);
                }
            }
            catch (ClassCastException e) {
                if (!contentType.startsWith("application/json")) break block18;
                if (content.isEmpty()) {
                    return new Response();
                }
                throw new IllegalArgumentException("Cannot decode response content: " + content, e);
            }
        }
        Response response = new Response();
        int statusCode = encodedResponse.getStatus();
        if (statusCode < 200 || statusCode > 299) {
            if (statusCode > 399 && statusCode < 500) {
                response.setStatus(9);
            } else {
                response.setStatus(13);
            }
        }
        if (encodedResponse.getContent().length > 0) {
            response.setValue(content);
        }
        if (response.getValue() instanceof String) {
            response.setValue(((String)response.getValue()).replace("\r\n", "\n"));
        }
        if (response.getStatus() != null && response.getState() == null) {
            response.setState(this.errorCodes.toState(response.getStatus()));
        } else if (response.getStatus() == null && response.getState() != null) {
            response.setStatus(this.errorCodes.toStatus(response.getState(), Optional.of(encodedResponse.getStatus())));
        } else if (statusCode == 200) {
            response.setStatus(0);
            response.setState(this.errorCodes.toState(0));
        }
        if (response.getStatus() != null) {
            response.setState(this.errorCodes.toState(response.getStatus()));
        } else if (statusCode == 200) {
            response.setState(this.errorCodes.toState(0));
        }
        return response;
    }

    protected abstract Response reconstructValue(Response var1);
}

