/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.common.collect.ImmutableSortedMap;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriverException;

public class SafariOptions
extends MutableCapabilities {
    public static final String CAPABILITY = "safari.options";
    private Map<String, Object> options = new TreeMap<String, Object>();

    public SafariOptions() {
        this.options.put("port", 0);
        this.setUseTechnologyPreview(false);
        this.setUseCleanSession(false);
        this.setCapability("browserName", "safari");
        this.setCapability("platform", Platform.MAC);
    }

    public SafariOptions(Capabilities source) {
        this();
        source.asMap().forEach((key, value) -> {
            if (CAPABILITY.equals(key) && value instanceof Map) {
                Map map = (Map)value;
                this.options.putAll(map);
            } else if (value != null) {
                this.setCapability((String)key, value);
            }
        });
    }

    @Override
    public SafariOptions merge(Capabilities extraCapabilities) {
        super.merge(extraCapabilities);
        return this;
    }

    public static SafariOptions fromCapabilities(Capabilities capabilities) throws WebDriverException {
        Object cap = capabilities.getCapability(CAPABILITY);
        if (cap instanceof SafariOptions) {
            return (SafariOptions)cap;
        }
        if (cap instanceof Map) {
            try {
                return SafariOptions.fromJsonMap((Map)cap);
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }
        return new SafariOptions();
    }

    @Deprecated
    SafariOptions setPort(int port) {
        this.options.put("port", port);
        return this;
    }

    public SafariOptions useCleanSession(boolean useCleanSession) {
        this.options.put("cleanSession", useCleanSession);
        return this;
    }

    @Deprecated
    public SafariOptions setUseCleanSession(boolean useCleanSession) {
        return this.useCleanSession(useCleanSession);
    }

    public SafariOptions setUseTechnologyPreview(boolean useTechnologyPreview) {
        this.options.put("technologyPreview", useTechnologyPreview);
        return this;
    }

    @Override
    public void setCapability(String key, Object value) {
        if ("technologyPreview".equals(key)) {
            this.setUseTechnologyPreview(Boolean.valueOf(value.toString()));
        } else if ("cleanSession".equals(key)) {
            this.useCleanSession(Boolean.valueOf(value.toString()));
        } else {
            super.setCapability(key, value);
        }
    }

    @Override
    public void setCapability(String key, boolean value) {
        if ("technologyPreview".equals(key)) {
            this.setUseTechnologyPreview(value);
        } else if ("cleanSession".equals(key)) {
            this.useCleanSession(value);
        } else {
            super.setCapability(key, value);
        }
    }

    public SafariOptions setProxy(Proxy proxy) {
        this.setCapability("proxy", proxy);
        return this;
    }

    @Deprecated
    public int getPort() {
        return (Integer)this.options.getOrDefault("port", 0);
    }

    @Deprecated
    public boolean getUseCleanSession() {
        return (Boolean)this.options.getOrDefault("cleanSession", false);
    }

    @Deprecated
    public boolean getUseTechnologyPreview() {
        return (Boolean)this.options.getOrDefault("technologyPreview", false);
    }

    private static SafariOptions fromJsonMap(Map<?, ?> options) throws IOException {
        Boolean useTechnologyPreview;
        Boolean useCleanSession;
        SafariOptions safariOptions = new SafariOptions();
        Number port = (Number)options.get("port");
        if (port != null) {
            safariOptions.setPort(port.intValue());
        }
        if ((useCleanSession = (Boolean)options.get("cleanSession")) != null) {
            safariOptions.useCleanSession(useCleanSession);
        }
        if ((useTechnologyPreview = (Boolean)options.get("technologyPreview")) != null) {
            safariOptions.setUseTechnologyPreview(useTechnologyPreview);
        }
        return safariOptions;
    }

    @Deprecated
    MutableCapabilities toCapabilities() {
        return this;
    }

    @Override
    protected int amendHashCode() {
        return this.options.hashCode();
    }

    @Override
    public Map<String, Object> asMap() {
        return ImmutableSortedMap.naturalOrder().putAll(super.asMap()).put((Object)CAPABILITY, this.options).build();
    }

    private static interface Option {
        public static final String CLEAN_SESSION = "cleanSession";
        public static final String TECHNOLOGY_PREVIEW = "technologyPreview";
        public static final String PORT = "port";
    }
}

