/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.GeneratedXmlFile;
import org.mybatis.generator.api.ProgressCallback;
import org.mybatis.generator.api.ShellCallback;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.MergeConstants;
import org.mybatis.generator.exception.InvalidConfigurationException;
import org.mybatis.generator.exception.ShellException;
import org.mybatis.generator.internal.DefaultShellCallback;
import org.mybatis.generator.internal.NullProgressCallback;
import org.mybatis.generator.internal.ObjectFactory;
import org.mybatis.generator.internal.XmlFileMergerJaxp;
import org.mybatis.generator.internal.util.ClassloaderUtility;
import org.mybatis.generator.internal.util.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyBatisGenerator {
    private Configuration configuration;
    private ShellCallback shellCallback;
    private List<GeneratedJavaFile> generatedJavaFiles;
    private List<GeneratedXmlFile> generatedXmlFiles;
    private List<String> warnings;
    private Set<String> projects;

    public MyBatisGenerator(Configuration configuration, ShellCallback shellCallback, List<String> warnings) throws InvalidConfigurationException {
        if (configuration == null) {
            throw new IllegalArgumentException(Messages.getString("RuntimeError.2"));
        }
        this.configuration = configuration;
        this.shellCallback = shellCallback == null ? new DefaultShellCallback(false) : shellCallback;
        this.warnings = warnings == null ? new ArrayList<String>() : warnings;
        this.generatedJavaFiles = new ArrayList<GeneratedJavaFile>();
        this.generatedXmlFiles = new ArrayList<GeneratedXmlFile>();
        this.projects = new HashSet<String>();
        this.configuration.validate();
    }

    public void generate(ProgressCallback callback) throws SQLException, IOException, InterruptedException {
        this.generate(callback, null, null);
    }

    public void generate(ProgressCallback callback, Set<String> contextIds) throws SQLException, IOException, InterruptedException {
        this.generate(callback, contextIds, null);
    }

    public void generate(ProgressCallback callback, Set<String> contextIds, Set<String> fullyQualifiedTableNames) throws SQLException, IOException, InterruptedException {
        String source;
        File targetFile;
        File directory;
        List<Context> contextsToRun;
        if (callback == null) {
            callback = new NullProgressCallback();
        }
        this.generatedJavaFiles.clear();
        this.generatedXmlFiles.clear();
        if (contextIds == null || contextIds.size() == 0) {
            contextsToRun = this.configuration.getContexts();
        } else {
            contextsToRun = new ArrayList<Context>();
            for (Context context : this.configuration.getContexts()) {
                if (!contextIds.contains(context.getId())) continue;
                contextsToRun.add(context);
            }
        }
        if (this.configuration.getClassPathEntries().size() > 0) {
            ClassLoader classLoader = ClassloaderUtility.getCustomClassloader(this.configuration.getClassPathEntries());
            ObjectFactory.addExternalClassLoader(classLoader);
        }
        int totalSteps = 0;
        for (Context context : contextsToRun) {
            totalSteps += context.getIntrospectionSteps();
        }
        callback.introspectionStarted(totalSteps);
        for (Context context : contextsToRun) {
            context.introspectTables(callback, this.warnings, fullyQualifiedTableNames);
        }
        totalSteps = 0;
        for (Context context : contextsToRun) {
            totalSteps += context.getGenerationSteps();
        }
        callback.generationStarted(totalSteps);
        for (Context context : contextsToRun) {
            context.generateFiles(callback, this.generatedJavaFiles, this.generatedXmlFiles, this.warnings);
        }
        callback.saveStarted(this.generatedXmlFiles.size() + this.generatedJavaFiles.size());
        for (GeneratedXmlFile gxf : this.generatedXmlFiles) {
            this.projects.add(gxf.getTargetProject());
            try {
                directory = this.shellCallback.getDirectory(gxf.getTargetProject(), gxf.getTargetPackage());
                targetFile = new File(directory, gxf.getFileName());
                if (targetFile.exists()) {
                    if (gxf.isMergeable()) {
                        source = XmlFileMergerJaxp.getMergedSource(gxf, targetFile);
                    } else if (this.shellCallback.isOverwriteEnabled()) {
                        source = gxf.getFormattedContent();
                        this.warnings.add(Messages.getString("Warning.11", targetFile.getAbsolutePath()));
                    } else {
                        source = gxf.getFormattedContent();
                        targetFile = this.getUniqueFileName(directory, gxf.getFileName());
                        this.warnings.add(Messages.getString("Warning.2", targetFile.getAbsolutePath()));
                    }
                } else {
                    source = gxf.getFormattedContent();
                }
            }
            catch (ShellException e) {
                this.warnings.add(e.getMessage());
                continue;
            }
            callback.checkCancel();
            callback.startTask(Messages.getString("Progress.15", targetFile.getName()));
            this.writeFile(targetFile, source, "UTF-8");
        }
        for (GeneratedJavaFile gjf : this.generatedJavaFiles) {
            this.projects.add(gjf.getTargetProject());
            try {
                directory = this.shellCallback.getDirectory(gjf.getTargetProject(), gjf.getTargetPackage());
                targetFile = new File(directory, gjf.getFileName());
                if (targetFile.exists()) {
                    if (this.shellCallback.isMergeSupported()) {
                        source = this.shellCallback.mergeJavaFile(gjf.getFormattedContent(), targetFile.getAbsolutePath(), MergeConstants.OLD_ELEMENT_TAGS, gjf.getFileEncoding());
                    } else if (this.shellCallback.isOverwriteEnabled()) {
                        source = gjf.getFormattedContent();
                        this.warnings.add(Messages.getString("Warning.11", targetFile.getAbsolutePath()));
                    } else {
                        source = gjf.getFormattedContent();
                        targetFile = this.getUniqueFileName(directory, gjf.getFileName());
                        this.warnings.add(Messages.getString("Warning.2", targetFile.getAbsolutePath()));
                    }
                } else {
                    source = gjf.getFormattedContent();
                }
                callback.checkCancel();
                callback.startTask(Messages.getString("Progress.15", targetFile.getName()));
                this.writeFile(targetFile, source, gjf.getFileEncoding());
            }
            catch (ShellException e) {
                this.warnings.add(e.getMessage());
            }
        }
        for (String project : this.projects) {
            this.shellCallback.refreshProject(project);
        }
        callback.done();
    }

    private void writeFile(File file, String content, String fileEncoding) throws IOException {
        FileOutputStream fos = new FileOutputStream(file, false);
        OutputStreamWriter osw = fileEncoding == null ? new OutputStreamWriter(fos) : new OutputStreamWriter((OutputStream)fos, fileEncoding);
        BufferedWriter bw = new BufferedWriter(osw);
        bw.write(content);
        bw.close();
    }

    private File getUniqueFileName(File directory, String fileName) {
        File answer = null;
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < 1000; ++i) {
            sb.setLength(0);
            sb.append(fileName);
            sb.append('.');
            sb.append(i);
            File testFile = new File(directory, sb.toString());
            if (testFile.exists()) continue;
            answer = testFile;
            break;
        }
        if (answer == null) {
            throw new RuntimeException(Messages.getString("RuntimeError.3", directory.getAbsolutePath()));
        }
        return answer;
    }
}

