/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.internal;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.mybatis.generator.api.ConnectionFactory;
import org.mybatis.generator.config.JDBCConnectionConfiguration;
import org.mybatis.generator.internal.ObjectFactory;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;

public class JDBCConnectionFactory
implements ConnectionFactory {
    private String userId;
    private String password;
    private String connectionURL;
    private String driverClass;
    private Properties otherProperties;

    public JDBCConnectionFactory(JDBCConnectionConfiguration config) {
        this.userId = config.getUserId();
        this.password = config.getPassword();
        this.connectionURL = config.getConnectionURL();
        this.driverClass = config.getDriverClass();
        this.otherProperties = config.getProperties();
    }

    public JDBCConnectionFactory() {
    }

    @Override
    public Connection getConnection() throws SQLException {
        Driver driver = this.getDriver();
        Properties props = new Properties();
        if (StringUtility.stringHasValue(this.userId)) {
            props.setProperty("user", this.userId);
        }
        if (StringUtility.stringHasValue(this.password)) {
            props.setProperty("password", this.password);
        }
        props.putAll((Map<?, ?>)this.otherProperties);
        Connection conn = driver.connect(this.connectionURL, props);
        if (conn == null) {
            throw new SQLException(Messages.getString("RuntimeError.7"));
        }
        return conn;
    }

    private Driver getDriver() {
        Driver driver;
        try {
            Class<?> clazz = ObjectFactory.externalClassForName(this.driverClass);
            driver = (Driver)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.getString("RuntimeError.8"), e);
        }
        return driver;
    }

    @Override
    public void addConfigurationProperties(Properties properties) {
        this.userId = properties.getProperty("userId");
        this.password = properties.getProperty("password");
        this.connectionURL = properties.getProperty("connectionURL");
        this.driverClass = properties.getProperty("driverClass");
        this.otherProperties = new Properties();
        this.otherProperties.putAll((Map<?, ?>)properties);
        this.otherProperties.remove("userId");
        this.otherProperties.remove("password");
        this.otherProperties.remove("connectionURL");
        this.otherProperties.remove("driverClass");
    }
}

