/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.page;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.util.PageObjectUtil;
import com.github.pagehelper.util.StringUtil;
import java.util.Properties;
import org.apache.ibatis.session.RowBounds;

public class PageParams {
    protected boolean offsetAsPageNum = false;
    protected boolean rowBoundsWithCount = false;
    protected boolean pageSizeZero = false;
    protected boolean reasonable = false;
    protected boolean supportMethodsArguments = false;
    protected String countColumn = "0";

    public Page getPage(Object parameterObject, RowBounds rowBounds) {
        Page<Object> page = PageHelper.getLocalPage();
        if (page == null) {
            if (rowBounds != RowBounds.DEFAULT) {
                if (this.offsetAsPageNum) {
                    page = new Page(rowBounds.getOffset(), rowBounds.getLimit(), this.rowBoundsWithCount);
                } else {
                    page = new Page(new int[]{rowBounds.getOffset(), rowBounds.getLimit()}, this.rowBoundsWithCount);
                    page.setReasonable(false);
                }
            } else {
                try {
                    page = PageObjectUtil.getPageFromObject(parameterObject, false);
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (page == null) {
                return null;
            }
            PageHelper.setLocalPage(page);
        }
        if (page.getReasonable() == null) {
            page.setReasonable(this.reasonable);
        }
        if (page.getPageSizeZero() == null) {
            page.setPageSizeZero(this.pageSizeZero);
        }
        return page;
    }

    public void setProperties(Properties properties) {
        String offsetAsPageNum = properties.getProperty("offsetAsPageNum");
        this.offsetAsPageNum = Boolean.parseBoolean(offsetAsPageNum);
        String rowBoundsWithCount = properties.getProperty("rowBoundsWithCount");
        this.rowBoundsWithCount = Boolean.parseBoolean(rowBoundsWithCount);
        String pageSizeZero = properties.getProperty("pageSizeZero");
        this.pageSizeZero = Boolean.parseBoolean(pageSizeZero);
        String reasonable = properties.getProperty("reasonable");
        this.reasonable = Boolean.parseBoolean(reasonable);
        String supportMethodsArguments = properties.getProperty("supportMethodsArguments");
        this.supportMethodsArguments = Boolean.parseBoolean(supportMethodsArguments);
        String countColumn = properties.getProperty("countColumn");
        if (StringUtil.isNotEmpty(countColumn)) {
            this.countColumn = countColumn;
        }
        PageObjectUtil.setParams(properties.getProperty("params"));
    }

    public boolean isOffsetAsPageNum() {
        return this.offsetAsPageNum;
    }

    public boolean isRowBoundsWithCount() {
        return this.rowBoundsWithCount;
    }

    public boolean isPageSizeZero() {
        return this.pageSizeZero;
    }

    public boolean isReasonable() {
        return this.reasonable;
    }

    public boolean isSupportMethodsArguments() {
        return this.supportMethodsArguments;
    }

    public String getCountColumn() {
        return this.countColumn;
    }
}

