/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.codegen.ibatis2.dao.templates;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.api.CommentGenerator;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDAOTemplate {
    private List<FullyQualifiedJavaType> interfaceImports = new ArrayList<FullyQualifiedJavaType>();
    private List<FullyQualifiedJavaType> implementationImports = new ArrayList<FullyQualifiedJavaType>();
    private FullyQualifiedJavaType superClass;
    private List<FullyQualifiedJavaType> checkedExceptions;
    private List<Field> fields = new ArrayList<Field>();
    private List<Method> methods = new ArrayList<Method>();
    private Method constructorTemplate;
    private String deleteMethodTemplate;
    private String insertMethodTemplate;
    private String updateMethodTemplate;
    private String queryForObjectMethodTemplate;
    private String queryForListMethodTemplate;
    private boolean configured = false;

    public AbstractDAOTemplate() {
        this.checkedExceptions = new ArrayList<FullyQualifiedJavaType>();
    }

    public final Method getConstructorClone(CommentGenerator commentGenerator, FullyQualifiedJavaType type, IntrospectedTable introspectedTable) {
        this.configure();
        Method answer = new Method();
        answer.setConstructor(true);
        answer.setName(type.getShortName());
        answer.setVisibility(this.constructorTemplate.getVisibility());
        for (Parameter parm : this.constructorTemplate.getParameters()) {
            answer.addParameter(parm);
        }
        for (String bodyLine : this.constructorTemplate.getBodyLines()) {
            answer.addBodyLine(bodyLine);
        }
        for (FullyQualifiedJavaType fqjt : this.constructorTemplate.getExceptions()) {
            answer.addException(fqjt);
        }
        commentGenerator.addGeneralMethodComment(answer, introspectedTable);
        return answer;
    }

    public final String getDeleteMethod(String sqlMapNamespace, String statementId, String parameter) {
        this.configure();
        String answer = MessageFormat.format(this.deleteMethodTemplate, sqlMapNamespace, statementId, parameter);
        return answer;
    }

    public final List<FullyQualifiedJavaType> getInterfaceImports() {
        this.configure();
        return this.interfaceImports;
    }

    public final List<FullyQualifiedJavaType> getImplementationImports() {
        this.configure();
        return this.implementationImports;
    }

    public final String getInsertMethod(String sqlMapNamespace, String statementId, String parameter) {
        this.configure();
        String answer = MessageFormat.format(this.insertMethodTemplate, sqlMapNamespace, statementId, parameter);
        return answer;
    }

    public final String getQueryForListMethod(String sqlMapNamespace, String statementId, String parameter) {
        this.configure();
        String answer = MessageFormat.format(this.queryForListMethodTemplate, sqlMapNamespace, statementId, parameter);
        return answer;
    }

    public final String getQueryForObjectMethod(String sqlMapNamespace, String statementId, String parameter) {
        this.configure();
        String answer = MessageFormat.format(this.queryForObjectMethodTemplate, sqlMapNamespace, statementId, parameter);
        return answer;
    }

    public final FullyQualifiedJavaType getSuperClass() {
        this.configure();
        return this.superClass;
    }

    public final String getUpdateMethod(String sqlMapNamespace, String statementId, String parameter) {
        this.configure();
        String answer = MessageFormat.format(this.updateMethodTemplate, sqlMapNamespace, statementId, parameter);
        return answer;
    }

    public final List<FullyQualifiedJavaType> getCheckedExceptions() {
        this.configure();
        return this.checkedExceptions;
    }

    public final List<Field> getFieldClones(CommentGenerator commentGenerator, IntrospectedTable introspectedTable) {
        this.configure();
        ArrayList<Field> answer = new ArrayList<Field>();
        for (Field oldField : this.fields) {
            Field field = new Field();
            field.setInitializationString(oldField.getInitializationString());
            field.setFinal(oldField.isFinal());
            field.setStatic(oldField.isStatic());
            field.setName(oldField.getName());
            field.setType(oldField.getType());
            field.setVisibility(oldField.getVisibility());
            commentGenerator.addFieldComment(field, introspectedTable);
            answer.add(field);
        }
        return answer;
    }

    public final List<Method> getMethodClones(CommentGenerator commentGenerator, IntrospectedTable introspectedTable) {
        this.configure();
        ArrayList<Method> answer = new ArrayList<Method>();
        for (Method oldMethod : this.methods) {
            Method method = new Method();
            for (String bodyLine : oldMethod.getBodyLines()) {
                method.addBodyLine(bodyLine);
            }
            for (FullyQualifiedJavaType fqjt : oldMethod.getExceptions()) {
                method.addException(fqjt);
            }
            for (Parameter parm : oldMethod.getParameters()) {
                method.addParameter(parm);
            }
            method.setConstructor(oldMethod.isConstructor());
            method.setFinal(oldMethod.isFinal());
            method.setStatic(oldMethod.isStatic());
            method.setName(oldMethod.getName());
            method.setReturnType(oldMethod.getReturnType());
            method.setVisibility(oldMethod.getVisibility());
            commentGenerator.addGeneralMethodComment(method, introspectedTable);
            answer.add(method);
        }
        return answer;
    }

    protected void setConstructorTemplate(Method constructorTemplate) {
        this.constructorTemplate = constructorTemplate;
    }

    protected void setDeleteMethodTemplate(String deleteMethodTemplate) {
        this.deleteMethodTemplate = deleteMethodTemplate;
    }

    protected void addField(Field field) {
        this.fields.add(field);
    }

    protected void setInsertMethodTemplate(String insertMethodTemplate) {
        this.insertMethodTemplate = insertMethodTemplate;
    }

    protected void addMethod(Method method) {
        this.methods.add(method);
    }

    protected void setQueryForListMethodTemplate(String queryForListMethodTemplate) {
        this.queryForListMethodTemplate = queryForListMethodTemplate;
    }

    protected void setQueryForObjectMethodTemplate(String queryForObjectMethodTemplate) {
        this.queryForObjectMethodTemplate = queryForObjectMethodTemplate;
    }

    protected void setSuperClass(FullyQualifiedJavaType superClass) {
        this.superClass = superClass;
    }

    protected void setUpdateMethodTemplate(String updateMethodTemplate) {
        this.updateMethodTemplate = updateMethodTemplate;
    }

    protected void addInterfaceImport(FullyQualifiedJavaType type) {
        this.interfaceImports.add(type);
    }

    protected void addImplementationImport(FullyQualifiedJavaType type) {
        this.implementationImports.add(type);
    }

    protected void addCheckedException(FullyQualifiedJavaType type) {
        this.checkedExceptions.add(type);
    }

    private void configure() {
        if (!this.configured) {
            this.configureCheckedExceptions();
            this.configureConstructorTemplate();
            this.configureDeleteMethodTemplate();
            this.configureFields();
            this.configureImplementationImports();
            this.configureInsertMethodTemplate();
            this.configureInterfaceImports();
            this.configureMethods();
            this.configureQueryForListMethodTemplate();
            this.configureQueryForObjectMethodTemplate();
            this.configureSuperClass();
            this.configureUpdateMethodTemplate();
            this.configured = true;
        }
    }

    protected void configureCheckedExceptions() {
    }

    protected void configureFields() {
    }

    protected void configureImplementationImports() {
    }

    protected void configureInterfaceImports() {
    }

    protected void configureMethods() {
    }

    protected void configureSuperClass() {
    }

    protected abstract void configureConstructorTemplate();

    protected abstract void configureInsertMethodTemplate();

    protected abstract void configureQueryForListMethodTemplate();

    protected abstract void configureQueryForObjectMethodTemplate();

    protected abstract void configureUpdateMethodTemplate();

    protected abstract void configureDeleteMethodTemplate();
}

