/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zzU4;
import com.aspose.words.Border;
import com.aspose.words.zzZS4;
import java.awt.Color;
import java.util.Iterator;

public final class BorderCollection
implements Iterable<Border> {
    private zzZS4 zzZZE;

    BorderCollection(zzZS4 parent) {
        this.zzZZE = parent;
    }

    public final Border getByBorderType(int borderType) throws Exception {
        Object v = this.zzZZE.getPossibleBorderKeys().get(borderType);
        if (v == null) {
            throw new IllegalStateException("The requested border is not available for this object.");
        }
        int n = (Integer)v;
        Border border = (Border)this.zzZZE.getDirectBorderAttr(n);
        if (border == null) {
            border = new Border(this.zzZZE, n);
            this.zzZZE.setBorderAttr(n, border);
        }
        return border;
    }

    public final Border get(int index) throws Exception {
        int n = (Integer)this.zzZZE.getPossibleBorderKeys().getKey(index);
        return this.getByBorderType(n);
    }

    public final Border getLeft() throws Exception {
        return this.getByBorderType(1);
    }

    public final Border getRight() throws Exception {
        return this.getByBorderType(2);
    }

    public final Border getTop() throws Exception {
        return this.getByBorderType(3);
    }

    public final Border getBottom() throws Exception {
        return this.getByBorderType(0);
    }

    public final Border getHorizontal() throws Exception {
        return this.getByBorderType(4);
    }

    public final Border getVertical() throws Exception {
        return this.getByBorderType(5);
    }

    public final int getCount() {
        return this.zzZZE.getPossibleBorderKeys().getCount();
    }

    public final double getLineWidth() throws Exception {
        return this.get(0).getLineWidth();
    }

    public final void setLineWidth(double value) throws Exception {
        Iterator iterator = this.zzZZE.getPossibleBorderKeys().zzE6().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzTB(n)) continue;
            this.getByBorderType(n).setLineWidth(value);
        }
    }

    public final int getLineStyle() throws Exception {
        return this.get(0).getLineStyle();
    }

    public final void setLineStyle(int value) throws Exception {
        Iterator iterator = this.zzZZE.getPossibleBorderKeys().zzE6().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzTB(n)) continue;
            this.getByBorderType(n).setLineStyle(value);
        }
    }

    public final Color getColor() throws Exception {
        BorderCollection borderCollection = this;
        return borderCollection.get(0).zzyw().zzUo();
    }

    public final void setColor(Color value) throws Exception {
        zzU4 zzU42 = zzU4.zzZ(value);
        BorderCollection borderCollection = this;
        Iterator iterator = borderCollection.zzZZE.getPossibleBorderKeys().zzE6().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzTB(n)) continue;
            borderCollection.getByBorderType(n).zzy(zzU42);
        }
    }

    public final double getDistanceFromText() throws Exception {
        return this.get(0).getDistanceFromText();
    }

    public final void setDistanceFromText(double value) throws Exception {
        Iterator iterator = this.zzZZE.getPossibleBorderKeys().zzE6().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzTB(n)) continue;
            this.getByBorderType(n).setDistanceFromText(value);
        }
    }

    public final boolean getShadow() throws Exception {
        return this.get(0).getShadow();
    }

    public final void setShadow(boolean value) throws Exception {
        Iterator iterator = this.zzZZE.getPossibleBorderKeys().zzE6().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzTB(n)) continue;
            this.getByBorderType(n).setShadow(value);
        }
    }

    public final void clearFormatting() {
        for (Border border : this) {
            border.clearFormatting();
        }
    }

    @Override
    public final Iterator iterator() {
        return new zzZ(this);
    }

    final boolean isVisible() {
        for (Border border : this) {
            if (!border.isVisible()) continue;
            return true;
        }
        return false;
    }

    private static boolean zzTB(int n) {
        return n != 6 && n != 7;
    }

    static final class zzZ
    implements Iterator {
        private BorderCollection zzZZp;
        private int zzZZo;

        zzZ(BorderCollection borderCollection) {
            this.zzZZp = borderCollection;
            this.zzZZo = -1;
        }

        @Override
        public final boolean hasNext() {
            if (this.zzZZo >= this.zzZZp.getCount() - 1) {
                return false;
            }
            ++this.zzZZo;
            return true;
        }

        public final Object next() {
            try {
                return this.zzZZp.get(this.zzZZo);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

