/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz3F;
import asposewobfuscated.zz7V;
import asposewobfuscated.zz7W;
import asposewobfuscated.zz7X;
import asposewobfuscated.zz84;
import asposewobfuscated.zz95;
import asposewobfuscated.zzAY;
import asposewobfuscated.zzAZ;
import asposewobfuscated.zzCB;
import asposewobfuscated.zzCS;
import asposewobfuscated.zzYD;
import asposewobfuscated.zzYP;
import asposewobfuscated.zzYQ;
import asposewobfuscated.zzZ;
import com.aspose.words.Body;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Table;
import com.aspose.words.zz3E;
import com.aspose.words.zz3J;
import com.aspose.words.zz7;
import com.aspose.words.zz9B;
import com.aspose.words.zzDD;
import com.aspose.words.zzE1;
import com.aspose.words.zzE7;
import com.aspose.words.zzFX;
import com.aspose.words.zzIB;
import com.aspose.words.zzMK;
import com.aspose.words.zzX;
import com.aspose.words.zzYH;
import com.aspose.words.zzYQ7;
import com.aspose.words.zzYSQ;
import com.aspose.words.zzYV9;
import com.aspose.words.zzYVK;
import com.aspose.words.zzYW5;
import com.aspose.words.zzYWI;
import com.aspose.words.zzZ02;
import com.aspose.words.zzZ19;
import com.aspose.words.zzZ86;
import com.aspose.words.zzZ8Z;
import com.aspose.words.zzZ93;
import com.aspose.words.zzZHY;
import com.aspose.words.zzZJ;
import com.aspose.words.zzZOZ;
import com.aspose.words.zzZP2;
import com.aspose.words.zzZQB;
import com.aspose.words.zzZS1;
import com.aspose.words.zzZS3;
import com.aspose.words.zzZUM;
import com.aspose.words.zzZV7;
import com.aspose.words.zzZWP;
import com.aspose.words.zzZZV;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.Iterator;

public class DocumentBuilder
implements zzZOZ,
zzZP2,
zzZS3 {
    private Document zzZrw;
    private Node zzZq2;
    private Node zzZq1;
    private zzZ19 zzZq0;
    private Font zzZpZ;
    private zz95 zzZpY;
    private zzYV9 zzZpX = zzYV9.zzZee();
    private zzYH zzZXN = new zzYH();
    private RowFormat zzZpW;
    private CellFormat zzZXM;
    private zz95 zzZpV;
    private int zzZpU = 0;
    private int zzZpT = -1;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzR(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzR(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzR(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        this.zzZ(this.getCurrentSection(), zzYQ7.zzxQ(headerFooterType), 0, 0);
    }

    private void zzR(int n, int n2, int n3, int n4) {
        this.zzZrw.ensureMinimum();
        Section section = (Section)this.zzZrw.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Parameter name: sectionIdx");
        }
        this.zzZ(section, 1, n3, n4);
    }

    private void zzZ(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzYQ7.zzxP(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzZrw, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzZrw));
            }
        }
        this.zzZ(story, n2, n3);
    }

    private void zzZ(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Parameter name: paraIdx");
        }
        this.zzY(paragraph, n2);
    }

    final void zzY(Paragraph paragraph, int n) {
        if (n == 0) {
            this.zzZ(paragraph, paragraph.getFirstChild());
            return;
        }
        if (n == -1) {
            this.zzZ(paragraph, null);
        }
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zz5B().isRemoved() ? zzZHY.zzU(this.zzZrw, fieldName) : zzZHY.zzT(this.zz5B(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzZ(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzZ(field, isAfter, false);
    }

    private boolean zzZ(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzZQB zzZQB2 = field.getFormat().zzZYp();
        Inline inline = zzZQB2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzZ(inline.zzZYq(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zzZJ.zzX(this.zzZrw, bookmarkName) : zzZJ.zzW(this.zzZrw, bookmarkName);
        if (node == null) {
            return false;
        }
        this.zzZ((Paragraph)node.zzZCH(), isAfter ? node.getNextSibling() : node);
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        this.zzZ(this.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        if (characterIndex != 0 && characterIndex != -1) {
            throw new IllegalArgumentException("Parameter name: characterIndex");
        }
        Row row = this.zzZ6(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Parameter name: columnIndex");
        }
        cell.ensureMinimum();
        if (characterIndex == 0) {
            this.zzY(cell.getFirstParagraph(), 0);
            return;
        }
        if (characterIndex == -1) {
            this.zzY(cell.getLastParagraph(), -1);
        }
    }

    private void zzZ(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || zzX.zzM(node)) {
            this.zzd(node);
        } else if (zzX.zzP(node)) {
            Node node2 = ((CompositeNode)node).getChild(8, 0, true);
            if (node2 == null) {
                throw new IllegalStateException("The block level node doesn't contain paragraph.");
            }
            this.zzd(node2);
        } else {
            throw new IllegalStateException("The node must be a block or an inline.");
        }
        if (this.isAtEndOfParagraph()) {
            this.zz5M();
            return;
        }
        if (!this.zz5N()) {
            this.zz5M();
        }
    }

    private boolean zz5N() {
        Node node = this.zz5B();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
        }
        if (node == null) {
            for (node = this.zz5B(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzZ(inline.zzZYq(), true);
            return true;
        }
        return false;
    }

    private void zz5M() {
        this.zzZ(this.getCurrentParagraph().zzZuz(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzZ6(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zz5E() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zz5B().zzZe(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzZCD();
                this.zzY(paragraph, 0);
            }
        }
        row.remove();
        if (!table.zzsF()) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzI(text, false);
    }

    public void writeln(String text) {
        this.zzI(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        Paragraph paragraph = this.getCurrentParagraph();
        zzYW5 zzYW52 = new zzYW5(this.getDocument());
        try {
            Paragraph paragraph2 = new Paragraph(this.zzZrw, this.zz5J(), this.zz5K());
            this.getCurrentParagraph().getParentNode().insertAfter(paragraph2, this.getCurrentParagraph());
            if (this.isAtEndOfParagraph()) {
                this.moveTo(paragraph2);
            } else {
                paragraph2.zzY(this.zz5B(), null, paragraph2.getLastChild());
            }
        }
        finally {
            zzYW52.dispose();
        }
        if (this.getDocument().zz6b()) {
            zzX.zzX(paragraph, this.getDocument().zz6g());
        }
        return this.getCurrentParagraph();
    }

    public void insertStyleSeparator() {
        zzYWI.zzY(this);
    }

    public void insertBreak(int breakType) {
        this.zzp(breakType, true);
    }

    final void zzp(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.insertParagraph();
                return;
            }
            case 1: {
                if (this.zzXz(bl)) {
                    this.zzSI(ControlChar.PAGE_BREAK);
                }
                return;
            }
            case 2: {
                if (this.zzXz(bl)) {
                    this.zzSI(ControlChar.COLUMN_BREAK);
                }
                return;
            }
            case 4: {
                if (this.zzXz(bl)) {
                    this.zzNJ(1);
                }
                return;
            }
            case 5: {
                if (this.zzXz(bl)) {
                    this.zzNJ(2);
                }
                return;
            }
            case 3: {
                if (this.zzXz(bl)) {
                    this.zzNJ(0);
                }
                return;
            }
            case 6: {
                if (this.zzXz(bl)) {
                    this.zzNJ(3);
                }
                return;
            }
            case 7: {
                if (this.zzXz(bl)) {
                    this.zzNJ(4);
                }
                return;
            }
            case 8: {
                this.zzSI(ControlChar.LINE_BREAK);
                return;
            }
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzCS.zzYK(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zz3F.format("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        return zzX.zzZ(fieldType, updateField, this.zz5K(), this.zz5B(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode) throws Exception {
        return zzX.zzZ(fieldCode, this.zz5K(), this.zz5B(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        return zzX.zzZ(fieldCode, fieldValue, this.zz5K(), this.zz5B(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzZ.zzZ((Object)displayText, "displayText");
        zzZ.zzZ((Object)urlOrBookmark, "hrefOrBookmark");
        zz3J zz3J2 = this.zzZ(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zz3J2.zzY(documentBuilder.zzo(88, true));
        return zzX.zzZ(zz3J2.getStart(), zz3J2.getSeparator(), zz3J2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Parameter name: maxLength");
        }
        this.zzNI(70);
        if (zzCS.zzYK(name)) {
            this.startBookmark(name);
        }
        this.zzSH(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzNH(70);
        String string = zzCS.zzYK(fieldValue) ? fieldValue : FormField.zzZ7F;
        Run run = new Run(this.zzZrw, string, this.zz5K());
        this.insertNode(run);
        this.zzo(70, true);
        if (zzCS.zzYK(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zze(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        return this.insertCheckBox(name, checkedValue, checkedValue, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Parameter name: size");
        }
        this.zzNI(71);
        if (zzCS.zzYK(name)) {
            this.startBookmark(name);
        }
        this.zzSH(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzo(71, false);
        if (zzCS.zzYK(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zze(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Parameter name: selectedIndex");
        }
        this.zzNI(83);
        if (zzCS.zzYK(name)) {
            this.startBookmark(name);
        }
        this.zzSH(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzo(83, false);
        if (zzCS.zzYK(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zze(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote((DocumentBase)this.zzZrw, footnoteType);
        footnote.getFont().setStyleIdentifier(zzX.zzUf(footnoteType));
        if (zzCS.zzYK(referenceMark)) {
            footnote.setReferenceMark(referenceMark);
        }
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzZrw);
        paragraph.getParagraphFormat().setStyleIdentifier(zzX.zzUe(footnoteType));
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzZrw, '\u0002', new zzZ19()) : new Run(this.zzZrw, footnote.getReferenceMark(), new zzZ19());
        inline.getFont().setStyleIdentifier(zzX.zzUf(footnoteType));
        paragraph.appendChild(inline);
        if (zzCS.zzYK(footnoteText)) {
            Node node = this.zz5B();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzd(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zza(zz7V zz7V2) throws Exception {
        return this.zzZ(zz7V2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zza(zz7V.zzY(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzZ(zz7V zz7V2, double d, double d2) throws Exception {
        return this.zzZ(zz7V2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzZ(zz7V.zzY(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        zz7X zz7X2 = new zz7X();
        try {
            zzYD.zzZ(image, zz7X2);
            Shape shape = this.zzZ(zz7X2, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            zz7X2.close();
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzZ.zzZ(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzCB.zzYx(fileName);
        try {
            Shape shape = this.zzZ((zz7V)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zz7V)object).close();
            }
        }
    }

    private Shape zzZ(zz7V zz7V2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zz7V2 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = zzZ.zzZ(zz7V2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzZ(zz7V.zzY(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Shape shape;
        if (imageBytes == null) {
            throw new NullPointerException("imageBytes");
        }
        if (this.zzZrw.getCompatibilityOptions().getMswVersion() > 12 || this.zzZrw.getCompatibilityOptions().getMswVersion() == 0) {
            shape = new Shape((DocumentBase)this.zzZrw, 0);
            zzDD zzDD2 = new zzDD();
            zzDD2.zzZ(zzFX.zzT3("rect"));
            zzDD2.zzZ(new zzMK());
            zzE1 zzE12 = new zzE1();
            zzE12.zzY(new zzE7(shape.getId(), ""));
            zzE12.zzZ(new zzIB());
            zzDD2.zzZ(zzE12);
            shape.zzMg(75);
            shape.zzX(zzDD2);
        } else {
            shape = new Shape((DocumentBase)this.zzZrw, 75);
        }
        shape.zzS(this.zz5K());
        shape.getImageData().setImageBytes(imageBytes);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        shape.zzC(width, height);
        return shape;
    }

    private Shape zzO(BufferedImage bufferedImage) throws Exception {
        byte[] byArray;
        zz7X zz7X2 = new zz7X();
        try {
            zzYD.zzZ(bufferedImage, zz7X2);
            byArray = zzZ.zzZ(zz7X2);
        }
        finally {
            zz7X2.close();
        }
        return this.zzZs(byArray);
    }

    private Shape zzZs(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzZrw, 1);
        shape.zzMg(75);
        shape.zzS(this.zz5K());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzC(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, BufferedImage presentation) throws Exception {
        BufferedImage bufferedImage = presentation;
        boolean bl = asIcon;
        String string = progId;
        zz7X zz7X2 = zz7V.zzY(stream);
        DocumentBuilder documentBuilder = this;
        zzZ93 zzZ932 = zzZ93.zzLt(string);
        Shape shape = bufferedImage != null ? documentBuilder.zzO(bufferedImage) : documentBuilder.zzZs(zzZ8Z.zzZ(zzZ932, bl));
        shape.zzMg(-2);
        shape.getOleFormat().setProgId(zzZ932.zzYu4);
        shape.getOleFormat().zzY(zzZ8Z.zzZ(zz7X2, string, bl));
        return shape;
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, BufferedImage presentation) throws Exception {
        zzZ93 zzZ932 = zzZ93.zzLs(zz7W.zzXI(fileName));
        return this.zzZ(fileName, isLinked, asIcon, presentation, zzZ932);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, BufferedImage presentation) throws Exception {
        zzZ93 zzZ932 = zzZ93.zzLt(progId);
        return this.zzZ(fileName, isLinked, asIcon, presentation, zzZ932);
    }

    private Shape zzZ(String string, boolean bl, boolean bl2, BufferedImage bufferedImage, zzZ93 zzZ932) throws Exception {
        Shape shape = bufferedImage != null ? this.zzO(bufferedImage) : this.zzZs(zzZ8Z.zzZ(zzZ932, bl2));
        shape.zzMg(-2);
        shape.getOleFormat().setProgId(zzZ932.zzYu4);
        shape.getOleFormat().zzY(zzZ8Z.zzZ(string, bl, bl2, zzZ932));
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    final Shape zzZ(zzZUM zzZUM2, BufferedImage bufferedImage) throws Exception {
        Shape shape = this.zzO(bufferedImage);
        shape.zzMg(201);
        shape.getOleFormat().zzY(zzZUM2.zzZQG());
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.zzZ(html, null);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        zzZV7 zzZV72 = new zzZV7();
        zzZV72.zzWG(useBuilderFormatting);
        zzZV72.zzWF(useBuilderFormatting);
        this.zzZ(html, zzZV72);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzZS1 zzZS12 = new zzZS1();
        return zzZS12.zzZ(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzYSQ(this).zzZ(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzYSQ(this).zzZ(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzZrw, 75);
        shape.zzS(this.zz5K());
        boolean bl = true;
        Shape shape2 = shape;
        if (!shape2.isSignatureLine()) {
            shape2.setShapeAttr(1983, true);
            shape2.setShapeAttr(1922, zz84.zzeb.toString("B").toUpperCase());
        }
        shape.getSignatureLine().zzZ(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzC(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    private void zzZ(String string, zzZV7 zzZV72) throws Exception {
        Object object;
        Object object2 = this;
        boolean bl = false;
        if (((DocumentBuilder)object2).zz5B().getParentNode().getNodeType() == 28) {
            object = (StructuredDocumentTag)((DocumentBuilder)object2).zz5B().getParentNode();
            switch (((StructuredDocumentTag)object).getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        if (bl) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(string);
            this.write(DocumentBuilder.zzSJ(documentBuilder.getDocument().toString(70)));
            return;
        }
        object = this;
        zzZV7 zzZV73 = zzZV72;
        object2 = string;
        zzZWP zzZWP2 = new zzZWP((String)object2, zzZV73, (DocumentBuilder)object);
        zzZWP2.read();
    }

    private static String zzSJ(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        if (this.zz5E() == null) {
            this.startTable();
        }
        if (this.zz5E().zzZfk() == 1) {
            this.zz5E().zzZfn();
        }
        if (this.zz5E().zzZfk() == 3) {
            this.zz5E().zzZfl();
        }
        return this.zz5E().zzZfm();
    }

    public Table startTable() {
        this.zzZpV.push(new zzYVK(this));
        return this.zz5E().startTable();
    }

    public Table endTable() {
        if (this.zz5E() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zz5E().endTable();
        this.zzZpV.pop();
        return table;
    }

    public Row endRow() {
        if (this.zz5E() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zz5E().endRow();
        if (this.zzZpZ != null && this.zzZpZ.getHidden()) {
            row.zz5A().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzZrw, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzZrw, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzZrw);
        this.zzZpT = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzZpT == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzZrw, this.zzZpT);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzZrw, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return new zz9B(this).zzZ(srcDoc, importFormatMode, 93);
    }

    public Document getDocument() {
        return this.zzZrw;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzZrw) {
            return;
        }
        this.zzZrw = value;
        this.zzd(null);
        this.zzZq0 = new zzZ19();
        this.zzZpY = null;
        this.zzZpZ = null;
        this.zzZpV = new zz95();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzZpZ == null) {
            this.zzZpZ = new Font(this, this.getDocument());
        }
        return this.zzZpZ;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        return this.getCurrentParagraph().getParagraphFormat();
    }

    public ListFormat getListFormat() {
        return this.getCurrentParagraph().getListFormat();
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzZpW == null) {
            this.zzZpW = new RowFormat(this);
        }
        return this.zzZpW;
    }

    public CellFormat getCellFormat() {
        if (this.zzZXM == null) {
            this.zzZXM = new CellFormat(this);
        }
        return this.zzZXM;
    }

    public void pushFont() {
        this.zz5C().push(this.zz5K());
    }

    public void popFont() {
        zz95 zz952 = this.zz5C();
        if (zz952.size() > 0) {
            this.zzZ((zzZ19)this.zz5C().pop(), false);
        }
    }

    private zz3J zzZ(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzNI(88);
        zz3E zz3E2 = new zz3E();
        zz3E2.setTarget(string2);
        zz3E2.setScreenTip(string3);
        if (bl) {
            zz3E2.setSubAddress(string);
        } else {
            zz3E2.setAddress(zzAY.zzYr(string));
            zz3E2.setSubAddress(zzAY.zzYq(string));
        }
        this.zzSH(zz3E2.toString());
        FieldSeparator fieldSeparator = this.zzNH(88);
        return new zz3J(fieldStart, fieldSeparator, null);
    }

    final zz3J zzS(String string, String string2, String string3) {
        boolean bl = zzAY.zzYi(string);
        String string4 = bl ? zzAY.zzYq(string) : string;
        return this.zzZ(string4, bl, string2, string3);
    }

    final FieldEnd zz5L() {
        return this.zzo(88, true);
    }

    final zzZ19 zz5K() {
        return (zzZ19)this.zzZq0.zzzt();
    }

    final zzZ86 zz5J() {
        return (zzZ86)this.getCurrentParagraph().zzZT1().zzzt();
    }

    final zzYV9 zz5I() {
        return (zzYV9)this.zz5A().zzzt();
    }

    final zzYH zz5H() {
        return (zzYH)this.zzxf().zzzt();
    }

    public boolean isAtStartOfParagraph() {
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zz5B(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zz5B().getNodeType() == 8;
    }

    private void zzI(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        String string2 = zzYQ7.zzIa(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    this.zzSG(string2.substring(n, n + n2));
                }
                switch (this.zzZpU) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzSI(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                this.zzSG(string2.substring(n, n + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    private Run zzSI(String string) {
        Run run = new Run(this.zzZrw, string, this.zz5K());
        this.insertNode(run);
        return run;
    }

    public void insertNode(Node node) {
        if (this.zz5E() != null && this.zz5E().zzZfk() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        this.zz5B().getParentNode().insertBefore(node, this.zz5B());
    }

    final void zzNK(int n) {
        this.zzXz(true);
        this.zzNJ(n);
    }

    private void zzNJ(int n) {
        this.insertParagraph();
        zzYW5 zzYW52 = new zzYW5(this.getDocument());
        try {
            zzZ02 zzZ022 = (zzZ02)this.getCurrentSection().zzZzb().zzzt();
            Section section = new Section(this.zzZrw, zzZ022);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzZrw));
            this.zzZrw.insertAfter(section, this.getCurrentSection());
            section.getBody().zzY(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzYW52.dispose();
        }
    }

    final FieldStart zzNI(int n) {
        return zzX.zzZ(n, this.zz5K(), this.zz5B(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final Run zzSH(String string) {
        return zzX.zzY(string, this.zz5K(), this.zz5B(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final FieldEnd zzo(int n, boolean bl) {
        return zzX.zzY(n, bl, this.zz5K(), this.zz5B(), this.getCurrentParagraph(), null, true);
    }

    final FieldSeparator zzNH(int n) {
        return zzX.zzY(n, this.zz5K(), this.zz5B(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    private FormField zze(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzZrw, new zzZZV(), this.zz5K());
        this.getCurrentParagraph().insertBefore(formField, node);
        return formField;
    }

    private boolean zzXz(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentParagraph().getParentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zz5E() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzZ6(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Parameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Parameter name: rowIndex");
        }
        return row;
    }

    private void zzSG(String string) {
        boolean bl;
        block4: {
            String string2 = string;
            DocumentBuilder documentBuilder = this;
            boolean bl2 = documentBuilder.getFont().getBidi();
            for (int i = 0; i < string2.length(); ++i) {
                boolean bl3;
                char c = string2.charAt(i);
                int n = zzAZ.zzy(c);
                boolean bl4 = n == 0;
                boolean bl5 = bl3 = n == 3 || n == 4;
                if ((!bl2 || !bl4) && (bl2 || !bl3)) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        if (bl) {
            zzYQ zzYQ10 = new zzYQ(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzYP zzYP2 : zzYQ10.zzI(this.getParagraphFormat().getBidi())) {
                zz7 zz710 = zz7.zzZo(zzYP2.zzYc());
                zzZ19 zzZ192 = this.zz5K();
                zzZ192.zzU(265, zz710);
                if (zzYP2.zzY9()) {
                    zzZ192.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzZrw, zzYP2.getText(), zzZ192);
                this.insertNode(run);
            }
            return;
        }
        this.zzSI(string);
    }

    final void zzZ(zzZ19 zzZ192, boolean bl) {
        this.zzZq0 = bl ? (zzZ19)zzZ192.zzzt() : zzZ192;
    }

    final void zz5G() {
        this.zzZq0.clear();
    }

    final void zz5F() {
        if (this.zz5D() != null) {
            zzYH zzYH2 = this.zz5D().zzxf();
            zzYH zzYH3 = this.zzZXN = (zzYH)zzYH2.zzzt();
            zzYH zzYH4 = zzYH2;
            Iterator iterator = zzYH.zzZXv.zzE4().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                if (zzYH4.contains(n)) {
                    Border border = new Border();
                    border.zzU((Border)zzYH4.get(n));
                    zzYH3.set(n, border);
                    continue;
                }
                zzYH3.remove(n);
            }
        }
    }

    final void zzNG(int n) {
        this.zzZpU = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph()) {
            return null;
        }
        return this.zz5B();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zz5B();
        }
        return (Paragraph)this.zz5B().getAncestor(8);
    }

    public Story getCurrentStory() {
        return this.getCurrentParagraph().getParentStory();
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzYVK zz5E() {
        zz95 zz952 = this.zzZpV;
        if (zz952.size() > 0) {
            return zzZ.zzZ(this.zzZpV.peek(), zzYVK.class);
        }
        return null;
    }

    private Cell zz5D() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzZYH();
    }

    private zz95 zz5C() {
        if (this.zzZpY == null) {
            this.zzZpY = new zz95();
        }
        return this.zzZpY;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzZq0.zzTU(fontAttr);
    }

    @ReservedForInternalUse
    @Deprecated
    public int getDirectRunAttrsCount() {
        return this.zzZq0.getCount();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzZA(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzZA(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzZq0.zzU(fontAttr, value);
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzZuq()) {
            this.getCurrentParagraph().zzZuz().zzU(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzZq0.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzZq0.clear();
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzZuq()) {
            this.getCurrentParagraph().zzZuz().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zz5A().zzTU(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zz5A().zzTT(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zz5A().zzTS(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zz5A().zzU(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zz5A().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zz5A().clear();
        zzYV9.zzZee().zzY(this.zz5A());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzxf().zzTU(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzxf().fetchCellAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzxf().zzTS(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzZ.zzZ(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zz5D() != null ? this.zz5D().getCellFormat() : this.getCellFormat();
            border.zzZ(cellFormat);
        }
        this.zzxf().zzU(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzxf().clear();
    }

    private Node zz5B() {
        Node node = this.zzZq2 != null && this.zzZq2.getParentNode() == null ? this.zzZq1 : this.zzZq2;
        if (node != null && node.zzZCy() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        return node;
    }

    private void zzd(Node node) {
        this.zzZq2 = node;
        if (this.zzZq2 != null) {
            this.zzZq1 = this.zzZq2.getParentNode();
        }
    }

    private zzYV9 zz5A() {
        if (this.zz5E() != null && this.zz5E().zzZfk() == 1) {
            return this.zzZpX;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zz5A();
        }
        return this.zzZpX;
    }

    private zzYH zzxf() {
        if (this.zz5E() != null && this.zz5E().zzZfk() != 3) {
            return this.zzZXN;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzZYH().zzxf();
        }
        return this.zzZXN;
    }
}

