/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz7V;
import asposewobfuscated.zz7Y;
import asposewobfuscated.zzCS;
import asposewobfuscated.zzD8;
import asposewobfuscated.zzRY;
import asposewobfuscated.zzW;
import asposewobfuscated.zzZ;
import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.zz19;
import java.io.EOFException;
import java.io.InputStream;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static zzD8 zzZac = new zzD8();
    private static zzD8 zzZab = new zzD8();
    private static zzD8 zzZaa = new zzD8();
    private static zzD8 zzZa9 = new zzD8();
    private static zzD8 zzZa8 = new zzD8();
    private static zzD8 zzZa7 = new zzD8();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzZ.zzZ(fileName, "fileName");
        zz7Y zz7Y2 = zzZ.zzT(fileName);
        try {
            FileFormatInfo fileFormatInfo = FileFormatUtil.zz5(zz7Y2);
            return fileFormatInfo;
        }
        finally {
            ((zz7V)zz7Y2).close();
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zz5(zzW.zzZ(stream));
    }

    static FileFormatInfo zz5(zz7V zz7V2) throws Exception {
        if (zz7V2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zz19 zz192 = new zz19();
            zz7V zz7V3 = zz7V2;
            zz19 zz193 = zz192;
            return zz192.zzY(zz7V3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzZ(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzKY(zzRY.zzk(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzL3(zzRY.zzk(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string = zzRY.zzXV(FileFormatUtil.zzL0(loadFormat));
        if (zzCS.zzYK(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzKY(FileFormatUtil.zzKZ(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzL3(FileFormatUtil.zzL0(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzRY.zzXV(FileFormatUtil.zzKZ(saveFormat));
        if (zzCS.zzYK(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzL3(zzRY.zzj(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        int n = imageType;
        Object object = zzZaa.get(n);
        return "." + zzRY.zzXV(object == null ? 0 : (Integer)object);
    }

    static Exception zzZ(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzL4(int n) {
        return zzRY.toString(FileFormatUtil.zzKZ(n));
    }

    static int zzL3(int n) {
        Object object = zzZa8.get(n);
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    static int zzL2(int n) {
        Object object = zzZa7.get(n);
        if (object != null) {
            return (Integer)object;
        }
        return 1;
    }

    static boolean zzL1(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzL0(int n) {
        Object object = zzZac.get(n);
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    static int zzKZ(int n) {
        Object object = zzZab.get(n);
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    private static int zzKY(int n) {
        Object object = zzZa9.get(n);
        if (object == null) {
            return 255;
        }
        return (Integer)object;
    }

    static {
        Object[] objectArray = new Object[]{11, 10, 10, null, 11, null, 0, null, 12, 11, 11, null, 13, 20, 20, null, 13, null, 254, null, 14, 21, 21, null, 15, 22, 22, null, 16, 23, 23, null, 18, 24, 24, null, 19, 25, 25, null, 20, 26, 26, null, 21, 27, 27, null, 24, 30, 30, null, 17, 31, 31, null, 25, 50, 50, null, 26, 45, null, null, 27, 51, 51, null, 28, null, 52, null, 22, 60, 60, null, 23, 61, 61, null, 31, 40, null, null, 38, 47, null, null, 39, 48, null, null, 32, 41, null, null, 33, 46, null, null, 35, 42, null, null, 34, 44, null, null, 29, 52, null, null, 30, 70, 62, null, 36, 71, null, null, 8, 100, null, null, 9, 105, null, null, 6, 101, null, 6, 7, 102, null, 7, 5, 104, null, 5, 4, null, null, 4, 3, null, null, 3, 37, 72, null, null, 2, 103, null, 2};
        for (int i = 0; i < 156; i += 4) {
            Object object = objectArray[i];
            Object object2 = objectArray[i + 1];
            Object object3 = objectArray[i + 2];
            Object object4 = objectArray[i + 3];
            if (object2 != null) {
                zzZa8.add((Integer)object, object2);
                zzZab.add((Integer)object2, object);
            }
            if (object3 != null) {
                if (!zzZa9.contains((Integer)object)) {
                    zzZa9.add((Integer)object, object3);
                }
                zzZac.add((Integer)object3, object);
            }
            if (object4 == null) continue;
            zzZa7.add((Integer)object, object4);
            zzZaa.add((Integer)object4, object);
        }
    }
}

