/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz2Q;
import asposewobfuscated.zz3F;
import asposewobfuscated.zz93;
import asposewobfuscated.zzCS;
import asposewobfuscated.zzR4;
import asposewobfuscated.zzZ;
import com.aspose.words.BookmarkStart;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.DropDownItemCollection;
import com.aspose.words.Field;
import com.aspose.words.FieldChar;
import com.aspose.words.FieldOptions;
import com.aspose.words.FieldStart;
import com.aspose.words.Node;
import com.aspose.words.SpecialChar;
import com.aspose.words.zzYQ7;
import com.aspose.words.zzZ19;
import com.aspose.words.zzZFW;
import com.aspose.words.zzZPL;
import com.aspose.words.zzZZV;

public class FormField
extends SpecialChar {
    private zzZZV zzZ7H;
    private Field zzZ7G;
    static String zzZ7F = zz3F.zzV('\u2002', 5);
    private static final zz2Q zzVU = new zz2Q("uppercase", "lowercase", "first capital", "title case");

    FormField(DocumentBase doc, zzZZV formFieldPr, zzZ19 runPr) {
        super(doc, '\u0001', runPr);
        this.zzZ7H = formFieldPr;
    }

    @Override
    final Node zzZ(boolean bl, zzZPL zzZPL2) {
        FormField formField = (FormField)super.zzZ(bl, zzZPL2);
        ((FormField)super.zzZ(bl, zzZPL2)).zzZ7H = (zzZZV)this.zzZ7H.zzzt();
        formField.zzZ7G = null;
        return formField;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return FormField.visitorActionToBool(visitor.visitFormField(this));
    }

    public void removeField() throws Exception {
        if (this.getField() == null) {
            return;
        }
        BookmarkStart bookmarkStart = zzZ.zzZ((Object)this.getField().getStart().getNextSibling(), BookmarkStart.class);
        if (bookmarkStart != null) {
            bookmarkStart.remove();
            this.getField().getStart().zzZCH().insertBefore(bookmarkStart, this.getField().getStart());
        }
        this.getField().remove();
    }

    public void setTextInputValue(Object newValue) throws Exception {
        if (newValue == null) {
            throw new NullPointerException("newValue");
        }
        if (this.getType() != 70) {
            throw new IllegalStateException("The form field is not a text form field.");
        }
        switch (this.getTextInputType()) {
            case 0: {
                int n;
                String string = this.getTextInputFormat();
                string = string.toLowerCase();
                switch (zzVU.zzWW(string)) {
                    case 0: {
                        n = 1;
                        break;
                    }
                    case 1: {
                        n = 2;
                        break;
                    }
                    case 2: {
                        n = 4;
                        break;
                    }
                    case 3: {
                        n = 3;
                        break;
                    }
                    default: {
                        n = 0;
                    }
                }
                int n2 = n;
                this.setResult(zzCS.zzH((String)newValue, n2));
                return;
            }
            case 1: {
                double d;
                FieldOptions fieldOptions = this.zzZCG().getFieldOptions();
                Object object = newValue;
                if (object == null) {
                    d = 0.0;
                } else if (object instanceof Byte) {
                    d = ((Byte)object).byteValue();
                } else if (object instanceof Short) {
                    d = ((Short)object).shortValue();
                } else if (object instanceof Integer) {
                    d = ((Integer)object).intValue();
                } else if (object instanceof Long) {
                    d = ((Long)object).longValue();
                } else if (object instanceof Float) {
                    d = ((Float)object).floatValue();
                } else if (object instanceof Double) {
                    d = (Double)object;
                } else {
                    throw new ClassCastException("Cannot convert a value to double.");
                }
                this.setResult(zzR4.zzZ(d, this.getTextInputFormat(), true, fieldOptions.getLegacyNumberFormat(), fieldOptions.getUseInvariantCultureNumberFormat()));
                return;
            }
            case 2: {
                this.setResult(zzYQ7.zzY((zz93)newValue, this.getTextInputFormat()));
                return;
            }
            case 3: 
            case 4: 
            case 5: {
                throw new IllegalStateException("Cannot set the form field value because it is calculated.");
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    @Override
    public int getNodeType() {
        return 25;
    }

    public String getName() {
        return this.zzZ7H.getName();
    }

    public void setName(String value) throws Exception {
        zzZ.zzZ((Object)value, "value");
        BookmarkStart bookmarkStart = this.getBookmarkStart();
        if (bookmarkStart != null) {
            bookmarkStart.getBookmark().setName(value);
        }
        this.zzZ7H.setName(value);
    }

    public int getType() {
        if (this.getField() != null) {
            return this.getField().getType();
        }
        return 0;
    }

    final int zzZUh() {
        switch (this.getType()) {
            case 70: {
                return 0;
            }
            case 71: {
                return 1;
            }
            case 83: {
                return 2;
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    /*
     * Enabled aggressive block sorting
     */
    final Field getField() {
        if (this.zzZ7G == null) {
            FieldChar fieldChar;
            FieldChar fieldChar2;
            block7: {
                FormField formField = this;
                int n = 0;
                Node node = formField.getPreviousSibling();
                while (node != null) {
                    switch (node.getNodeType()) {
                        case 22: {
                            if (n-- != 0) break;
                            fieldChar2 = (FieldStart)node;
                            break block7;
                        }
                        case 24: {
                            ++n;
                        }
                    }
                    node = node.getPreviousSibling();
                }
                fieldChar2 = fieldChar = null;
            }
            if (fieldChar2 != null) {
                this.zzZ7G = fieldChar.getField();
            }
        }
        return this.zzZ7G;
    }

    public String getResult() {
        switch (this.getType()) {
            case 70: {
                if (this.getField() == null) {
                    return "";
                }
                String string = this.getField().getResult();
                if (zz3F.equals(string, zzZ7F)) {
                    return "";
                }
                return string;
            }
            case 71: {
                if (this.getChecked()) {
                    return "1";
                }
                return "0";
            }
            case 83: {
                return this.zzZUg();
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    public void setResult(String value) throws Exception {
        zzZ.zzZ((Object)value, "value");
        switch (this.getType()) {
            case 70: {
                this.getField().setResult(value);
                return;
            }
            case 71: {
                this.setChecked(zzR4.parseInt(value) != 0);
                return;
            }
            case 83: {
                this.zzQJ(value);
                return;
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    public String getStatusText() {
        return this.zzZ7H.getStatusText();
    }

    public void setStatusText(String value) {
        this.zzZ7H.setStatusText(value);
    }

    public boolean getOwnStatus() {
        return this.zzZ7H.zzZUc();
    }

    public void setOwnStatus(boolean value) {
        this.zzZ7H.zzWP(value);
    }

    public String getHelpText() {
        return this.zzZ7H.getHelpText();
    }

    public void setHelpText(String value) {
        this.zzZ7H.setHelpText(value);
    }

    public boolean getOwnHelp() {
        return this.zzZ7H.zzZUd();
    }

    public void setOwnHelp(boolean value) {
        this.zzZ7H.zzWQ(value);
    }

    public boolean getCalculateOnExit() {
        return this.zzZ7H.zzZUe();
    }

    public void setCalculateOnExit(boolean value) {
        this.zzZ7H.zzWR(value);
    }

    public String getEntryMacro() {
        return this.zzZ7H.getEntryMacro();
    }

    public void setEntryMacro(String value) {
        this.zzZ7H.setEntryMacro(value);
    }

    public String getExitMacro() {
        return this.zzZ7H.getExitMacro();
    }

    public void setExitMacro(String value) {
        this.zzZ7H.setExitMacro(value);
    }

    public boolean getEnabled() {
        return this.zzZ7H.getEnabled();
    }

    public void setEnabled(boolean value) {
        this.zzZ7H.setEnabled(value);
    }

    public String getTextInputFormat() {
        return this.zzZ7H.getTextInputFormat();
    }

    public void setTextInputFormat(String value) {
        this.zzZ7H.setTextInputFormat(value);
    }

    public int getTextInputType() {
        return this.zzZ7H.getTextInputType();
    }

    public void setTextInputType(int value) {
        this.zzZ7H.setTextInputType(value);
    }

    public String getTextInputDefault() {
        return this.zzZ7H.getTextInputDefault();
    }

    public void setTextInputDefault(String value) throws Exception {
        this.zzZ7H.setTextInputDefault(value);
        if (this.getTextInputType() == 5) {
            Node node = this.getField().getStart().zzFX(21);
            zzZFW.zzZ(node, false, this, false);
            DocumentBuilder documentBuilder = new DocumentBuilder(this.zzZCG());
            documentBuilder.moveTo(this);
            documentBuilder.insertField(value, "");
            this.getField().update();
        }
    }

    public int getMaxLength() {
        return this.zzZ7H.zzZUb();
    }

    public void setMaxLength(int value) {
        this.zzZ7H.zzKk(value);
    }

    public DropDownItemCollection getDropDownItems() {
        return this.zzZ7H.getDropDownItems();
    }

    public int getDropDownSelectedIndex() {
        zzZZV zzZZV2 = this.zzZ7H;
        if (zzZZV2.contains(21070)) {
            return this.zzZ7H.zzZU5();
        }
        return this.zzZ7H.zzZU6();
    }

    public void setDropDownSelectedIndex(int value) {
        this.zzZ7H.zzKh(value);
    }

    final String zzZUg() {
        int n = this.getDropDownSelectedIndex();
        if (n < 0 || n >= this.getDropDownItems().getCount()) {
            return "";
        }
        return this.getDropDownItems().get(n);
    }

    final void zzQJ(String string) {
        for (int i = 0; i < this.getDropDownItems().getCount(); ++i) {
            if (!zzCS.equalsIgnoreCase(this.getDropDownItems().get(i), string)) continue;
            this.setDropDownSelectedIndex(i);
            return;
        }
    }

    public boolean getChecked() {
        zzZZV zzZZV2 = this.zzZ7H;
        if (zzZZV2.contains(21010)) {
            return this.zzZ7H.zzZU7();
        }
        return this.zzZ7H.zzZU8();
    }

    public void setChecked(boolean value) {
        this.zzZ7H.zzWM(value);
    }

    public boolean getDefault() {
        return this.zzZ7H.zzZU8();
    }

    public void setDefault(boolean value) {
        this.zzZ7H.zzWN(value);
    }

    public boolean isCheckBoxExactSize() {
        return !this.zzZ7H.zzZUa();
    }

    public void isCheckBoxExactSize(boolean value) {
        this.zzZ7H.zzWO(!value);
    }

    public double getCheckBoxSize() {
        int n = this.zzZ7H.zzZU9();
        return (double)n / 2.0;
    }

    public void setCheckBoxSize(double value) {
        this.zzZ7H.zzKj(zzZ.zzU(value));
    }

    final BookmarkStart getBookmarkStart() {
        if (this.getField() == null) {
            return null;
        }
        BookmarkStart bookmarkStart = zzZ.zzZ((Object)this.getField().getStart().getNextSibling(), BookmarkStart.class);
        if (bookmarkStart == null) {
            bookmarkStart = zzZ.zzZ((Object)this.getField().getStart().getPreviousSibling(), BookmarkStart.class);
        }
        return bookmarkStart;
    }

    final zzZZV zzZUf() {
        return this.zzZ7H;
    }
}

