/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz7W;
import asposewobfuscated.zzRY;
import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IWarningCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;

public abstract class SaveOptions {
    private boolean zzYcq = false;
    private boolean zzYcp = true;
    private boolean zzFQ;
    private String zzYco;
    private boolean zzYcn;
    private boolean zzYcm = false;
    private boolean zzYcl = true;
    private int zzYck = 1;
    private int zzYXD = 0;
    private IWarningCallback zz1R;
    private int zzEP = 0;
    private String zzYcj = "";
    private boolean zzYci = true;
    private boolean zzYch = true;
    private boolean zzYcg;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzZQ9() {
        return false;
    }

    boolean zzZVz() {
        return true;
    }

    final boolean zzZno() {
        return this.zzYcp;
    }

    public String getTempFolder() {
        return this.zzYco;
    }

    public void setTempFolder(String value) {
        this.zzYco = value;
    }

    public boolean getPrettyFormat() {
        return this.zzFQ;
    }

    public void setPrettyFormat(boolean value) {
        this.zzFQ = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzYcn;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzYcn = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzYcm;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzYcm = value;
    }

    public boolean getUpdateSdtContent() {
        return this.zzYcl;
    }

    public void setUpdateSdtContent(boolean value) {
        this.zzYcl = value;
    }

    public int getColorMode() {
        return this.zzEP;
    }

    public void setColorMode(int value) {
        this.zzEP = value;
    }

    public int getDmlRenderingMode() {
        return this.zzYck;
    }

    public void setDmlRenderingMode(int value) {
        this.zzYck = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzYXD;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzYXD = value;
    }

    public String getDefaultTemplate() {
        return this.zzYcj;
    }

    public void setDefaultTemplate(String value) {
        this.zzYcj = value;
    }

    public boolean getUpdateFields() {
        return this.zzYci;
    }

    public void setUpdateFields(boolean value) {
        this.zzYci = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzYcg;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzYcg = value;
    }

    @Deprecated
    public IWarningCallback getWarningCallback() {
        return this.zz1R;
    }

    @Deprecated
    public void setWarningCallback(IWarningCallback value) {
        this.zz1R = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzYcq;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzYcq = value;
    }

    final boolean zzZnn() {
        return this.zzYch;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzL3(zzRY.zzj(zz7W.zzXI(fileName))));
    }
}

