/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataTable;
import java.util.ArrayList;
import java.util.Iterator;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzXSb = new ArrayList();
    private DataTable zzYLY;

    DataColumnCollection(DataTable table) {
        this.zzYLY = table;
    }

    public void add(DataColumn column) {
        column.zzZ(this.zzYLY);
        column.setOrdinal(this.zzXSb.size());
        this.zzXSb.add(column);
        this.zzYLY.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        DataColumn dataColumn = new DataColumn(columnName, this.zzYLY);
        this.add(dataColumn);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzYLY);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        for (int i = 0; i < this.zzXSb.size(); ++i) {
            if (!this.zzXSb.get(i).getColumnName().equalsIgnoreCase(columnName)) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzXSb.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            this.zzYLY.onDataColumnDeleted(this.zzXSb.get(n));
            this.zzXSb.remove(n);
        }
    }

    public int getCount() {
        return this.zzXSb.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzXSb.iterator();
    }

    public void clear() {
        this.zzXSb.clear();
    }

    final DataColumn[] zzZay() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>();
        Iterator<DataColumn> iterator = this.zzXSb.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }
}

