/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.net.System.Data.Constraint;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.ForeignKeyConstraint;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;

public class DataRelation {
    private String zzXSa;
    private DataTable zzXS9;
    private DataTable zzXS8;
    private String zzat;
    private String zzas;
    private String[] zzXS7;
    private String[] zzXS6;
    private DataColumn[] zzXS5;
    private DataColumn[] zzXS4;
    private UniqueConstraint zzXS3;
    private ForeignKeyConstraint zzXS2;
    private boolean zzXS1 = true;

    public DataRelation(String relationName, DataTable parentTable, DataTable childTable, String[] parentColumnNames, String[] childColumnNames) {
        int n;
        if (parentColumnNames == null || parentColumnNames.length == 0) {
            throw new IllegalStateException("Parent column names need to have at least one column name.");
        }
        if (childColumnNames == null || childColumnNames.length == 0) {
            throw new IllegalStateException("Child column names need to have at least one column name.");
        }
        if (parentColumnNames.length != childColumnNames.length) {
            throw new IllegalStateException("The number of parent columns must be the same as the number of child columns.");
        }
        this.zzXSa = relationName;
        this.zzXS9 = parentTable;
        this.zzXS8 = childTable;
        this.zzat = parentTable.getTableName();
        this.zzas = childTable.getTableName();
        this.zzXS7 = parentColumnNames;
        this.zzXS6 = childColumnNames;
        this.zzXS5 = new DataColumn[this.zzXS7.length];
        for (n = 0; n < this.zzXS7.length; ++n) {
            this.zzXS5[n] = new DataColumn(this.zzXS7[n], this.zzXS9);
        }
        this.zzXS4 = new DataColumn[this.zzXS6.length];
        for (n = 0; n < this.zzXS6.length; ++n) {
            this.zzXS4[n] = new DataColumn(this.zzXS6[n], this.zzXS8);
        }
    }

    public DataRelation(String relationName, DataColumn[] parentColumns, DataColumn[] childColumns, boolean createConstraints) {
        int n;
        DataColumn dataColumn;
        int n2;
        String string = this.zzXSa = relationName == null ? "" : relationName;
        if (parentColumns == null) {
            throw new IllegalArgumentException("parentColumns");
        }
        this.zzXS5 = parentColumns;
        if (childColumns == null) {
            throw new IllegalArgumentException("childColumns");
        }
        this.zzXS4 = childColumns;
        this.zzXS1 = createConstraints;
        if (parentColumns.length != childColumns.length) {
            throw new IllegalArgumentException("ParentColumns and ChildColumns should be the same length");
        }
        DataTable dataTable = parentColumns[0].getTable();
        DataTable dataTable2 = childColumns[0].getTable();
        if (dataTable.getDataSet() != dataTable2.getDataSet()) {
            throw new IllegalStateException();
        }
        DataColumn[] dataColumnArray = parentColumns;
        int n3 = parentColumns.length;
        for (n2 = 0; n2 < n3; ++n2) {
            dataColumn = dataColumnArray[n2];
            if (dataColumn.getTable() == dataTable) continue;
            throw new IllegalStateException();
        }
        dataColumnArray = childColumns;
        n3 = childColumns.length;
        for (n2 = 0; n2 < n3; ++n2) {
            dataColumn = dataColumnArray[n2];
            if (dataColumn.getTable() == dataTable2) continue;
            throw new IllegalStateException();
        }
        for (n = 0; n < this.zzXS4.length; ++n) {
            DataColumn dataColumn2 = childColumns[n];
            DataColumn dataColumn3 = parentColumns[n];
            if (dataColumn3.getDataType() == dataColumn2.getDataType()) continue;
            throw new IllegalStateException("Parent Columns and Child Columns don't have matching column types");
        }
        this.zzXS7 = new String[this.zzXS5.length];
        for (n = 0; n < this.zzXS5.length; ++n) {
            this.zzXS7[n] = this.zzXS5[n].getColumnName();
        }
        this.zzXS6 = new String[this.zzXS4.length];
        for (n = 0; n < this.zzXS4.length; ++n) {
            this.zzXS6[n] = this.zzXS4[n].getColumnName();
        }
    }

    public DataRelation(String relationName, DataColumn parentColumn, DataColumn childColumn, boolean createConstraint) {
        this(relationName, new DataColumn[]{parentColumn}, new DataColumn[]{childColumn}, createConstraint);
    }

    public DataRelation(String relationName, DataColumn parentColumn, DataColumn childColumn) {
        this(relationName, new DataColumn[]{parentColumn}, new DataColumn[]{childColumn}, true);
    }

    public String getRelationName() {
        return this.zzXSa;
    }

    public String getParentTableName() {
        DataTable dataTable = this.getParentTable();
        if (dataTable != null) {
            return dataTable.getTableName();
        }
        return null;
    }

    public String getChildTableName() {
        DataTable dataTable = this.getChildTable();
        if (dataTable != null) {
            return dataTable.getTableName();
        }
        return null;
    }

    public DataTable getParentTable() {
        if (this.zzXS9 != null) {
            return this.zzXS9;
        }
        return this.zzXS5[0].getTable();
    }

    public DataTable getChildTable() {
        if (this.zzXS8 != null) {
            return this.zzXS8;
        }
        return this.zzXS4[0].getTable();
    }

    public String[] getParentColumnNames() {
        return this.zzXS7;
    }

    public String[] getChildColumnNames() {
        return this.zzXS6;
    }

    public DataColumn[] getParentColumns() {
        return this.zzXS5;
    }

    public DataColumn[] getChildColumns() {
        return this.zzXS4;
    }

    public void setNested(boolean nested) {
    }

    public UniqueConstraint getParentKeyConstraint() {
        return this.zzXS3;
    }

    public void setParentKeyConstraint(UniqueConstraint parentKeyConstraint) {
        this.zzXS3 = parentKeyConstraint;
    }

    public ForeignKeyConstraint getChildKeyConstraint() {
        return this.zzXS2;
    }

    public void setChildKeyConstraint(ForeignKeyConstraint childKeyConstraint) {
        this.zzXS2 = childKeyConstraint;
    }

    public int hashCode() {
        int n = 31 + this.zzXSa.hashCode();
        n = n * 31 + this.zzat.hashCode();
        n = n * 31 + this.zzas.hashCode();
        for (int i = 0; i < this.zzXS7.length; ++i) {
            n = n * 31 + this.zzXS7[i].hashCode();
            n = n * 31 + this.zzXS6[i].hashCode();
        }
        return n;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataRelation)) {
            return false;
        }
        DataRelation dataRelation = (DataRelation)obj;
        boolean bl = this.getRelationName().equals(dataRelation.getRelationName()) && this.getParentTableName().equals(dataRelation.getParentTableName()) && this.getChildTableName().equals(dataRelation.getChildTableName());
        if (!bl) {
            return false;
        }
        if (this.getParentColumnNames().length != dataRelation.getParentColumnNames().length || this.getChildColumnNames().length != dataRelation.getChildColumnNames().length) {
            return false;
        }
        for (int i = 0; i < this.getParentColumnNames().length; ++i) {
            if (this.getParentColumnNames()[i].equals(dataRelation.getParentColumnNames()[i]) && this.getChildColumnNames()[i].equals(dataRelation.getChildColumnNames()[i])) continue;
            return false;
        }
        return true;
    }

    final void zzZax() throws InvalidConstraintException, DataException {
        UniqueConstraint uniqueConstraint;
        Constraint constraint;
        ForeignKeyConstraint foreignKeyConstraint;
        block6: {
            ForeignKeyConstraint foreignKeyConstraint2;
            Constraint constraint2;
            DataRelation dataRelation;
            ConstraintCollection constraintCollection;
            block5: {
                if (!this.zzXS1) {
                    return;
                }
                constraintCollection = this.getChildTable().getConstraints();
                dataRelation = this;
                for (Constraint constraint3 : constraintCollection) {
                    if (!(constraint3 instanceof ForeignKeyConstraint)) continue;
                    constraint2 = (ForeignKeyConstraint)constraint3;
                    if (!DataRelation.zzZ(dataRelation.getChildColumns(), ((ForeignKeyConstraint)constraint2).getColumns()) || !DataRelation.zzZ(dataRelation.getParentColumns(), ((ForeignKeyConstraint)constraint2).getRelatedColumns())) continue;
                    foreignKeyConstraint2 = constraint2;
                    break block5;
                }
                foreignKeyConstraint2 = null;
            }
            foreignKeyConstraint = foreignKeyConstraint2;
            constraintCollection = this.getParentTable().getConstraints();
            dataRelation = this;
            for (Constraint constraint3 : constraintCollection) {
                if (!(constraint3 instanceof UniqueConstraint)) continue;
                constraint2 = (UniqueConstraint)constraint3;
                if (!DataRelation.zzZ(dataRelation.getParentColumns(), ((UniqueConstraint)constraint2).getColumns())) continue;
                constraint = constraint2;
                break block6;
            }
            constraint = uniqueConstraint = null;
        }
        if (constraint == null) {
            uniqueConstraint = new UniqueConstraint(this.getParentColumns(), false);
            this.getParentTable().getConstraints().add(uniqueConstraint);
        }
        if (foreignKeyConstraint == null) {
            foreignKeyConstraint = new ForeignKeyConstraint(this.getRelationName(), this.getParentColumns(), this.getChildColumns());
            this.getChildTable().getConstraints().add(foreignKeyConstraint);
        }
        this.setParentKeyConstraint(uniqueConstraint);
        this.setChildKeyConstraint(foreignKeyConstraint);
    }

    private static boolean zzZ(DataColumn[] dataColumnArray, DataColumn[] dataColumnArray2) {
        if (dataColumnArray.length != dataColumnArray2.length) {
            return false;
        }
        for (int i = 0; i < dataColumnArray.length; ++i) {
            DataColumn dataColumn = dataColumnArray[i];
            DataColumn dataColumn2 = dataColumnArray2[i];
            if (dataColumn.getColumnName().equals(dataColumn2.getColumnName()) && dataColumn.getDataType() == dataColumn2.getDataType() && dataColumn.getTable().getTableName().equals(dataColumn2.getTable().getTableName())) continue;
            return false;
        }
        return true;
    }
}

