/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import asposewobfuscated.zz3F;
import asposewobfuscated.zz93;
import asposewobfuscated.zzW;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.zzY;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DataRow {
    private final DataTable zzYLY;
    private Object[] zzYLU;
    private int zzXS0 = 1;
    private int zzXRZ;
    private String zzXRY;
    private Map<String, Object> zzXRX = new HashMap<String, Object>();
    private Map<String, String> zzXRW = new HashMap<String, String>();

    protected DataRow(DataTable table) {
        this.zzYLY = table;
        this.zzYLU = new Object[table.getColumns().getCount()];
    }

    public boolean readFrom(ResultSet resultSet) throws SQLException {
        Object[] objectArray = zzY.zzY(resultSet, this.getTable());
        if (objectArray != null) {
            int n = this.getTable().getColumns().getCount();
            for (int i = 0; i < n; ++i) {
                this.set(i, objectArray[i]);
            }
            return true;
        }
        return false;
    }

    public Object get(int index) {
        return this.getValue(index);
    }

    public Object get(String columnName) {
        return this.getValue(this.zzYLY.getColumns().indexOf(columnName));
    }

    public Object get(DataColumn column) {
        return this.getValue(this.zzYLY.getColumns().indexOf(column));
    }

    public DataTable getTable() {
        return this.zzYLY;
    }

    public DataRow[] getChildRows(DataRelation relation) {
        if (this.zzYLY.getDataSet() == null) {
            return new DataRow[0];
        }
        if (!relation.getParentTable().getTableName().equalsIgnoreCase(this.zzYLY.getTableName())) {
            return new DataRow[0];
        }
        String[] stringArray = relation.getParentColumnNames();
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = this.get(stringArray[i]);
        }
        String[] stringArray2 = relation.getChildColumnNames();
        DataTable dataTable = this.zzYLY.getDataSet().getTables().get(relation.getChildTable().getTableName());
        ArrayList<DataRow> arrayList = new ArrayList<DataRow>();
        for (int i = 0; i < dataTable.getRows().getCount(); ++i) {
            DataRow dataRow = dataTable.getRows().get(i);
            for (int j = 0; j < stringArray2.length; ++j) {
                Object object = objectArray[j];
                Object object2 = dataRow.get(stringArray2[j]);
                if (object == null || !object.equals(object2)) continue;
                arrayList.add(dataRow);
            }
        }
        DataRow[] dataRowArray = new DataRow[arrayList.size()];
        return arrayList.toArray(dataRowArray);
    }

    public DataRow getParentRow(DataRelation relation) {
        if (this.zzYLY.getDataSet() == null) {
            return null;
        }
        String[] stringArray = relation.getParentColumnNames();
        String[] stringArray2 = relation.getChildColumnNames();
        if (stringArray.length == 0 || stringArray2.length == 0) {
            return null;
        }
        String string = stringArray[0];
        String string2 = stringArray2[0];
        Object object = this.get(string2);
        for (DataRow dataRow : relation.getParentTable().getRows()) {
            Object object2 = dataRow.get(string);
            if (object == null && object2 == null) {
                return dataRow;
            }
            if (!object.equals(object2)) continue;
            return dataRow;
        }
        return null;
    }

    public DataRow[] getParentRows(DataRelation relation) {
        if (this.zzYLY.getDataSet() == null) {
            return new DataRow[0];
        }
        String[] stringArray = relation.getParentColumnNames();
        String[] stringArray2 = relation.getChildColumnNames();
        if (stringArray.length == 0 || stringArray2.length == 0) {
            return new DataRow[0];
        }
        ArrayList<DataRow> arrayList = new ArrayList<DataRow>();
        for (DataRow dataRow : relation.getParentTable().getRows()) {
            arrayList.add(dataRow);
        }
        DataRow[] dataRowArray = new DataRow[arrayList.size()];
        return arrayList.toArray(dataRowArray);
    }

    public void set(int columnIndex, Object value) {
        this.zzv(columnIndex, value);
        this.zzYLY.onDataRowChanged(this);
    }

    public void set(String columnName, Object value) {
        this.set(this.zzYLY.getColumns().indexOf(columnName), value);
    }

    public int getRowState() {
        return this.zzXS0;
    }

    public void setRowState(int state) {
        this.zzXS0 = state;
    }

    public void delete() {
        zzY.zzY(this.getTable(), this);
    }

    public void setOriginalValue(String columnName, Object data) {
        this.zzXRX.put(columnName, data);
    }

    public Object getOriginalValue(String columnName) {
        if (columnName == null) {
            return null;
        }
        return this.zzXRX.get(columnName);
    }

    public Object[] getItemArray() {
        Object[] objectArray = new Object[this.zzYLU.length];
        System.arraycopy(this.zzYLU, 0, objectArray, 0, this.zzYLU.length);
        return objectArray;
    }

    public void setItemArray(Object[] array) {
        if (array == null) {
            return;
        }
        if (array.length != this.zzYLU.length) {
            throw new IllegalArgumentException("The array must have the same size (" + this.zzYLU.length + ") and ordering as the column collection.");
        }
        for (int i = 0; i < array.length; ++i) {
            this.zzv(i, array[i]);
        }
        this.zzYLY.onDataRowChanged(this);
    }

    final int zzZaw() {
        return this.zzXRZ;
    }

    final void zzZd(String string, String string2) {
        this.zzXRW.put(string, string2);
    }

    final void zzZc(String string, String string2) {
        this.zzXRY = zz3F.format(string, string2);
    }

    final String zzZav() {
        return this.zzXRY;
    }

    final void zzxK(int n) {
        this.zzXRZ = n;
    }

    final Object[] zzZau() {
        return this.zzYLU;
    }

    static boolean zzZ(DataColumn[] dataColumnArray) {
        int n;
        for (n = 0; n < dataColumnArray.length; ++n) {
            DataColumn dataColumn = dataColumnArray[n];
            if (dataColumn != null) continue;
            return true;
        }
        return n == dataColumnArray.length;
    }

    private Object getValue(int index) {
        if (!this.zzxJ(index)) {
            return null;
        }
        return this.zzYLU[index];
    }

    private void zzv(int n, Object object) {
        if (!this.zzxJ(n)) {
            return;
        }
        Class clazz = this.getTable().getColumns().get(n).getDataType();
        Object object2 = object == null ? (clazz == String.class ? "" : null) : (object instanceof Clob ? DataRow.zzZ((Clob)object) : (object instanceof Blob ? (Object)DataRow.zzZ((Blob)object) : (clazz.isAssignableFrom(object.getClass()) ? object : DataRow.zzY(clazz, object))));
        this.zzYLU[n] = object2;
    }

    private static Object zzY(Class clazz, Object object) {
        String string = object.toString().trim();
        if (clazz == String.class) {
            return string;
        }
        try {
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                return (byte)Integer.parseInt(string);
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                return (short)Integer.parseInt(string);
            }
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return (int)Long.parseLong(string);
            }
            if (clazz == Long.TYPE || clazz == Long.class) {
                return Long.parseLong(string);
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                return Float.valueOf(Float.parseFloat(string));
            }
            if (clazz == Double.TYPE || clazz == Double.class) {
                return Double.parseDouble(string);
            }
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                return Boolean.parseBoolean(string);
            }
            if (clazz == Character.TYPE || clazz == Character.class) {
                return Character.valueOf(string.charAt(0));
            }
            if (clazz == Date.class || clazz == zz93.class) {
                return new Date(zz93.zzY0(string).zzDQ().zzDS());
            }
        }
        catch (Exception exception) {}
        return object;
    }

    private boolean zzxJ(int n) {
        int n2;
        DataRow dataRow = this;
        if (dataRow.zzYLY != null && dataRow.zzYLY.getColumns() != null && dataRow.zzYLU != null && dataRow.zzYLU.length != (n2 = dataRow.zzYLY.getColumns().getCount())) {
            Object[] objectArray = new Object[dataRow.zzYLU.length];
            System.arraycopy(dataRow.zzYLU, 0, objectArray, 0, dataRow.zzYLU.length);
            dataRow.zzYLU = new Object[n2];
            System.arraycopy(objectArray, 0, dataRow.zzYLU, 0, Math.min(objectArray.length, dataRow.zzYLU.length));
        }
        return this.zzYLU != null && n >= 0 && n < this.zzYLU.length;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] zzZ(Blob blob) {
        byte[] byArray = null;
        InputStream inputStream = null;
        try {
            if (blob == null) return null;
            if (blob.length() == 0L) {
                return null;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            inputStream = blob.getBinaryStream();
            zzW.copyStream(inputStream, byteArrayOutputStream);
            byArray = byteArrayOutputStream.toByteArray();
            if (inputStream == null) return byArray;
        }
        catch (Exception exception) {
            if (inputStream == null) return byArray;
            try {
                inputStream.close();
                return byArray;
            }
            catch (IOException iOException) {
                return byArray;
            }
        }
        catch (Throwable throwable) {
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            return byArray;
        }
    }

    private static String zzZ(Clob clob) {
        StringBuilder stringBuilder;
        block6: {
            stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = null;
            try {
                int n;
                if (clob == null || clob.length() == 0L) {
                    return stringBuilder.toString();
                }
                bufferedReader = new BufferedReader(clob.getCharacterStream());
                char[] cArray = new char[8192];
                while ((n = bufferedReader.read(cArray, 0, 8192)) > 0) {
                    stringBuilder.append(cArray, 0, n);
                }
            }
            catch (Exception exception) {
                if (bufferedReader == null) break block6;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getTable().getTableName());
        stringBuilder.append(": ");
        DataRow dataRow = this;
        Object[] objectArray = dataRow.zzYLU;
        int n = dataRow.zzYLU.length;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            stringBuilder.append(object).append("; ");
        }
        return stringBuilder.toString();
    }
}

