/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import asposewobfuscated.zz3B;
import asposewobfuscated.zz3F;
import asposewobfuscated.zz3O;
import asposewobfuscated.zz44;
import asposewobfuscated.zz4W;
import asposewobfuscated.zz5G;
import asposewobfuscated.zz5I;
import asposewobfuscated.zz5L;
import asposewobfuscated.zz7X;
import asposewobfuscated.zzZZG;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.DataTableCollection;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.XmlReadMode;
import com.aspose.words.net.System.Data.zzS;
import com.aspose.words.net.System.Data.zzY;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class DataSet {
    private boolean zzXRV = true;
    private String zzXRU = "NewDataSet";
    private Locale zzXRT;
    private DataTableCollection zzXRS = new DataTableCollection(this);
    private DataRelationCollection zzXRR = new DataRelationCollection();
    private String zzXRQ;

    public DataSet() {
    }

    public DataSet(Connection connection) throws Exception {
        this(connection, "");
    }

    public DataSet(Connection connection, String schemaName) throws Exception {
        Object object;
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string = connection.getCatalog();
        List<String> list = zzY.zzZ(databaseMetaData, schemaName, string);
        Object list2 = list.iterator();
        while (list2.hasNext()) {
            String object22;
            String string2 = object22 = list2.next();
            String string3 = schemaName;
            object = string3 == null || string3.trim().isEmpty() ? string2 : string3 + "." + string2;
            ResultSet resultSet = connection.createStatement().executeQuery("SELECT * FROM " + (String)object);
            DataTable dataTable = new DataTable(resultSet, object22);
            dataTable.zzT(zzY.zzZ(databaseMetaData, string, schemaName, object22));
            this.getTables().add(dataTable);
            zzY.zzZ(databaseMetaData, string, schemaName, dataTable);
        }
        list2 = zzY.zzZ(databaseMetaData, string, schemaName, this.getTables());
        Iterator<DataRelation> iterator = list2.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.getRelations().add((DataRelation)object);
        }
    }

    public DataSet(String name) {
        this.zzXRU = name;
    }

    public String getDataSetName() {
        return this.zzXRU;
    }

    public void setDataSetName(String newDataSetName) {
        this.zzXRU = newDataSetName;
    }

    public String getNamespace() {
        return null;
    }

    public DataTableCollection getTables() {
        return this.zzXRS;
    }

    public DataRelationCollection getRelations() {
        return this.zzXRR;
    }

    public void close() throws Exception {
        for (DataTable dataTable : this.zzXRS) {
            dataTable.close();
        }
    }

    public void clear() {
        for (DataTable dataTable : this.getTables()) {
            dataTable.getRows().clear();
        }
    }

    public void reset() {
        this.clear();
        Iterator<DataTable> iterator = this.zzXRS.iterator();
        while (iterator.hasNext()) {
            iterator.remove();
        }
        Iterator<DataRelation> iterator2 = this.zzXRR.iterator();
        while (iterator2.hasNext()) {
            iterator2.remove();
        }
    }

    public XmlReadMode readXml(InputStream xmlStream, XmlReadMode mode) throws DataException {
        if (xmlStream == null) {
            return mode;
        }
        boolean bl = false;
        try {
            zzZZG zzZZG2 = DataSet.zzZat();
            XMLStreamReader xMLStreamReader = zzZZG2.createXMLStreamReader(xmlStream);
            zzS zzS10 = null;
            zz5I zz5I2 = null;
            if (xMLStreamReader.hasNext()) {
                switch (xMLStreamReader.next()) {
                    case 1: {
                        if (xMLStreamReader.getLocalName().equals("diffgram") && xMLStreamReader.getNamespaceURI().equals("urn:schemas-microsoft-com:xml-diffgram-v1")) {
                            switch (mode) {
                                case AUTO: 
                                case DIFF_GRAM: {
                                    zzS10 = new zzS(this);
                                    zzS10.zze(xMLStreamReader);
                                    return XmlReadMode.DIFF_GRAM;
                                }
                                case FRAGMENT: {
                                    DataSet.zzg(xMLStreamReader);
                                    break;
                                }
                                default: {
                                    DataSet.zzg(xMLStreamReader);
                                    return mode;
                                }
                            }
                        }
                        if (xMLStreamReader.getLocalName().equals("Schema") && xMLStreamReader.getNamespaceURI().equals("urn:schemas-microsoft-com:xml-data") || xMLStreamReader.getLocalName().equals("schema") && xMLStreamReader.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                            bl = true;
                            switch (mode) {
                                case IGNORE_SCHEMA: 
                                case INFER_SCHEMA: {
                                    DataSet.zzg(xMLStreamReader);
                                    return mode;
                                }
                                case FRAGMENT: {
                                    this.zzf(xMLStreamReader);
                                    break;
                                }
                                case AUTO: {
                                    if (this.getTables().getCount() == 0) {
                                        this.zzf(xMLStreamReader);
                                        return XmlReadMode.READ_SCHEMA;
                                    }
                                    DataSet.zzg(xMLStreamReader);
                                    return XmlReadMode.IGNORE_SCHEMA;
                                }
                                default: {
                                    this.zzf(xMLStreamReader);
                                    return mode;
                                }
                            }
                        }
                        zz5I2 = new zz5I();
                        zz5I2.setName(zz5L.decode(xMLStreamReader.getLocalName()));
                        for (int i = 0; i < xMLStreamReader.getAttributeCount(); ++i) {
                            if (!"".equals(xMLStreamReader.getAttributePrefix(i))) continue;
                            zz5I2.getAttributes().put(xMLStreamReader.getAttributeLocalName(i), xMLStreamReader.getAttributeValue(i));
                        }
                        break;
                    }
                }
            }
            XmlReadMode xmlReadMode = mode;
            while (xMLStreamReader.hasNext()) {
                switch (xMLStreamReader.next()) {
                    case 1: {
                        zzY zzY10;
                        if (xMLStreamReader.getLocalName().equals("Schema") && xMLStreamReader.getNamespaceURI().equals("urn:schemas-microsoft-com:xml-data") || xMLStreamReader.getLocalName().equals("schema") && xMLStreamReader.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                            xMLStreamReader.getLocalName();
                            switch (mode) {
                                case IGNORE_SCHEMA: 
                                case INFER_SCHEMA: {
                                    DataSet.zzg(xMLStreamReader);
                                    break;
                                }
                                default: {
                                    this.zzf(xMLStreamReader);
                                    xmlReadMode = XmlReadMode.READ_SCHEMA;
                                    bl = true;
                                    break;
                                }
                            }
                            break;
                        }
                        if (xMLStreamReader.getLocalName().equals("diffgram") && xMLStreamReader.getNamespaceURI().equals("urn:schemas-microsoft-com:xml-diffgram-v1")) {
                            if (mode == XmlReadMode.DIFF_GRAM || mode == XmlReadMode.IGNORE_SCHEMA || mode == XmlReadMode.AUTO) {
                                if (zzS10 == null) {
                                    zzS10 = new zzS(this);
                                }
                                zzS10.zze(xMLStreamReader);
                                xmlReadMode = XmlReadMode.DIFF_GRAM;
                                if (mode != XmlReadMode.DIFF_GRAM) break;
                                return xmlReadMode;
                            }
                            DataSet.zzg(xMLStreamReader);
                            break;
                        }
                        if (!(bl || xmlReadMode == XmlReadMode.READ_SCHEMA || mode == XmlReadMode.IGNORE_SCHEMA || mode == XmlReadMode.FRAGMENT || this.getTables().getCount() != 0 && mode != XmlReadMode.INFER_SCHEMA)) {
                            if (mode == XmlReadMode.AUTO) {
                                xmlReadMode = XmlReadMode.INFER_SCHEMA;
                            }
                            zzY10 = new zzY(this, xMLStreamReader, zz5I2, true);
                            zzY10.zzZas();
                            return xmlReadMode;
                        }
                        mode = bl ? XmlReadMode.READ_SCHEMA : XmlReadMode.IGNORE_SCHEMA;
                        zzY10 = new zzY(this, xMLStreamReader, zz5I2, false);
                        zzY10.zzZas();
                    }
                }
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DataException(xMLStreamException);
        }
        catch (SQLException sQLException) {
            throw new DataException(sQLException);
        }
        catch (zz4W zz4W2) {
            throw new DataException(zz4W2);
        }
        catch (InvalidConstraintException invalidConstraintException) {
            throw new DataException(invalidConstraintException);
        }
        return XmlReadMode.AUTO;
    }

    public XmlReadMode readXml(InputStream xmlStream) throws DataException {
        return this.readXml(xmlStream, XmlReadMode.AUTO);
    }

    public XmlReadMode readXml(String xmlPath) throws DataException {
        return this.readXml(xmlPath, XmlReadMode.AUTO);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XmlReadMode readXml(String xmlPath, XmlReadMode readMode) throws DataException {
        XmlReadMode xmlReadMode;
        if (xmlPath == null) throw new IllegalArgumentException("xmlPath cannot be empty");
        if (xmlPath.trim().length() == 0) {
            throw new IllegalArgumentException("xmlPath cannot be empty");
        }
        InputStream inputStream = null;
        try {
            this.zzXRQ = xmlPath;
            inputStream = new FileInputStream(xmlPath);
            xmlReadMode = this.readXml(inputStream, readMode);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new DataException(fileNotFoundException);
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            inputStream.close();
            return xmlReadMode;
        }
        catch (Exception exception) {}
        return xmlReadMode;
    }

    @Deprecated
    public XmlReadMode readXml(zz7X stream) {
        return this.readXml(new zz3B(stream));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readXmlSchema(InputStream xmlStream) throws DataException {
        if (xmlStream == null) {
            throw new IllegalArgumentException("xmlStream cannot be null");
        }
        XMLStreamReader xMLStreamReader = null;
        try {
            zzZZG zzZZG2 = DataSet.zzZat();
            xMLStreamReader = zzZZG2.createXMLStreamReader(xmlStream);
            this.zzf(xMLStreamReader);
            if (xMLStreamReader == null) return;
        }
        catch (XMLStreamException xMLStreamException) {
            try {
                throw new DataException(xMLStreamException);
                catch (zz4W zz4W2) {
                    throw new DataException(zz4W2);
                }
                catch (InvalidConstraintException invalidConstraintException) {
                    throw new DataException(invalidConstraintException);
                }
            }
            catch (Throwable throwable) {
                if (xMLStreamReader == null) throw throwable;
                try {
                    xMLStreamReader.close();
                    throw throwable;
                }
                catch (XMLStreamException xMLStreamException2) {
                    throw new DataException(xMLStreamException2);
                }
            }
        }
        try {
            xMLStreamReader.close();
            return;
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DataException(xMLStreamException);
        }
    }

    public void readXmlSchema(String xmlPath) throws DataException {
        if (xmlPath == null || xmlPath.trim().length() == 0) {
            throw new IllegalArgumentException("xmlPath cannot be empty");
        }
        InputStream inputStream = null;
        try {
            this.zzXRQ = xmlPath;
            try {
                inputStream = new FileInputStream(xmlPath);
                this.readXmlSchema(inputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new DataException(fileNotFoundException);
            }
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void setLocale(Locale locale) {
        this.zzXRT = locale;
    }

    public boolean isLocaleSpecified() {
        return this.zzXRT != null;
    }

    public boolean getEnforceConstraints() {
        return this.zzXRV;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzXRV = enforceConstraints;
        for (DataTable dataTable : this.getTables()) {
            dataTable.setEnforceConstraints(enforceConstraints);
        }
    }

    private static void zzg(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        String string = xMLStreamReader.getLocalName();
        while (xMLStreamReader.hasNext()) {
            switch (xMLStreamReader.next()) {
                case 2: {
                    if (!string.equals(xMLStreamReader.getLocalName())) break;
                    return;
                }
            }
        }
    }

    private void zzf(XMLStreamReader xMLStreamReader) throws zz4W, XMLStreamException, DataException, InvalidConstraintException {
        int n = 0;
        boolean bl = false;
        do {
            switch (xMLStreamReader.getEventType()) {
                case 1: {
                    if (bl) {
                        ++n;
                    }
                    if (xMLStreamReader.getLocalName().equals("Schema") && xMLStreamReader.getNamespaceURI().equals("urn:schemas-microsoft-com:xml-data")) {
                        throw new UnsupportedOperationException("readXDSSchema is not implemented yet.");
                    }
                    if (xMLStreamReader.getLocalName().equals("schema") && xMLStreamReader.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                        XMLStreamReader xMLStreamReader2 = xMLStreamReader;
                        DataSet dataSet = this;
                        zz44 zz442 = new zz44();
                        zz5G zz5G2 = zz5G.zzZ(xMLStreamReader2);
                        zz5G2.zzXg(dataSet.zzXRQ);
                        zz442.zzS(zz5G2);
                        zz442.zzAQ();
                        zz3O zz3O2 = new zz3O();
                        zz3O2.zzZ(zz442, dataSet);
                        return;
                    }
                    if (xMLStreamReader.getLocalName().equals("schema") && xMLStreamReader.getNamespaceURI().startsWith("http://www.w3.org/")) {
                        throw new IllegalStateException("DataSetUnsupportedSchema http://www.w3.org/2001/XMLSchema");
                    }
                    bl = false;
                    break;
                }
                case 4: {
                    bl = zz3F.zzX6(xMLStreamReader.getText().trim());
                    break;
                }
                case 2: {
                    if (--n > 0) break;
                    return;
                }
            }
            if (!xMLStreamReader.hasNext()) continue;
            xMLStreamReader.next();
        } while (xMLStreamReader.hasNext());
    }

    private static zzZZG zzZat() {
        zzZZG zzZZG2 = new zzZZG();
        zzZZG2.zzZ7c().zzQQ(false);
        zzZZG2.zzZ7c().zzQV(false);
        zzZZG2.zzZ7c().zzQW(false);
        zzZZG2.zzZ7c().zzQX(true);
        zzZZG2.zzZ7c().zzQY(true);
        zzZZG2.zzZ7c().zzQU(false);
        zzZZG2.zzZ7c().zzQP(false);
        zzZZG2.zzZ7c().zzxA(0x800000);
        return zzZZG2;
    }
}

