/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt.entity.edits;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Edit
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Edit.class);
    @NonNull
    private String model;
    @NonNull
    private String input;
    @NonNull
    private String instruction;
    private double temperature;
    @JsonProperty(value="top_p")
    private Double topP;
    private Integer n;

    public void setModel(Model model) {
        this.model = model.getName();
    }

    public void setTemperature(double temperature) {
        if (temperature > 2.0 || temperature < 0.0) {
            log.error("temperature\u53c2\u6570\u5f02\u5e38\uff0ctemperature\u5c5e\u4e8e[0,2]");
            this.temperature = 2.0;
            return;
        }
        if (temperature < 0.0) {
            log.error("temperature\u53c2\u6570\u5f02\u5e38\uff0ctemperature\u5c5e\u4e8e[0,2]");
            this.temperature = 0.0;
            return;
        }
        this.temperature = temperature;
    }

    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public void setInstruction(String instruction) {
        this.instruction = instruction;
    }

    private static double $default$temperature() {
        return 0.0;
    }

    private static Double $default$topP() {
        return 1.0;
    }

    private static Integer $default$n() {
        return 1;
    }

    public static EditBuilder builder() {
        return new EditBuilder();
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    @NonNull
    public String getInput() {
        return this.input;
    }

    @NonNull
    public String getInstruction() {
        return this.instruction;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Integer getN() {
        return this.n;
    }

    public Edit() {
        this.temperature = Edit.$default$temperature();
        this.topP = Edit.$default$topP();
        this.n = Edit.$default$n();
    }

    public Edit(@NonNull String model, @NonNull String input, @NonNull String instruction, double temperature, Double topP, Integer n) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (instruction == null) {
            throw new NullPointerException("instruction is marked non-null but is null");
        }
        this.model = model;
        this.input = input;
        this.instruction = instruction;
        this.temperature = temperature;
        this.topP = topP;
        this.n = n;
    }

    public static class EditBuilder {
        private String model;
        private String input;
        private String instruction;
        private boolean temperature$set;
        private double temperature$value;
        private boolean topP$set;
        private Double topP$value;
        private boolean n$set;
        private Integer n$value;

        EditBuilder() {
        }

        public EditBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            return this;
        }

        public EditBuilder input(@NonNull String input) {
            if (input == null) {
                throw new NullPointerException("input is marked non-null but is null");
            }
            this.input = input;
            return this;
        }

        public EditBuilder instruction(@NonNull String instruction) {
            if (instruction == null) {
                throw new NullPointerException("instruction is marked non-null but is null");
            }
            this.instruction = instruction;
            return this;
        }

        public EditBuilder temperature(double temperature) {
            this.temperature$value = temperature;
            this.temperature$set = true;
            return this;
        }

        @JsonProperty(value="top_p")
        public EditBuilder topP(Double topP) {
            this.topP$value = topP;
            this.topP$set = true;
            return this;
        }

        public EditBuilder n(Integer n) {
            this.n$value = n;
            this.n$set = true;
            return this;
        }

        public Edit build() {
            double temperature$value = this.temperature$value;
            if (!this.temperature$set) {
                temperature$value = Edit.$default$temperature();
            }
            Double topP$value = this.topP$value;
            if (!this.topP$set) {
                topP$value = Edit.$default$topP();
            }
            Integer n$value = this.n$value;
            if (!this.n$set) {
                n$value = Edit.$default$n();
            }
            return new Edit(this.model, this.input, this.instruction, temperature$value, topP$value, n$value);
        }

        public String toString() {
            return "Edit.EditBuilder(model=" + this.model + ", input=" + this.input + ", instruction=" + this.instruction + ", temperature$value=" + this.temperature$value + ", topP$value=" + this.topP$value + ", n$value=" + this.n$value + ")";
        }
    }

    public static enum Model {
        TEXT_DAVINCI_EDIT_001("text-davinci-edit-001"),
        CODE_DAVINCI_EDIT_001("code-davinci-edit-001");

        private String name;

        public String getName() {
            return this.name;
        }

        private Model(String name) {
            this.name = name;
        }
    }
}

