/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.ContentType;
import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.unfbx.chatgpt.OpenAiApi;
import com.unfbx.chatgpt.entity.billing.BillingUsage;
import com.unfbx.chatgpt.entity.billing.CreditGrantsResponse;
import com.unfbx.chatgpt.entity.billing.Subscription;
import com.unfbx.chatgpt.entity.chat.ChatCompletion;
import com.unfbx.chatgpt.entity.chat.Message;
import com.unfbx.chatgpt.entity.common.OpenAiResponse;
import com.unfbx.chatgpt.entity.completions.Completion;
import com.unfbx.chatgpt.exception.BaseException;
import com.unfbx.chatgpt.exception.CommonError;
import com.unfbx.chatgpt.function.KeyRandomStrategy;
import com.unfbx.chatgpt.function.KeyStrategyFunction;
import com.unfbx.chatgpt.interceptor.DefaultOpenAiAuthInterceptor;
import com.unfbx.chatgpt.interceptor.OpenAiAuthInterceptor;
import io.reactivex.Single;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class OpenAiStreamClient {
    private static final Logger log = LoggerFactory.getLogger(OpenAiStreamClient.class);
    @NotNull
    private List<String> apiKey;
    private String apiHost;
    private OkHttpClient okHttpClient;
    private KeyStrategyFunction<List<String>, String> keyStrategy;
    private OpenAiApi openAiApi;
    private OpenAiAuthInterceptor authInterceptor;

    private OpenAiStreamClient(Builder builder) {
        if (CollectionUtil.isEmpty((Collection)builder.apiKey)) {
            throw new BaseException(CommonError.API_KEYS_NOT_NUL);
        }
        this.apiKey = builder.apiKey;
        if (StrUtil.isBlank((CharSequence)builder.apiHost)) {
            builder.apiHost = "https://api.openai.com/";
        }
        this.apiHost = builder.apiHost;
        if (Objects.isNull(builder.keyStrategy)) {
            builder.keyStrategy = new KeyRandomStrategy();
        }
        this.keyStrategy = builder.keyStrategy;
        if (Objects.isNull(builder.authInterceptor)) {
            builder.authInterceptor = new DefaultOpenAiAuthInterceptor();
        }
        this.authInterceptor = builder.authInterceptor;
        this.authInterceptor.setApiKey(this.apiKey);
        this.authInterceptor.setKeyStrategy(this.keyStrategy);
        if (Objects.isNull(builder.okHttpClient)) {
            builder.okHttpClient = this.okHttpClient();
        } else {
            builder.okHttpClient = builder.okHttpClient.newBuilder().addInterceptor((Interceptor)this.authInterceptor).build();
        }
        this.okHttpClient = builder.okHttpClient;
        this.openAiApi = (OpenAiApi)new Retrofit.Builder().baseUrl(this.apiHost).client(this.okHttpClient).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build().create(OpenAiApi.class);
    }

    private OkHttpClient okHttpClient() {
        if (Objects.isNull(this.authInterceptor)) {
            this.authInterceptor = new DefaultOpenAiAuthInterceptor();
        }
        this.authInterceptor.setApiKey(this.apiKey);
        this.authInterceptor.setKeyStrategy(this.keyStrategy);
        return new OkHttpClient.Builder().addInterceptor((Interceptor)this.authInterceptor).connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(50L, TimeUnit.SECONDS).readTimeout(50L, TimeUnit.SECONDS).build();
    }

    public void streamCompletions(Completion completion, EventSourceListener eventSourceListener) {
        if (Objects.isNull(eventSourceListener)) {
            log.error("\u53c2\u6570\u5f02\u5e38\uff1aEventSourceListener\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u53ef\u4ee5\u53c2\u8003\uff1acom.unfbx.chatgpt.sse.ConsoleEventSourceListener");
            throw new BaseException(CommonError.PARAM_ERROR);
        }
        if (StrUtil.isBlank((CharSequence)completion.getPrompt())) {
            log.error("\u53c2\u6570\u5f02\u5e38\uff1aPrompt\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BaseException(CommonError.PARAM_ERROR);
        }
        if (!completion.isStream()) {
            completion.setStream(true);
        }
        try {
            EventSource.Factory factory = EventSources.createFactory((OkHttpClient)this.okHttpClient);
            ObjectMapper mapper = new ObjectMapper();
            String requestBody = mapper.writeValueAsString((Object)completion);
            Request request = new Request.Builder().url(this.apiHost + "v1/completions").post(RequestBody.create((MediaType)MediaType.parse((String)ContentType.JSON.getValue()), (String)requestBody)).build();
            EventSource eventSource = factory.newEventSource(request, eventSourceListener);
        }
        catch (JsonProcessingException e) {
            log.error("\u8bf7\u6c42\u53c2\u6570\u89e3\u6790\u5f02\u5e38\uff1a{}", (Throwable)e);
            e.printStackTrace();
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u53c2\u6570\u89e3\u6790\u5f02\u5e38\uff1a{}", (Throwable)e);
            e.printStackTrace();
        }
    }

    public void streamCompletions(String question, EventSourceListener eventSourceListener) {
        Completion q = Completion.builder().prompt(question).stream(true).build();
        this.streamCompletions(q, eventSourceListener);
    }

    public void streamChatCompletion(ChatCompletion chatCompletion, EventSourceListener eventSourceListener) {
        if (Objects.isNull(eventSourceListener)) {
            log.error("\u53c2\u6570\u5f02\u5e38\uff1aEventSourceListener\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u53ef\u4ee5\u53c2\u8003\uff1acom.unfbx.chatgpt.sse.ConsoleEventSourceListener");
            throw new BaseException(CommonError.PARAM_ERROR);
        }
        if (!chatCompletion.isStream()) {
            chatCompletion.setStream(true);
        }
        try {
            EventSource.Factory factory = EventSources.createFactory((OkHttpClient)this.okHttpClient);
            ObjectMapper mapper = new ObjectMapper();
            String requestBody = mapper.writeValueAsString((Object)chatCompletion);
            Request request = new Request.Builder().url(this.apiHost + "v1/chat/completions").post(RequestBody.create((MediaType)MediaType.parse((String)ContentType.JSON.getValue()), (String)requestBody)).build();
            EventSource eventSource = factory.newEventSource(request, eventSourceListener);
        }
        catch (JsonProcessingException e) {
            log.error("\u8bf7\u6c42\u53c2\u6570\u89e3\u6790\u5f02\u5e38\uff1a{}", (Throwable)e);
            e.printStackTrace();
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u53c2\u6570\u89e3\u6790\u5f02\u5e38\uff1a{}", (Throwable)e);
            e.printStackTrace();
        }
    }

    public void streamChatCompletion(List<Message> messages, EventSourceListener eventSourceListener) {
        ChatCompletion chatCompletion = ChatCompletion.builder().messages(messages).stream(true).build();
        this.streamChatCompletion(chatCompletion, eventSourceListener);
    }

    @Deprecated
    public CreditGrantsResponse creditGrants() {
        Request request = new Request.Builder().url(this.apiHost + "dashboard/billing/credit_grants").get().build();
        Response response = this.okHttpClient.newCall(request).execute();
        ResponseBody body = response.body();
        String bodyStr = body.string();
        if (!response.isSuccessful()) {
            if (response.code() == CommonError.OPENAI_AUTHENTICATION_ERROR.code() || response.code() == CommonError.OPENAI_LIMIT_ERROR.code() || response.code() == CommonError.OPENAI_SERVER_ERROR.code()) {
                OpenAiResponse openAiResponse = (OpenAiResponse)JSONUtil.toBean((String)bodyStr, OpenAiResponse.class);
                log.error(openAiResponse.getError().getMessage());
                throw new BaseException(openAiResponse.getError().getMessage());
            }
            log.error("\u8be2\u4f59\u989d\u8bf7\u6c42\u5f02\u5e38\uff1a{}", (Object)bodyStr);
            OpenAiResponse openAiResponse = (OpenAiResponse)JSONUtil.toBean((String)bodyStr, OpenAiResponse.class);
            if (Objects.nonNull(openAiResponse.getError())) {
                log.error(openAiResponse.getError().getMessage());
                throw new BaseException(openAiResponse.getError().getMessage());
            }
            throw new BaseException(CommonError.RETRY_ERROR);
        }
        ObjectMapper mapper = new ObjectMapper();
        return (CreditGrantsResponse)mapper.readValue(bodyStr, CreditGrantsResponse.class);
    }

    public Subscription subscription() {
        Single<Subscription> subscription = this.openAiApi.subscription();
        return (Subscription)subscription.blockingGet();
    }

    public BillingUsage billingUsage(@NotNull LocalDate starDate, @NotNull LocalDate endDate) {
        if (starDate == null) {
            OpenAiStreamClient.$$$reportNull$$$0(0);
        }
        if (endDate == null) {
            OpenAiStreamClient.$$$reportNull$$$0(1);
        }
        Single<BillingUsage> billingUsage = this.openAiApi.billingUsage(starDate, endDate);
        return (BillingUsage)billingUsage.blockingGet();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public List<String> getApiKey() {
        List<String> list = this.apiKey;
        if (list == null) {
            OpenAiStreamClient.$$$reportNull$$$0(2);
        }
        return list;
    }

    public String getApiHost() {
        return this.apiHost;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public KeyStrategyFunction<List<String>, String> getKeyStrategy() {
        return this.keyStrategy;
    }

    public OpenAiApi getOpenAiApi() {
        return this.openAiApi;
    }

    public OpenAiAuthInterceptor getAuthInterceptor() {
        return this.authInterceptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "starDate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endDate";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/unfbx/chatgpt/OpenAiStreamClient";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/unfbx/chatgpt/OpenAiStreamClient";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getApiKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "billingUsage";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Builder {
        @NotNull
        private List<String> apiKey;
        private String apiHost;
        private OkHttpClient okHttpClient;
        private KeyStrategyFunction keyStrategy;
        private OpenAiAuthInterceptor authInterceptor;

        public Builder apiKey(@NotNull List<String> val) {
            if (val == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.apiKey = val;
            return this;
        }

        public Builder apiHost(String val) {
            this.apiHost = val;
            return this;
        }

        public Builder keyStrategy(KeyStrategyFunction val) {
            this.keyStrategy = val;
            return this;
        }

        public Builder okHttpClient(OkHttpClient val) {
            this.okHttpClient = val;
            return this;
        }

        public Builder authInterceptor(OpenAiAuthInterceptor val) {
            this.authInterceptor = val;
            return this;
        }

        public OpenAiStreamClient build() {
            return new OpenAiStreamClient(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "val", "com/unfbx/chatgpt/OpenAiStreamClient$Builder", "apiKey"));
        }
    }
}

