/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt.entity.images;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.unfbx.chatgpt.entity.images.ResponseFormat;
import com.unfbx.chatgpt.entity.images.SizeEnum;
import com.unfbx.chatgpt.exception.BaseException;
import com.unfbx.chatgpt.exception.CommonError;
import java.io.Serializable;
import java.util.Objects;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Image
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Image.class);
    @NonNull
    private String prompt;
    private Integer n;
    private String size;
    @JsonProperty(value="response_format")
    private String responseFormat;
    private String user;

    public void setN(Integer n) {
        if (n < 1) {
            log.warn("n\u6700\u5c0f\u503c1");
            this.n = 1;
            return;
        }
        if (n > 10) {
            log.warn("n\u6700\u5927\u503c10");
            this.n = 10;
            return;
        }
        this.n = n;
    }

    public void setPrompt(String prompt) {
        if (Objects.isNull(prompt) || "".equals(prompt)) {
            log.error("\u53c2\u6570\u5f02\u5e38");
            throw new BaseException(CommonError.PARAM_ERROR);
        }
        if (prompt.length() > 1000) {
            log.error("\u957f\u5ea6\u8d85\u8fc71000");
            throw new BaseException(CommonError.PARAM_ERROR);
        }
        this.prompt = prompt;
    }

    public void setSize(SizeEnum size) {
        if (Objects.isNull(size)) {
            size = SizeEnum.size_512;
        }
        this.size = size.getName();
    }

    public void setResponseFormat(ResponseFormat responseFormat) {
        if (Objects.isNull(responseFormat)) {
            responseFormat = ResponseFormat.URL;
        }
        this.responseFormat = responseFormat.getName();
    }

    public void setUser(String user) {
        this.user = user;
    }

    private static Integer $default$n() {
        return 1;
    }

    private static String $default$size() {
        return SizeEnum.size_512.getName();
    }

    private static String $default$responseFormat() {
        return ResponseFormat.URL.getName();
    }

    public static ImageBuilder builder() {
        return new ImageBuilder();
    }

    @NonNull
    public String getPrompt() {
        return this.prompt;
    }

    public Integer getN() {
        return this.n;
    }

    public String getSize() {
        return this.size;
    }

    public String getResponseFormat() {
        return this.responseFormat;
    }

    public String getUser() {
        return this.user;
    }

    public Image() {
        this.n = Image.$default$n();
        this.size = Image.$default$size();
        this.responseFormat = Image.$default$responseFormat();
    }

    public Image(@NonNull String prompt, Integer n, String size, String responseFormat, String user) {
        if (prompt == null) {
            throw new NullPointerException("prompt is marked non-null but is null");
        }
        this.prompt = prompt;
        this.n = n;
        this.size = size;
        this.responseFormat = responseFormat;
        this.user = user;
    }

    public static class ImageBuilder {
        private String prompt;
        private boolean n$set;
        private Integer n$value;
        private boolean size$set;
        private String size$value;
        private boolean responseFormat$set;
        private String responseFormat$value;
        private String user;

        ImageBuilder() {
        }

        public ImageBuilder prompt(@NonNull String prompt) {
            if (prompt == null) {
                throw new NullPointerException("prompt is marked non-null but is null");
            }
            this.prompt = prompt;
            return this;
        }

        public ImageBuilder n(Integer n) {
            this.n$value = n;
            this.n$set = true;
            return this;
        }

        public ImageBuilder size(String size) {
            this.size$value = size;
            this.size$set = true;
            return this;
        }

        @JsonProperty(value="response_format")
        public ImageBuilder responseFormat(String responseFormat) {
            this.responseFormat$value = responseFormat;
            this.responseFormat$set = true;
            return this;
        }

        public ImageBuilder user(String user) {
            this.user = user;
            return this;
        }

        public Image build() {
            Integer n$value = this.n$value;
            if (!this.n$set) {
                n$value = Image.$default$n();
            }
            String size$value = this.size$value;
            if (!this.size$set) {
                size$value = Image.$default$size();
            }
            String responseFormat$value = this.responseFormat$value;
            if (!this.responseFormat$set) {
                responseFormat$value = Image.$default$responseFormat();
            }
            return new Image(this.prompt, n$value, size$value, responseFormat$value, this.user);
        }

        public String toString() {
            return "Image.ImageBuilder(prompt=" + this.prompt + ", n$value=" + this.n$value + ", size$value=" + this.size$value + ", responseFormat$value=" + this.responseFormat$value + ", user=" + this.user + ")";
        }
    }
}

