/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt.utils;

import cn.hutool.core.util.StrUtil;
import com.knuddels.jtokkit.Encodings;
import com.knuddels.jtokkit.api.Encoding;
import com.knuddels.jtokkit.api.EncodingRegistry;
import com.knuddels.jtokkit.api.EncodingType;
import com.knuddels.jtokkit.api.ModelType;
import com.unfbx.chatgpt.entity.chat.ChatCompletion;
import com.unfbx.chatgpt.entity.chat.FunctionCall;
import com.unfbx.chatgpt.entity.chat.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TikTokensUtil {
    private static final Logger log = LoggerFactory.getLogger(TikTokensUtil.class);
    private static final Map<String, Encoding> modelMap = new HashMap<String, Encoding>();
    private static final EncodingRegistry registry = Encodings.newDefaultEncodingRegistry();

    public static List<Integer> encode(@NotNull Encoding enc, String text) {
        if (enc == null) {
            TikTokensUtil.$$$reportNull$$$0(0);
        }
        return StrUtil.isBlank((CharSequence)text) ? new ArrayList() : enc.encode(text);
    }

    public static int tokens(@NotNull Encoding enc, String text) {
        if (enc == null) {
            TikTokensUtil.$$$reportNull$$$0(1);
        }
        return TikTokensUtil.encode(enc, text).size();
    }

    public static String decode(@NotNull Encoding enc, @NotNull List<Integer> encoded) {
        if (enc == null) {
            TikTokensUtil.$$$reportNull$$$0(2);
        }
        if (encoded == null) {
            TikTokensUtil.$$$reportNull$$$0(3);
        }
        return enc.decode(encoded);
    }

    public static Encoding getEncoding(@NotNull EncodingType encodingType) {
        if (encodingType == null) {
            TikTokensUtil.$$$reportNull$$$0(4);
        }
        return registry.getEncoding(encodingType);
    }

    public static List<Integer> encode(@NotNull EncodingType encodingType, String text) {
        if (encodingType == null) {
            TikTokensUtil.$$$reportNull$$$0(5);
        }
        if (StrUtil.isBlank((CharSequence)text)) {
            return new ArrayList<Integer>();
        }
        Encoding enc = TikTokensUtil.getEncoding(encodingType);
        return enc.encode(text);
    }

    public static int tokens(@NotNull EncodingType encodingType, String text) {
        if (encodingType == null) {
            TikTokensUtil.$$$reportNull$$$0(6);
        }
        return TikTokensUtil.encode(encodingType, text).size();
    }

    public static String decode(@NotNull EncodingType encodingType, @NotNull List<Integer> encoded) {
        if (encodingType == null) {
            TikTokensUtil.$$$reportNull$$$0(7);
        }
        if (encoded == null) {
            TikTokensUtil.$$$reportNull$$$0(8);
        }
        Encoding enc = TikTokensUtil.getEncoding(encodingType);
        return enc.decode(encoded);
    }

    public static Encoding getEncoding(@NotNull String modelName) {
        if (modelName == null) {
            TikTokensUtil.$$$reportNull$$$0(9);
        }
        return modelMap.get(modelName);
    }

    public static List<Integer> encode(@NotNull String modelName, String text) {
        if (modelName == null) {
            TikTokensUtil.$$$reportNull$$$0(10);
        }
        if (StrUtil.isBlank((CharSequence)text)) {
            return new ArrayList<Integer>();
        }
        Encoding enc = TikTokensUtil.getEncoding(modelName);
        if (Objects.isNull(enc)) {
            log.warn("[{}]\u6a21\u578b\u4e0d\u5b58\u5728\u6216\u8005\u6682\u4e0d\u652f\u6301\u8ba1\u7b97tokens\uff0c\u76f4\u63a5\u8fd4\u56detokens==0");
            return new ArrayList<Integer>();
        }
        return enc.encode(text);
    }

    public static int tokens(@NotNull String modelName, String text) {
        if (modelName == null) {
            TikTokensUtil.$$$reportNull$$$0(11);
        }
        return TikTokensUtil.encode(modelName, text).size();
    }

    public static int tokens(@NotNull String modelName, @NotNull List<Message> messages) {
        if (modelName == null) {
            TikTokensUtil.$$$reportNull$$$0(12);
        }
        if (messages == null) {
            TikTokensUtil.$$$reportNull$$$0(13);
        }
        Encoding encoding = TikTokensUtil.getEncoding(modelName);
        int tokensPerMessage = 0;
        int tokensPerName = 0;
        if (modelName.equals(ChatCompletion.Model.GPT_3_5_TURBO_0613.getName()) || modelName.equals(ChatCompletion.Model.GPT_3_5_TURBO_16K_0613.getName()) || modelName.equals(ChatCompletion.Model.GPT_4_0314.getName()) || modelName.equals(ChatCompletion.Model.GPT_4_32K_0314.getName()) || modelName.equals(ChatCompletion.Model.GPT_4_0613.getName()) || modelName.equals(ChatCompletion.Model.GPT_4_32K_0613.getName())) {
            tokensPerMessage = 3;
            tokensPerName = 1;
        } else if (modelName.equals(ChatCompletion.Model.GPT_3_5_TURBO_0301.getName())) {
            tokensPerMessage = 4;
            tokensPerName = -1;
        } else if (modelName.contains(ChatCompletion.Model.GPT_3_5_TURBO.getName())) {
            log.warn("Warning: gpt-3.5-turbo may update over time. Returning num tokens assuming gpt-3.5-turbo-0613.");
            tokensPerMessage = 3;
            tokensPerName = 1;
        } else if (modelName.contains(ChatCompletion.Model.GPT_4.getName())) {
            log.warn("Warning: gpt-4 may update over time. Returning num tokens assuming gpt-4-0613.");
            tokensPerMessage = 3;
            tokensPerName = 1;
        } else {
            log.warn("\u4e0d\u652f\u6301\u7684model {}. See https://github.com/openai/openai-python/blob/main/chatml.md \u66f4\u591a\u4fe1\u606f.", (Object)modelName);
        }
        int sum = 0;
        for (Message msg : messages) {
            sum += tokensPerMessage;
            sum += TikTokensUtil.tokens(encoding, msg.getContent());
            sum += TikTokensUtil.tokens(encoding, msg.getRole());
            sum += TikTokensUtil.tokens(encoding, msg.getName());
            FunctionCall functionCall = msg.getFunctionCall();
            sum += Objects.isNull(functionCall) ? 0 : TikTokensUtil.tokens(encoding, functionCall.toString());
            if (!StrUtil.isNotBlank((CharSequence)msg.getName())) continue;
            sum += tokensPerName;
        }
        return sum += 3;
    }

    public static String decode(@NotNull String modelName, @NotNull List<Integer> encoded) {
        if (modelName == null) {
            TikTokensUtil.$$$reportNull$$$0(14);
        }
        if (encoded == null) {
            TikTokensUtil.$$$reportNull$$$0(15);
        }
        Encoding enc = TikTokensUtil.getEncoding(modelName);
        return enc.decode(encoded);
    }

    public static ModelType getModelTypeByName(String name) {
        if (ChatCompletion.Model.GPT_3_5_TURBO_0301.getName().equals(name) || ChatCompletion.Model.GPT_3_5_TURBO_0613.getName().equals(name) || ChatCompletion.Model.GPT_3_5_TURBO_16K.getName().equals(name) || ChatCompletion.Model.GPT_3_5_TURBO_16K_0613.getName().equals(name)) {
            return ModelType.GPT_3_5_TURBO;
        }
        if (ChatCompletion.Model.GPT_4.getName().equals(name) || ChatCompletion.Model.GPT_4_32K.getName().equals(name) || ChatCompletion.Model.GPT_4_32K_0314.getName().equals(name) || ChatCompletion.Model.GPT_4_0314.getName().equals(name) || ChatCompletion.Model.GPT_4_0613.getName().equals(name) || ChatCompletion.Model.GPT_4_32K_0613.getName().equals(name)) {
            return ModelType.GPT_4;
        }
        for (ModelType modelType : ModelType.values()) {
            if (!modelType.getName().equals(name)) continue;
            return modelType;
        }
        log.warn("[{}]\u6a21\u578b\u4e0d\u5b58\u5728\u6216\u8005\u6682\u4e0d\u652f\u6301\u8ba1\u7b97tokens", (Object)name);
        return null;
    }

    static {
        for (ModelType modelType : ModelType.values()) {
            modelMap.put(modelType.getName(), registry.getEncodingForModel(modelType));
        }
        modelMap.put(ChatCompletion.Model.GPT_3_5_TURBO_0301.getName(), registry.getEncodingForModel(ModelType.GPT_3_5_TURBO));
        modelMap.put(ChatCompletion.Model.GPT_3_5_TURBO_0613.getName(), registry.getEncodingForModel(ModelType.GPT_3_5_TURBO));
        modelMap.put(ChatCompletion.Model.GPT_3_5_TURBO_16K.getName(), registry.getEncodingForModel(ModelType.GPT_3_5_TURBO));
        modelMap.put(ChatCompletion.Model.GPT_3_5_TURBO_16K_0613.getName(), registry.getEncodingForModel(ModelType.GPT_3_5_TURBO));
        modelMap.put(ChatCompletion.Model.GPT_4_32K.getName(), registry.getEncodingForModel(ModelType.GPT_4));
        modelMap.put(ChatCompletion.Model.GPT_4_32K_0314.getName(), registry.getEncodingForModel(ModelType.GPT_4));
        modelMap.put(ChatCompletion.Model.GPT_4_0314.getName(), registry.getEncodingForModel(ModelType.GPT_4));
        modelMap.put(ChatCompletion.Model.GPT_4_0613.getName(), registry.getEncodingForModel(ModelType.GPT_4));
        modelMap.put(ChatCompletion.Model.GPT_4_32K_0613.getName(), registry.getEncodingForModel(ModelType.GPT_4));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enc";
                break;
            }
            case 3: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoded";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encodingType";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
        }
        objectArray2[1] = "com/unfbx/chatgpt/utils/TikTokensUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "encode";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "tokens";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "decode";
                break;
            }
            case 4: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getEncoding";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

