/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.conversion.msoffice;

import com.documents4j.api.DocumentType;
import com.documents4j.conversion.ViableConversion;
import com.documents4j.conversion.msoffice.AbstractMicrosoftOfficeBridge;
import com.documents4j.conversion.msoffice.MicrosoftExcelFormat;
import com.documents4j.conversion.msoffice.MicrosoftExcelScript;
import com.documents4j.conversion.msoffice.MicrosoftExcelTargetNameCorrectorAndLockManager;
import com.documents4j.conversion.msoffice.MicrosoftOfficeFormat;
import com.documents4j.conversion.msoffice.MicrosoftOfficeScript;
import com.documents4j.conversion.msoffice.MicrosoftOfficeTargetNameCorrector;
import java.io.File;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ViableConversion(from={"application/vnd.ms-excel", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/vnd.com.documents4j.any-msexcel", "application/vnd.oasis.opendocument.spreadsheet"}, to={"application/pdf", "application/vnd.ms-excel", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/vnd.oasis.opendocument.spreadsheet", "text/csv", "text/plain", "application/xml"})
public class MicrosoftExcelBridge
extends AbstractMicrosoftOfficeBridge {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicrosoftExcelBridge.class);
    private static final Object EXCEL_LOCK = new Object();
    private static final Semaphore CONVERSION_LOCK = new Semaphore(1, true);

    public MicrosoftExcelBridge(File baseFolder, long processTimeout, TimeUnit processTimeoutUnit) {
        super(baseFolder, processTimeout, processTimeoutUnit, (MicrosoftOfficeScript)MicrosoftExcelScript.CONVERSION);
        this.startUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startUp() {
        Object object = EXCEL_LOCK;
        synchronized (object) {
            this.tryStart(MicrosoftExcelScript.STARTUP);
            LOGGER.info("From-Microsoft-Excel-Converter was started successfully");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        Object object = EXCEL_LOCK;
        synchronized (object) {
            this.tryStop(MicrosoftExcelScript.SHUTDOWN);
            LOGGER.info("From-Microsoft-Excel-Converter was shut down successfully");
        }
    }

    protected MicrosoftOfficeTargetNameCorrector targetNameCorrector(File target, String fileExtension) {
        return new MicrosoftExcelTargetNameCorrectorAndLockManager(target, fileExtension, CONVERSION_LOCK, LOGGER);
    }

    protected MicrosoftOfficeFormat formatOf(DocumentType documentType) {
        return MicrosoftExcelFormat.of(documentType);
    }

    protected MicrosoftOfficeScript getAssertionScript() {
        return MicrosoftExcelScript.ASSERTION;
    }

    protected Logger getLogger() {
        return LOGGER;
    }
}

