/*
 * Decompiled with CFR 0.152.
 */
package com.documents4j.conversion.msoffice;

import com.documents4j.conversion.msoffice.MicrosoftOfficeTargetNameCorrector;
import java.io.File;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.zeroturnaround.exec.ProcessExecutor;

class MicrosoftExcelTargetNameCorrectorAndLockManager
extends MicrosoftOfficeTargetNameCorrector {
    private final Semaphore conversionLock;
    private final Logger logger;

    public MicrosoftExcelTargetNameCorrectorAndLockManager(File target, String fileExtension, Semaphore conversionLock, Logger logger) {
        super(target, fileExtension);
        this.conversionLock = conversionLock;
        this.logger = logger;
    }

    public void beforeStart(ProcessExecutor executor) {
        this.logger.trace("Attempting to acquire MS Excel conversion lock");
        this.conversionLock.acquireUninterruptibly();
        this.logger.trace("Acquired MS Excel conversion lock");
        super.beforeStart(executor);
    }

    public void afterStop(Process process) {
        this.conversionLock.release();
        this.logger.trace("Released MS Excel conversion lock");
        super.afterStop(process);
    }

    protected boolean targetHasNoFileExtension() {
        return !this.fileExtension.equals("txt") && super.targetHasNoFileExtension();
    }

    protected boolean targetHasWrongFileExtension() {
        return this.fileExtension.equals("pdf") && super.targetHasWrongFileExtension();
    }
}

