/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ehcache.annotations.key;

import com.googlecode.ehcache.annotations.key.AbstractHashingCacheKeyGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashCodeCacheKeyGenerator
extends AbstractHashingCacheKeyGenerator<LongGenerator, Long> {
    public static final String DEFAULT_BEAN_NAME = "com.googlecode.ehcache.annotations.key.HashCodeCacheKeyGenerator.DEFAULT_BEAN_NAME";
    protected static final long INITIAL_HASH = 1L;
    protected static final long MULTIPLIER = 31L;

    public HashCodeCacheKeyGenerator() {
    }

    public HashCodeCacheKeyGenerator(boolean includeMethod, boolean includeParameterTypes) {
        super(includeMethod, includeParameterTypes);
    }

    @Override
    public LongGenerator getGenerator(Object ... data) {
        return new LongGenerator();
    }

    @Override
    public Long generateKey(LongGenerator generator) {
        return generator.hash;
    }

    @Override
    protected void append(LongGenerator generator, boolean[] a) {
        for (boolean element : a) {
            generator.hash = 31L * generator.hash + (long)(element ? 1231 : 1237);
        }
    }

    @Override
    protected void append(LongGenerator generator, byte[] a) {
        for (byte element : a) {
            generator.hash = 31L * generator.hash + (long)element;
        }
    }

    @Override
    protected void append(LongGenerator generator, char[] a) {
        for (char element : a) {
            generator.hash = 31L * generator.hash + (long)element;
        }
    }

    @Override
    protected void append(LongGenerator generator, double[] a) {
        for (double element : a) {
            generator.hash = 31L * generator.hash + Double.doubleToLongBits(element);
        }
    }

    @Override
    protected void append(LongGenerator generator, float[] a) {
        for (float element : a) {
            generator.hash = 31L * generator.hash + (long)Float.floatToIntBits(element);
        }
    }

    @Override
    protected void append(LongGenerator generator, int[] a) {
        for (int element : a) {
            generator.hash = 31L * generator.hash + (long)element;
        }
    }

    @Override
    protected void append(LongGenerator generator, long[] a) {
        for (long element : a) {
            generator.hash = 31L * generator.hash + element;
        }
    }

    @Override
    protected void append(LongGenerator generator, short[] a) {
        for (short element : a) {
            generator.hash = 31L * generator.hash + (long)element;
        }
    }

    @Override
    protected void appendGraphCycle(LongGenerator generator, Object o) {
        generator.hash = 31L * generator.hash;
    }

    @Override
    protected void appendNull(LongGenerator generator) {
        generator.hash = 31L * generator.hash;
    }

    @Override
    protected void appendHash(LongGenerator generator, Object e) {
        if (e instanceof Double) {
            generator.hash = 31L * generator.hash + Double.doubleToLongBits((Double)e);
        } else if (e instanceof Long) {
            generator.hash = 31L * generator.hash + (Long)e;
        } else {
            generator.hash = 31L * generator.hash + (long)e.hashCode();
        }
    }

    public static class LongGenerator {
        private long hash = 1L;

        private LongGenerator() {
        }
    }
}

