/*
 * Decompiled with CFR 0.152.
 */
package com.schooner.MemCached;

import com.schooner.MemCached.AuthInfo;
import com.schooner.MemCached.SchoonerSockIO;
import com.schooner.MemCached.SchoonerSockIOFactory;
import com.schooner.MemCached.SockInputStream;
import java.io.DataInputStream;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthSchoonerSockIOFactory
extends SchoonerSockIOFactory {
    public static Logger log = LoggerFactory.getLogger(AuthSchoonerSockIOFactory.class);
    public static final String NTLM = "NTLM";
    public static final String PLAIN = "PLAIN";
    public static final String LOGIN = "LOGIN";
    public static final String DIGEST_MD5 = "DIGEST-MD5";
    public static final String CRAM_MD5 = "CRAM-MD5";
    public static final String ANONYMOUS = "ANONYMOUS";
    public static final byte[] EMPTY_BYTES = new byte[0];
    private AuthInfo authInfo;

    public AuthSchoonerSockIOFactory(String string, boolean bl, int n, int n2, int n3, boolean bl2, AuthInfo authInfo) {
        super(string, bl, n, n2, n3, bl2);
        this.authInfo = authInfo;
    }

    public Object makeObject() throws Exception {
        SchoonerSockIO schoonerSockIO = this.createSocket(this.host);
        this.auth(schoonerSockIO);
        return schoonerSockIO;
    }

    private void auth(SchoonerSockIO schoonerSockIO) throws Exception {
        SaslClient saslClient = Sasl.createSaslClient(this.authInfo.getMechanisms(), null, "memcached", this.host, null, this.authInfo.getCallbackHandler());
        byte[] byArray = saslClient.hasInitialResponse() ? saslClient.evaluateChallenge(EMPTY_BYTES) : EMPTY_BYTES;
        byArray = this.sendAuthData(schoonerSockIO, (byte)33, saslClient.getMechanismName(), byArray);
        if (byArray == null) {
            return;
        }
        byArray = saslClient.evaluateChallenge(byArray);
        if (this.sendAuthData(schoonerSockIO, (byte)34, saslClient.getMechanismName(), byArray) == null) {
            return;
        }
        if (log.isErrorEnabled()) {
            log.error("Auth Failed: mechanism = " + saslClient.getMechanismName());
        }
        throw new Exception();
    }

    private byte[] sendAuthData(SchoonerSockIO schoonerSockIO, byte by, String string, byte[] byArray) throws Exception {
        schoonerSockIO.writeBuf.clear();
        schoonerSockIO.writeBuf.put((byte)-128);
        schoonerSockIO.writeBuf.put(by);
        schoonerSockIO.writeBuf.putShort((short)string.length());
        schoonerSockIO.writeBuf.putInt(0);
        schoonerSockIO.writeBuf.putInt(string.length() + byArray.length);
        schoonerSockIO.writeBuf.putInt(0);
        schoonerSockIO.writeBuf.putLong(0L);
        schoonerSockIO.writeBuf.put(string.getBytes());
        schoonerSockIO.writeBuf.put(byArray);
        schoonerSockIO.flush();
        DataInputStream dataInputStream = new DataInputStream(new SockInputStream(schoonerSockIO, Integer.MAX_VALUE));
        dataInputStream.readInt();
        dataInputStream.readByte();
        dataInputStream.readByte();
        byte[] byArray2 = null;
        short s = dataInputStream.readShort();
        if (s == 33) {
            int n = dataInputStream.readInt();
            byArray2 = new byte[n];
            dataInputStream.readInt();
            dataInputStream.readLong();
            dataInputStream.read(byArray2);
        } else if (s == 32) {
            if (log.isErrorEnabled()) {
                log.error("Auth Failed: mechanism = " + string);
            }
            throw new Exception();
        }
        return byArray2;
    }
}

