/*
 * Decompiled with CFR 0.152.
 */
package com.schooner.MemCached;

import com.danga.MemCached.ErrorHandler;
import com.danga.MemCached.MemCachedClient;
import com.schooner.MemCached.ByteBufArrayInputStream;
import com.schooner.MemCached.MemcachedItem;
import com.schooner.MemCached.NativeHandler;
import com.schooner.MemCached.ObjectTransCoder;
import com.schooner.MemCached.SchoonerSockIO;
import com.schooner.MemCached.SchoonerSockIOPool;
import com.schooner.MemCached.SockInputStream;
import com.schooner.MemCached.SockOutputStream;
import com.schooner.MemCached.TransCoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryClient
extends MemCachedClient {
    private TransCoder transCoder = new ObjectTransCoder();
    private SchoonerSockIOPool pool;
    private String poolName;
    private boolean sanitizeKeys;
    private boolean primitiveAsString;
    private boolean compressEnable;
    private long compressThreshold;
    private String defaultEncoding = "utf-8";

    @Override
    public boolean isUseBinaryProtocol() {
        return true;
    }

    public BinaryClient() {
        this((String)null);
    }

    public BinaryClient(String string) {
        this(string, null, null);
    }

    public BinaryClient(String string, ClassLoader classLoader, ErrorHandler errorHandler) {
        super((MemCachedClient)null);
        this.poolName = string;
        this.classLoader = classLoader;
        this.errorHandler = errorHandler;
        this.init();
    }

    private void init() {
        this.poolName = this.poolName == null ? "default" : this.poolName;
        this.pool = SchoonerSockIOPool.getInstance(this.poolName);
    }

    @Override
    public boolean keyExists(String string) {
        return this.get(string, null) != null;
    }

    @Override
    public boolean delete(String string) {
        return this.delete(string, null, null);
    }

    @Override
    public boolean delete(String string, Date date) {
        return this.delete(string, null, date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(String string, Integer n, Date date) {
        if (string == null) {
            if (log.isErrorEnabled()) {
                log.error("null value for key passed to delete()");
            }
            return false;
        }
        try {
            string = this.sanitizeKey(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnDelete(this, unsupportedEncodingException, string);
            }
            if (log.isErrorEnabled()) {
                log.error("failed to sanitize your key!", (Throwable)unsupportedEncodingException);
            }
            return false;
        }
        SchoonerSockIO schoonerSockIO = this.pool.getSock(string, n);
        if (schoonerSockIO == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnDelete(this, new IOException("no socket to server available"), string);
            }
            return false;
        }
        try {
            schoonerSockIO.writeBuf.clear();
            schoonerSockIO.writeBuf.put((byte)-128);
            schoonerSockIO.writeBuf.put((byte)4);
            byte[] byArray = string.getBytes();
            schoonerSockIO.writeBuf.putShort((short)byArray.length);
            schoonerSockIO.writeBuf.putInt(0);
            schoonerSockIO.writeBuf.putInt(byArray.length);
            schoonerSockIO.writeBuf.putInt(0);
            schoonerSockIO.writeBuf.putLong(0L);
            schoonerSockIO.writeBuf.put(byArray);
            schoonerSockIO.flush();
            SockInputStream sockInputStream = new SockInputStream(schoonerSockIO, Integer.MAX_VALUE);
            DataInputStream dataInputStream = new DataInputStream(sockInputStream);
            dataInputStream.readInt();
            dataInputStream.readShort();
            short s = dataInputStream.readShort();
            if (s == 0) {
                if (log.isDebugEnabled()) {
                    log.debug("++++ deletion of key: " + string + " from cache was a success");
                }
                boolean bl = true;
                return bl;
            }
            if (s == 1) {
                if (log.isDebugEnabled()) {
                    log.debug("++++ deletion of key: " + string + " from cache failed as the key was not found");
                }
            } else if (log.isErrorEnabled()) {
                log.error("++++ error deleting key: " + string);
                log.error("++++ server response: " + s);
            }
        }
        catch (IOException iOException) {
            block28: {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnDelete(this, iOException, string);
                }
                if (log.isErrorEnabled()) {
                    log.error("++++ exception thrown while writing bytes to server on delete");
                    log.error(iOException.getMessage(), (Throwable)iOException);
                }
                try {
                    schoonerSockIO.sockets.invalidateObject((Object)schoonerSockIO);
                }
                catch (Exception exception) {
                    if (!log.isErrorEnabled()) break block28;
                    log.error("++++ failed to close socket : " + schoonerSockIO.toString());
                }
            }
            schoonerSockIO = null;
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            if (schoonerSockIO != null) {
                schoonerSockIO.close();
                schoonerSockIO = null;
            }
        }
        return false;
    }

    @Override
    public boolean set(String string, Object object) {
        return this.set((byte)1, string, object, null, null, 0L, this.primitiveAsString);
    }

    @Override
    public boolean set(String string, Object object, Integer n) {
        return this.set((byte)1, string, object, null, n, 0L, this.primitiveAsString);
    }

    @Override
    public boolean set(String string, Object object, Date date) {
        return this.set((byte)1, string, object, date, null, 0L, this.primitiveAsString);
    }

    @Override
    public boolean set(String string, Object object, Date date, Integer n) {
        return this.set((byte)1, string, object, date, n, 0L, this.primitiveAsString);
    }

    @Override
    public boolean add(String string, Object object) {
        return this.set((byte)2, string, object, null, null, 0L, this.primitiveAsString);
    }

    @Override
    public boolean add(String string, Object object, Integer n) {
        return this.set((byte)2, string, object, null, n, 0L, this.primitiveAsString);
    }

    @Override
    public boolean add(String string, Object object, Date date) {
        return this.set((byte)2, string, object, date, null, 0L, this.primitiveAsString);
    }

    @Override
    public boolean add(String string, Object object, Date date, Integer n) {
        return this.set((byte)2, string, object, date, n, 0L, this.primitiveAsString);
    }

    @Override
    public boolean append(String string, Object object, Integer n) {
        return this.apPrepend((byte)14, string, object, n, 0L);
    }

    @Override
    public boolean append(String string, Object object) {
        return this.apPrepend((byte)14, string, object, null, 0L);
    }

    @Override
    public boolean cas(String string, Object object, Integer n, long l) {
        return this.set((byte)1, string, object, null, n, l, this.primitiveAsString);
    }

    @Override
    public boolean cas(String string, Object object, Date date, long l) {
        return this.set((byte)1, string, object, date, null, l, this.primitiveAsString);
    }

    @Override
    public boolean cas(String string, Object object, Date date, Integer n, long l) {
        return this.set((byte)1, string, object, date, n, l, this.primitiveAsString);
    }

    @Override
    public boolean cas(String string, Object object, long l) {
        return this.set((byte)1, string, object, null, null, l, this.primitiveAsString);
    }

    @Override
    public boolean prepend(String string, Object object, Integer n) {
        return this.apPrepend((byte)15, string, object, n, 0L);
    }

    @Override
    public boolean prepend(String string, Object object) {
        return this.apPrepend((byte)15, string, object, null, 0L);
    }

    @Override
    public boolean replace(String string, Object object) {
        return this.set((byte)3, string, object, null, null, 0L, this.primitiveAsString);
    }

    @Override
    public boolean replace(String string, Object object, Integer n) {
        return this.set((byte)3, string, object, null, n, 0L, this.primitiveAsString);
    }

    @Override
    public boolean replace(String string, Object object, Date date) {
        return this.set((byte)3, string, object, date, null, 0L, this.primitiveAsString);
    }

    @Override
    public boolean replace(String string, Object object, Date date, Integer n) {
        return this.set((byte)3, string, object, date, n, 0L, this.primitiveAsString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean set(byte by, String string, Object object, Date date, Integer n, long l, boolean bl) {
        if (string == null) {
            if (log.isErrorEnabled()) {
                log.error("key is null or cmd is null/empty for set()");
            }
            return false;
        }
        try {
            string = this.sanitizeKey(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, unsupportedEncodingException, string);
            }
            if (log.isErrorEnabled()) {
                log.error("failed to sanitize your key!", (Throwable)unsupportedEncodingException);
            }
            return false;
        }
        if (object == null) {
            if (log.isErrorEnabled()) {
                log.error("trying to store a null value to cache");
            }
            return false;
        }
        SchoonerSockIO schoonerSockIO = this.pool.getSock(string, n);
        if (schoonerSockIO == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, new IOException("no socket to server available"), string);
            }
            return false;
        }
        if (date == null) {
            date = new Date(0L);
        }
        try {
            int n2 = NativeHandler.getMarkerFlag(object);
            byte[] byArray = string.getBytes();
            schoonerSockIO.writeBuf.clear();
            schoonerSockIO.writeBuf.put((byte)-128);
            schoonerSockIO.writeBuf.put(by);
            schoonerSockIO.writeBuf.putShort((short)byArray.length);
            schoonerSockIO.writeBuf.put((byte)8);
            schoonerSockIO.writeBuf.put((byte)0);
            schoonerSockIO.writeBuf.putShort((short)0);
            schoonerSockIO.writeBuf.putInt(0);
            schoonerSockIO.writeBuf.putInt(0);
            schoonerSockIO.writeBuf.putLong(l);
            schoonerSockIO.writeBuf.putInt(n2);
            schoonerSockIO.writeBuf.putInt(new Long(date.getTime() / 1000L).intValue());
            schoonerSockIO.writeBuf.put(byArray);
            SockOutputStream sockOutputStream = new SockOutputStream(schoonerSockIO);
            int n3 = 0;
            if (n2 != 0) {
                byte[] byArray2 = bl ? object.toString().getBytes(this.defaultEncoding) : NativeHandler.encode(object);
                sockOutputStream.write(byArray2);
                n3 = byArray2.length;
                n3 = byArray2.length;
            } else {
                n3 = this.transCoder.encode(sockOutputStream, object);
            }
            int n4 = 8 + byArray.length + n3;
            int n5 = schoonerSockIO.writeBuf.position();
            schoonerSockIO.writeBuf.position(8);
            schoonerSockIO.writeBuf.putInt(n4);
            schoonerSockIO.writeBuf.position(n5);
            schoonerSockIO.flush();
            DataInputStream dataInputStream = new DataInputStream(new SockInputStream(schoonerSockIO, Integer.MAX_VALUE));
            dataInputStream.readInt();
            dataInputStream.readShort();
            if (0 == dataInputStream.readShort()) {
                boolean bl2 = true;
                return bl2;
            }
        }
        catch (IOException iOException) {
            block27: {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnSet(this, iOException, string);
                }
                if (log.isErrorEnabled()) {
                    log.error("++++ exception thrown while writing bytes to server on set");
                    log.error(iOException.getMessage(), (Throwable)iOException);
                }
                try {
                    schoonerSockIO.sockets.invalidateObject((Object)schoonerSockIO);
                }
                catch (Exception exception) {
                    if (!log.isErrorEnabled()) break block27;
                    log.error("++++ failed to close socket : " + schoonerSockIO.toString());
                }
            }
            schoonerSockIO = null;
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            if (schoonerSockIO != null) {
                schoonerSockIO.close();
                schoonerSockIO = null;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean apPrepend(byte by, String string, Object object, Integer n, Long l) {
        if (string == null) {
            if (log.isErrorEnabled()) {
                log.error("key is null or cmd is null/empty for set()");
            }
            return false;
        }
        try {
            string = this.sanitizeKey(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (log.isErrorEnabled()) {
                log.error("failed to sanitize your key!", (Throwable)unsupportedEncodingException);
            }
            return false;
        }
        if (object == null) {
            if (log.isErrorEnabled()) {
                log.error("trying to store a null value to cache");
            }
            return false;
        }
        SchoonerSockIO schoonerSockIO = this.pool.getSock(string, n);
        if (schoonerSockIO == null) {
            return false;
        }
        try {
            int n2 = NativeHandler.getMarkerFlag(object);
            byte[] byArray = string.getBytes();
            schoonerSockIO.writeBuf.clear();
            schoonerSockIO.writeBuf.put((byte)-128);
            schoonerSockIO.writeBuf.put(by);
            schoonerSockIO.writeBuf.putShort((short)byArray.length);
            schoonerSockIO.writeBuf.putInt(0);
            schoonerSockIO.writeBuf.putLong(0L);
            schoonerSockIO.writeBuf.putLong(l);
            schoonerSockIO.writeBuf.put(byArray);
            SockOutputStream sockOutputStream = new SockOutputStream(schoonerSockIO);
            int n3 = 0;
            if (n2 != 0) {
                byte[] byArray2 = NativeHandler.encode(object);
                sockOutputStream.write(byArray2);
                n3 = byArray2.length;
            } else {
                n3 = this.transCoder.encode(sockOutputStream, object);
            }
            int n4 = byArray.length + n3;
            int n5 = schoonerSockIO.writeBuf.position();
            schoonerSockIO.writeBuf.position(8);
            schoonerSockIO.writeBuf.putInt(n4);
            schoonerSockIO.writeBuf.position(n5);
            schoonerSockIO.flush();
            DataInputStream dataInputStream = new DataInputStream(new SockInputStream(schoonerSockIO, Integer.MAX_VALUE));
            dataInputStream.readInt();
            dataInputStream.readShort();
            if (0 == dataInputStream.readShort()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
            block21: {
                if (log.isErrorEnabled()) {
                    log.error("++++ exception thrown while writing bytes to server on set");
                    log.error(iOException.getMessage(), (Throwable)iOException);
                }
                try {
                    schoonerSockIO.sockets.invalidateObject((Object)schoonerSockIO);
                }
                catch (Exception exception) {
                    if (!log.isErrorEnabled()) break block21;
                    log.error("++++ failed to close socket : " + schoonerSockIO.toString());
                }
            }
            schoonerSockIO = null;
        }
        finally {
            if (schoonerSockIO != null) {
                schoonerSockIO.close();
                schoonerSockIO = null;
            }
        }
        return false;
    }

    @Override
    public long addOrIncr(String string) {
        return this.addOrIncr(string, 0L, null);
    }

    @Override
    public long addOrIncr(String string, long l) {
        return this.addOrIncr(string, l, null);
    }

    @Override
    public long addOrIncr(String string, long l, Integer n) {
        boolean bl = this.add(string, (Object)("" + l), n);
        if (bl) {
            return l;
        }
        return this.incrdecr((byte)5, string, l, n);
    }

    @Override
    public long addOrDecr(String string) {
        return this.addOrDecr(string, 0L, null);
    }

    @Override
    public long addOrDecr(String string, long l) {
        return this.addOrDecr(string, l, null);
    }

    @Override
    public long addOrDecr(String string, long l, Integer n) {
        boolean bl = this.add(string, (Object)("" + l), n);
        if (bl) {
            return l;
        }
        return this.incrdecr((byte)6, string, l, n);
    }

    @Override
    public long incr(String string) {
        return this.incrdecr((byte)5, string, 1L, null);
    }

    @Override
    public long incr(String string, long l) {
        return this.incrdecr((byte)5, string, l, null);
    }

    @Override
    public long incr(String string, long l, Integer n) {
        return this.incrdecr((byte)5, string, l, n);
    }

    @Override
    public long decr(String string) {
        return this.incrdecr((byte)6, string, 1L, null);
    }

    @Override
    public long decr(String string, long l) {
        return this.incrdecr((byte)6, string, l, null);
    }

    @Override
    public long decr(String string, long l, Integer n) {
        return this.incrdecr((byte)6, string, l, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long incrdecr(byte by, String string, long l, Integer n) {
        if (string == null) {
            if (log.isErrorEnabled()) {
                log.error("null key for incrdecr()");
            }
            return -1L;
        }
        try {
            string = this.sanitizeKey(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)unsupportedEncodingException, string);
            }
            if (log.isErrorEnabled()) {
                log.error("failed to sanitize your key!", (Throwable)unsupportedEncodingException);
            }
            return -1L;
        }
        SchoonerSockIO schoonerSockIO = this.pool.getSock(string, n);
        if (schoonerSockIO == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnSet(this, new IOException("no socket to server available"), string);
            }
            return -1L;
        }
        try {
            schoonerSockIO.writeBuf.clear();
            schoonerSockIO.writeBuf.put((byte)-128);
            schoonerSockIO.writeBuf.put(by);
            byte[] byArray = string.getBytes();
            schoonerSockIO.writeBuf.putShort((short)byArray.length);
            schoonerSockIO.writeBuf.put((byte)20);
            schoonerSockIO.writeBuf.put((byte)0);
            schoonerSockIO.writeBuf.putShort((short)0);
            schoonerSockIO.writeBuf.putInt(byArray.length + 20);
            schoonerSockIO.writeBuf.putInt(0);
            schoonerSockIO.writeBuf.putLong(0L);
            schoonerSockIO.writeBuf.putLong(l);
            schoonerSockIO.writeBuf.putLong(0L);
            schoonerSockIO.writeBuf.putInt(0);
            schoonerSockIO.writeBuf.put(byArray);
            schoonerSockIO.flush();
            DataInputStream dataInputStream = new DataInputStream(new SockInputStream(schoonerSockIO, Integer.MAX_VALUE));
            dataInputStream.readInt();
            dataInputStream.readShort();
            short s = dataInputStream.readShort();
            if (s == 0) {
                long l2;
                dataInputStream.readLong();
                dataInputStream.readLong();
                long l3 = l2 = dataInputStream.readLong();
                return l3;
            }
            if (log.isErrorEnabled()) {
                log.error(new StringBuffer().append("++++ error incr/decr key: ").append(string).toString());
                log.error(new StringBuffer().append("++++ server response: ").append(s).toString());
            }
        }
        catch (IOException iOException) {
            block22: {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)iOException, string);
                }
                if (log.isErrorEnabled()) {
                    log.error("++++ exception thrown while writing bytes to server on incr/decr");
                    log.error(iOException.getMessage(), (Throwable)iOException);
                }
                try {
                    schoonerSockIO.sockets.invalidateObject((Object)schoonerSockIO);
                }
                catch (Exception exception) {
                    if (!log.isErrorEnabled()) break block22;
                    log.error("++++ failed to close socket : " + schoonerSockIO.toString());
                }
            }
            schoonerSockIO = null;
        }
        finally {
            if (schoonerSockIO != null) {
                schoonerSockIO.close();
                schoonerSockIO = null;
            }
        }
        return -1L;
    }

    @Override
    public Object get(String string) {
        return this.get(string, null);
    }

    @Override
    public Object get(String string, Integer n) {
        return this.get((byte)0, string, n, false);
    }

    @Override
    public MemcachedItem gets(String string) {
        return this.gets(string, null);
    }

    @Override
    public MemcachedItem gets(String string, Integer n) {
        return this.gets((byte)0, string, n, false);
    }

    @Override
    public void setTransCoder(TransCoder transCoder) {
        this.transCoder = transCoder;
    }

    @Override
    public Object[] getMultiArray(String[] stringArray) {
        return this.getMultiArray(stringArray, null);
    }

    @Override
    public Object[] getMultiArray(String[] stringArray, Integer[] integerArray) {
        Map<String, Object> map = this.getMulti(stringArray, integerArray);
        if (map == null) {
            return null;
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = map.get(stringArray[i]);
        }
        return objectArray;
    }

    @Override
    public Map<String, Object> getMulti(String[] stringArray) {
        return this.getMulti(stringArray, null);
    }

    @Override
    public Map<String, Object> getMulti(String[] stringArray, Integer[] integerArray) {
        return this.getMulti(stringArray, integerArray, false);
    }

    @Override
    public Map<String, Object> getMulti(String[] stringArray, Integer[] integerArray, boolean bl) {
        if (stringArray == null || stringArray.length == 0) {
            if (log.isErrorEnabled()) {
                log.error("missing keys for getMulti()");
            }
            return null;
        }
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null) {
                if (!log.isErrorEnabled()) continue;
                log.error("null key, so skipping");
                continue;
            }
            Integer n = null;
            if (integerArray != null && integerArray.length > i) {
                n = integerArray[i];
            }
            stringArray2[i] = string;
            try {
                stringArray2[i] = this.sanitizeKey(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)unsupportedEncodingException, string);
                }
                if (!log.isErrorEnabled()) continue;
                log.error("failed to sanitize your key!", (Throwable)unsupportedEncodingException);
                continue;
            }
            SchoonerSockIO schoonerSockIO = this.pool.getSock(stringArray2[i], n);
            if (schoonerSockIO == null) {
                if (this.errorHandler == null) continue;
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)new IOException("no socket to server available"), string);
                continue;
            }
            if (!hashMap.containsKey(schoonerSockIO.getHost())) {
                hashMap.put(schoonerSockIO.getHost(), new ArrayList());
            }
            ((ArrayList)hashMap.get(schoonerSockIO.getHost())).add(stringArray2[i]);
            schoonerSockIO.close();
        }
        if (log.isDebugEnabled()) {
            log.debug("multi get socket count : " + hashMap.size());
        }
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>(stringArray.length);
        new NIOLoader(this).doMulti(bl, hashMap, stringArray, hashMap2);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(stringArray2[i]) || !hashMap2.containsKey(stringArray2[i])) continue;
            hashMap2.put(stringArray[i], hashMap2.get(stringArray2[i]));
            hashMap2.remove(stringArray2[i]);
        }
        if (log.isDebugEnabled()) {
            log.debug("++++ memcache: got back " + hashMap2.size() + " results");
        }
        return hashMap2;
    }

    private void loadMulti(DataInputStream dataInputStream, Map<String, Object> map) throws IOException {
        while (true) {
            dataInputStream.readByte();
            byte by = dataInputStream.readByte();
            if (by == 13) {
                short s = dataInputStream.readShort();
                dataInputStream.readInt();
                int n = dataInputStream.readInt() - s - 4;
                dataInputStream.readInt();
                dataInputStream.readLong();
                int n2 = dataInputStream.readInt();
                byte[] byArray = new byte[s];
                dataInputStream.read(byArray);
                String string = new String(byArray);
                byte[] byArray2 = new byte[n];
                dataInputStream.read(byArray2);
                Object object = null;
                if ((n2 & 2) == 2) {
                    int n3;
                    GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray2));
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray2.length);
                    byte[] byArray3 = new byte[2048];
                    while ((n3 = gZIPInputStream.read(byArray3)) != -1) {
                        byteArrayOutputStream.write(byArray3, 0, n3);
                    }
                    byArray2 = byteArrayOutputStream.toByteArray();
                    gZIPInputStream.close();
                }
                if (n2 != 0) {
                    try {
                        object = NativeHandler.decode(byArray2, n2);
                    }
                    catch (Exception exception) {
                        if (this.errorHandler != null) {
                            this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)exception, string);
                        }
                        if (log.isErrorEnabled()) {
                            log.error("++++ Exception thrown while trying to deserialize for key: " + string, (Throwable)exception);
                        }
                        exception.printStackTrace();
                    }
                } else if (this.transCoder != null) {
                    object = this.transCoder.decode(new ByteArrayInputStream(byArray2));
                }
                map.put(string, object);
                continue;
            }
            if (by == 10) break;
        }
    }

    @Override
    public boolean flushAll() {
        return this.flushAll(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flushAll(String[] stringArray) {
        if (this.pool == null) {
            log.error("++++ unable to get SockIOPool instance");
            return false;
        }
        String[] stringArray2 = stringArray = stringArray == null ? this.pool.getServers() : stringArray;
        if (stringArray == null || stringArray.length <= 0) {
            if (log.isErrorEnabled()) {
                log.error("++++ no servers to flush");
            }
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            SchoonerSockIO schoonerSockIO = this.pool.getConnection(stringArray[i]);
            if (schoonerSockIO == null) {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnFlush(this, new IOException("no socket to server available"));
                }
                if (log.isErrorEnabled()) {
                    log.error("++++ unable to get connection to : " + stringArray[i]);
                }
                bl = false;
                continue;
            }
            schoonerSockIO.writeBuf.clear();
            schoonerSockIO.writeBuf.put((byte)-128);
            schoonerSockIO.writeBuf.put((byte)8);
            schoonerSockIO.writeBuf.putShort((short)0);
            schoonerSockIO.writeBuf.putInt(0);
            schoonerSockIO.writeBuf.putLong(0L);
            schoonerSockIO.writeBuf.putLong(0L);
            try {
                schoonerSockIO.flush();
                DataInputStream dataInputStream = new DataInputStream(new SockInputStream(schoonerSockIO, Integer.MAX_VALUE));
                dataInputStream.readInt();
                dataInputStream.readShort();
                bl = dataInputStream.readShort() == 0 ? bl : false;
                continue;
            }
            catch (IOException iOException) {
                block17: {
                    if (this.errorHandler != null) {
                        this.errorHandler.handleErrorOnFlush(this, iOException);
                    }
                    if (log.isErrorEnabled()) {
                        log.error("++++ exception thrown while writing bytes to server on flushAll");
                        log.error(iOException.getMessage(), (Throwable)iOException);
                    }
                    try {
                        schoonerSockIO.sockets.invalidateObject((Object)schoonerSockIO);
                    }
                    catch (Exception exception) {
                        if (!log.isErrorEnabled()) break block17;
                        log.error("++++ failed to close socket : " + schoonerSockIO.toString());
                    }
                }
                bl = false;
                schoonerSockIO = null;
                continue;
            }
            finally {
                if (schoonerSockIO != null) {
                    schoonerSockIO.close();
                    schoonerSockIO = null;
                }
            }
        }
        return bl;
    }

    @Override
    public Map<String, Map<String, String>> stats() {
        return this.stats(null);
    }

    @Override
    public Map<String, Map<String, String>> stats(String[] stringArray) {
        return this.stats(stringArray, (byte)16, null);
    }

    @Override
    public Map<String, Map<String, String>> statsItems() {
        return this.statsItems(null);
    }

    @Override
    public Map<String, Map<String, String>> statsItems(String[] stringArray) {
        return this.stats(stringArray, (byte)16, "items".getBytes());
    }

    @Override
    public Map<String, Map<String, String>> statsSlabs() {
        return this.statsSlabs(null);
    }

    @Override
    public Map<String, Map<String, String>> statsSlabs(String[] stringArray) {
        return this.stats(stringArray, (byte)16, "slabs".getBytes());
    }

    @Override
    public Map<String, Map<String, String>> statsCacheDump(int n, int n2) {
        return this.statsCacheDump(null, n, n2);
    }

    @Override
    public Map<String, Map<String, String>> statsCacheDump(String[] stringArray, int n, int n2) {
        return this.stats(stringArray, (byte)16, String.format("cachedump %d %d", n, n2).getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, String>> stats(String[] stringArray, byte by, byte[] byArray) {
        String[] stringArray2 = stringArray = stringArray == null ? this.pool.getServers() : stringArray;
        if (stringArray == null || stringArray.length <= 0) {
            if (log.isErrorEnabled()) {
                log.error("++++ no servers to check stats");
            }
            return null;
        }
        HashMap<String, Map<String, String>> hashMap = new HashMap<String, Map<String, String>>();
        for (int i = 0; i < stringArray.length; ++i) {
            SchoonerSockIO schoonerSockIO = this.pool.getConnection(stringArray[i]);
            if (schoonerSockIO == null) {
                if (this.errorHandler == null) continue;
                this.errorHandler.handleErrorOnStats(this, new IOException("no socket to server available"));
                continue;
            }
            try {
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                schoonerSockIO.writeBuf.clear();
                schoonerSockIO.writeBuf.put((byte)-128);
                schoonerSockIO.writeBuf.put(by);
                if (byArray != null) {
                    schoonerSockIO.writeBuf.putShort((short)byArray.length);
                } else {
                    schoonerSockIO.writeBuf.putShort((short)0);
                }
                schoonerSockIO.writeBuf.put((byte)0);
                schoonerSockIO.writeBuf.put((byte)0);
                schoonerSockIO.writeBuf.putShort((short)0);
                schoonerSockIO.writeBuf.putInt(0);
                schoonerSockIO.writeBuf.putInt(0);
                schoonerSockIO.writeBuf.putLong(0L);
                if (byArray != null) {
                    schoonerSockIO.writeBuf.put(byArray);
                }
                schoonerSockIO.writeBuf.flip();
                schoonerSockIO.getChannel().write(schoonerSockIO.writeBuf);
                DataInputStream dataInputStream = new DataInputStream(new SockInputStream(schoonerSockIO, Integer.MAX_VALUE));
                while (true) {
                    dataInputStream.skip(2L);
                    short s = dataInputStream.readShort();
                    dataInputStream.skip(4L);
                    int n = dataInputStream.readInt() - s;
                    dataInputStream.skip(12L);
                    if (s == 0) break;
                    byte[] byArray2 = new byte[s];
                    byte[] byArray3 = new byte[n];
                    dataInputStream.read(byArray2);
                    dataInputStream.read(byArray3);
                    hashMap2.put(new String(byArray2), new String(byArray3));
                }
                hashMap.put(stringArray[i], hashMap2);
                continue;
            }
            catch (IOException iOException) {
                block18: {
                    if (this.errorHandler != null) {
                        this.errorHandler.handleErrorOnStats(this, iOException);
                    }
                    if (log.isErrorEnabled()) {
                        log.error("++++ exception thrown while writing bytes to server on stats");
                        log.error(iOException.getMessage(), (Throwable)iOException);
                    }
                    try {
                        schoonerSockIO.sockets.invalidateObject((Object)schoonerSockIO);
                    }
                    catch (Exception exception) {
                        if (!log.isErrorEnabled()) break block18;
                        log.error("++++ failed to close socket : " + schoonerSockIO.toString());
                    }
                }
                schoonerSockIO = null;
                continue;
            }
            finally {
                if (schoonerSockIO != null) {
                    schoonerSockIO.close();
                    schoonerSockIO = null;
                }
            }
        }
        return hashMap;
    }

    @Override
    public boolean sync(String string, Integer n) {
        return false;
    }

    @Override
    public boolean sync(String string) {
        return this.sync(string, null);
    }

    @Override
    public boolean syncAll() {
        return this.syncAll(null);
    }

    @Override
    public boolean syncAll(String[] stringArray) {
        return false;
    }

    @Override
    public void setDefaultEncoding(String string) {
        this.defaultEncoding = string;
    }

    @Override
    public void setPrimitiveAsString(boolean bl) {
        this.primitiveAsString = bl;
    }

    @Override
    public void setSanitizeKeys(boolean bl) {
        this.sanitizeKeys = bl;
    }

    private String sanitizeKey(String string) throws UnsupportedEncodingException {
        return this.sanitizeKeys ? URLEncoder.encode(string, "UTF-8") : string;
    }

    @Override
    public Object get(String string, Integer n, boolean bl) {
        return this.get((byte)0, string, n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object get(byte by, String string, Integer n, boolean bl) {
        if (string == null) {
            if (log.isErrorEnabled()) {
                log.error("key is null for get()");
            }
            return null;
        }
        try {
            string = this.sanitizeKey(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)unsupportedEncodingException, string);
            }
            if (log.isErrorEnabled()) {
                log.error("failed to sanitize your key!", (Throwable)unsupportedEncodingException);
            }
            return null;
        }
        SchoonerSockIO schoonerSockIO = this.pool.getSock(string, n);
        if (schoonerSockIO == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)new IOException("no socket to server available"), string);
            }
            return null;
        }
        try {
            InputStream inputStream;
            byte[] byArray = string.getBytes();
            schoonerSockIO.writeBuf.clear();
            schoonerSockIO.writeBuf.put((byte)-128);
            schoonerSockIO.writeBuf.put(by);
            schoonerSockIO.writeBuf.putShort((short)byArray.length);
            schoonerSockIO.writeBuf.putInt(0);
            schoonerSockIO.writeBuf.putInt(byArray.length);
            schoonerSockIO.writeBuf.putInt(0);
            schoonerSockIO.writeBuf.putLong(0L);
            schoonerSockIO.writeBuf.put(byArray);
            schoonerSockIO.flush();
            int n2 = 0;
            int n3 = 0;
            SockInputStream sockInputStream = new SockInputStream(schoonerSockIO, Integer.MAX_VALUE);
            DataInputStream dataInputStream = new DataInputStream(sockInputStream);
            dataInputStream.readInt();
            byte by2 = dataInputStream.readByte();
            dataInputStream.readByte();
            if (0 == dataInputStream.readShort()) {
                n2 = dataInputStream.readInt() - by2;
                dataInputStream.readInt();
                dataInputStream.readLong();
            }
            n3 = dataInputStream.readInt();
            Object object = null;
            sockInputStream.willRead(n2);
            if (n2 > 0) {
                if (NativeHandler.isHandled(n3)) {
                    byArray = sockInputStream.getBuffer();
                    if ((n3 & 2) == 2) {
                        int n4;
                        inputStream = new GZIPInputStream(new ByteArrayInputStream(byArray));
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
                        byte[] byArray2 = new byte[2048];
                        while ((n4 = ((FilterInputStream)inputStream).read(byArray2)) != -1) {
                            byteArrayOutputStream.write(byArray2, 0, n4);
                        }
                        byArray = byteArrayOutputStream.toByteArray();
                        ((GZIPInputStream)inputStream).close();
                    }
                    object = this.primitiveAsString || bl ? new String(byArray, this.defaultEncoding) : NativeHandler.decode(byArray, n3);
                } else if (this.transCoder != null) {
                    inputStream = sockInputStream;
                    if ((n3 & 2) == 2) {
                        inputStream = new GZIPInputStream(inputStream);
                    }
                    object = this.classLoader == null ? this.transCoder.decode(inputStream) : ((ObjectTransCoder)this.transCoder).decode(inputStream, this.classLoader);
                }
            }
            inputStream = object;
            return inputStream;
        }
        catch (IOException iOException) {
            block28: {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnDelete(this, iOException, string);
                }
                if (log.isErrorEnabled()) {
                    log.error("++++ exception thrown while writing bytes to server on get");
                    log.error(iOException.getMessage(), (Throwable)iOException);
                }
                try {
                    schoonerSockIO.sockets.invalidateObject((Object)schoonerSockIO);
                }
                catch (Exception exception) {
                    if (!log.isErrorEnabled()) break block28;
                    log.error("++++ failed to close socket : " + schoonerSockIO.toString());
                }
            }
            schoonerSockIO = null;
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            if (schoonerSockIO != null) {
                schoonerSockIO.close();
                schoonerSockIO = null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MemcachedItem gets(byte by, String string, Integer n, boolean bl) {
        if (string == null) {
            if (log.isErrorEnabled()) {
                log.error("key is null for get()");
            }
            return null;
        }
        try {
            string = this.sanitizeKey(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)unsupportedEncodingException, string);
            }
            if (log.isErrorEnabled()) {
                log.error("failed to sanitize your key!", (Throwable)unsupportedEncodingException);
            }
            return null;
        }
        SchoonerSockIO schoonerSockIO = this.pool.getSock(string, n);
        if (schoonerSockIO == null) {
            if (this.errorHandler != null) {
                this.errorHandler.handleErrorOnGet((MemCachedClient)this, (Throwable)new IOException("no socket to server available"), string);
            }
            return null;
        }
        try {
            Object object;
            byte[] byArray = string.getBytes();
            schoonerSockIO.writeBuf.clear();
            schoonerSockIO.writeBuf.put((byte)-128);
            schoonerSockIO.writeBuf.put(by);
            schoonerSockIO.writeBuf.putShort((short)byArray.length);
            schoonerSockIO.writeBuf.putInt(0);
            schoonerSockIO.writeBuf.putInt(byArray.length);
            schoonerSockIO.writeBuf.putInt(0);
            schoonerSockIO.writeBuf.putLong(0L);
            schoonerSockIO.writeBuf.put(byArray);
            schoonerSockIO.flush();
            int n2 = 0;
            int n3 = 0;
            MemcachedItem memcachedItem = new MemcachedItem();
            SockInputStream sockInputStream = new SockInputStream(schoonerSockIO, Integer.MAX_VALUE);
            DataInputStream dataInputStream = new DataInputStream(sockInputStream);
            dataInputStream.readInt();
            byte by2 = dataInputStream.readByte();
            dataInputStream.readByte();
            if (0 == dataInputStream.readShort()) {
                n2 = dataInputStream.readInt() - by2;
                dataInputStream.readInt();
                memcachedItem.casUnique = dataInputStream.readLong();
            }
            n3 = dataInputStream.readInt();
            Object object2 = null;
            sockInputStream.willRead(n2);
            if (n2 > 0) {
                if (NativeHandler.isHandled(n3)) {
                    byArray = sockInputStream.getBuffer();
                    if ((n3 & 2) == 2) {
                        int n4;
                        object = new GZIPInputStream(new ByteArrayInputStream(byArray));
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
                        byte[] byArray2 = new byte[2048];
                        while ((n4 = ((FilterInputStream)object).read(byArray2)) != -1) {
                            byteArrayOutputStream.write(byArray2, 0, n4);
                        }
                        byArray = byteArrayOutputStream.toByteArray();
                        ((GZIPInputStream)object).close();
                    }
                    object2 = this.primitiveAsString || bl ? new String(byArray, this.defaultEncoding) : NativeHandler.decode(byArray, n3);
                } else if (this.transCoder != null) {
                    object = sockInputStream;
                    if ((n3 & 2) == 2) {
                        object = new GZIPInputStream((InputStream)object);
                    }
                    object2 = this.classLoader == null ? this.transCoder.decode((InputStream)object) : ((ObjectTransCoder)this.transCoder).decode((InputStream)object, this.classLoader);
                }
            }
            memcachedItem.value = object2;
            object = memcachedItem;
            return object;
        }
        catch (IOException iOException) {
            block26: {
                if (this.errorHandler != null) {
                    this.errorHandler.handleErrorOnDelete(this, iOException, string);
                }
                if (log.isErrorEnabled()) {
                    log.error("++++ exception thrown while writing bytes to server on get");
                    log.error(iOException.getMessage(), (Throwable)iOException);
                }
                try {
                    schoonerSockIO.sockets.invalidateObject((Object)schoonerSockIO);
                }
                catch (Exception exception) {
                    if (!log.isErrorEnabled()) break block26;
                    log.error("++++ failed to close socket : " + schoonerSockIO.toString());
                }
            }
            schoonerSockIO = null;
        }
        finally {
            if (schoonerSockIO != null) {
                schoonerSockIO.close();
                schoonerSockIO = null;
            }
        }
        return null;
    }

    @Override
    public Object[] getMultiArray(String[] stringArray, Integer[] integerArray, boolean bl) {
        Map<String, Object> map = this.getMulti(stringArray, integerArray, bl);
        if (map == null) {
            return null;
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = map.get(stringArray[i]);
        }
        return objectArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class NIOLoader {
        protected Selector selector;
        protected int numConns = 0;
        protected BinaryClient mc;
        protected Connection[] conns;

        public NIOLoader(BinaryClient binaryClient2) {
            this.mc = binaryClient2;
        }

        public void doMulti(Map<String, ArrayList<String>> map, String[] stringArray, Map<String, Object> map2) {
            this.doMulti(false, map, stringArray, map2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doMulti(boolean bl, Map<String, ArrayList<String>> map, String[] stringArray, Map<String, Object> map2) {
            long l = 0L;
            try {
                long l2;
                this.selector = Selector.open();
                this.conns = new Connection[map.keySet().size()];
                this.numConns = 0;
                for (String object : map.keySet()) {
                    SchoonerSockIO schoonerSockIO = BinaryClient.this.pool.getConnection(object);
                    if (schoonerSockIO == null) {
                        return;
                    }
                    this.conns[this.numConns++] = new Connection(schoonerSockIO, map.get(object));
                }
                long l3 = System.currentTimeMillis();
                l = l2 = BinaryClient.this.pool.getMaxBusy();
                while (this.numConns > 0 && l > 0L) {
                    int n = this.selector.select(Math.min(l2, 5000L));
                    if (n > 0) {
                        Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                        while (iterator.hasNext()) {
                            SelectionKey selectionKey = iterator.next();
                            iterator.remove();
                            this.handleKey(selectionKey);
                        }
                    } else if (MemCachedClient.log.isErrorEnabled()) {
                        MemCachedClient.log.error("selector timed out waiting for activity");
                    }
                    l = l2 - (System.currentTimeMillis() - l3);
                }
            }
            catch (IOException iOException) {
                if (MemCachedClient.log.isErrorEnabled()) {
                    MemCachedClient.log.error("Caught the exception on " + iOException);
                }
                return;
            }
            finally {
                try {
                    if (this.selector != null) {
                        this.selector.close();
                    }
                }
                catch (IOException iOException) {}
                for (Connection connection : this.conns) {
                    if (connection == null) continue;
                    connection.close();
                }
            }
            for (Connection connection : this.conns) {
                try {
                    if (connection.incoming.size() <= 0 || !connection.isDone()) continue;
                    BinaryClient.this.loadMulti(new DataInputStream(new ByteBufArrayInputStream(connection.incoming)), map2);
                }
                catch (Exception exception) {
                    if (!MemCachedClient.log.isDebugEnabled()) continue;
                    MemCachedClient.log.debug("Caught the aforementioned exception on " + connection);
                }
            }
        }

        private void handleKey(SelectionKey selectionKey) throws IOException {
            if (selectionKey.isReadable()) {
                this.readResponse(selectionKey);
            } else if (selectionKey.isWritable()) {
                this.writeRequest(selectionKey);
            }
        }

        public void writeRequest(SelectionKey selectionKey) throws IOException {
            ByteBuffer byteBuffer = ((Connection)selectionKey.attachment()).outgoing;
            SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
            if (byteBuffer.hasRemaining()) {
                socketChannel.write(byteBuffer);
            }
            if (!byteBuffer.hasRemaining()) {
                selectionKey.interestOps(1);
            }
        }

        public void readResponse(SelectionKey selectionKey) throws IOException {
            Connection connection = (Connection)selectionKey.attachment();
            ByteBuffer byteBuffer = connection.getBuffer();
            int n = connection.channel.read(byteBuffer);
            if (n > 0 && connection.isDone()) {
                selectionKey.cancel();
                --this.numConns;
                return;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class Connection {
            public List<ByteBuffer> incoming = new ArrayList<ByteBuffer>();
            public ByteBuffer outgoing;
            public SchoonerSockIO sock;
            public SocketChannel channel;
            private boolean isDone = false;
            private final byte[] NOOPFLAG = new byte[]{-127, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

            public Connection(SchoonerSockIO schoonerSockIO, ArrayList<String> arrayList) throws IOException {
                byte[] byArray;
                this.sock = schoonerSockIO;
                ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>(arrayList.size());
                int n = 0;
                for (String string : arrayList) {
                    byArray = string.getBytes();
                    arrayList2.add(byArray);
                    n += byArray.length;
                }
                this.outgoing = ByteBuffer.allocateDirect(n += (arrayList2.size() + 1) * 24);
                this.outgoing.clear();
                for (String string : arrayList) {
                    byArray = string.getBytes();
                    this.outgoing.put((byte)-128);
                    this.outgoing.put((byte)13);
                    this.outgoing.putShort((short)byArray.length);
                    this.outgoing.putInt(0);
                    this.outgoing.putInt(byArray.length);
                    this.outgoing.putInt(0);
                    this.outgoing.putLong(0L);
                    this.outgoing.put(byArray);
                }
                this.outgoing.put((byte)-128);
                this.outgoing.put((byte)10);
                this.outgoing.putShort((short)0);
                this.outgoing.putInt(0);
                this.outgoing.putLong(0L);
                this.outgoing.putLong(0L);
                this.outgoing.flip();
                this.channel = schoonerSockIO.getChannel();
                if (this.channel == null) {
                    throw new IOException("dead connection to: " + schoonerSockIO.getHost());
                }
                this.channel.configureBlocking(false);
                this.channel.register(NIOLoader.this.selector, 4, this);
            }

            public void close() {
                block6: {
                    block5: {
                        try {
                            if (this.isDone) {
                                this.channel.configureBlocking(true);
                                this.sock.close();
                                return;
                            }
                        }
                        catch (IOException iOException) {
                            if (!MemCachedClient.log.isErrorEnabled()) break block5;
                            MemCachedClient.log.warn("++++ memcache: unexpected error closing normally");
                        }
                    }
                    try {
                        this.sock.sockets.invalidateObject((Object)this.sock);
                    }
                    catch (Exception exception) {
                        if (!MemCachedClient.log.isErrorEnabled()) break block6;
                        MemCachedClient.log.error("++++ failed to close socket : " + this.sock.toString());
                    }
                }
            }

            public boolean isDone() {
                if (this.isDone) {
                    return true;
                }
                int n = this.NOOPFLAG.length - 1;
                for (int i = this.incoming.size() - 1; i >= 0 && n >= 0; --i) {
                    ByteBuffer byteBuffer = this.incoming.get(i);
                    int n2 = byteBuffer.position() - 1;
                    while (n2 >= 0 && n >= 0) {
                        if (byteBuffer.get(n2--) == this.NOOPFLAG[n--]) continue;
                        return false;
                    }
                }
                this.isDone = n < 0;
                return this.isDone;
            }

            public ByteBuffer getBuffer() {
                int n = this.incoming.size() - 1;
                if (n >= 0 && this.incoming.get(n).hasRemaining()) {
                    return this.incoming.get(n);
                }
                ByteBuffer byteBuffer = ByteBuffer.allocate(8192);
                this.incoming.add(byteBuffer);
                return byteBuffer;
            }

            public String toString() {
                return new StringBuffer().append("Connection to ").append(this.sock.getHost()).append(" with ").append(this.incoming.size()).append(" bufs; done is ").append(this.isDone).toString();
            }
        }
    }
}

