/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.page;

import com.github.pagehelper.PageException;
import com.github.pagehelper.dialect.AbstractHelperDialect;
import com.github.pagehelper.dialect.helper.Db2Dialect;
import com.github.pagehelper.dialect.helper.HsqldbDialect;
import com.github.pagehelper.dialect.helper.InformixDialect;
import com.github.pagehelper.dialect.helper.MySqlDialect;
import com.github.pagehelper.dialect.helper.OracleDialect;
import com.github.pagehelper.dialect.helper.SqlServer2012Dialect;
import com.github.pagehelper.dialect.helper.SqlServerDialect;
import com.github.pagehelper.util.StringUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import org.apache.ibatis.mapping.MappedStatement;

public class PageAutoDialect {
    private static Map<String, Class<?>> dialectAliasMap = new HashMap();
    private boolean autoDialect = true;
    private boolean closeConn = true;
    private Properties properties;
    private Map<String, AbstractHelperDialect> urlDialectMap = new ConcurrentHashMap<String, AbstractHelperDialect>();
    private ReentrantLock lock = new ReentrantLock();
    private AbstractHelperDialect delegate;
    private ThreadLocal<AbstractHelperDialect> dialectThreadLocal = new ThreadLocal();

    public void initDelegateDialect(MappedStatement ms) {
        if (this.delegate == null) {
            if (this.autoDialect) {
                this.delegate = this.getDialect(ms);
            } else {
                this.dialectThreadLocal.set(this.getDialect(ms));
            }
        }
    }

    public AbstractHelperDialect getDelegate() {
        if (this.delegate != null) {
            return this.delegate;
        }
        return this.dialectThreadLocal.get();
    }

    public void clearDelegate() {
        this.dialectThreadLocal.remove();
    }

    private String fromJdbcUrl(String jdbcUrl) {
        for (String dialect : dialectAliasMap.keySet()) {
            if (jdbcUrl.indexOf(":" + dialect + ":") == -1) continue;
            return dialect;
        }
        return null;
    }

    private Class resloveDialectClass(String className) throws Exception {
        if (dialectAliasMap.containsKey(className.toLowerCase())) {
            return dialectAliasMap.get(className.toLowerCase());
        }
        return Class.forName(className);
    }

    private AbstractHelperDialect initDialect(String dialectClass, Properties properties) {
        AbstractHelperDialect dialect;
        if (StringUtil.isEmpty(dialectClass)) {
            throw new PageException("\u4f7f\u7528 PageHelper \u5206\u9875\u63d2\u4ef6\u65f6\uff0c\u5fc5\u987b\u8bbe\u7f6e helper \u5c5e\u6027");
        }
        try {
            Class sqlDialectClass = this.resloveDialectClass(dialectClass);
            if (!AbstractHelperDialect.class.isAssignableFrom(sqlDialectClass)) {
                throw new PageException("\u4f7f\u7528 PageHelper \u65f6\uff0c\u65b9\u8a00\u5fc5\u987b\u662f\u5b9e\u73b0 " + AbstractHelperDialect.class.getCanonicalName() + " \u63a5\u53e3\u7684\u5b9e\u73b0\u7c7b!");
            }
            dialect = (AbstractHelperDialect)sqlDialectClass.newInstance();
        }
        catch (Exception e) {
            throw new PageException("\u521d\u59cb\u5316 helper [" + dialectClass + "]\u65f6\u51fa\u9519:" + e.getMessage(), e);
        }
        dialect.setProperties(properties);
        return dialect;
    }

    private String getUrl(DataSource dataSource) {
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            String string = conn.getMetaData().getURL();
            return string;
        }
        catch (SQLException e) {
            throw new PageException(e);
        }
        finally {
            if (conn != null) {
                try {
                    if (this.closeConn) {
                        conn.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractHelperDialect getDialect(MappedStatement ms) {
        DataSource dataSource = ms.getConfiguration().getEnvironment().getDataSource();
        String url = this.getUrl(dataSource);
        if (this.urlDialectMap.containsKey(url)) {
            return this.urlDialectMap.get(url);
        }
        try {
            this.lock.lock();
            if (this.urlDialectMap.containsKey(url)) {
                AbstractHelperDialect abstractHelperDialect = this.urlDialectMap.get(url);
                return abstractHelperDialect;
            }
            if (StringUtil.isEmpty(url)) {
                throw new PageException("\u65e0\u6cd5\u81ea\u52a8\u83b7\u53d6jdbcUrl\uff0c\u8bf7\u5728\u5206\u9875\u63d2\u4ef6\u4e2d\u914d\u7f6edialect\u53c2\u6570!");
            }
            String dialectStr = this.fromJdbcUrl(url);
            if (dialectStr == null) {
                throw new PageException("\u65e0\u6cd5\u81ea\u52a8\u83b7\u53d6\u6570\u636e\u5e93\u7c7b\u578b\uff0c\u8bf7\u901a\u8fc7 helperDialect \u53c2\u6570\u6307\u5b9a!");
            }
            AbstractHelperDialect dialect = this.initDialect(dialectStr, this.properties);
            this.urlDialectMap.put(url, dialect);
            AbstractHelperDialect abstractHelperDialect = dialect;
            return abstractHelperDialect;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setProperties(Properties properties) {
        String closeConn = properties.getProperty("closeConn");
        if (StringUtil.isNotEmpty(closeConn)) {
            this.closeConn = Boolean.parseBoolean(closeConn);
        }
        String dialect = properties.getProperty("helperDialect");
        String runtimeDialect = properties.getProperty("autoRuntimeDialect");
        if (StringUtil.isNotEmpty(runtimeDialect) && runtimeDialect.equalsIgnoreCase("TRUE")) {
            this.autoDialect = false;
            this.properties = properties;
        } else if (StringUtil.isEmpty(dialect)) {
            this.autoDialect = true;
            this.properties = properties;
        } else {
            this.autoDialect = false;
            this.delegate = this.initDialect(dialect, properties);
        }
    }

    static {
        dialectAliasMap.put("hsqldb", HsqldbDialect.class);
        dialectAliasMap.put("h2", HsqldbDialect.class);
        dialectAliasMap.put("postgresql", HsqldbDialect.class);
        dialectAliasMap.put("mysql", MySqlDialect.class);
        dialectAliasMap.put("mariadb", MySqlDialect.class);
        dialectAliasMap.put("sqlite", MySqlDialect.class);
        dialectAliasMap.put("oracle", OracleDialect.class);
        dialectAliasMap.put("db2", Db2Dialect.class);
        dialectAliasMap.put("informix", InformixDialect.class);
        dialectAliasMap.put("sqlserver", SqlServerDialect.class);
        dialectAliasMap.put("sqlserver2012", SqlServer2012Dialect.class);
        dialectAliasMap.put("derby", SqlServer2012Dialect.class);
    }
}

