/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hdgf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.hdgf.HDGFLZW;

final class HDGFLZWCompressor {
    byte[] dict = new byte[4096];
    byte[] buffer = new byte[16];
    int bufferLen = 0;
    byte[] rawCode = new byte[18];
    int rawCodeLen = 0;
    int posInp = 0;
    int posOut = 0;
    int nextMask = 0;
    int maskBitsSet = 0;

    private int findRawCodeInBuffer() {
        for (int i = 4096 - this.rawCodeLen; i > 0; --i) {
            boolean matches = true;
            for (int j = 0; matches && j < this.rawCodeLen; ++j) {
                if (this.dict[i + j] == this.rawCode[j]) continue;
                matches = false;
            }
            if (!matches) continue;
            return i;
        }
        return -1;
    }

    private void outputCompressed(OutputStream res) throws IOException {
        if (this.rawCodeLen < 3) {
            for (int i = 0; i < this.rawCodeLen; ++i) {
                this.outputUncompressed(this.rawCode[i], res);
            }
            return;
        }
        int codesAt = this.findRawCodeInBuffer();
        if ((codesAt -= 18) < 0) {
            codesAt += 4096;
        }
        ++this.maskBitsSet;
        int bp1 = codesAt & 0xFF;
        int bp2 = this.rawCodeLen - 3 + (codesAt - bp1 >> 4);
        this.buffer[this.bufferLen] = HDGFLZW.fromInt((int)bp1);
        ++this.bufferLen;
        this.buffer[this.bufferLen] = HDGFLZW.fromInt((int)bp2);
        ++this.bufferLen;
        for (int i = 0; i < this.rawCodeLen; ++i) {
            this.dict[this.posOut & 0xFFF] = this.rawCode[i];
            ++this.posOut;
        }
        if (this.maskBitsSet == 8) {
            this.output8Codes(res);
        }
    }

    private void outputUncompressed(byte b, OutputStream res) throws IOException {
        this.nextMask += 1 << this.maskBitsSet;
        ++this.maskBitsSet;
        this.buffer[this.bufferLen] = b;
        ++this.bufferLen;
        this.dict[this.posOut & 0xFFF] = b;
        ++this.posOut;
        if (this.maskBitsSet == 8) {
            this.output8Codes(res);
        }
    }

    private void output8Codes(OutputStream res) throws IOException {
        res.write(new byte[]{HDGFLZW.fromInt((int)this.nextMask)});
        res.write(this.buffer, 0, this.bufferLen);
        this.nextMask = 0;
        this.maskBitsSet = 0;
        this.bufferLen = 0;
    }

    public void compress(InputStream src, OutputStream res) throws IOException {
        boolean going = true;
        while (going) {
            int dataI = src.read();
            ++this.posInp;
            if (dataI == -1) {
                going = false;
            }
            byte dataB = HDGFLZW.fromInt((int)dataI);
            if (!going) {
                if (this.rawCodeLen <= 0) break;
                this.outputCompressed(res);
                if (this.maskBitsSet <= 0) break;
                this.output8Codes(res);
                break;
            }
            this.rawCode[this.rawCodeLen] = dataB;
            ++this.rawCodeLen;
            int rawAt = this.findRawCodeInBuffer();
            if (this.rawCodeLen == 18 && rawAt > -1) {
                this.outputCompressed(res);
                this.rawCodeLen = 0;
                continue;
            }
            if (rawAt > -1) continue;
            --this.rawCodeLen;
            if (this.rawCodeLen > 0) {
                this.outputCompressed(res);
                this.rawCode[0] = dataB;
                this.rawCodeLen = 1;
                if (this.findRawCodeInBuffer() > -1) continue;
                this.outputUncompressed(dataB, res);
                this.rawCodeLen = 0;
                continue;
            }
            this.outputUncompressed(dataB, res);
        }
    }
}

