/*
 * Decompiled with CFR 0.152.
 */
package javazoom.upload;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javazoom.upload.DBStore;
import javazoom.upload.UploadBean;
import javazoom.upload.UploadException;
import javazoom.upload.UploadFile;

public class DefaultDBStore
extends DBStore {
    public static final String CUSTOMCOLUMN = "dbstore.customcolumn";
    public static final String CUSTOMFILESIZE = "dbstore.filesize";
    public static final String CUSTOMFILETYPE = "dbstore.filetype";
    public static final String CUSTOMUPLOADID = "dbstore.uploadid";
    private int _$280 = -1;

    public void connect(Object object, Object object2, Object object3) throws UploadException {
        if (object instanceof Connection) {
            super.setConnection((Connection)object);
        } else {
            String string = (String)object;
            String string2 = (String)object2;
            Properties properties = (Properties)object3;
            Connection connection = null;
            try {
                Class.forName(string);
                connection = DriverManager.getConnection(string2, properties);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new UploadException(classNotFoundException);
            }
            catch (SQLException sQLException) {
                throw new UploadException(sQLException);
            }
            super.setConnection(connection);
        }
    }

    public int countFiles() throws UploadException {
        if (this.getConnection() != null) {
            String string = "SELECT COUNT(*) FROM " + UploadBean.SQLUPLOADTABLE;
            int n = 0;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                try {
                    statement = this.getConnection().createStatement();
                    resultSet = statement.executeQuery(string);
                    while (resultSet.next()) {
                        n = resultSet.getInt(1);
                    }
                }
                catch (SQLException sQLException) {
                    throw new UploadException(sQLException);
                }
                Object var7_5 = null;
                this.closeResultSet(resultSet);
                this.closeStatement(statement);
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                this.closeResultSet(resultSet);
                this.closeStatement(statement);
                throw throwable;
            }
            return n;
        }
        return -1;
    }

    protected void delete(UploadFile uploadFile, Map map) throws UploadException {
        String string = (String)map.get("dbstore.customtable");
        if (string == null) {
            string = UploadBean.SQLUPLOADTABLE;
        }
        String string2 = UploadBean.SQLUPLOADFILENAME;
        String string3 = uploadFile.getFileName();
        if (map.get("dbstore.update.filterfield") != null) {
            string2 = (String)map.get("dbstore.update.filterfield");
        }
        if (map.get("dbstore.update.filtervalue") != null) {
            string3 = (String)map.get("dbstore.update.filtervalue");
        }
        String string4 = "DELETE FROM " + string + " WHERE " + string2 + " = ?";
        PreparedStatement preparedStatement = null;
        try {
            try {
                preparedStatement = this.getConnection().prepareStatement(string4);
                preparedStatement.setObject(1, string3);
                int n = preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException) {
                throw new UploadException(sQLException);
            }
            Object var10_10 = null;
            this.closeStatement(preparedStatement);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.closeStatement(preparedStatement);
            throw throwable;
        }
    }

    public Connection getConnection() {
        return super.getConnection();
    }

    protected List getCustomColumnsName(Map map) {
        ArrayList<String> arrayList = null;
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!string.startsWith(CUSTOMCOLUMN)) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                String string2 = string.substring(CUSTOMCOLUMN.length() + 1, string.length());
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    protected List getCustomColumnsValue(List list, Map map) {
        ArrayList arrayList = null;
        if (map != null && list != null && list.size() > 0) {
            arrayList = new ArrayList();
            int n = 0;
            while (n < list.size()) {
                arrayList.add(map.get("dbstore.customcolumn." + list.get(n)));
                ++n;
            }
        }
        return arrayList;
    }

    protected long getFilesize(UploadFile uploadFile, Map map) {
        String string;
        long l = -1L;
        if (map != null && (string = (String)map.get(CUSTOMFILESIZE)) != null && string.equalsIgnoreCase("enabled")) {
            l = uploadFile.getFileSize();
        }
        return l;
    }

    protected String getFiletype(UploadFile uploadFile, Map map) {
        String string;
        String string2 = null;
        if (map != null && (string = (String)map.get(CUSTOMFILETYPE)) != null && string.equalsIgnoreCase("enabled")) {
            string2 = uploadFile.getContentType();
        }
        return string2;
    }

    public int getLastId() {
        return this._$280;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void insert(UploadFile uploadFile, Map map) throws UploadException {
        Object object;
        Object var3_3 = null;
        String string = (String)map.get("dbstore.customtable");
        if (string == null) {
            string = UploadBean.SQLUPLOADTABLE;
        }
        String string2 = this.getFiletype(uploadFile, map);
        long l = this.getFilesize(uploadFile, map);
        List list = this.getCustomColumnsName(map);
        List list2 = this.getCustomColumnsValue(list, map);
        if (map != null) {
            var3_3 = map.get(CUSTOMUPLOADID);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ").append(string);
        stringBuffer.append(" (").append(UploadBean.SQLUPLOADID);
        stringBuffer.append(",").append(UploadBean.SQLUPLOADFILENAME);
        stringBuffer.append(",").append(UploadBean.SQLUPLOADFILE);
        if (string2 != null) {
            stringBuffer.append(",").append(UploadBean.SQLUPLOADFILETYPE);
        }
        if (l > 0L) {
            stringBuffer.append(",").append(UploadBean.SQLUPLOADFILESIZE);
        }
        if (list != null && list.size() > 0) {
            object = list.iterator();
            while (object.hasNext()) {
                stringBuffer.append(",").append((String)object.next());
            }
        }
        stringBuffer.append(") VALUES (?,?,?");
        if (string2 != null) {
            stringBuffer.append(",?");
        }
        if (l > 0L) {
            stringBuffer.append(",?");
        }
        if (list != null && list.size() > 0) {
            int n = 0;
            while (n < list.size()) {
                stringBuffer.append(",?");
                ++n;
            }
        }
        stringBuffer.append(")");
        object = stringBuffer.toString();
        PreparedStatement preparedStatement = null;
        InputStream inputStream = null;
        try {
            try {
                preparedStatement = this.getConnection().prepareStatement((String)object);
                if (var3_3 != null) {
                    preparedStatement.setObject(1, var3_3);
                } else {
                    this._$280 = (int)System.currentTimeMillis();
                    preparedStatement.setInt(1, this._$280);
                }
                preparedStatement.setString(2, uploadFile.getFileName());
                if (UploadBean.INSERTASBYTES) {
                    preparedStatement.setBytes(3, uploadFile.getData());
                    inputStream = uploadFile.getInpuStream();
                } else {
                    inputStream = uploadFile.getInpuStream();
                    preparedStatement.setBinaryStream(3, inputStream, (int)uploadFile.getFileSize());
                }
                int n = 4;
                if (string2 != null) {
                    preparedStatement.setString(n++, string2);
                }
                if (l > 0L) {
                    preparedStatement.setInt(n++, (int)l);
                }
                if (list2 != null && list2.size() > 0) {
                    Iterator iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        preparedStatement.setObject(n++, iterator.next());
                    }
                }
                int n2 = preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException) {
                throw new UploadException(sQLException);
            }
            Object var17_18 = null;
            this.closeStatement(preparedStatement);
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            this.closeStatement(preparedStatement);
            try {
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (inputStream == null) return;
        inputStream.close();
        return;
    }

    public void reset() throws UploadException {
        if (this.getConnection() != null) {
            String string = "DELETE FROM " + UploadBean.SQLUPLOADTABLE;
            Statement statement = null;
            try {
                try {
                    statement = this.getConnection().createStatement();
                    int n = statement.executeUpdate(string);
                }
                catch (SQLException sQLException) {
                    throw new UploadException(sQLException);
                }
                Object var5_5 = null;
                this.closeStatement(statement);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.closeStatement(statement);
                throw throwable;
            }
        }
    }

    public void store(UploadFile uploadFile, boolean bl, Map map) throws UploadException {
        if (!bl) {
            this.insert(uploadFile, map);
        } else {
            String string = (String)map.get("dbstore.customtable");
            if (string == null) {
                string = UploadBean.SQLUPLOADTABLE;
            }
            String string2 = UploadBean.SQLUPLOADFILENAME;
            String string3 = uploadFile.getFileName();
            if (map.get("dbstore.update.filterfield") != null) {
                string2 = (String)map.get("dbstore.update.filterfield");
            }
            if (map.get("dbstore.update.filtervalue") != null) {
                string3 = (String)map.get("dbstore.update.filtervalue");
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT COUNT(*) FROM ").append(string).append(" WHERE ");
            stringBuffer.append(string2).append("='").append(string3).append("'");
            String string4 = stringBuffer.toString();
            int n = 0;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                try {
                    statement = this.getConnection().createStatement();
                    resultSet = statement.executeQuery(string4);
                    while (resultSet.next()) {
                        n = resultSet.getInt(1);
                    }
                }
                catch (SQLException sQLException) {
                    throw new UploadException(sQLException);
                }
                Object var14_12 = null;
                this.closeResultSet(resultSet);
                this.closeStatement(statement);
            }
            catch (Throwable throwable) {
                Object var14_13 = null;
                this.closeResultSet(resultSet);
                this.closeStatement(statement);
                throw throwable;
            }
            if (n > 0) {
                if (n > 1) {
                    this.delete(uploadFile, map);
                    this.insert(uploadFile, map);
                } else if (n == 1) {
                    this.update(uploadFile, map);
                }
            } else {
                this.insert(uploadFile, map);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void update(UploadFile uploadFile, Map map) throws UploadException {
        Object object;
        String string = (String)map.get("dbstore.customtable");
        if (string == null) {
            string = UploadBean.SQLUPLOADTABLE;
        }
        long l = this.getFilesize(uploadFile, map);
        String string2 = this.getFiletype(uploadFile, map);
        List list = this.getCustomColumnsName(map);
        List list2 = this.getCustomColumnsValue(list, map);
        String string3 = UploadBean.SQLUPLOADFILENAME;
        String string4 = uploadFile.getFileName();
        if (map.get("dbstore.update.filterfield") != null) {
            string3 = (String)map.get("dbstore.update.filterfield");
        }
        if (map.get("dbstore.update.filtervalue") != null) {
            string4 = (String)map.get("dbstore.update.filtervalue");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ").append(string).append(" SET ");
        stringBuffer.append(UploadBean.SQLUPLOADFILENAME).append(" = ?");
        stringBuffer.append(", ").append(UploadBean.SQLUPLOADFILE).append(" = ?");
        if (string2 != null) {
            stringBuffer.append(", ").append(UploadBean.SQLUPLOADFILETYPE).append(" = ?");
        }
        if (l > 0L) {
            stringBuffer.append(", ").append(UploadBean.SQLUPLOADFILESIZE).append(" = ?");
        }
        if (list != null && list.size() > 0) {
            object = list.iterator();
            while (object.hasNext()) {
                stringBuffer.append(", ").append((String)object.next()).append(" = ?");
            }
        }
        stringBuffer.append(" WHERE ").append(string3).append(" = ?");
        object = stringBuffer.toString();
        PreparedStatement preparedStatement = null;
        InputStream inputStream = null;
        try {
            try {
                int n = 1;
                preparedStatement = this.getConnection().prepareStatement((String)object);
                preparedStatement.setObject(n++, uploadFile.getFileName());
                if (UploadBean.INSERTASBYTES) {
                    preparedStatement.setBytes(n++, uploadFile.getData());
                    inputStream = uploadFile.getInpuStream();
                } else {
                    inputStream = uploadFile.getInpuStream();
                    preparedStatement.setBinaryStream(n++, inputStream, (int)uploadFile.getFileSize());
                }
                if (string2 != null) {
                    preparedStatement.setString(n++, string2);
                }
                if (l > 0L) {
                    preparedStatement.setInt(n++, (int)l);
                }
                if (list2 != null && list2.size() > 0) {
                    Iterator iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        preparedStatement.setObject(n++, iterator.next());
                    }
                }
                preparedStatement.setObject(n++, string4);
                int n2 = preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException) {
                throw new UploadException(sQLException);
            }
            Object var18_18 = null;
            this.closeStatement(preparedStatement);
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            this.closeStatement(preparedStatement);
            try {
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (inputStream == null) return;
        inputStream.close();
        return;
    }
}

