/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import com.google.zxing.Binarizer;
import com.google.zxing.LuminanceSource;
import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;

public class GlobalHistogramBinarizer
extends Binarizer {
    private static final int LUMINANCE_BITS = 5;
    private static final int LUMINANCE_SHIFT = 3;
    private static final int LUMINANCE_BUCKETS = 32;
    private static final byte[] EMPTY = new byte[0];
    private byte[] luminances = EMPTY;
    private final int[] buckets = new int[32];

    public GlobalHistogramBinarizer(LuminanceSource source) {
        super(source);
    }

    @Override
    public BitArray getBlackRow(int y, BitArray row) throws NotFoundException {
        LuminanceSource source = this.getLuminanceSource();
        int width = source.getWidth();
        if (row == null || row.getSize() < width) {
            row = new BitArray(width);
        } else {
            row.clear();
        }
        this.initArrays(width);
        byte[] localLuminances = source.getRow(y, this.luminances);
        int[] localBuckets = this.buckets;
        int x = 0;
        while (x < width) {
            int pixel = localLuminances[x] & 0xFF;
            int n = pixel >> 3;
            localBuckets[n] = localBuckets[n] + 1;
            ++x;
        }
        int blackPoint = GlobalHistogramBinarizer.estimateBlackPoint(localBuckets);
        int left = localLuminances[0] & 0xFF;
        int center = localLuminances[1] & 0xFF;
        int x2 = 1;
        while (x2 < width - 1) {
            int right = localLuminances[x2 + 1] & 0xFF;
            int luminance = (center * 4 - left - right) / 2;
            if (luminance < blackPoint) {
                row.set(x2);
            }
            left = center;
            center = right;
            ++x2;
        }
        return row;
    }

    @Override
    public BitMatrix getBlackMatrix() throws NotFoundException {
        int pixel;
        int x;
        LuminanceSource source = this.getLuminanceSource();
        int width = source.getWidth();
        int height = source.getHeight();
        BitMatrix matrix = new BitMatrix(width, height);
        this.initArrays(width);
        int[] localBuckets = this.buckets;
        int y = 1;
        while (y < 5) {
            int row = height * y / 5;
            byte[] localLuminances = source.getRow(row, this.luminances);
            int right = width * 4 / 5;
            x = width / 5;
            while (x < right) {
                pixel = localLuminances[x] & 0xFF;
                int n = pixel >> 3;
                localBuckets[n] = localBuckets[n] + 1;
                ++x;
            }
            ++y;
        }
        int blackPoint = GlobalHistogramBinarizer.estimateBlackPoint(localBuckets);
        byte[] localLuminances = source.getMatrix();
        int y2 = 0;
        while (y2 < height) {
            int offset = y2 * width;
            x = 0;
            while (x < width) {
                pixel = localLuminances[offset + x] & 0xFF;
                if (pixel < blackPoint) {
                    matrix.set(x, y2);
                }
                ++x;
            }
            ++y2;
        }
        return matrix;
    }

    @Override
    public Binarizer createBinarizer(LuminanceSource source) {
        return new GlobalHistogramBinarizer(source);
    }

    private void initArrays(int luminanceSize) {
        if (this.luminances.length < luminanceSize) {
            this.luminances = new byte[luminanceSize];
        }
        int x = 0;
        while (x < 32) {
            this.buckets[x] = 0;
            ++x;
        }
    }

    private static int estimateBlackPoint(int[] buckets) throws NotFoundException {
        int numBuckets = buckets.length;
        int maxBucketCount = 0;
        int firstPeak = 0;
        int firstPeakSize = 0;
        int x = 0;
        while (x < numBuckets) {
            if (buckets[x] > firstPeakSize) {
                firstPeak = x;
                firstPeakSize = buckets[x];
            }
            if (buckets[x] > maxBucketCount) {
                maxBucketCount = buckets[x];
            }
            ++x;
        }
        int secondPeak = 0;
        int secondPeakScore = 0;
        int x2 = 0;
        while (x2 < numBuckets) {
            int distanceToBiggest = x2 - firstPeak;
            int score = buckets[x2] * distanceToBiggest * distanceToBiggest;
            if (score > secondPeakScore) {
                secondPeak = x2;
                secondPeakScore = score;
            }
            ++x2;
        }
        if (firstPeak > secondPeak) {
            int temp = firstPeak;
            firstPeak = secondPeak;
            secondPeak = temp;
        }
        if (secondPeak - firstPeak <= numBuckets / 16) {
            throw NotFoundException.getNotFoundInstance();
        }
        int bestValley = secondPeak - 1;
        int bestValleyScore = -1;
        int x3 = secondPeak - 1;
        while (x3 > firstPeak) {
            int fromFirst = x3 - firstPeak;
            int score = fromFirst * fromFirst * (secondPeak - x3) * (maxBucketCount - buckets[x3]);
            if (score > bestValleyScore) {
                bestValley = x3;
                bestValleyScore = score;
            }
            --x3;
        }
        return bestValley << 3;
    }
}

