/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.code128;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.impl.code128.Code128;
import org.krysalis.barcode4j.impl.code128.EAN128Bean;
import org.krysalis.barcode4j.tools.Length;

public class EAN128
extends Code128
implements Configurable {
    public EAN128() {
        this.bean = new EAN128Bean();
    }

    public EAN128Bean getEAN128Bean() {
        return (EAN128Bean)this.getBean();
    }

    public void configure(Configuration cfg) throws ConfigurationException {
        Length mw = new Length(cfg.getChild("module-width").getValue("0.21mm"), "mm");
        this.getEAN128Bean().setModuleWidth(mw.getValueAsMillimeter());
        super.configure(cfg);
        this.getEAN128Bean().setChecksumMode(ChecksumMode.byName(cfg.getChild("checksum").getValue(ChecksumMode.CP_AUTO.getName())));
        this.getEAN128Bean().setCheckDigitMarker(this.getFirstChar(cfg.getChild("check-digit-marker").getValue("\u00f0")));
        this.getEAN128Bean().setTemplate(cfg.getChild("template").getValue(""));
        this.getEAN128Bean().setGroupSeparator(this.getFirstChar(cfg.getChild("group-separator").getValue("\u00f1")));
        Configuration hr = cfg.getChild("human-readable", false);
        if (hr != null) {
            this.getEAN128Bean().setOmitBrackets(hr.getChild("omit-brackets").getValueAsBoolean(false));
        }
    }

    private char getFirstChar(String s) {
        if ((s = s.trim()) != null && s.length() > 0) {
            return s.charAt(0);
        }
        throw new IllegalArgumentException("Value must have at least one character");
    }
}

