/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.code128;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;

public class EAN128AI {
    public static final byte CONSTLenMax = 48;
    public static final byte TYPEAlphaNum = 0;
    public static final byte TYPENum = 1;
    public static final byte TYPEAlpha = 2;
    public static final byte TYPENumDate = 3;
    public static final byte TYPEError = 4;
    public static final byte TYPECD = 5;
    private static final String[] typeToString;
    String id;
    byte lenID;
    byte lenMinAll;
    byte lenMaxAll;
    byte minLenAfterVariableLen;
    byte[] lenMin;
    byte[] lenMax;
    byte[] type;
    byte[] checkDigitStart;
    boolean fixed = false;
    boolean canDoChecksumADD = false;
    private static String[] fixedLenTable;
    private static byte[] fixedLenValueTable;
    private static EAN128AI dft;
    private static Object[] aiTable;
    private static boolean propertiesLoaded;
    static /* synthetic */ Class class$org$krysalis$barcode4j$impl$code128$EAN128AI;

    private static void initFixedLen(String aiName, byte aiLen) {
        byte lenID = (byte)aiName.length();
        EAN128AI ai = new EAN128AI(aiName, "an" + aiLen, lenID, 0, aiLen);
        try {
            EAN128AI.setAI(aiName, ai);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void loadProperties() {
        if (propertiesLoaded) {
            return;
        }
        String filename = "EAN128AIs.properties";
        AIProperties p = new AIProperties();
        try {
            InputStream is = (class$org$krysalis$barcode4j$impl$code128$EAN128AI == null ? (class$org$krysalis$barcode4j$impl$code128$EAN128AI = EAN128AI.class$("org.krysalis.barcode4j.impl.code128.EAN128AI")) : class$org$krysalis$barcode4j$impl$code128$EAN128AI).getResourceAsStream("EAN128AIs.properties");
            if (is == null) {
                throw new FileNotFoundException("EAN128AIs.properties could not be loaded!");
            }
            try {
                p.load(is);
            }
            finally {
                is.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        propertiesLoaded = true;
    }

    private EAN128AI(String id, byte lenID, byte[] type, byte[] lenMin, byte[] lenMax, byte[] checkDigitStart) {
        this.id = id;
        this.lenID = lenID;
        this.type = type;
        this.lenMin = lenMin;
        this.lenMax = lenMax;
        this.checkDigitStart = checkDigitStart;
        this.minLenAfterVariableLen = 0;
        this.lenMaxAll = 0;
        this.lenMinAll = 0;
        int idxVarLen = type.length;
        int idxFirstChecksum = -1;
        for (int i = 0; i < type.length; ++i) {
            this.lenMinAll = (byte)(this.lenMinAll + lenMin[i]);
            this.lenMaxAll = (byte)(this.lenMaxAll + lenMax[i]);
            if (i > idxVarLen) {
                this.minLenAfterVariableLen = (byte)(this.minLenAfterVariableLen + lenMin[i]);
            }
            if (lenMin[i] != lenMax[i]) {
                if (idxVarLen < type.length) {
                    throw new IllegalArgumentException("Only one Part with var len!");
                }
                idxVarLen = i;
            }
            if (idxFirstChecksum != -1 || type[i] != 5) continue;
            idxFirstChecksum = i;
        }
        this.canDoChecksumADD = idxFirstChecksum == type.length - 1 && this.lenMinAll == this.lenMaxAll;
    }

    private EAN128AI(String id, String spec, byte lenID, byte type, byte len) {
        this(id, lenID, new byte[]{type}, new byte[]{len}, new byte[]{len}, new byte[]{0});
        this.fixed = true;
    }

    private static void checkFixed(EAN128AI aiNew, EAN128AI aiOld) {
        if (aiOld.fixed && !aiNew.fixed) {
            if (aiNew.lenMaxAll != aiNew.lenMinAll || aiNew.lenID + aiNew.lenMinAll != aiOld.lenID + aiOld.lenMinAll) {
                throw new IllegalArgumentException("AI \"" + aiNew.toString() + "\" must have fixed len: " + aiOld.lenID + "+" + aiOld.lenMin);
            }
            aiNew.fixed = true;
        }
    }

    private static void SetAIHere(EAN128AI ai, Object[] aitParent) {
        for (int idx = 0; idx <= 9; ++idx) {
            EAN128AI.SetAIHere(ai, aitParent, idx);
        }
    }

    private static void SetAIHere(EAN128AI aiNew, Object[] aitParent, int idx) {
        Object tmp = aitParent[idx];
        if (tmp instanceof EAN128AI) {
            EAN128AI aiOld = (EAN128AI)tmp;
            if (aiNew.type[0] == 4) {
                aiOld.type[0] = 4;
            } else {
                EAN128AI.checkFixed(aiNew, aiOld);
                aitParent[idx] = aiNew;
            }
        } else {
            EAN128AI.SetAIHere(aiNew, (Object[])tmp);
        }
    }

    private static void setAI(String aiName, EAN128AI ai) {
        int aiLastRelevantIdx;
        Object[] aitParent = aiTable;
        for (aiLastRelevantIdx = aiName.length() - 1; aiLastRelevantIdx >= 0 && !Character.isDigit(aiName.charAt(aiLastRelevantIdx)); --aiLastRelevantIdx) {
        }
        for (int i = 0; i <= aiLastRelevantIdx; ++i) {
            int idx = aiName.charAt(i) - 48;
            if (i == aiLastRelevantIdx) {
                EAN128AI.SetAIHere(ai, aitParent, idx);
                continue;
            }
            Object[] tmp = aitParent[idx];
            if (tmp instanceof EAN128AI) {
                aitParent[idx] = tmp = new Object[]{tmp, tmp, tmp, tmp, tmp, tmp, tmp, tmp, tmp, tmp};
            }
            aitParent = tmp;
        }
    }

    public static EAN128AI parseSpec(String ai, String spec) throws Exception {
        EAN128AI ret = EAN128AI.parseSpecPrivate(ai, spec);
        EAN128AI.checkAI(ret);
        return ret;
    }

    private static void parseSpecPrivate(int i, String spec, byte[] type, byte[] lenMin, byte[] lenMax, byte[] checkDigitStart) {
        int startLen = 0;
        checkDigitStart[i] = 1;
        if (spec.startsWith("an")) {
            type[i] = 0;
            startLen = 2;
        } else if (spec.startsWith("a")) {
            type[i] = 2;
            startLen = 1;
        } else {
            if (spec.startsWith("cd")) {
                type[i] = 5;
                if (spec.length() > 2) {
                    checkDigitStart[i] = Byte.parseByte(spec.substring(2));
                }
                lenMax[i] = 1;
                lenMin[i] = 1;
                return;
            }
            if (spec.startsWith("n")) {
                type[i] = 1;
                startLen = 1;
            } else if (spec.startsWith("d")) {
                type[i] = 3;
                startLen = 1;
            } else {
                if (spec.startsWith("e")) {
                    type[i] = 4;
                    lenMax[i] = 0;
                    lenMin[i] = 0;
                    return;
                }
                throw new IllegalArgumentException("Unknown type!");
            }
        }
        int hyphenIdx = spec.indexOf(45, startLen);
        if (hyphenIdx < 0) {
            lenMin[i] = lenMax[i] = Byte.parseByte(spec.substring(startLen));
        } else if (hyphenIdx == startLen) {
            lenMin[i] = 1;
            lenMax[i] = Byte.parseByte(spec.substring(startLen + 1));
        } else {
            lenMin[i] = Byte.parseByte(spec.substring(startLen, hyphenIdx));
            lenMax[i] = Byte.parseByte(spec.substring(hyphenIdx + 1));
        }
        if (type[i] == 3 && (lenMin[i] != 6 || lenMax[i] != 6)) {
            throw new IllegalArgumentException("Date Field must have length 6");
        }
    }

    private static EAN128AI parseSpecPrivate(String ai, String spec) {
        try {
            byte lenID = (byte)ai.trim().length();
            spec = spec.trim();
            StringTokenizer st = new StringTokenizer(spec, "+", false);
            int count = st.countTokens();
            byte[] type = new byte[count];
            byte[] checkDigitStart = new byte[count];
            byte[] lenMin = new byte[count];
            byte[] lenMax = new byte[count];
            for (int i = 0; i < count; ++i) {
                EAN128AI.parseSpecPrivate(i, st.nextToken(), type, lenMin, lenMax, checkDigitStart);
            }
            return new EAN128AI(ai, lenID, type, lenMin, lenMax, checkDigitStart);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot Parse AI: \"" + ai + "\" spec: \"" + spec + "\" ");
        }
    }

    public static boolean checkAI(EAN128AI ai) throws Exception {
        EAN128AI aiCompare = EAN128AI.getAIPrivate(ai.id + "0000", 0);
        EAN128AI.checkFixed(ai, aiCompare);
        return true;
    }

    public static EAN128AI getAI(String msg, int msgStart) throws Exception {
        EAN128AI.loadProperties();
        return EAN128AI.getAIPrivate(msg, msgStart);
    }

    private static EAN128AI getAIPrivate(String msg, int msgStart) throws Exception {
        EAN128AI ret = dft;
        Object o = aiTable;
        for (int i = 0; i < msg.length() - msgStart; ++i) {
            int c = EAN128AI.getIDChar(msg, msgStart + i) - 48;
            if ((o = o[c]) == null) {
                return dft;
            }
            if (!(o instanceof EAN128AI)) continue;
            ret = (EAN128AI)o;
            break;
        }
        return ret;
    }

    private static char getIDChar(String msg, int msgStart) {
        char ret;
        try {
            ret = msg.charAt(msgStart);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to read AI: Message too short!");
        }
        if (!Character.isDigit(ret)) {
            throw new IllegalArgumentException("Unable to read AI: Characters must be numerical!");
        }
        return ret;
    }

    public static final boolean isCheckDigitType(byte type) {
        return type == 5;
    }

    public final boolean isCheckDigit(byte idx) {
        return EAN128AI.isCheckDigitType(this.type[idx]);
    }

    public static final String getType(byte type) {
        String ret = "?";
        try {
            ret = typeToString[type];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append('(').append(this.id).append(")");
        for (int i = 0; i < this.lenMin.length; ++i) {
            if (i != 0) {
                ret.append('+');
            }
            ret.append(EAN128AI.getType(this.type[i]));
            if (this.type[i] >= 4) continue;
            ret.append(this.lenMin[i]);
            if (this.lenMin[i] == this.lenMax[i]) continue;
            ret.append('-').append(this.lenMax[i]);
        }
        ret.append(this.fixed ? " (fixed)" : "");
        return ret.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        int i;
        typeToString = new String[]{"an", "n", "a", "d", "e", "cd"};
        fixedLenTable = new String[]{"00", "01", "02", "03", "04", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "31", "32", "33", "34", "35", "36", "41"};
        fixedLenValueTable = new byte[]{20, 16, 16, 16, 18, 8, 8, 8, 8, 8, 8, 8, 8, 8, 4, 10, 10, 10, 10, 10, 10, 16};
        dft = EAN128AI.parseSpecPrivate("xx", "an1-48");
        aiTable = new Object[]{dft, dft, dft, dft, dft, dft, dft, dft, dft, dft};
        propertiesLoaded = false;
        for (i = 0; i <= 9; ++i) {
            EAN128AI.initFixedLen("23" + i, (byte)(1 + 9 * i));
        }
        for (i = fixedLenValueTable.length - 1; i >= 0; --i) {
            EAN128AI.initFixedLen(fixedLenTable[i], (byte)(fixedLenValueTable[i] - 2));
        }
    }

    private static class AIProperties
    extends Properties {
        private AIProperties() {
        }

        public synchronized Object put(Object arg0, Object arg1) {
            EAN128AI ai = EAN128AI.parseSpecPrivate((String)arg0, (String)arg1);
            try {
                EAN128AI.setAI((String)arg0, ai);
            }
            catch (Exception e) {
                System.err.println(e);
            }
            return super.put(arg0, arg1);
        }
    }
}

