/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.datamatrix;

import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.impl.DefaultTwoDimCanvasLogicHandler;
import org.krysalis.barcode4j.impl.datamatrix.DataMatrixHighLevelEncoder;
import org.krysalis.barcode4j.impl.datamatrix.DataMatrixLogicImpl;
import org.krysalis.barcode4j.impl.datamatrix.DataMatrixSymbolInfo;
import org.krysalis.barcode4j.output.Canvas;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.tools.UnitConv;

public class DataMatrixBean
extends AbstractBarcodeBean {
    protected static final double DEFAULT_MODULE_WIDTH = UnitConv.in2mm(0.013888888888888888);

    public DataMatrixBean() {
        this.height = 0.0;
        this.moduleWidth = DEFAULT_MODULE_WIDTH;
        this.quietZone = 1.0 * this.moduleWidth;
    }

    public void generateBarcode(CanvasProvider canvas, String msg) {
        if (msg == null || msg.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        DefaultTwoDimCanvasLogicHandler handler = new DefaultTwoDimCanvasLogicHandler(this, new Canvas(canvas));
        DataMatrixLogicImpl impl = new DataMatrixLogicImpl();
        impl.generateBarcodeLogic(handler, msg);
    }

    public BarcodeDimension calcDimensions(String msg) {
        String encoded = DataMatrixHighLevelEncoder.encodeHighLevel(msg);
        DataMatrixSymbolInfo symbolInfo = DataMatrixSymbolInfo.lookup(encoded.length());
        double width = (double)symbolInfo.getSymbolWidth() * this.getModuleWidth();
        double height = (double)symbolInfo.getSymbolHeight() * this.getBarHeight();
        double qzh = this.hasQuietZone() ? this.getQuietZone() : 0.0;
        double qzv = this.hasQuietZone() ? this.getVerticalQuietZone() : 0.0;
        return new BarcodeDimension(width, height, width + 2.0 * qzh, height + 2.0 * qzv, qzh, qzv);
    }

    public double getVerticalQuietZone() {
        return this.getQuietZone();
    }

    public double getBarWidth(int width) {
        return this.moduleWidth;
    }

    public double getBarHeight() {
        return this.moduleWidth;
    }
}

