/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.int2of5;

import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.impl.DefaultCanvasLogicHandler;
import org.krysalis.barcode4j.impl.int2of5.Interleaved2Of5LogicImpl;
import org.krysalis.barcode4j.output.Canvas;
import org.krysalis.barcode4j.output.CanvasProvider;

public class Interleaved2Of5Bean
extends AbstractBarcodeBean {
    protected static final double DEFAULT_MODULE_WIDTH = (double)0.21f;
    public static final double DEFAULT_WIDE_FACTOR = 3.0;
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;
    private double wideFactor = 3.0;
    private boolean displayChecksum = false;

    public Interleaved2Of5Bean() {
        this.moduleWidth = 0.21f;
        this.quietZone = 10.0 * this.moduleWidth;
    }

    public boolean isDisplayChecksum() {
        return this.displayChecksum;
    }

    public void setDisplayChecksum(boolean value) {
        this.displayChecksum = value;
    }

    public void generateBarcode(CanvasProvider canvas, String msg) {
        if (msg == null || msg.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        DefaultCanvasLogicHandler handler = new DefaultCanvasLogicHandler(this, new Canvas(canvas));
        Interleaved2Of5LogicImpl impl = new Interleaved2Of5LogicImpl(this.getChecksumMode(), this.isDisplayChecksum());
        impl.generateBarcodeLogic(handler, msg);
    }

    public BarcodeDimension calcDimensions(String msg) {
        int msgLen = msg.length();
        if (this.getChecksumMode() == ChecksumMode.CP_ADD) {
            ++msgLen;
        }
        if (msgLen % 2 != 0) {
            ++msgLen;
        }
        double charwidth = 2.0 * this.wideFactor + 3.0;
        double width = ((double)msgLen * charwidth + 6.0 + this.wideFactor) * this.moduleWidth;
        double qz = this.hasQuietZone() ? this.quietZone : 0.0;
        return new BarcodeDimension(width, this.getHeight(), width + 2.0 * qz, this.getHeight(), this.quietZone, 0.0);
    }

    public double getBarWidth(int width) {
        if (width == 1) {
            return this.moduleWidth;
        }
        if (width == 2) {
            return this.moduleWidth * this.wideFactor;
        }
        throw new IllegalArgumentException("Only widths 1 and 2 allowed");
    }

    public void setChecksumMode(ChecksumMode mode) {
        this.checksumMode = mode;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public double getWideFactor() {
        return this.wideFactor;
    }

    public void setWideFactor(double value) {
        if (value <= 1.0) {
            throw new IllegalArgumentException("wide factor must be > 1.0");
        }
        this.wideFactor = value;
    }
}

