/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.pdf417;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.krysalis.barcode4j.impl.ConfigurableBarcodeGenerator;
import org.krysalis.barcode4j.impl.pdf417.PDF417Bean;
import org.krysalis.barcode4j.tools.Length;

public class PDF417
extends ConfigurableBarcodeGenerator
implements Configurable {
    public PDF417() {
        this.bean = new PDF417Bean();
    }

    public void configure(Configuration cfg) throws ConfigurationException {
        String rhs;
        String mws = cfg.getChild("module-width").getValue(null);
        if (mws != null) {
            Length mw = new Length(mws, "mm");
            this.getPDF417Bean().setModuleWidth(mw.getValueAsMillimeter());
        }
        super.configure(cfg);
        this.getPDF417Bean().setColumns(cfg.getChild("columns").getValueAsInteger(2));
        this.getPDF417Bean().setErrorCorrectionLevel(cfg.getChild("ec-level").getValueAsInteger(0));
        String qzvs = cfg.getChild("vertical-quiet-zone").getValue(null);
        if (qzvs != null) {
            Length qz = new Length(qzvs, "mw");
            if (qz.getUnit().equalsIgnoreCase("mw")) {
                this.getPDF417Bean().setVerticalQuietZone(qz.getValue() * this.getBean().getModuleWidth());
            } else {
                this.getPDF417Bean().setVerticalQuietZone(qz.getValueAsMillimeter());
            }
        }
        if ((rhs = cfg.getChild("row-height").getValue(null)) != null) {
            Length rh = new Length(rhs, "mw");
            if (rh.getUnit().equalsIgnoreCase("mw")) {
                this.getPDF417Bean().setBarHeight(rh.getValue() * this.getBean().getModuleWidth());
            } else {
                this.getPDF417Bean().setBarHeight(rh.getValueAsMillimeter());
            }
        }
    }

    public PDF417Bean getPDF417Bean() {
        return (PDF417Bean)this.getBean();
    }
}

