/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.upcean;

import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.impl.AbstractBarcodeBean;
import org.krysalis.barcode4j.impl.upcean.UPCEANCanvasLogicHandler;
import org.krysalis.barcode4j.impl.upcean.UPCEANLogicImpl;
import org.krysalis.barcode4j.output.Canvas;
import org.krysalis.barcode4j.output.CanvasProvider;

public abstract class UPCEANBean
extends AbstractBarcodeBean {
    protected static final double DEFAULT_MODULE_WIDTH = (double)0.33f;
    private ChecksumMode checksumMode = ChecksumMode.CP_AUTO;

    public UPCEANBean() {
        this.moduleWidth = 0.33f;
        this.quietZone = 10.0 * this.moduleWidth;
    }

    public void setChecksumMode(ChecksumMode mode) {
        this.checksumMode = mode;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksumMode;
    }

    public double getBarWidth(int width) {
        if (width >= 1 && width <= 4) {
            return (double)width * this.moduleWidth;
        }
        throw new IllegalArgumentException("Only widths 1 to 4 allowed");
    }

    public abstract UPCEANLogicImpl createLogicImpl();

    public void generateBarcode(CanvasProvider canvas, String msg) {
        if (msg == null || msg.length() == 0) {
            throw new NullPointerException("Parameter msg must not be empty");
        }
        UPCEANCanvasLogicHandler handler = new UPCEANCanvasLogicHandler(this, new Canvas(canvas));
        UPCEANLogicImpl impl = this.createLogicImpl();
        impl.generateBarcodeLogic(handler, msg);
    }

    protected double supplementalWidth(String msg) {
        double width = 0.0;
        int suppLen = UPCEANLogicImpl.getSupplementalLength(msg);
        if (suppLen > 0) {
            width += this.quietZone;
            width += 4.0 * this.moduleWidth;
            width += (double)(suppLen * 7) * this.moduleWidth;
            width += (double)((suppLen - 1) * 2) * this.moduleWidth;
        }
        return width;
    }

    public BarcodeDimension calcDimensions(String msg) {
        double width = 3.0 * this.moduleWidth;
        width += 42.0 * this.moduleWidth;
        width += 5.0 * this.moduleWidth;
        width += 42.0 * this.moduleWidth;
        width += 3.0 * this.moduleWidth;
        double qz = this.hasQuietZone() ? this.quietZone : 0.0;
        return new BarcodeDimension(width += this.supplementalWidth(msg), this.getHeight(), width + 2.0 * qz, this.getHeight(), this.quietZone, 0.0);
    }
}

