/*
 * Decompiled with CFR 0.152.
 */
package org.jbarcode.encode;

import java.util.ArrayList;
import org.jbarcode.encode.BarSet;
import org.jbarcode.encode.BarcodeEncoder;
import org.jbarcode.encode.InvalidAtributeException;

public class Code128Encoder
implements BarcodeEncoder {
    private static Code128Encoder instance;
    protected static final int ENCODING_SET_B_ALPHA = 0;
    protected static final int ENCODING_SET_C_NUMERIC = 1;
    protected static final int START_CODE_B_ALPHA = 104;
    protected static final int START_CODE_C_NUMERIC = 105;
    protected static final int SWITCH_TO_CODE_B_ALPHA = 100;
    protected static final int SWITCH_TO_CODE_C_NUMERIC = 99;
    protected static final int STOP = 106;
    protected static final BarSet[] BARSETS;
    protected static final BarSet TERMINATION_BAR;

    private Code128Encoder() {
    }

    public String computeCheckSum(String string) {
        return "";
    }

    public static Code128Encoder getInstance() {
        if (instance == null) {
            instance = new Code128Encoder();
        }
        return instance;
    }

    private boolean isDigit(byte by) {
        return by >= 48 && by <= 57;
    }

    private int getCode(byte by) {
        return by - 32;
    }

    public BarSet[] encode(String string) throws InvalidAtributeException {
        int n;
        if (string == null || string.length() < 1) {
            throw new InvalidAtributeException("[Code128] Invalid text (" + string + ").");
        }
        ArrayList<BarSet> arrayList = new ArrayList<BarSet>();
        byte[] byArray = string.getBytes();
        boolean bl = false;
        int n2 = 104;
        if (byArray.length > 1 && this.isDigit(byArray[0]) && this.isDigit(byArray[1])) {
            bl = true;
            n2 = 105;
        }
        int n3 = n2;
        arrayList.add(BARSETS[n2]);
        int n4 = 1;
        for (n = 0; n < byArray.length; ++n) {
            if (n < byArray.length - 1 && this.isDigit(byArray[n]) && this.isDigit(byArray[n + 1])) {
                if (!bl) {
                    bl = true;
                    n2 = 99;
                    n3 += n2 * n4;
                    ++n4;
                    arrayList.add(BARSETS[n2]);
                }
                n2 = Integer.parseInt(new String(byArray, n, 2));
                ++n;
            } else {
                if (bl) {
                    bl = false;
                    n2 = 100;
                    n3 += n2 * n4;
                    ++n4;
                    arrayList.add(BARSETS[n2]);
                }
                n2 = this.getCode(byArray[n]);
            }
            n3 += n2 * n4;
            ++n4;
            arrayList.add(BARSETS[n2]);
        }
        n = n3 % 103;
        arrayList.add(BARSETS[n]);
        arrayList.add(BARSETS[106]);
        arrayList.add(TERMINATION_BAR);
        return arrayList.toArray(new BarSet[0]);
    }

    public String toString() {
        return "CODE 128";
    }

    static {
        BARSETS = new BarSet[107];
        TERMINATION_BAR = new BarSet("11");
        Code128Encoder.BARSETS[0] = new BarSet("11011001100");
        Code128Encoder.BARSETS[1] = new BarSet("11001101100");
        Code128Encoder.BARSETS[2] = new BarSet("11001100110");
        Code128Encoder.BARSETS[3] = new BarSet("10010011000");
        Code128Encoder.BARSETS[4] = new BarSet("10010001100");
        Code128Encoder.BARSETS[5] = new BarSet("10001001100");
        Code128Encoder.BARSETS[6] = new BarSet("10011001000");
        Code128Encoder.BARSETS[7] = new BarSet("10011000100");
        Code128Encoder.BARSETS[8] = new BarSet("10001100100");
        Code128Encoder.BARSETS[9] = new BarSet("11001001000");
        Code128Encoder.BARSETS[10] = new BarSet("11001000100");
        Code128Encoder.BARSETS[11] = new BarSet("11000100100");
        Code128Encoder.BARSETS[12] = new BarSet("10110011100");
        Code128Encoder.BARSETS[13] = new BarSet("10011011100");
        Code128Encoder.BARSETS[14] = new BarSet("10011001110");
        Code128Encoder.BARSETS[15] = new BarSet("10111001100");
        Code128Encoder.BARSETS[16] = new BarSet("10011101100");
        Code128Encoder.BARSETS[17] = new BarSet("10011100110");
        Code128Encoder.BARSETS[18] = new BarSet("11001110010");
        Code128Encoder.BARSETS[19] = new BarSet("11001011100");
        Code128Encoder.BARSETS[20] = new BarSet("11001001110");
        Code128Encoder.BARSETS[21] = new BarSet("11011100100");
        Code128Encoder.BARSETS[22] = new BarSet("11001110100");
        Code128Encoder.BARSETS[23] = new BarSet("11101101110");
        Code128Encoder.BARSETS[24] = new BarSet("11101001100");
        Code128Encoder.BARSETS[25] = new BarSet("11100101100");
        Code128Encoder.BARSETS[26] = new BarSet("11100100110");
        Code128Encoder.BARSETS[27] = new BarSet("11101100100");
        Code128Encoder.BARSETS[28] = new BarSet("11100110100");
        Code128Encoder.BARSETS[29] = new BarSet("11100110010");
        Code128Encoder.BARSETS[30] = new BarSet("11011011000");
        Code128Encoder.BARSETS[31] = new BarSet("11011000110");
        Code128Encoder.BARSETS[32] = new BarSet("11000110110");
        Code128Encoder.BARSETS[33] = new BarSet("10100011000");
        Code128Encoder.BARSETS[34] = new BarSet("10001011000");
        Code128Encoder.BARSETS[35] = new BarSet("10001000110");
        Code128Encoder.BARSETS[36] = new BarSet("10110001000");
        Code128Encoder.BARSETS[37] = new BarSet("10001101000");
        Code128Encoder.BARSETS[38] = new BarSet("10001100010");
        Code128Encoder.BARSETS[39] = new BarSet("11010001000");
        Code128Encoder.BARSETS[40] = new BarSet("11000101000");
        Code128Encoder.BARSETS[41] = new BarSet("11000100010");
        Code128Encoder.BARSETS[42] = new BarSet("10110111000");
        Code128Encoder.BARSETS[43] = new BarSet("10110001110");
        Code128Encoder.BARSETS[44] = new BarSet("10001101110");
        Code128Encoder.BARSETS[45] = new BarSet("10111011000");
        Code128Encoder.BARSETS[46] = new BarSet("10111000110");
        Code128Encoder.BARSETS[47] = new BarSet("10001110110");
        Code128Encoder.BARSETS[48] = new BarSet("11101110110");
        Code128Encoder.BARSETS[49] = new BarSet("11010001110");
        Code128Encoder.BARSETS[50] = new BarSet("11000101110");
        Code128Encoder.BARSETS[51] = new BarSet("11011101000");
        Code128Encoder.BARSETS[52] = new BarSet("11011100010");
        Code128Encoder.BARSETS[53] = new BarSet("11011101110");
        Code128Encoder.BARSETS[54] = new BarSet("11101011000");
        Code128Encoder.BARSETS[55] = new BarSet("11101000110");
        Code128Encoder.BARSETS[56] = new BarSet("11100010110");
        Code128Encoder.BARSETS[57] = new BarSet("11101101000");
        Code128Encoder.BARSETS[58] = new BarSet("11101100010");
        Code128Encoder.BARSETS[59] = new BarSet("11100011010");
        Code128Encoder.BARSETS[60] = new BarSet("11101111010");
        Code128Encoder.BARSETS[61] = new BarSet("11001000010");
        Code128Encoder.BARSETS[62] = new BarSet("11110001010");
        Code128Encoder.BARSETS[63] = new BarSet("10100110000");
        Code128Encoder.BARSETS[64] = new BarSet("10100001100");
        Code128Encoder.BARSETS[65] = new BarSet("10010110000");
        Code128Encoder.BARSETS[66] = new BarSet("10010000110");
        Code128Encoder.BARSETS[67] = new BarSet("10000101100");
        Code128Encoder.BARSETS[68] = new BarSet("10000100110");
        Code128Encoder.BARSETS[69] = new BarSet("10110010000");
        Code128Encoder.BARSETS[70] = new BarSet("10110000100");
        Code128Encoder.BARSETS[71] = new BarSet("10011010000");
        Code128Encoder.BARSETS[72] = new BarSet("10011000010");
        Code128Encoder.BARSETS[73] = new BarSet("10000110100");
        Code128Encoder.BARSETS[74] = new BarSet("10000110010");
        Code128Encoder.BARSETS[75] = new BarSet("11000010010");
        Code128Encoder.BARSETS[76] = new BarSet("11001010000");
        Code128Encoder.BARSETS[77] = new BarSet("11110111010");
        Code128Encoder.BARSETS[78] = new BarSet("11000010100");
        Code128Encoder.BARSETS[79] = new BarSet("10001111010");
        Code128Encoder.BARSETS[80] = new BarSet("10100111100");
        Code128Encoder.BARSETS[81] = new BarSet("10010111100");
        Code128Encoder.BARSETS[82] = new BarSet("10010011110");
        Code128Encoder.BARSETS[83] = new BarSet("10111100100");
        Code128Encoder.BARSETS[84] = new BarSet("10011110100");
        Code128Encoder.BARSETS[85] = new BarSet("10011110010");
        Code128Encoder.BARSETS[86] = new BarSet("11110100100");
        Code128Encoder.BARSETS[87] = new BarSet("11110010100");
        Code128Encoder.BARSETS[88] = new BarSet("11110010010");
        Code128Encoder.BARSETS[89] = new BarSet("11011011110");
        Code128Encoder.BARSETS[90] = new BarSet("11011110110");
        Code128Encoder.BARSETS[91] = new BarSet("11110110110");
        Code128Encoder.BARSETS[92] = new BarSet("10101111000");
        Code128Encoder.BARSETS[93] = new BarSet("10100011110");
        Code128Encoder.BARSETS[94] = new BarSet("10001011110");
        Code128Encoder.BARSETS[95] = new BarSet("10111101000");
        Code128Encoder.BARSETS[96] = new BarSet("10111100010");
        Code128Encoder.BARSETS[97] = new BarSet("11110101000");
        Code128Encoder.BARSETS[98] = new BarSet("11110100010");
        Code128Encoder.BARSETS[99] = new BarSet("10111011110");
        Code128Encoder.BARSETS[100] = new BarSet("10111101110");
        Code128Encoder.BARSETS[101] = new BarSet("11101011110");
        Code128Encoder.BARSETS[102] = new BarSet("11110101110");
        Code128Encoder.BARSETS[103] = new BarSet("11010000100");
        Code128Encoder.BARSETS[104] = new BarSet("11010010000");
        Code128Encoder.BARSETS[105] = new BarSet("11010011100");
        Code128Encoder.BARSETS[106] = new BarSet("11000111010");
    }
}

