/*
 * Decompiled with CFR 0.152.
 */
package org.jbarcode.encode;

import org.jbarcode.encode.BarSet;
import org.jbarcode.encode.BarcodeEncoder;
import org.jbarcode.encode.InvalidAtributeException;

public abstract class EANEncoder
implements BarcodeEncoder {
    protected static final BarSet[] CODES = new BarSet[]{new BarSet("1110010"), new BarSet("1100110"), new BarSet("1101100"), new BarSet("1000010"), new BarSet("1011100"), new BarSet("1001110"), new BarSet("1010000"), new BarSet("1000100"), new BarSet("1001000"), new BarSet("1110100")};
    protected static final BarSet LEFT_GUARD = new BarSet("101");
    protected static final BarSet CENTER_GUARD = new BarSet("01010");
    protected static final BarSet RIGTH_GUARD = new BarSet("101");

    public String computeCheckSum(String string) throws InvalidAtributeException {
        int n;
        int n2 = 0;
        boolean bl = true;
        for (n = string.length() - 1; n >= 0; --n) {
            n2 = bl ? (n2 += 3 * EANEncoder.charToInt(string.charAt(n))) : (n2 += EANEncoder.charToInt(string.charAt(n)));
            bl = !bl;
        }
        n = n2 % 10;
        if (n == 0) {
            return "0";
        }
        return Integer.toString(10 - n);
    }

    protected static int charToInt(char c) throws NumberFormatException {
        if (!Character.isDigit(c)) {
            throw new NumberFormatException("Invalid number");
        }
        return c - 48;
    }
}

