/*
 * Decompiled with CFR 0.152.
 */
package org.jbarcode.encode;

import org.jbarcode.encode.BarSet;
import org.jbarcode.encode.BarcodeEncoder;
import org.jbarcode.encode.InvalidAtributeException;

public class PostNetEncoder
implements BarcodeEncoder {
    protected final BarSet[] CODES = new BarSet[]{new BarSet("11000"), new BarSet("00011"), new BarSet("00101"), new BarSet("00110"), new BarSet("01001"), new BarSet("01010"), new BarSet("01100"), new BarSet("10001"), new BarSet("10010"), new BarSet("10100")};
    protected final BarSet START_STOP_CHAR = new BarSet("1");
    private static PostNetEncoder instance;

    private PostNetEncoder() {
    }

    public static PostNetEncoder getInstance() {
        if (instance == null) {
            instance = new PostNetEncoder();
        }
        return instance;
    }

    public BarSet[] encode(String string) throws InvalidAtributeException {
        if (string.length() < 1) {
            throw new InvalidAtributeException("[PostNet] Tamanho de texto invalido (" + string.length() + ").");
        }
        BarSet[] barSetArray = new BarSet[string.length() + 2];
        try {
            barSetArray[0] = this.START_STOP_CHAR;
            for (int i = 0; i < string.length(); ++i) {
                int n = Integer.parseInt(String.valueOf(string.charAt(i)));
                barSetArray[i + 1] = this.CODES[n];
            }
            barSetArray[barSetArray.length - 1] = this.START_STOP_CHAR;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidAtributeException("[PostNet] O padrao suporta apenas numeros.");
        }
        return barSetArray;
    }

    public String computeCheckSum(String string) throws InvalidAtributeException {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            n += Integer.parseInt(String.valueOf(string.charAt(i)));
        }
        n = 10 - n % 10;
        return String.valueOf(n);
    }

    public String toString() {
        return "PostNet";
    }
}

