/*
 * Decompiled with CFR 0.152.
 */
package org.jbarcode.encode;

import org.jbarcode.encode.BarSet;
import org.jbarcode.encode.EANEncoder;
import org.jbarcode.encode.InvalidAtributeException;

public class UPCEEncoder
extends EANEncoder {
    private static UPCEEncoder instance;
    protected BarSet[] DIGIT_PARITY = new BarSet[]{new BarSet("111000"), new BarSet("110100"), new BarSet("110010"), new BarSet("110001"), new BarSet("101100"), new BarSet("100110"), new BarSet("100011"), new BarSet("101010"), new BarSet("101001"), new BarSet("100101")};
    private BarSet RIGTH_GUARD_EXT = new BarSet("010101");

    private UPCEEncoder() {
    }

    public static UPCEEncoder getInstance() {
        if (instance == null) {
            instance = new UPCEEncoder();
        }
        return instance;
    }

    public BarSet[] encode(String string) throws InvalidAtributeException {
        if (string.length() != 8) {
            throw new InvalidAtributeException("[UPCE] Invalid text length (" + string.length() + ").");
        }
        BarSet[] barSetArray = new BarSet[8];
        try {
            int n = UPCEEncoder.charToInt(string.charAt(7));
            int n2 = UPCEEncoder.charToInt(string.charAt(0));
            BarSet barSet = n2 == 0 ? this.DIGIT_PARITY[n] : this.DIGIT_PARITY[n].xorTrue();
            barSetArray[0] = LEFT_GUARD;
            for (int i = 0; i < 6; ++i) {
                int n3 = UPCEEncoder.charToInt(string.charAt(i + 1));
                barSetArray[i + 1] = barSet.get(i) ? CODES[n3].reverse() : CODES[n3].xorTrue();
            }
            barSetArray[7] = this.RIGTH_GUARD_EXT;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidAtributeException("[UPCE] O padrao suporta apenas numeros.");
        }
        return barSetArray;
    }

    public String convertUPCEtoUPCA(String string) throws InvalidAtributeException {
        if (string.length() != 7 && string.length() != 8) {
            throw new InvalidAtributeException("[UPCE] Invalid text length (" + string.length() + ").");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.charAt(0));
        switch (string.charAt(6)) {
            case '0': 
            case '1': 
            case '2': {
                stringBuffer.append(string.charAt(1));
                stringBuffer.append(string.charAt(2));
                stringBuffer.append(string.charAt(6));
                stringBuffer.append("0000");
                stringBuffer.append(string.charAt(3));
                stringBuffer.append(string.charAt(4));
                stringBuffer.append(string.charAt(5));
                break;
            }
            case '3': {
                stringBuffer.append(string.charAt(1));
                stringBuffer.append(string.charAt(2));
                stringBuffer.append(string.charAt(3));
                stringBuffer.append("00000");
                stringBuffer.append(string.charAt(4));
                stringBuffer.append(string.charAt(5));
                break;
            }
            case '4': {
                stringBuffer.append(string.charAt(1));
                stringBuffer.append(string.charAt(2));
                stringBuffer.append(string.charAt(3));
                stringBuffer.append(string.charAt(4));
                stringBuffer.append("00000");
                stringBuffer.append(string.charAt(5));
                break;
            }
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                stringBuffer.append(string.charAt(1));
                stringBuffer.append(string.charAt(2));
                stringBuffer.append(string.charAt(3));
                stringBuffer.append(string.charAt(4));
                stringBuffer.append(string.charAt(5));
                stringBuffer.append("0000");
                stringBuffer.append(string.charAt(6));
                break;
            }
            default: {
                throw new InvalidAtributeException("[UPCE] Invalid char (" + string.charAt(6) + ").");
            }
        }
        if (string.length() == 8) {
            stringBuffer.append(string.charAt(7));
        }
        return stringBuffer.toString();
    }

    public String computeCheckSum(String string) throws InvalidAtributeException {
        if (string.length() != 7) {
            throw new InvalidAtributeException("[UPCE] Invalid text length (" + string.length() + ").");
        }
        String string2 = this.convertUPCEtoUPCA(string);
        return super.computeCheckSum(string2);
    }

    public String toString() {
        return "UPC-E";
    }
}

