/*
 * Decompiled with CFR 0.152.
 */
package com.jspsmart.upload;

import com.jspsmart.upload.File;
import com.jspsmart.upload.Files;
import com.jspsmart.upload.Request;
import com.jspsmart.upload.SmartUploadException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;

public class SmartUpload {
    protected byte[] m_binArray;
    protected HttpServletRequest m_request;
    protected HttpServletResponse m_response;
    protected ServletContext m_application;
    private int m_totalBytes = 0;
    private int m_currentIndex = 0;
    private int m_startData = 0;
    private int m_endData = 0;
    private String m_boundary = new String();
    private long m_totalMaxFileSize = 0L;
    private long m_maxFileSize = 0L;
    private Vector m_deniedFilesList = new Vector();
    private Vector m_allowedFilesList = new Vector();
    private boolean m_denyPhysicalPath = false;
    private boolean m_forcePhysicalPath = false;
    private String m_contentDisposition = new String();
    public static final int SAVE_AUTO = 0;
    public static final int SAVE_VIRTUAL = 1;
    public static final int SAVE_PHYSICAL = 2;
    private Files m_files = new Files();
    private Request m_formRequest = new Request();

    public final void init(ServletConfig servletConfig) throws ServletException {
        this.m_application = servletConfig.getServletContext();
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.m_request = httpServletRequest;
        this.m_response = httpServletResponse;
    }

    public final void initialize(ServletConfig servletConfig, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        this.m_application = servletConfig.getServletContext();
        this.m_request = httpServletRequest;
        this.m_response = httpServletResponse;
    }

    public final void initialize(PageContext pageContext) throws ServletException {
        this.m_application = pageContext.getServletContext();
        this.m_request = (HttpServletRequest)pageContext.getRequest();
        this.m_response = (HttpServletResponse)pageContext.getResponse();
    }

    public final void initialize(ServletContext servletContext, HttpSession httpSession, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, JspWriter jspWriter) throws ServletException {
        this.m_application = servletContext;
        this.m_request = httpServletRequest;
        this.m_response = httpServletResponse;
    }

    public void upload() throws ServletException, IOException, SmartUploadException {
        int n = 0;
        int n2 = 0;
        long l = 0L;
        boolean bl = false;
        String string = new String();
        String string2 = new String();
        String string3 = new String();
        String string4 = new String();
        String string5 = new String();
        String string6 = new String();
        String string7 = new String();
        String string8 = new String();
        String string9 = new String();
        boolean bl2 = false;
        this.m_totalBytes = this.m_request.getContentLength();
        this.m_binArray = new byte[this.m_totalBytes];
        while (n < this.m_totalBytes) {
            try {
                this.m_request.getInputStream();
                n2 = this.m_request.getInputStream().read(this.m_binArray, n, this.m_totalBytes - n);
            }
            catch (Exception exception) {
                throw new SmartUploadException("Unable to upload.");
            }
            n += n2;
        }
        while (!bl && this.m_currentIndex < this.m_totalBytes) {
            if (this.m_binArray[this.m_currentIndex] == 13) {
                bl = true;
            } else {
                this.m_boundary = this.m_boundary + (char)this.m_binArray[this.m_currentIndex];
            }
            ++this.m_currentIndex;
        }
        if (this.m_currentIndex == 1) {
            return;
        }
        ++this.m_currentIndex;
        while (this.m_currentIndex < this.m_totalBytes) {
            Object object;
            string = this.getDataHeader();
            this.m_currentIndex += 2;
            bl2 = string.indexOf("filename") > 0;
            string2 = this.getDataFieldValue(string, "name");
            if (bl2) {
                string5 = this.getDataFieldValue(string, "filename");
                string3 = this.getFileName(string5);
                string4 = this.getFileExt(string3);
                string6 = this.getContentType(string);
                string7 = this.getContentDisp(string);
                string8 = this.getTypeMIME(string6);
                string9 = this.getSubTypeMIME(string6);
            }
            this.getDataSection();
            if (bl2 && string3.length() > 0) {
                if (this.m_deniedFilesList.contains(string4)) {
                    throw new SecurityException("The extension of the file is denied to be uploaded (1015).");
                }
                if (!this.m_allowedFilesList.isEmpty() && !this.m_allowedFilesList.contains(string4)) {
                    throw new SecurityException("The extension of the file is not allowed to be uploaded (1010).");
                }
                if (this.m_maxFileSize > 0L && (long)(this.m_endData - this.m_startData + 1) > this.m_maxFileSize) {
                    throw new SecurityException("Size exceeded for this file : " + string3 + " (1105).");
                }
                if (this.m_totalMaxFileSize > 0L && (l += (long)(this.m_endData - this.m_startData + 1)) > this.m_totalMaxFileSize) {
                    throw new SecurityException("Total File Size exceeded (1110).");
                }
            }
            if (bl2) {
                object = new File();
                ((File)object).setParent(this);
                ((File)object).setFieldName(string2);
                ((File)object).setFileName(string3);
                ((File)object).setFileExt(string4);
                ((File)object).setFilePathName(string5);
                ((File)object).setIsMissing(string5.length() == 0);
                ((File)object).setContentType(string6);
                ((File)object).setContentDisp(string7);
                ((File)object).setTypeMIME(string8);
                ((File)object).setSubTypeMIME(string9);
                if (string6.indexOf("application/x-macbinary") > 0) {
                    this.m_startData += 128;
                }
                ((File)object).setSize(this.m_endData - this.m_startData + 1);
                ((File)object).setStartData(this.m_startData);
                ((File)object).setEndData(this.m_endData);
                this.m_files.addFile((File)object);
            } else {
                object = new String(this.m_binArray, this.m_startData, this.m_endData - this.m_startData + 1);
                this.m_formRequest.putParameter(string2, (String)object);
            }
            if ((char)this.m_binArray[this.m_currentIndex + 1] == '-') break;
            this.m_currentIndex += 2;
        }
    }

    public int save(String string) throws ServletException, IOException, SmartUploadException {
        return this.save(string, 0);
    }

    public int save(String string, int n) throws ServletException, IOException, SmartUploadException {
        int n2 = 0;
        if (string == null) {
            string = this.m_application.getRealPath("/");
        }
        if (string.indexOf("/") != -1) {
            if (string.charAt(string.length() - 1) != '/') {
                string = string + "/";
            }
        } else if (string.charAt(string.length() - 1) != '\\') {
            string = string + "\\";
        }
        int n3 = 0;
        while (n3 < this.m_files.getCount()) {
            if (!this.m_files.getFile(n3).isMissing()) {
                this.m_files.getFile(n3).saveAs(string + this.m_files.getFile(n3).getFileName(), n);
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public int getSize() {
        return this.m_totalBytes;
    }

    public byte getBinaryData(int n) {
        byte by;
        try {
            by = this.m_binArray[n];
        }
        catch (Exception exception) {
            throw new ArrayIndexOutOfBoundsException("Index out of range (1005).");
        }
        return by;
    }

    public Files getFiles() {
        return this.m_files;
    }

    public Request getRequest() {
        return this.m_formRequest;
    }

    public void downloadFile(String string) throws ServletException, IOException, SmartUploadException {
        this.downloadFile(string, null, null);
    }

    public void downloadFile(String string, String string2) throws ServletException, IOException, SmartUploadException, SmartUploadException {
        this.downloadFile(string, string2, null);
    }

    public void downloadFile(String string, String string2, String string3) throws ServletException, IOException, SmartUploadException {
        this.downloadFile(string, string2, string3, 65000);
    }

    public void downloadFile(String string, String string2, String string3, int n) throws ServletException, IOException, SmartUploadException {
        if (string == null) {
            throw new IllegalArgumentException("File '" + string + "' not found (1040).");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("File '" + string + "' not found (1040).");
        }
        if (!this.isVirtual(string) && this.m_denyPhysicalPath) {
            throw new SecurityException("Physical path is denied (1035).");
        }
        if (this.isVirtual(string)) {
            string = this.m_application.getRealPath(string);
        }
        java.io.File file = new java.io.File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        long l = file.length();
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = new byte[n];
        if (string2 == null) {
            this.m_response.setContentType("application/x-msdownload");
        } else if (string2.length() == 0) {
            this.m_response.setContentType("application/x-msdownload");
        } else {
            this.m_response.setContentType(string2);
        }
        this.m_response.setContentLength((int)l);
        String string4 = this.m_contentDisposition = this.m_contentDisposition == null ? "attachment;" : this.m_contentDisposition;
        if (string3 == null) {
            this.m_response.setHeader("Content-Disposition", this.m_contentDisposition + " filename=" + this.getFileName(string));
        } else if (string3.length() == 0) {
            this.m_response.setHeader("Content-Disposition", this.m_contentDisposition);
        } else {
            this.m_response.setHeader("Content-Disposition", this.m_contentDisposition + " filename=" + string3);
        }
        while ((long)n3 < l) {
            n2 = fileInputStream.read(byArray, 0, n);
            n3 += n2;
            this.m_response.getOutputStream().write(byArray, 0, n2);
        }
        fileInputStream.close();
    }

    public void downloadField(ResultSet resultSet, String string, String string2, String string3) throws ServletException, IOException, SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("The RecordSet cannot be null (1045).");
        }
        if (string == null) {
            throw new IllegalArgumentException("The columnName cannot be null (1050).");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("The columnName cannot be empty (1055).");
        }
        byte[] byArray = resultSet.getBytes(string);
        if (string2 == null) {
            this.m_response.setContentType("application/x-msdownload");
        } else if (string2.length() == 0) {
            this.m_response.setContentType("application/x-msdownload");
        } else {
            this.m_response.setContentType(string2);
        }
        this.m_response.setContentLength(byArray.length);
        if (string3 == null) {
            this.m_response.setHeader("Content-Disposition", "attachment;");
        } else if (string3.length() == 0) {
            this.m_response.setHeader("Content-Disposition", "attachment;");
        } else {
            this.m_response.setHeader("Content-Disposition", "attachment; filename=" + string3);
        }
        this.m_response.getOutputStream().write(byArray, 0, byArray.length);
    }

    public void fieldToFile(ResultSet resultSet, String string, String string2) throws ServletException, IOException, SmartUploadException, SQLException {
        try {
            int n;
            if (this.m_application.getRealPath(string2) != null) {
                string2 = this.m_application.getRealPath(string2);
            }
            InputStream inputStream = resultSet.getBinaryStream(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            while ((n = inputStream.read()) != -1) {
                fileOutputStream.write(n);
            }
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new SmartUploadException("Unable to save file from the DataBase (1020).");
        }
    }

    private String getDataFieldValue(String string, String string2) {
        String string3 = new String();
        String string4 = new String();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        string3 = string2 + "=" + '\"';
        n = string.indexOf(string3);
        if (n > 0) {
            n3 = n2 = n + string3.length();
            string3 = "\"";
            n4 = string.indexOf(string3, n2);
            if (n3 > 0 && n4 > 0) {
                string4 = string.substring(n3, n4);
            }
        }
        return string4;
    }

    private String getFileExt(String string) {
        String string2 = new String();
        int n = 0;
        int n2 = 0;
        if (string == null) {
            return null;
        }
        n = string.lastIndexOf(46) + 1;
        n2 = string.length();
        string2 = string.substring(n, n2);
        if (string.lastIndexOf(46) > 0) {
            return string2;
        }
        return "";
    }

    private String getContentType(String string) {
        String string2 = new String();
        String string3 = new String();
        int n = 0;
        int n2 = 0;
        string2 = "Content-Type:";
        n = string.indexOf(string2) + string2.length();
        if (n != -1) {
            n2 = string.length();
            string3 = string.substring(n, n2);
        }
        return string3;
    }

    private String getTypeMIME(String string) {
        String string2 = new String();
        int n = 0;
        n = string.indexOf("/");
        if (n != -1) {
            return string.substring(1, n);
        }
        return string;
    }

    private String getSubTypeMIME(String string) {
        String string2 = new String();
        int n = 0;
        int n2 = 0;
        n = string.indexOf("/") + 1;
        if (n != -1) {
            n2 = string.length();
            return string.substring(n, n2);
        }
        return string;
    }

    private String getContentDisp(String string) {
        String string2 = new String();
        int n = 0;
        int n2 = 0;
        n = string.indexOf(":") + 1;
        n2 = string.indexOf(";");
        string2 = string.substring(n, n2);
        return string2;
    }

    private void getDataSection() {
        boolean bl = false;
        String string = new String();
        int n = this.m_currentIndex;
        int n2 = 0;
        int n3 = this.m_boundary.length();
        this.m_startData = this.m_currentIndex;
        this.m_endData = 0;
        while (n < this.m_totalBytes) {
            if (this.m_binArray[n] == (byte)this.m_boundary.charAt(n2)) {
                if (n2 == n3 - 1) {
                    this.m_endData = n - n3 + 1 - 3;
                    break;
                }
                ++n;
                ++n2;
                continue;
            }
            ++n;
            n2 = 0;
        }
        this.m_currentIndex = this.m_endData + n3 + 3;
    }

    private String getDataHeader() {
        int n = this.m_currentIndex;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        while (!bl2) {
            if (this.m_binArray[this.m_currentIndex] == 13 && this.m_binArray[this.m_currentIndex + 2] == 13) {
                bl2 = true;
                n2 = this.m_currentIndex - 1;
                this.m_currentIndex += 2;
                continue;
            }
            ++this.m_currentIndex;
        }
        String string = new String(this.m_binArray, n, n2 - n + 1);
        return string;
    }

    private String getFileName(String string) {
        String string2 = new String();
        String string3 = new String();
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        n = string.lastIndexOf(47);
        if (n != -1) {
            return string.substring(n + 1, string.length());
        }
        n = string.lastIndexOf(92);
        if (n != -1) {
            return string.substring(n + 1, string.length());
        }
        return string;
    }

    public void setDeniedFilesList(String string) throws ServletException, IOException, SQLException {
        String string2 = "";
        if (string != null) {
            string2 = "";
            int n = 0;
            while (n < string.length()) {
                if (string.charAt(n) == ',') {
                    if (!this.m_deniedFilesList.contains(string2)) {
                        this.m_deniedFilesList.addElement(string2);
                    }
                    string2 = "";
                } else {
                    string2 = string2 + string.charAt(n);
                }
                ++n;
            }
            if (string2 != "") {
                this.m_deniedFilesList.addElement(string2);
            }
        } else {
            this.m_deniedFilesList = null;
        }
    }

    public void setAllowedFilesList(String string) {
        String string2 = "";
        if (string != null) {
            string2 = "";
            int n = 0;
            while (n < string.length()) {
                if (string.charAt(n) == ',') {
                    if (!this.m_allowedFilesList.contains(string2)) {
                        this.m_allowedFilesList.addElement(string2);
                    }
                    string2 = "";
                } else {
                    string2 = string2 + string.charAt(n);
                }
                ++n;
            }
            if (string2 != "") {
                this.m_allowedFilesList.addElement(string2);
            }
        } else {
            this.m_allowedFilesList = null;
        }
    }

    public void setDenyPhysicalPath(boolean bl) {
        this.m_denyPhysicalPath = bl;
    }

    public void setForcePhysicalPath(boolean bl) {
        this.m_forcePhysicalPath = bl;
    }

    public void setContentDisposition(String string) {
        this.m_contentDisposition = string;
    }

    public void setTotalMaxFileSize(long l) {
        this.m_totalMaxFileSize = l;
    }

    public void setMaxFileSize(long l) {
        this.m_maxFileSize = l;
    }

    protected String getPhysicalPath(String string, int n) throws IOException {
        java.io.File file;
        String string2 = new String();
        String string3 = new String();
        String string4 = new String();
        boolean bl = false;
        string4 = System.getProperty("file.separator");
        if (string == null) {
            throw new IllegalArgumentException("There is no specified destination file (1140).");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("There is no specified destination file (1140).");
        }
        if (string.lastIndexOf("\\") >= 0) {
            string2 = string.substring(0, string.lastIndexOf("\\"));
            string3 = string.substring(string.lastIndexOf("\\") + 1);
        }
        if (string.lastIndexOf("/") >= 0) {
            string2 = string.substring(0, string.lastIndexOf("/"));
            string3 = string.substring(string.lastIndexOf("/") + 1);
        }
        if ((file = new java.io.File(string2 = string2.length() == 0 ? "/" : string2)).exists()) {
            bl = true;
        }
        if (n == 0) {
            if (this.isVirtual(string2)) {
                string2 = (string2 = this.m_application.getRealPath(string2)).endsWith(string4) ? string2 + string3 : string2 + string4 + string3;
                return string2;
            }
            if (bl) {
                if (this.m_denyPhysicalPath) {
                    throw new IllegalArgumentException("Physical path is denied (1125).");
                }
                return string;
            }
            throw new IllegalArgumentException("This path does not exist (1135).");
        }
        if (n == 1) {
            if (this.isVirtual(string2)) {
                string2 = (string2 = this.m_application.getRealPath(string2)).endsWith(string4) ? string2 + string3 : string2 + string4 + string3;
                return string2;
            }
            if (bl) {
                throw new IllegalArgumentException("The path is not a virtual path.");
            }
            throw new IllegalArgumentException("This path does not exist (1135).");
        }
        if (n == 2) {
            if (bl) {
                if (this.m_denyPhysicalPath) {
                    throw new IllegalArgumentException("Physical path is denied (1125).");
                }
                return string;
            }
            if (this.isVirtual(string2)) {
                throw new IllegalArgumentException("The path is not a physical path.");
            }
            throw new IllegalArgumentException("This path does not exist (1135).");
        }
        return null;
    }

    public void uploadInFile(String string) throws IOException, SmartUploadException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (string == null) {
            throw new IllegalArgumentException("There is no specified destination file (1025).");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("There is no specified destination file (1025).");
        }
        if (!this.isVirtual(string) && this.m_denyPhysicalPath) {
            throw new SecurityException("Physical path is denied (1035).");
        }
        n = this.m_request.getContentLength();
        this.m_binArray = new byte[n];
        while (n2 < n) {
            try {
                n3 = this.m_request.getInputStream().read(this.m_binArray, n2, n - n2);
            }
            catch (Exception exception) {
                throw new SmartUploadException("Unable to upload.");
            }
            n2 += n3;
        }
        if (this.isVirtual(string)) {
            string = this.m_application.getRealPath(string);
        }
        try {
            java.io.File file = new java.io.File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(this.m_binArray);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new SmartUploadException("The Form cannot be saved in the specified file (1030).");
        }
    }

    private boolean isVirtual(String string) {
        if (this.m_application.getRealPath(string) != null) {
            java.io.File file = new java.io.File(this.m_application.getRealPath(string));
            return file.exists();
        }
        return false;
    }
}

